/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.questionnaire.framework.answer.Answer;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.question.QuestionMultiChoice;
import org.kuali.coeus.common.questionnaire.impl.QuestionnaireDao;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krms.api.engine.TermResolver;

public class QuestionResolver
implements TermResolver<Object> {
    public static final String QUESTIONNAIRE_SEQ_ID = "Questionnaire ID";
    public static final String QUESTION_SEQ_ID = "Question ID";
    private final String outputName;
    private final Set<String> prereqs;
    private final Set<String> params;
    private QuestionnaireDao questionnaireDao;

    public QuestionResolver(String outputName, Set<String> params) {
        this.outputName = outputName;
        this.prereqs = new HashSet<String>();
        this.prereqs.add("moduleCode");
        this.prereqs.add("moduleItemKey");
        this.prereqs.add("moduleSubItemKey");
        this.params = Objects.requireNonNullElse(params, Collections.emptySet());
    }

    public int getCost() {
        return 1;
    }

    public String getOutput() {
        return this.outputName;
    }

    public Set<String> getPrerequisites() {
        return this.prereqs;
    }

    public Set<String> getParameterNames() {
        return this.params;
    }

    public Object resolve(Map<String, Object> resolvedPrereqs, Map<String, String> parameters) {
        ArrayList<String> multipleAnswers = new ArrayList<String>();
        String questionnaireId = parameters.get(QUESTIONNAIRE_SEQ_ID);
        String questionId = parameters.get(QUESTION_SEQ_ID);
        String moduleCode = (String)resolvedPrereqs.get("moduleCode");
        String moduleItemKey = (String)resolvedPrereqs.get("moduleItemKey");
        String moduleSubItemKey = resolvedPrereqs.get("moduleSubItemKey").toString();
        List<AnswerHeader> answerHeaders = this.getQuestionnaireDao().getQuestionnaireAnswerHeaders(moduleCode, moduleItemKey, moduleSubItemKey);
        for (AnswerHeader answerHeader : this.getLatestAnswerVersions(answerHeaders)) {
            if (!answerHeader.getQuestionnaire().getQuestionnaireSeqId().equals(questionnaireId)) continue;
            for (Answer answer : answerHeader.getAnswers()) {
                if (!answer.getQuestion().getQuestionSeqId().toString().equals(questionId)) continue;
                if (answer.getQuestion().getQuestionTypeId().equals(100L) && StringUtils.contains((CharSequence)answer.getAnswer(), (CharSequence)":")) {
                    String bestPrompt = "";
                    List<String> multipleChoicePrompts = answer.getQuestion().getQuestionMultiChoices().stream().map(QuestionMultiChoice::getPrompt).toList();
                    for (String prompt : multipleChoicePrompts) {
                        if (!answer.getAnswer().contains(prompt) || prompt.length() <= bestPrompt.length()) continue;
                        bestPrompt = prompt;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)bestPrompt)) continue;
                    multipleAnswers.add(bestPrompt);
                    continue;
                }
                multipleAnswers.add(answer.getAnswer());
            }
        }
        if (multipleAnswers.size() == 0) {
            return null;
        }
        if (multipleAnswers.size() == 1) {
            return multipleAnswers.get(0);
        }
        return multipleAnswers;
    }

    protected Collection<AnswerHeader> getLatestAnswerVersions(List<AnswerHeader> allAnswerHeaders) {
        HashMap<String, AnswerHeader> latestAnswerHeaders = new HashMap<String, AnswerHeader>();
        for (AnswerHeader header : allAnswerHeaders) {
            AnswerHeader compHeader = (AnswerHeader)latestAnswerHeaders.get(header.getQuestionnaire().getQuestionnaireSeqId());
            if (compHeader != null && header.getQuestionnaire().getSequenceNumber() <= compHeader.getQuestionnaire().getSequenceNumber()) continue;
            latestAnswerHeaders.put(header.getQuestionnaire().getQuestionnaireSeqId(), header);
        }
        return latestAnswerHeaders.values();
    }

    public QuestionnaireDao getQuestionnaireDao() {
        if (this.questionnaireDao == null) {
            this.questionnaireDao = KcServiceLocator.getService(QuestionnaireDao.class);
        }
        return this.questionnaireDao;
    }
}

