/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage.restartable.partial;

import com.terracottatech.frs.RestartStore;
import com.terracottatech.offheapstore.storage.restartable.partial.RestartableMinimalStorageEngine;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.terracotta.offheapstore.paging.OffHeapStorageArea;
import org.terracotta.offheapstore.paging.PageSource;
import org.terracotta.offheapstore.storage.PointerSize;
import org.terracotta.offheapstore.storage.StorageEngine;
import org.terracotta.offheapstore.storage.portability.Portability;
import org.terracotta.offheapstore.util.Factory;
import org.terracotta.offheapstore.util.Validation;

public class RestartablePartialStorageEngine<I, K, V>
extends RestartableMinimalStorageEngine<I, K, V> {
    private static final boolean VALIDATING = Validation.shouldValidate(RestartablePartialStorageEngine.class);
    private static final long NULL_ENCODING = -1L;
    private static final int CACHE_META_OFFSET = 0;
    private static final int CACHE_PREVIOUS_OFFSET = 8;
    private static final int CACHE_NEXT_OFFSET = 16;
    private static final int CACHE_EVICTION_DATA_OFFSET = 24;
    private static final int CACHE_KEY_LENGTH_OFFSET = 28;
    private static final int CACHE_VALUE_LENGTH_OFFSET = 32;
    private static final int CACHE_DATA_OFFSET = 36;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final OffHeapStorageArea storage;
    private long first = -1L;
    private long last = -1L;
    private long hand = -1L;

    public static <I, K, V> Factory<RestartablePartialStorageEngine<I, K, V>> createPartialFactory(final I identifier, final RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, final boolean synchronous, final PointerSize width, final PageSource source, final int pageSize, final Portability<? super K> keyPortability, final Portability<? super V> valuePortability, final boolean thief, final boolean victim, final float compressThreshold) {
        return new Factory<RestartablePartialStorageEngine<I, K, V>>(){

            @Override
            public RestartablePartialStorageEngine<I, K, V> newInstance() {
                return new RestartablePartialStorageEngine(identifier, transactionSource, synchronous, width, source, pageSize, keyPortability, valuePortability, thief, victim, compressThreshold);
            }
        };
    }

    public static <I, K, V> Factory<RestartablePartialStorageEngine<I, K, V>> createPartialFactory(final I identifier, final RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, final boolean synchronous, final PointerSize width, final PageSource source, final int initialPageSize, final int maximalPageSize, final Portability<? super K> keyPortability, final Portability<? super V> valuePortability, final boolean thief, final boolean victim, final float compressThreshold) {
        return new Factory<RestartablePartialStorageEngine<I, K, V>>(){

            @Override
            public RestartablePartialStorageEngine<I, K, V> newInstance() {
                return new RestartablePartialStorageEngine(identifier, transactionSource, synchronous, width, source, initialPageSize, maximalPageSize, keyPortability, valuePortability, thief, victim, compressThreshold);
            }
        };
    }

    public RestartablePartialStorageEngine(I identifier, RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, boolean synchronous, PointerSize width, PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, float compressThreshold) {
        super(identifier, transactionSource, synchronous, width, source, pageSize, keyPortability, valuePortability, compressThreshold);
        this.storage = new OffHeapStorageArea(width, (OffHeapStorageArea.Owner)new CacheStorageAreaOwner(), source, pageSize, false, true, compressThreshold);
    }

    public RestartablePartialStorageEngine(I identifier, RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, boolean synchronous, PointerSize width, PageSource source, int initialPageSize, int maximalPageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, float compressThreshold) {
        super(identifier, transactionSource, synchronous, width, source, initialPageSize, maximalPageSize, keyPortability, valuePortability, compressThreshold);
        this.storage = new OffHeapStorageArea(width, (OffHeapStorageArea.Owner)new CacheStorageAreaOwner(), source, maximalPageSize, false, true, compressThreshold);
    }

    public RestartablePartialStorageEngine(I identifier, RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, boolean synchronous, PointerSize width, PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim, float compressThreshold) {
        super(identifier, transactionSource, synchronous, width, source, pageSize, keyPortability, valuePortability, thief, victim, compressThreshold);
        this.storage = new OffHeapStorageArea(width, (OffHeapStorageArea.Owner)new CacheStorageAreaOwner(), source, pageSize, false, true, compressThreshold);
    }

    public RestartablePartialStorageEngine(I identifier, RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, boolean synchronous, PointerSize width, PageSource source, int initialPageSize, int maximalPageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim, float compressThreshold) {
        super(identifier, transactionSource, synchronous, width, source, initialPageSize, maximalPageSize, keyPortability, valuePortability, thief, victim, compressThreshold);
        this.storage = new OffHeapStorageArea(width, (OffHeapStorageArea.Owner)new CacheStorageAreaOwner(), source, maximalPageSize, false, true, compressThreshold);
    }

    @Override
    public Long writeMapping(K key, V value, int hash, int metadata) {
        do {
            Long result;
            if ((result = super.writeMapping(key, value, hash, metadata)) == null) continue;
            this.createEntry(result).close();
            return result;
        } while (this.shrink());
        return null;
    }

    @Override
    public Long writeBinaryMapping(ByteBuffer binaryKey, ByteBuffer binaryValue, int pojoHash, int metadata) {
        Long result = super.writeBinaryMapping(binaryKey, binaryValue, pojoHash, metadata);
        if (result != null) {
            this.metadataArea.writeLong(result + (long)this.getCacheOffset(result), -1L);
        }
        return result;
    }

    @Override
    public Long writeBinaryMapping(ByteBuffer[] binaryKey, ByteBuffer[] binaryValue, int pojoHash, int metadata) {
        Long result = super.writeBinaryMapping(binaryKey, binaryValue, pojoHash, metadata);
        if (result != null) {
            this.metadataArea.writeLong(result + (long)this.getCacheOffset(result), -1L);
        }
        return result;
    }

    @Override
    protected int getRequiredEntrySize(ByteBuffer binaryKey, ByteBuffer binaryValue) {
        return super.getRequiredEntrySize(binaryKey, binaryValue) + 8;
    }

    @Override
    protected int getActualEntrySize(long encoding) {
        return super.getActualEntrySize(encoding) + 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeMapping(long encoding, int hash, boolean removal) {
        this.lock.writeLock().lock();
        try {
            long cacheAddress = this.metadataArea.readLong(encoding + (long)this.getCacheOffset(encoding));
            super.freeMapping(encoding, hash, removal);
            if (cacheAddress >= 0L) {
                this.unlinkEntry(cacheAddress);
                this.storage.free(cacheAddress);
            }
            this.validateCache();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V readValue(long encoding) {
        this.lock.readLock().lock();
        try {
            ByteBuffer binaryValue = this.readCachedBinaryValue(encoding);
            if (binaryValue != null) {
                Object t = this.valuePortability.decode(binaryValue);
                return (V)t;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        try (RestartableMinimalStorageEngine.Entry result = this.createEntry(encoding);){
            Object t = this.valuePortability.decode(result.getValue());
            return (V)t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equalsValue(Object value, long encoding) {
        this.lock.readLock().lock();
        try {
            ByteBuffer binaryValue = this.readCachedBinaryValue(encoding);
            if (binaryValue != null) {
                boolean bl = this.valuePortability.equals(value, binaryValue);
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        try (RestartableMinimalStorageEngine.Entry result = this.createEntry(encoding);){
            boolean bl = this.valuePortability.equals(value, result.getValue());
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public K readKey(long encoding, int hashcode) {
        this.lock.readLock().lock();
        try {
            ByteBuffer binaryKey = this.readCachedBinaryKey(encoding);
            if (binaryKey != null) {
                Object t = this.keyPortability.decode(binaryKey);
                return (K)t;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        try (RestartableMinimalStorageEngine.Entry result = this.createEntry(encoding);){
            Object t = this.keyPortability.decode(result.getKey());
            return (K)t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equalsKey(Object key, long encoding) {
        this.lock.readLock().lock();
        try {
            ByteBuffer binaryKey = this.readCachedBinaryKey(encoding);
            if (binaryKey != null) {
                boolean bl = this.keyPortability.equals(key, binaryKey);
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        try (RestartableMinimalStorageEngine.Entry result = this.createEntry(encoding);){
            boolean bl = this.keyPortability.equals(key, result.getKey());
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equalsBinaryKey(ByteBuffer probeBinaryKey, long encoding) {
        this.lock.readLock().lock();
        try {
            ByteBuffer binaryKey = this.readCachedBinaryKey(encoding);
            if (binaryKey != null) {
                this.validateCache();
                boolean bl = this.equalsBinaryKey(probeBinaryKey, binaryKey);
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        try (RestartableMinimalStorageEngine.Entry result = this.createEntry(encoding);){
            boolean bl = this.equalsBinaryKey(probeBinaryKey, result.getKey());
            return bl;
        }
    }

    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.storage.clear();
            this.first = -1L;
            this.last = -1L;
            this.hand = -1L;
            this.validateCache();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        super.clear();
    }

    @Override
    public long getAllocatedMemory() {
        return this.storage.getAllocatedMemory() + super.getAllocatedMemory();
    }

    @Override
    public long getOccupiedMemory() {
        return this.storage.getOccupiedMemory() + super.getOccupiedMemory();
    }

    @Override
    public void bind(StorageEngine.Owner owner) {
        super.bind(new CacheStorageEngineOwner(owner));
    }

    @Override
    public void destroy() {
        this.lock.writeLock().lock();
        try {
            this.storage.destroy();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        super.destroy();
    }

    @Override
    public boolean shrink() {
        this.lock.writeLock().lock();
        try {
            if (this.storage.shrink()) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return super.shrink();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer readBinaryKey(long encoding) {
        this.lock.readLock().lock();
        try {
            ByteBuffer binaryKey = this.readCachedBinaryKey(encoding);
            if (binaryKey != null) {
                ByteBuffer byteBuffer = RestartablePartialStorageEngine.detach(binaryKey);
                return byteBuffer;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        try (RestartableMinimalStorageEngine.Entry result = this.createEntry(encoding);){
            ByteBuffer byteBuffer = RestartablePartialStorageEngine.detach(result.getKey());
            return byteBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer readBinaryValue(long encoding) {
        this.lock.readLock().lock();
        try {
            ByteBuffer binaryValue = this.readCachedBinaryValue(encoding);
            if (binaryValue != null) {
                ByteBuffer byteBuffer = RestartablePartialStorageEngine.detach(binaryValue);
                return byteBuffer;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        try (RestartableMinimalStorageEngine.Entry result = this.createEntry(encoding);){
            ByteBuffer byteBuffer = RestartablePartialStorageEngine.detach(result.getValue());
            return byteBuffer;
        }
    }

    private int getCacheOffset(long encoding) {
        return super.getActualEntrySize(encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RestartableMinimalStorageEngine.Entry createEntry(long encoding) {
        RestartableMinimalStorageEngine.Entry entry = this.readEntry(encoding);
        try {
            this.lock.writeLock().lock();
            try {
                int keyLength = entry.getKey().remaining();
                int valueLength = entry.getValue().remaining();
                do {
                    long cacheAddress;
                    if ((cacheAddress = this.storage.allocate(36 + keyLength + valueLength)) < 0L) continue;
                    this.validateCache();
                    this.storage.writeLong(cacheAddress + 0L, encoding);
                    this.storage.writeInt(cacheAddress + 24L, 1);
                    this.storage.writeInt(cacheAddress + 28L, keyLength);
                    this.storage.writeInt(cacheAddress + 32L, valueLength);
                    this.storage.writeBuffer(cacheAddress + 36L, entry.getKey().duplicate());
                    this.storage.writeBuffer(cacheAddress + 36L + (long)keyLength, entry.getValue().duplicate());
                    this.metadataArea.writeLong(encoding + (long)this.getCacheOffset(encoding), cacheAddress);
                    this.linkEntry(cacheAddress);
                    this.validateCache();
                    RestartableMinimalStorageEngine.Entry entry2 = entry;
                    return entry2;
                } while (this.evict());
                this.metadataArea.writeLong(encoding + (long)this.getCacheOffset(encoding), -1L);
                RestartableMinimalStorageEngine.Entry entry3 = entry;
                return entry3;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (Throwable t) {
            entry.close();
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long free(long encoding) {
        this.lock.writeLock().lock();
        try {
            long cacheAddress = this.metadataArea.readLong(encoding + (long)this.getCacheOffset(encoding));
            if (cacheAddress >= 0L) {
                this.metadataArea.writeLong(encoding + (long)this.getCacheOffset(encoding), -1L);
                this.unlinkEntry(cacheAddress);
                this.storage.free(cacheAddress);
                this.validateCache();
                Long l = cacheAddress;
                return l;
            }
            Long l = null;
            return l;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void linkEntry(long cacheAddress) {
        if (this.hand == -1L) {
            this.storage.writeLong(cacheAddress + 8L, this.last);
            this.storage.writeLong(cacheAddress + 16L, -1L);
            if (this.last == -1L) {
                this.first = cacheAddress;
            } else {
                this.storage.writeLong(this.last + 16L, cacheAddress);
            }
            this.last = cacheAddress;
        } else {
            long prev = this.storage.readLong(this.hand + 8L);
            this.storage.writeLong(cacheAddress + 8L, prev);
            if (prev == -1L) {
                this.first = cacheAddress;
            } else {
                this.storage.writeLong(prev + 16L, cacheAddress);
            }
            this.storage.writeLong(this.hand + 8L, cacheAddress);
            this.storage.writeLong(cacheAddress + 16L, this.hand);
        }
    }

    private void unlinkEntry(long cacheAddress) {
        long prev = this.storage.readLong(cacheAddress + 8L);
        long next = this.storage.readLong(cacheAddress + 16L);
        this.storage.writeLong(cacheAddress + 8L, -1L);
        this.storage.writeLong(cacheAddress + 16L, -1L);
        if (prev == -1L) {
            this.first = next;
        } else {
            this.storage.writeLong(prev + 16L, next);
        }
        if (next == -1L) {
            this.last = prev;
        } else {
            this.storage.writeLong(next + 8L, prev);
        }
        if (this.hand == cacheAddress) {
            this.hand = next;
        }
    }

    private boolean evict() {
        while (true) {
            if (this.hand == -1L) {
                if (this.first == -1L) {
                    return false;
                }
                this.hand = this.first;
            }
            if (this.storage.readInt(this.hand + 24L) == 0) {
                this.free(this.storage.readLong(this.hand + 0L));
                return true;
            }
            this.storage.writeInt(this.hand + 24L, 0);
            this.hand = this.storage.readLong(this.hand + 16L);
        }
    }

    private void validateCache() {
        if (VALIDATING) {
            long previous = -1L;
            long current = this.first;
            while (true) {
                if (current == -1L) {
                    Validation.validate(this.last == previous);
                    break;
                }
                long currentMeta = this.storage.readLong(current + 0L);
                Validation.validate(this.metadataArea.readLong(currentMeta + (long)this.getCacheOffset(currentMeta)) == current);
                Validation.validate(!VALIDATING || this.storage.readLong(current + 8L) == previous);
                if (previous != -1L) {
                    Validation.validate(this.storage.readLong(previous + 16L) == current);
                }
                previous = current;
                current = this.storage.readLong(previous + 16L);
            }
        }
    }

    private ByteBuffer readCachedBinaryKey(long encoding) {
        long cacheAddress = this.metadataArea.readLong(encoding + (long)this.getCacheOffset(encoding));
        if (cacheAddress >= 0L) {
            try {
                this.storage.writeInt(cacheAddress + 24L, 1);
                int keyLength = this.storage.readInt(cacheAddress + 28L);
                this.validateCache();
                return this.storage.readBuffer(cacheAddress + 36L, keyLength);
            }
            catch (NullPointerException e) {
                throw new NullPointerException("NPE reading key @ " + cacheAddress);
            }
        }
        return null;
    }

    private ByteBuffer readCachedBinaryValue(long encoding) {
        long cacheAddress = this.metadataArea.readLong(encoding + (long)this.getCacheOffset(encoding));
        if (cacheAddress >= 0L) {
            this.storage.writeInt(cacheAddress + 24L, 1);
            int keyLength = this.storage.readInt(cacheAddress + 28L);
            int valueLength = this.storage.readInt(cacheAddress + 32L);
            this.validateCache();
            return this.storage.readBuffer(cacheAddress + 36L + (long)keyLength, valueLength);
        }
        return null;
    }

    private class CacheStorageAreaOwner
    implements OffHeapStorageArea.Owner {
        private CacheStorageAreaOwner() {
        }

        @Override
        public Collection<Long> evictAtAddress(long address, boolean shrink) {
            Long freed = RestartablePartialStorageEngine.this.free(RestartablePartialStorageEngine.this.storage.readLong(address + 0L));
            if (freed == null) {
                return Collections.emptyList();
            }
            return Collections.singleton(freed);
        }

        @Override
        public Lock writeLock() {
            return RestartablePartialStorageEngine.this.lock.writeLock();
        }

        @Override
        public boolean isThief() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean moved(long from, long to) {
            RestartablePartialStorageEngine.this.lock.writeLock().lock();
            try {
                long metaAddress = RestartablePartialStorageEngine.this.storage.readLong(to + 0L);
                RestartablePartialStorageEngine.this.metadataArea.writeLong(metaAddress + (long)RestartablePartialStorageEngine.this.getCacheOffset(to), to);
                long prev = RestartablePartialStorageEngine.this.storage.readLong(to + 8L);
                long next = RestartablePartialStorageEngine.this.storage.readLong(to + 16L);
                if (prev == -1L) {
                    RestartablePartialStorageEngine.this.first = to;
                } else {
                    RestartablePartialStorageEngine.this.storage.writeLong(prev + 16L, to);
                }
                if (next == -1L) {
                    RestartablePartialStorageEngine.this.last = to;
                } else {
                    RestartablePartialStorageEngine.this.storage.writeLong(next + 8L, to);
                }
                if (RestartablePartialStorageEngine.this.hand == from) {
                    RestartablePartialStorageEngine.this.hand = to;
                }
                RestartablePartialStorageEngine.this.validateCache();
                boolean bl = true;
                return bl;
            }
            finally {
                RestartablePartialStorageEngine.this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int sizeOf(long cacheAddress) {
            RestartablePartialStorageEngine.this.lock.readLock().lock();
            try {
                int keyLength = RestartablePartialStorageEngine.this.storage.readInt(cacheAddress + 28L);
                int valueLength = RestartablePartialStorageEngine.this.storage.readInt(cacheAddress + 32L);
                int n = 36 + keyLength + valueLength;
                return n;
            }
            finally {
                RestartablePartialStorageEngine.this.lock.readLock().unlock();
            }
        }
    }

    private class CacheStorageEngineOwner
    implements StorageEngine.Owner {
        private final StorageEngine.Owner owner;

        public CacheStorageEngineOwner(StorageEngine.Owner owner) {
            this.owner = owner;
        }

        @Override
        public Long getEncodingForHashAndBinary(int hash, ByteBuffer offHeapBinaryKey) {
            return this.owner.getEncodingForHashAndBinary(hash, offHeapBinaryKey);
        }

        @Override
        public long getSize() {
            return this.owner.getSize();
        }

        @Override
        public long installMappingForHashAndEncoding(int pojoHash, ByteBuffer offheapBinaryKey, ByteBuffer offheapBinaryValue, int metadata) {
            return this.owner.installMappingForHashAndEncoding(pojoHash, offheapBinaryKey, offheapBinaryValue, metadata);
        }

        @Override
        public Iterable<Long> encodingSet() {
            return this.owner.encodingSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean updateEncoding(int hashCode, long from, long to, long mask) {
            if (this.owner.updateEncoding(hashCode, from, to, mask)) {
                RestartablePartialStorageEngine.this.lock.writeLock().lock();
                try {
                    long cacheAddress = RestartablePartialStorageEngine.this.metadataArea.readLong(to + (long)RestartablePartialStorageEngine.this.getCacheOffset(to));
                    if (cacheAddress >= 0L) {
                        RestartablePartialStorageEngine.this.storage.writeLong(cacheAddress + 0L, to);
                    }
                }
                finally {
                    RestartablePartialStorageEngine.this.lock.writeLock().unlock();
                }
                return true;
            }
            return false;
        }

        @Override
        public Integer getSlotForHashAndEncoding(int hash, long address, long mask) {
            return this.owner.getSlotForHashAndEncoding(hash, address, mask);
        }

        @Override
        public boolean evict(int slot, boolean b) {
            return this.owner.evict(slot, b);
        }

        @Override
        public boolean isThiefForTableAllocations() {
            return this.owner.isThiefForTableAllocations();
        }

        @Override
        public Lock readLock() {
            return this.owner.readLock();
        }

        @Override
        public Lock writeLock() {
            return this.owner.writeLock();
        }
    }
}

