/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.TransactionAbortedException;
import org.apache.ojb.broker.TransactionInProgressException;
import org.apache.ojb.broker.TransactionNotInProgressException;
import org.apache.ojb.broker.accesslayer.ConnectionFactory;
import org.apache.ojb.broker.accesslayer.ConnectionFactoryFactory;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.accesslayer.OJBBatchUpdateException;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.platforms.PlatformFactory;
import org.apache.ojb.broker.util.batch.BatchConnection;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ConnectionManagerImpl
implements ConnectionManagerIF {
    private Logger log = LoggerFactory.getLogger(ConnectionManagerImpl.class);
    private PersistenceBrokerImpl broker = null;
    private ConnectionFactory connectionFactory;
    private JdbcConnectionDescriptor jcd;
    private Platform platform;
    private Connection con = null;
    private PBKey pbKey;
    private boolean originalAutoCommitState;
    private boolean isInLocalTransaction;
    private boolean batchMode;
    private BatchConnection batchCon = null;

    public ConnectionManagerImpl(PersistenceBroker persistenceBroker) {
        this.broker = (PersistenceBrokerImpl)persistenceBroker;
        this.pbKey = persistenceBroker.getPBKey();
        this.jcd = MetadataManager.getInstance().connectionRepository().getDescriptor(this.pbKey);
        this.connectionFactory = ConnectionFactoryFactory.getInstance().createConnectionFactory();
        this.platform = PlatformFactory.getPlatformFor(this.jcd);
        this.setBatchMode(false);
    }

    @Override
    public JdbcConnectionDescriptor getConnectionDescriptor() {
        return this.jcd;
    }

    @Override
    public Platform getSupportedPlatform() {
        return this.platform;
    }

    @Override
    public Connection getConnection() throws LookupException {
        if (this.con != null && !this.isInLocalTransaction() && !this.isAlive(this.con)) {
            this.releaseConnection();
        }
        if (this.con == null) {
            this.con = this.connectionFactory.lookupConnection(this.jcd);
            if (this.con == null) {
                throw new PersistenceBrokerException("Cannot get connection for " + this.jcd);
            }
            if (this.jcd.getUseAutoCommit() == 1) {
                try {
                    this.originalAutoCommitState = this.con.getAutoCommit();
                }
                catch (SQLException sQLException) {
                    throw new PersistenceBrokerException("Cannot request autoCommit state on the connection", sQLException);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Request new connection from ConnectionFactory: " + this.con);
            }
        }
        if (this.isBatchMode()) {
            if (this.batchCon == null) {
                this.batchCon = new BatchConnection(this.con, this.broker);
            }
            return this.batchCon;
        }
        return this.con;
    }

    @Override
    public void localBegin() {
        if (this.isInLocalTransaction) {
            throw new TransactionInProgressException("Connection is already in transaction");
        }
        Connection connection = null;
        try {
            connection = this.getConnection();
        }
        catch (LookupException lookupException) {
            throw new PersistenceBrokerException("Can't lookup a connection", (Throwable)((Object)lookupException));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("localBegin was called for con " + connection);
        }
        if (!this.broker.isManaged()) {
            if (this.jcd.getUseAutoCommit() == 1) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Try to change autoCommit state to 'false'");
                }
                this.platform.changeAutoCommitState(this.jcd, connection, false);
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Found managed environment setting in PB, will skip Platform.changeAutoCommitState(...) call");
        }
        this.isInLocalTransaction = true;
    }

    @Override
    public void localCommit() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("commit was called");
        }
        if (!this.isInLocalTransaction) {
            throw new TransactionNotInProgressException("Not in transaction, call begin() before commit()");
        }
        try {
            if (!this.broker.isManaged()) {
                if (this.batchCon != null) {
                    this.batchCon.commit();
                } else if (this.con != null) {
                    this.con.commit();
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Found managed environment setting in PB, will skip Connection.commit() call");
            }
        }
        catch (SQLException sQLException) {
            this.log.error("Commit on underlying connection failed, try to rollback connection", sQLException);
            this.localRollback();
            throw new TransactionAbortedException("Commit on connection failed", sQLException);
        }
        finally {
            this.isInLocalTransaction = false;
            this.restoreAutoCommitState();
            this.releaseConnection();
        }
    }

    @Override
    public void localRollback() {
        this.log.info("Rollback was called, do rollback on current connection " + this.con);
        if (!this.isInLocalTransaction) {
            throw new PersistenceBrokerException("Not in transaction, cannot abort");
        }
        try {
            this.isInLocalTransaction = false;
            if (!this.broker.isManaged()) {
                if (this.batchCon != null) {
                    this.batchCon.rollback();
                } else if (this.con != null && !this.con.isClosed()) {
                    this.con.rollback();
                }
            } else if (this.log.isEnabledFor(2)) {
                this.log.info("Found managed environment setting in PB, will ignore rollback call on connection, this should be done by JTA");
            }
        }
        catch (SQLException sQLException) {
            this.log.error("Rollback on the underlying connection failed", sQLException);
        }
        finally {
            try {
                this.restoreAutoCommitState();
            }
            catch (OJBRuntimeException oJBRuntimeException) {}
            this.releaseConnection();
        }
    }

    protected void restoreAutoCommitState() {
        try {
            if (!this.broker.isManaged()) {
                if (this.jcd.getUseAutoCommit() == 1 && this.originalAutoCommitState && this.con != null && !this.con.isClosed()) {
                    this.platform.changeAutoCommitState(this.jcd, this.con, true);
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Found managed environment setting in PB, will skip Platform.changeAutoCommitState(...) call");
            }
        }
        catch (SQLException sQLException) {
            throw new OJBRuntimeException("Restore of connection autocommit state failed", sQLException);
        }
    }

    @Override
    public boolean isAlive(Connection connection) {
        try {
            return this.con != null ? !this.con.isClosed() : false;
        }
        catch (SQLException sQLException) {
            this.log.error("IsAlive check failed, running connection was invalid!!", sQLException);
            return false;
        }
    }

    @Override
    public boolean isInLocalTransaction() {
        return this.isInLocalTransaction;
    }

    @Override
    public void releaseConnection() {
        if (this.con == null) {
            return;
        }
        if (this.isInLocalTransaction()) {
            this.log.error("Release connection: connection is in local transaction, missing 'localCommit' or 'localRollback' call - try to rollback the connection");
            this.localRollback();
        } else {
            this.connectionFactory.releaseConnection(this.jcd, this.con);
            this.con = null;
            this.batchCon = null;
        }
    }

    public ConnectionFactory getUnderlyingConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    public void setBatchMode(boolean bl) {
        this.batchMode = bl && this.jcd.getBatchMode();
    }

    @Override
    public boolean isBatchMode() {
        return this.batchMode && this.platform.supportsBatchOperations();
    }

    @Override
    public void executeBatch() throws OJBBatchUpdateException {
        if (this.batchCon != null) {
            try {
                this.batchCon.executeBatch();
            }
            catch (Throwable throwable) {
                throw new OJBBatchUpdateException(throwable);
            }
        }
    }

    @Override
    public void executeBatchIfNecessary() throws OJBBatchUpdateException {
        if (this.batchCon != null) {
            try {
                this.batchCon.executeBatchIfNecessary();
            }
            catch (Throwable throwable) {
                throw new OJBBatchUpdateException(throwable);
            }
        }
    }

    @Override
    public void clearBatch() {
        if (this.batchCon != null) {
            this.batchCon.clearBatch();
        }
    }
}

