/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.dataovveride.common;

import org.apache.commons.lang.StringUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.data.DataType;
import org.kuali.rice.krad.datadictionary.AttributeDefinition;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.uif.field.InputFieldBase;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;

public abstract class AbstractDataOverrideInputField
extends InputFieldBase {
    private static final String YES = "Yes";
    private static final String Y = "Y";
    private static final String NO = "No";
    private static final String ON = "on";
    private boolean inCollection;
    private transient DataDictionaryService dataDictionaryService;

    public abstract String getEntryName();

    public void performApplyModel(Object model, LifecycleElement parent) {
        if (this.inCollection && StringUtils.isNotBlank((String)this.getDictionaryAttributeName())) {
            AttributeDefinition attributeDefinition = this.getDataDictionaryService().getAttributeDefinition(this.getEntryName(), this.getDictionaryAttributeName());
            if (attributeDefinition.getDataType() == DataType.BOOLEAN) {
                Object value = ObjectPropertyUtils.getPropertyValue((Object)model, (String)this.getBindingInfo().getBindingPath());
                this.setReadOnlyDisplayReplacement(ON.equals(value) || YES.equals(value) || Y.equals(value) ? YES : NO);
            }
            this.copyFromAttributeDefinition(attributeDefinition);
        }
        super.performApplyModel(model, parent);
    }

    public String getReadOnlyDisplayReplacement() {
        return super.getReadOnlyDisplayReplacement();
    }

    public boolean isInCollection() {
        return this.inCollection;
    }

    public void setInCollection(boolean inCollection) {
        this.inCollection = inCollection;
    }

    public DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KcServiceLocator.getService(DataDictionaryService.class);
        }
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

