/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.document;

import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentAuthorizerBase;
import org.kuali.rice.krad.document.TransactionalDocumentAuthorizer;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

public class TransactionalDocumentAuthorizerBase
extends DocumentAuthorizerBase
implements TransactionalDocumentAuthorizer {
    private static final long serialVersionUID = 3255133642834256283L;
    private DataDictionaryService dataDictionaryService;

    @Override
    public boolean canClose(Document document, Person user) {
        return true;
    }

    @Override
    public boolean canSave(Document document, Person user) {
        boolean canSave = super.canSave(document, user);
        if (!this.isUsingPessimisticLocking(document)) {
            return canSave;
        }
        return canSave && this.canEstablishPessimisticLock(document, user);
    }

    @Override
    public boolean canRoute(Document document, Person user) {
        boolean canRoute = super.canRoute(document, user);
        if (!this.isUsingPessimisticLocking(document)) {
            return canRoute;
        }
        return canRoute && this.canEstablishPessimisticLock(document, user);
    }

    @Override
    public boolean canCancel(Document document, Person user) {
        boolean canCancel = super.canCancel(document, user);
        if (!this.isUsingPessimisticLocking(document)) {
            return canCancel;
        }
        return canCancel && this.canEstablishPessimisticLock(document, user);
    }

    @Override
    public boolean canBlanketApprove(Document document, Person user) {
        boolean canBlanketApprove = super.canBlanketApprove(document, user);
        if (!this.isUsingPessimisticLocking(document)) {
            return canBlanketApprove;
        }
        return canBlanketApprove && this.canEstablishPessimisticLock(document, user);
    }

    protected boolean isUsingPessimisticLocking(Document document) {
        String documentClassName = document.getClass().getName();
        DocumentEntry documentEntry = this.getDataDictionaryService().getDataDictionary().getDocumentEntry(documentClassName);
        return documentEntry.getUsePessimisticLocking();
    }

    protected boolean canEstablishPessimisticLock(Document document, Person user) {
        if (document.getPessimisticLocks().isEmpty()) {
            return true;
        }
        for (PessimisticLock pessimisticLock : document.getPessimisticLocks()) {
            if (!pessimisticLock.isOwnedByUser(user)) continue;
            return true;
        }
        return false;
    }

    protected DataDictionaryService getDataDictionaryService() {
        if (this.dataDictionaryService == null) {
            this.dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return this.dataDictionaryService;
    }

    protected void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }
}

