/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.budget;

import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.common.budget.api.core.category.BudgetCategoryMapContract;
import org.kuali.coeus.common.budget.api.core.category.BudgetCategoryMapService;
import org.kuali.coeus.common.budget.api.core.category.BudgetCategoryMappingContract;
import org.kuali.coeus.s2sgen.impl.budget.S2SBudgetCategoryMapService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="s2SBudgetCategoryMapService")
public class S2SBudgetCategoryMapServiceImpl
implements S2SBudgetCategoryMapService {
    private static final String SPONSOR = "S2S";
    @Autowired
    @Qualifier(value="budgetCategoryMapService")
    private BudgetCategoryMapService budgetCategoryMapService;

    @Override
    public List<? extends BudgetCategoryMapContract> getBudgetCategoryMapList(List<String> filterTargetCategoryCodes, List<String> filterCategoryTypes) {
        ArrayList<BudgetCategoryMapContract> budgetCategoryMapList = new ArrayList<BudgetCategoryMapContract>();
        List budgetCategoryMappingList = this.budgetCategoryMapService.findCatMappingByMappingName(SPONSOR);
        for (BudgetCategoryMappingContract categoryMapping : budgetCategoryMappingList) {
            boolean targetMatched = true;
            if (filterTargetCategoryCodes.size() > 0) {
                for (String targetCategoryCode : filterTargetCategoryCodes) {
                    if (!categoryMapping.getTargetCategoryCode().equals(targetCategoryCode)) continue;
                    targetMatched = false;
                    break;
                }
            }
            if (!targetMatched) continue;
            for (BudgetCategoryMapContract filterMap : this.budgetCategoryMapService.findCatMapByTargetAndMappingName(categoryMapping.getTargetCategoryCode(), categoryMapping.getMappingName())) {
                targetMatched = true;
                if (filterCategoryTypes.size() > 0) {
                    for (String categoryType : filterCategoryTypes) {
                        if (!filterMap.getCategoryType().trim().equals(categoryType.trim())) continue;
                        targetMatched = false;
                        break;
                    }
                }
                if (!targetMatched) continue;
                boolean duplicateExists = false;
                for (BudgetCategoryMapContract map : budgetCategoryMapList) {
                    if (!filterMap.getTargetCategoryCode().equals(map.getTargetCategoryCode())) continue;
                    duplicateExists = true;
                    break;
                }
                if (duplicateExists) continue;
                budgetCategoryMapList.add(filterMap);
            }
        }
        return budgetCategoryMapList;
    }

    public void setBudgetCategoryMapService(BudgetCategoryMapService budgetCategoryMapService) {
        this.budgetCategoryMapService = budgetCategoryMapService;
    }

    public BudgetCategoryMapService getBudgetCategoryMapService() {
        return this.budgetCategoryMapService;
    }
}

