/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.edSF424SupplementV11.EDSF424SupplementDocument;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoNotApplicableDataType;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.propdev.api.specialreview.ProposalSpecialReviewContract;
import org.kuali.coeus.propdev.api.specialreview.ProposalSpecialReviewExemptionContract;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.EDSF424SupplementBaseGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="EDSF424SupplementV1_1Generator")
public class EDSF424SupplementV1_1Generator
extends EDSF424SupplementBaseGenerator<EDSF424SupplementDocument> {
    @Value(value="http://apply.grants.gov/forms/ED_SF424_Supplement-V1.1")
    private String namespace;
    @Value(value="ED_SF424_Supplement-V1.1")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/ED_SF424_Supplement-V1.1.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="1000")
    private int sortIndex;
    @Autowired
    @Qualifier(value="s2SConfigurationService")
    private S2SConfigurationService s2SConfigurationService;

    private EDSF424SupplementDocument getEDSF424Supplement() {
        EDSF424SupplementDocument edsf424SupplementDocument = (EDSF424SupplementDocument)EDSF424SupplementDocument.Factory.newInstance();
        EDSF424SupplementDocument.EDSF424Supplement edsf424Supplement = (EDSF424SupplementDocument.EDSF424Supplement)EDSF424SupplementDocument.EDSF424Supplement.Factory.newInstance();
        edsf424Supplement.setFormVersion(FormVersion.v1_1.getVersion());
        ProposalPersonContract pi = this.getS2SProposalPersonService().getPrincipalInvestigator(this.pdDoc);
        edsf424Supplement.setProjectDirector(this.globLibV20Generator.getContactPersonDataType(pi));
        String answer = null;
        List answerHeaders = this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        if (answerHeaders != null && !answerHeaders.isEmpty()) {
            for (Object answerHeader : answerHeaders) {
                List answerDetails = answerHeader.getAnswers();
                for (AnswerContract answers : answerDetails) {
                    Integer seqId = this.getQuestionAnswerService().findQuestionById(answers.getQuestionId()).getQuestionSeqId();
                    if (seqId == null || !seqId.equals(PROPOSAL_YNQ_NOVICE_APPLICANT)) continue;
                    if (answers.getAnswer() != null) {
                        answer = answers.getAnswer();
                    }
                    if (YnqConstant.YES.code().equals(answer)) {
                        edsf424Supplement.setIsNoviceApplicant(YesNoNotApplicableDataType.Y_YES);
                        continue;
                    }
                    if (YnqConstant.NO.code().equals(answer)) {
                        edsf424Supplement.setIsNoviceApplicant(YesNoNotApplicableDataType.N_NO);
                        continue;
                    }
                    if (!YnqConstant.NA.code().equals(answer)) continue;
                    edsf424Supplement.setIsNoviceApplicant(YesNoNotApplicableDataType.NA_NOT_APPLICABLE);
                }
            }
        }
        edsf424Supplement.setIsHumanResearch(YesNoDataType.N_NO);
        OrganizationContract organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        for (ProposalSpecialReviewContract specialReview : this.pdDoc.getDevelopmentProposal().getPropSpecialReviews()) {
            if (specialReview.getSpecialReviewType() != null && specialReview.getSpecialReviewType().getCode().equals("1")) {
                edsf424Supplement.setIsHumanResearch(YesNoDataType.Y_YES);
                if (specialReview.getApprovalType() != null && specialReview.getApprovalType().getCode().equals("4")) {
                    edsf424Supplement.setIsHumanResearchExempt(YesNoDataType.Y_YES);
                    EDSF424SupplementDocument.EDSF424Supplement.ExemptionsNumber exemptionsNumber = (EDSF424SupplementDocument.EDSF424Supplement.ExemptionsNumber)EDSF424SupplementDocument.EDSF424Supplement.ExemptionsNumber.Factory.newInstance();
                    exemptionsNumber.setIsHumanResearchExempt(YesNoDataType.Y_YES);
                    if (specialReview.getSpecialReviewExemptions() != null && specialReview.getSpecialReviewExemptions().size() > 0) {
                        ArrayList<String> exemptionTypeCodes = new ArrayList<String>();
                        for (ProposalSpecialReviewExemptionContract exemption : specialReview.getSpecialReviewExemptions()) {
                            exemptionTypeCodes.add(exemption.getExemptionType().getCode());
                        }
                        exemptionsNumber.setStringValue(EDSF424SupplementV1_1Generator.colToString(exemptionTypeCodes));
                    }
                    edsf424Supplement.setExemptionsNumber(exemptionsNumber);
                    break;
                }
                edsf424Supplement.setIsHumanResearchExempt(YesNoDataType.N_NO);
                if (organization == null) break;
                EDSF424SupplementDocument.EDSF424Supplement.AssuranceNumber assuranceNumber = (EDSF424SupplementDocument.EDSF424Supplement.AssuranceNumber)EDSF424SupplementDocument.EDSF424Supplement.AssuranceNumber.Factory.newInstance();
                assuranceNumber.setIsHumanResearchExempt(YesNoDataType.N_NO);
                if (organization.getHumanSubAssurance() != null) {
                    assuranceNumber.setStringValue(organization.getHumanSubAssurance());
                }
                edsf424Supplement.setAssuranceNumber(assuranceNumber);
                break;
            }
            edsf424Supplement.setIsHumanResearch(YesNoDataType.N_NO);
        }
        AttachedFileDataType attachedFileDataType = null;
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 54 || (attachedFileDataType = this.addAttachedFileType(narrative)) == null) continue;
            edsf424Supplement.setAttachment(attachedFileDataType);
            break;
        }
        edsf424SupplementDocument.setEDSF424Supplement(edsf424Supplement);
        return edsf424SupplementDocument;
    }

    @Override
    public EDSF424SupplementDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getEDSF424Supplement();
    }

    public S2SConfigurationService getS2SConfigurationService() {
        return this.s2SConfigurationService;
    }

    public void setS2SConfigurationService(S2SConfigurationService s2SConfigurationService) {
        this.s2SConfigurationService = s2SConfigurationService;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public DocumentFactory<EDSF424SupplementDocument> factory() {
        return EDSF424SupplementDocument.Factory;
    }
}

