/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.faithBasedSurveyOnEEOV12.SurveyOnEEODocument;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.propdev.api.s2s.S2sOpportunityContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.sys.api.model.Cfda;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="FaithBasedSurveyOnEEOV1_2Generator")
public class FaithBasedSurveyOnEEOV1_2Generator
extends S2SBaseFormGenerator<SurveyOnEEODocument>
implements S2SFormGeneratorPdfFillable<SurveyOnEEODocument> {
    @Value(value="http://apply.grants.gov/forms/FaithBased_SurveyOnEEO-V1.2")
    private String namespace;
    @Value(value="FaithBased_SurveyOnEEO-V1.2")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/FaithBased_SurveyOnEEO-V1.2.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/FaithBased_SurveyOnEEO-V1.2.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;

    private SurveyOnEEODocument getSurveyOnEEO() {
        SurveyOnEEODocument surveyOnEEODocument = (SurveyOnEEODocument)SurveyOnEEODocument.Factory.newInstance();
        SurveyOnEEODocument.SurveyOnEEO surveyOnEEO = (SurveyOnEEODocument.SurveyOnEEO)SurveyOnEEODocument.SurveyOnEEO.Factory.newInstance();
        surveyOnEEO.setFormVersion(FormVersion.v1_2.getVersion());
        ProposalSiteContract proposalSite = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        if (proposalSite != null) {
            OrganizationContract organization = proposalSite.getOrganization();
            if (proposalSite.getLocationName() != null) {
                surveyOnEEO.setOrganizationName(StringUtils.substring((String)proposalSite.getLocationName(), (int)0, (int)60));
            }
            if (organization.getDunsNumber() != null) {
                if (organization.getDunsNumber().length() > 13) {
                    surveyOnEEO.setDUNSID(organization.getDunsNumber().substring(0, 13));
                } else {
                    surveyOnEEO.setDUNSID(organization.getDunsNumber());
                }
            }
        }
        S2sOpportunityContract s2sOpportunity = this.pdDoc.getDevelopmentProposal().getS2sOpportunity();
        String opportunityTitle = "";
        if (s2sOpportunity != null) {
            opportunityTitle = s2sOpportunity.getOpportunityTitle();
            s2sOpportunity.getS2sOpportunityCfdas().stream().map(Cfda::getCfdaNumber).findFirst().ifPresent(surveyOnEEO::setCFDANumber);
        }
        surveyOnEEO.setOpportunityTitle(opportunityTitle);
        surveyOnEEODocument.setSurveyOnEEO(surveyOnEEO);
        return surveyOnEEODocument;
    }

    @Override
    public SurveyOnEEODocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getSurveyOnEEO();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(SurveyOnEEODocument form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<SurveyOnEEODocument> factory() {
        return SurveyOnEEODocument.Factory;
    }
}

