/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrsf424SF424BV11.AssuranceType;
import gov.grants.apply.forms.rrsf424SF424BV11.AssurancesDocument;
import gov.grants.apply.forms.rrsf424SF424BV11.AuthorizedRepresentativeDocument;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="RRSF424BV1_1Generator")
public class RRSF424BV1_1Generator
extends S2SBaseFormGenerator<AssurancesDocument>
implements S2SFormGeneratorPdfFillable<AssurancesDocument> {
    private static final String NON_CONSTRUCTION = "Non-Construction";
    @Autowired
    @Qualifier(value="departmentalPersonService")
    private DepartmentalPersonService departmentalPersonService;
    @Value(value="http://apply.grants.gov/forms/RRSF424_SF424B-V1.1")
    private String namespace;
    @Value(value="RRSF424_SF424B-V1.1")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RRSF424B-V1.1.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/RRSF424_SF424B-V1.1.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;

    @Override
    public AssurancesDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) throws S2SException {
        AssurancesDocument assurcesDocument = (AssurancesDocument)AssurancesDocument.Factory.newInstance();
        DevelopmentProposalContract propDevFormBean = proposalDevelopmentDocument.getDevelopmentProposal();
        AssuranceType rrSF424B = assurcesDocument.addNewAssurances();
        rrSF424B.setFormVersionIdentifier(FormVersion.v1_1.getVersion());
        rrSF424B.setProgramType(NON_CONSTRUCTION);
        rrSF424B.setFormVersion(FormVersion.v1_1.getVersion());
        ProposalSiteContract applicantOrganization = propDevFormBean.getApplicantOrganization();
        rrSF424B.setApplicantOrganizationName(StringUtils.substring((String)applicantOrganization.getLocationName(), (int)0, (int)60));
        DepartmentalPersonDto aorInfo = this.departmentalPersonService.getDepartmentalPerson(proposalDevelopmentDocument);
        rrSF424B.setAuthorizedRepresentative(this.getAuthorizedRepresentative(aorInfo));
        rrSF424B.setSubmittedDate(aorInfo.getSubmittedDate());
        return assurcesDocument;
    }

    private AuthorizedRepresentativeDocument.AuthorizedRepresentative getAuthorizedRepresentative(DepartmentalPersonDto aorInfo) {
        AuthorizedRepresentativeDocument.AuthorizedRepresentative authorizedRepresentative = (AuthorizedRepresentativeDocument.AuthorizedRepresentative)AuthorizedRepresentativeDocument.AuthorizedRepresentative.Factory.newInstance();
        if (aorInfo.getPrimaryTitle() != null) {
            authorizedRepresentative.setRepresentativeTitle(StringUtils.substring((String)aorInfo.getPrimaryTitle(), (int)0, (int)45));
        }
        authorizedRepresentative.setRepresentativeName(aorInfo.getFullName());
        return authorizedRepresentative;
    }

    public DepartmentalPersonService getDepartmentalPersonService() {
        return this.departmentalPersonService;
    }

    public void setDepartmentalPersonService(DepartmentalPersonService departmentalPersonService) {
        this.departmentalPersonService = departmentalPersonService;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(AssurancesDocument form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<AssurancesDocument> factory() {
        return AssurancesDocument.Factory;
    }
}

