/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.system.globalLibraryV20.ApplicantTypeCodeDataType;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.common.api.org.type.OrganizationTypeContract;
import org.kuali.coeus.propdev.api.core.SubmissionInfoService;
import org.kuali.coeus.propdev.api.s2s.S2SConfigurationService;
import org.kuali.coeus.s2sgen.impl.datetime.S2SDateTimeService;
import org.kuali.coeus.s2sgen.impl.generate.support.CommonSF424BaseGenerator;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonService;
import org.kuali.coeus.s2sgen.impl.person.S2SProposalPersonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class SF424BaseGenerator<T extends XmlObject>
extends CommonSF424BaseGenerator<T> {
    protected static final int APPLICANT_TYPE_1_INDEX = 0;
    protected static final int APPLICANT_TYPE_2_INDEX = 1;
    protected static final int APPLICANT_TYPE_3_INDEX = 2;
    public static final int PROGRAM_ANNOUNCEMENT_TITLE_LENGTH = 120;
    public static final int AREAS_AFFECTED_MAX_LENGTH = 250;
    public static final String REVISIONCODE_STARTS_WITH_E = "E";
    public static final int CONGRESSIONAL_DISTRICTS_ATTACHMENT = 42;
    public static final int PROJECT_TITLE_ATTACHMENT = 41;
    public static final int ABSTRACTTYPE_CODE_AREAS_AFFECTED = 16;
    public static final String STATE_REVIEW_YES = "Y";
    public static final String STATE_REVIEW_NO = "N";
    public static final String STATE_REVIEW_NA = "X";
    public static final String PROPOSAL_YNQ_FEDERAL_DEBTS = "I7";
    public static final String CORE_SCHEMA_VERSION_1_0 = "1.0";
    protected static final String NON_CONSTRUCTION = "Non-Construction";
    protected static final String TARGET_CATEGORY_CODE_SUPPLIES = "43";
    protected static final String TARGET_CATEGORY_CODE_CONSTRUCTION = "40";
    protected static final String TARGET_CATEGORY_CODE_CONTRACTUAL = "04";
    protected static final String TARGET_CATEGORY_CODE_EQUIPMENT = "42";
    protected static final String TARGET_CATEGORY_CODE_OTHER_DIRECT_COSTS = "39";
    protected static final String TARGET_CATEGORY_CODE_EQUIPMENT_RENTAL = "45";
    protected static final String TARGET_CATEGORY_CODE_TRAVEL = "73";
    protected static final String TARGET_CATEGORY_CODE_FOREIGN_TRAVEL = "74";
    protected static final String TARGET_CATEGORY_CODE_PARTICIPANT_STIPENDS = "75";
    protected static final String TARGET_CATEGORY_CODE_PARTICIPANT_TUITION = "76";
    protected static final String TARGET_CATEGORY_CODE_PARTICIPANT_TRAVEL = "77";
    protected static final String TARGET_CATEGORY_CODE_PARTICIPANT_OTHER = "78";
    protected static final String TARGET_CATEGORY_CODE_PARTICIPANT_SUBSISTENCE = "79";
    protected static final String TARGET_CATEGORY_CODE_PUBLICATION_COSTS = "80";
    protected static final String TARGET_CATEGORY_CODE_CONSULTANT_COSTS = "81";
    protected static final String TARGET_CATEGORY_CODE_COMPUTER_SERVICES = "82";
    protected static final String TARGET_CATEGORY_TYPE_CODE_PERSONNEL = "P";
    protected static final String RATE_CLASS_TYPE_EMPLOYEE_BENEFITS = "E";
    protected static final String RATE_CLASS_TYPE_LA_SALARIES = "Y";
    protected static final String RATE_CLASS_TYPE_LAB_ALLOCATION = "L";
    protected static final String RATE_CLASS_TYPE_VACATION = "V";
    protected static final String PROGRAM_TYPE = "Non-Construction";
    protected static final String INCREASE_AWARD_CODE = "A";
    protected static final String DECREASE_AWARD_CODE = "B";
    protected static final String INCREASE_DURATION_CODE = "C";
    protected static final String DECREASE_DURATION_CODE = "D";
    protected static final String OTHER_SPECIFY_CODE = "E";
    protected static final String INCREASE_AWARD_INCREASE_DURATION_CODE = "AC";
    protected static final String INCREASE_AWARD_DECREASE_DURATION_CODE = "AD";
    protected static final String DECREASE_AWARD_INCREASE_DURATION_CODE = "BC";
    protected static final String DECREASE_AWARD_DECREASE_DURATION_CODE = "BD";
    protected static final int DEPARTMENT_NAME_MAX_LENGTH = 30;
    @Autowired
    @Qualifier(value="submissionInfoService")
    protected SubmissionInfoService submissionInfoService;
    @Autowired
    @Qualifier(value="departmentalPersonService")
    protected DepartmentalPersonService departmentalPersonService;
    @Autowired
    @Qualifier(value="s2SProposalPersonService")
    protected S2SProposalPersonService s2SProposalPersonService;
    @Autowired
    @Qualifier(value="s2SDateTimeService")
    protected S2SDateTimeService s2SDateTimeService;
    @Autowired
    @Qualifier(value="s2SConfigurationService")
    protected S2SConfigurationService s2SConfigurationService;

    protected boolean doesParameterContainCode(String parameterName, String code) {
        List parameterValues = this.s2SConfigurationService.getValuesFromCommaSeparatedParam(parameterName);
        return parameterValues.contains(code);
    }

    protected ApplicantTypeCodeDataType.Enum getApplicantType(List<? extends OrganizationTypeContract> organizationTypes, int index) {
        if (index < organizationTypes.size()) {
            OrganizationTypeContract orgType = organizationTypes.get(index);
            int orgTypeCode = orgType.getOrganizationTypeList().getCode();
            return switch (orgTypeCode) {
                case 1 -> ApplicantTypeCodeDataType.C_CITY_OR_TOWNSHIP_GOVERNMENT;
                case 2 -> ApplicantTypeCodeDataType.A_STATE_GOVERNMENT;
                case 3 -> ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                case 4 -> ApplicantTypeCodeDataType.M_NONPROFIT_WITH_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                case 5 -> ApplicantTypeCodeDataType.N_NONPROFIT_WITHOUT_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                case 6 -> ApplicantTypeCodeDataType.Q_FOR_PROFIT_ORGANIZATION_OTHER_THAN_SMALL_BUSINESS;
                case 7 -> ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                case 8 -> ApplicantTypeCodeDataType.I_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_FEDERALLY_RECOGNIZED;
                case 9 -> ApplicantTypeCodeDataType.P_INDIVIDUAL;
                case 10 -> ApplicantTypeCodeDataType.O_PRIVATE_INSTITUTION_OF_HIGHER_EDUCATION;
                case 11 -> ApplicantTypeCodeDataType.R_SMALL_BUSINESS;
                case 14 -> ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                case 15 -> ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                case 21 -> ApplicantTypeCodeDataType.H_PUBLIC_STATE_CONTROLLED_INSTITUTION_OF_HIGHER_EDUCATION;
                case 22 -> ApplicantTypeCodeDataType.B_COUNTY_GOVERNMENT;
                case 23 -> ApplicantTypeCodeDataType.D_SPECIAL_DISTRICT_GOVERNMENT;
                case 24 -> ApplicantTypeCodeDataType.G_INDEPENDENT_SCHOOL_DISTRICT;
                case 25 -> ApplicantTypeCodeDataType.L_PUBLIC_INDIAN_HOUSING_AUTHORITY;
                case 26 -> ApplicantTypeCodeDataType.J_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_OTHER_THAN_FEDERALLY_RECOGNIZED;
                case 100 -> ApplicantTypeCodeDataType.E_REGIONAL_ORGANIZATION;
                case 101 -> ApplicantTypeCodeDataType.F_U_S_TERRITORY_OR_POSSESSION;
                case 102 -> ApplicantTypeCodeDataType.K_INDIAN_NATIVE_AMERICAN_TRIBALLY_DESIGNATED_ORGANIZATION;
                case 103 -> ApplicantTypeCodeDataType.S_HISPANIC_SERVING_INSTITUTION;
                case 104 -> ApplicantTypeCodeDataType.T_HISTORICALLY_BLACK_COLLEGES_AND_UNIVERSITIES_HBC_US;
                case 105 -> ApplicantTypeCodeDataType.U_TRIBALLY_CONTROLLED_COLLEGES_AND_UNIVERSITIES_TCC_US;
                case 106 -> ApplicantTypeCodeDataType.V_ALASKA_NATIVE_AND_NATIVE_HAWAIIAN_SERVING_INSTITUTIONS;
                case 107 -> ApplicantTypeCodeDataType.W_NON_DOMESTIC_NON_US_ENTITY;
                default -> ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
            };
        }
        return null;
    }

    public DepartmentalPersonService getDepartmentalPersonService() {
        return this.departmentalPersonService;
    }

    public void setDepartmentalPersonService(DepartmentalPersonService departmentalPersonService) {
        this.departmentalPersonService = departmentalPersonService;
    }

    public SubmissionInfoService getSubmissionInfoService() {
        return this.submissionInfoService;
    }

    public void setSubmissionInfoService(SubmissionInfoService submissionInfoService) {
        this.submissionInfoService = submissionInfoService;
    }

    public S2SProposalPersonService getS2SProposalPersonService() {
        return this.s2SProposalPersonService;
    }

    public void setS2SProposalPersonService(S2SProposalPersonService s2SProposalPersonService) {
        this.s2SProposalPersonService = s2SProposalPersonService;
    }

    public S2SDateTimeService getS2SDateTimeService() {
        return this.s2SDateTimeService;
    }

    public void setS2SDateTimeService(S2SDateTimeService s2SDateTimeService) {
        this.s2SDateTimeService = s2SDateTimeService;
    }

    public S2SConfigurationService getS2SConfigurationService() {
        return this.s2SConfigurationService;
    }

    public void setS2SConfigurationService(S2SConfigurationService s2SConfigurationService) {
        this.s2SConfigurationService = s2SConfigurationService;
    }
}

