/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.sf424Short20V20.SF424Short20Document;
import gov.grants.apply.system.globalLibraryV20.ApplicantTypeCodeDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.address.Addressable;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.sponsor.SponsorContract;
import org.kuali.coeus.propdev.api.abstrct.ProposalAbstractContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.s2s.S2sOpportunityContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.SF424BaseGenerator;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="SF424ShortV2_0Generator")
public class SF424ShortV2_0Generator
extends SF424BaseGenerator<SF424Short20Document>
implements S2SFormGeneratorPdfFillable<SF424Short20Document> {
    private static final String ABSTRACT_TYPE_PROJECT_DESCRIPTION = "1";
    private static final int PROGRAM_ANNOUNCEMENT_TITLE_MAX_LENGTH = 120;
    private static final int OPPORTUNITY_ID_MAX_LENGTH = 40;
    private static final int ABSTRACT_TYPE_CODE_MAX_LENGTH = 1000;
    private static final int OFFICE_PHONE_MAX_LENGTH = 25;
    private static final int EMAIL_ADDRESS_MAX_LENGTH = 60;
    private static final int FAX_NUMBER_MAX_LENGTH = 25;
    @Value(value="http://apply.grants.gov/forms/SF424_Short_2_0-V2.0")
    private String namespace;
    @Value(value="SF424_Short-V2.0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/SF424_Short-V2.0.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/SF424_Short_2_0-V2.0.pdf")
    private Resource pdfForm;
    @Value(value="1000")
    private int sortIndex;

    private SF424Short20Document getsf424ShortDocument() {
        String congressionalDistrict;
        ApplicantTypeCodeDataType.Enum applicantTypeCode3;
        ApplicantTypeCodeDataType.Enum applicantTypeCode2;
        List organizationTypes;
        ApplicantTypeCodeDataType.Enum applicantTypeCode;
        S2sOpportunityContract s2sOpportunity;
        SF424Short20Document sf424ShortDocument = (SF424Short20Document)SF424Short20Document.Factory.newInstance();
        SF424Short20Document.SF424Short20 sf424Short = (SF424Short20Document.SF424Short20)SF424Short20Document.SF424Short20.Factory.newInstance();
        sf424Short.setFormVersion(FormVersion.v2_0.getVersion());
        sf424Short.setAgencyName("");
        sf424Short.setFundingOpportunityNumber("");
        sf424Short.setFundingOpportunityTitle("");
        sf424Short.setOrganizationName("");
        sf424Short.setEmployerTaxpayerIdentificationNumber("");
        sf424Short.setProjectDescription("");
        sf424Short.setAuthorizedRepresentativeTitle("");
        sf424Short.setAuthorizedRepresentativePhoneNumber("");
        sf424Short.setAuthorizedRepresentativeEmail("");
        SponsorContract sponsor = this.pdDoc.getDevelopmentProposal().getPrimeSponsor();
        if (this.pdDoc.getDevelopmentProposal().getSponsor() != null && this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorName() != null) {
            if (this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorName().length() > 60) {
                sf424Short.setAgencyName(this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorName().substring(0, 60));
            } else {
                sf424Short.setAgencyName(this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorName());
            }
        } else if (sponsor.getSponsorName() != null) {
            if (sponsor.getSponsorName().length() > 60) {
                sf424Short.setAgencyName(sponsor.getSponsorName().substring(0, 60));
            } else {
                sf424Short.setAgencyName(sponsor.getSponsorName());
            }
        }
        String cfdaNumber = this.getFirstCfdaNumber();
        if (cfdaNumber != null) {
            sf424Short.setCFDANumber(cfdaNumber);
        }
        if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle() != null) {
            if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().length() > 120) {
                sf424Short.setCFDAProgramTitle(this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().substring(0, 120));
            } else {
                sf424Short.setCFDAProgramTitle(this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle());
            }
        }
        if ((s2sOpportunity = this.pdDoc.getDevelopmentProposal().getS2sOpportunity()) != null) {
            if (s2sOpportunity.getOpportunityId().length() > 40) {
                sf424Short.setFundingOpportunityNumber(s2sOpportunity.getOpportunityId().substring(0, 40));
            } else {
                sf424Short.setFundingOpportunityNumber(s2sOpportunity.getOpportunityId());
            }
            if (s2sOpportunity.getOpportunityTitle() != null) {
                sf424Short.setFundingOpportunityTitle(s2sOpportunity.getOpportunityTitle());
            }
        }
        ProposalSiteContract proposalSite = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        OrganizationContract organization = proposalSite.getOrganization();
        if (proposalSite.getLocationName() != null) {
            sf424Short.setOrganizationName(StringUtils.substring((String)proposalSite.getLocationName(), (int)0, (int)60));
        }
        if (proposalSite != null) {
            sf424Short.setAddress(this.globLibV20Generator.getAddressDataTypeV3((Addressable)proposalSite));
        }
        if ((applicantTypeCode = this.getApplicantType(organizationTypes = organization.getOrganizationTypes(), 0)) != null) {
            sf424Short.setApplicantTypeCode1(applicantTypeCode);
        }
        if ((applicantTypeCode2 = this.getApplicantType(organizationTypes, 1)) != null) {
            sf424Short.setApplicantTypeCode2(applicantTypeCode2);
        }
        if ((applicantTypeCode3 = this.getApplicantType(organizationTypes, 2)) != null) {
            sf424Short.setApplicantTypeCode3(applicantTypeCode3);
        }
        sf424Short.setEmployerTaxpayerIdentificationNumber(this.getEmployerId());
        sf424Short.setDUNSNumber(organization.getDunsNumber());
        String string = congressionalDistrict = organization.getCongressionalDistrict() == null ? "Unknown" : organization.getCongressionalDistrict();
        if (congressionalDistrict.length() > 6) {
            sf424Short.setCongressionalDistrictApplicant(congressionalDistrict.substring(0, 6));
        } else {
            sf424Short.setCongressionalDistrictApplicant(congressionalDistrict);
        }
        sf424Short.setProjectTitle(this.pdDoc.getDevelopmentProposal().getTitle());
        for (ProposalAbstractContract proposalAbstract : this.pdDoc.getDevelopmentProposal().getProposalAbstracts()) {
            if (proposalAbstract.getAbstractType().getCode() == null || !proposalAbstract.getAbstractType().getCode().equals(ABSTRACT_TYPE_PROJECT_DESCRIPTION)) continue;
            if (proposalAbstract.getAbstractDetails().length() > 1000) {
                sf424Short.setProjectDescription(proposalAbstract.getAbstractDetails().substring(0, 1000));
                break;
            }
            sf424Short.setProjectDescription(proposalAbstract.getAbstractDetails());
            break;
        }
        sf424Short.setProjectStartDate(this.s2SDateTimeService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedStartDateInitial()));
        sf424Short.setProjectEndDate(this.s2SDateTimeService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedEndDateInitial()));
        ProposalPersonContract pi = this.s2SProposalPersonService.getPrincipalInvestigator(this.pdDoc);
        sf424Short.setProjectDirectorGroup(this.globLibV20Generator.getContactPersonDataTypeV3(pi));
        sf424Short.setContactPersonGroup(this.globLibV20Generator.getContactPersonDataTypeV3(this.pdDoc));
        sf424Short.setApplicationCertification(YesNoDataType.Y_YES);
        DepartmentalPersonDto aorInfo = this.departmentalPersonService.getDepartmentalPerson(this.pdDoc);
        sf424Short.setDateReceived(aorInfo.getSubmittedDate());
        sf424Short.setAuthorizedRepresentative(this.globLibV20Generator.getHumanNameDataType(aorInfo));
        if (aorInfo.getPrimaryTitle() != null) {
            sf424Short.setAuthorizedRepresentativeTitle(StringUtils.substring((String)aorInfo.getPrimaryTitle(), (int)0, (int)45));
        }
        if (aorInfo.getOfficePhone() != null) {
            if (aorInfo.getOfficePhone().length() > 25) {
                sf424Short.setAuthorizedRepresentativePhoneNumber(aorInfo.getOfficePhone().substring(0, 25));
            } else {
                sf424Short.setAuthorizedRepresentativePhoneNumber(aorInfo.getOfficePhone());
            }
        }
        if (aorInfo.getEmailAddress() != null) {
            if (aorInfo.getEmailAddress().length() > 60) {
                sf424Short.setAuthorizedRepresentativeEmail(aorInfo.getEmailAddress().substring(0, 60));
            } else {
                sf424Short.setAuthorizedRepresentativeEmail(aorInfo.getEmailAddress());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)aorInfo.getFaxNumber())) {
            if (aorInfo.getFaxNumber().length() > 25) {
                sf424Short.setAuthorizedRepresentativeFaxNumber(aorInfo.getFaxNumber().substring(0, 25));
            } else {
                sf424Short.setAuthorizedRepresentativeFaxNumber(aorInfo.getFaxNumber());
            }
        }
        sf424Short.setAuthorizedRepresentativeSignature(aorInfo.getFullName());
        sf424Short.setAuthorizedRepresentativeDateSigned(aorInfo.getSubmittedDate());
        sf424ShortDocument.setSF424Short20(sf424Short);
        return sf424ShortDocument;
    }

    @Override
    public SF424Short20Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getsf424ShortDocument();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(SF424Short20Document form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<SF424Short20Document> factory() {
        return SF424Short20Document.Factory;
    }
}

