/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerAware;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.RuntimeObject;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DListImpl;

public class DListEntry
implements Serializable,
PersistenceBrokerAware {
    private static final long serialVersionUID = 5251476492626009907L;
    private transient Logger log;
    protected transient Object realSubject;
    protected PBKey pbKey;
    protected Integer id;
    protected Integer dlistId;
    protected Identity oid;
    protected int position;

    public DListEntry() {
        this.getPBKey();
    }

    public DListEntry(DListImpl dListImpl, Object object) {
        this.dlistId = dListImpl.getId();
        this.position = dListImpl.size();
        this.realSubject = object;
        this.pbKey = this.getPBKey();
    }

    protected Logger getLog() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(DListEntry.class);
        }
        return this.log;
    }

    protected TransactionImpl getTransaction() {
        return TxManagerFactory.instance().getTransaction();
    }

    public PBKey getPBKey() {
        TransactionImpl transactionImpl;
        if (this.pbKey == null && (transactionImpl = this.getTransaction()) != null && transactionImpl.isOpen()) {
            this.pbKey = transactionImpl.getBroker().getPBKey();
        }
        return this.pbKey;
    }

    protected void prepareForPersistency(PersistenceBroker persistenceBroker) {
        if (this.oid == null) {
            if (this.realSubject == null) {
                throw new OJBRuntimeException("Identity and real object are 'null' - Can not persist empty entry");
            }
            this.oid = persistenceBroker.serviceIdentity().buildIdentity(this.realSubject);
        }
    }

    protected void prepareRealSubject(PersistenceBroker persistenceBroker) {
        if (this.oid == null) {
            throw new OJBRuntimeException("can not return real object, real object and Identity is null");
        }
        this.realSubject = persistenceBroker.getObjectByIdentity(this.oid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getRealSubject() {
        if (this.realSubject != null) {
            return this.realSubject;
        }
        TransactionImpl transactionImpl = this.getTransaction();
        if (transactionImpl != null && transactionImpl.isOpen()) {
            this.prepareRealSubject(transactionImpl.getBroker());
            if (this.realSubject != null) {
                RuntimeObject runtimeObject = new RuntimeObject(this.realSubject, transactionImpl, false);
                transactionImpl.lockAndRegister(runtimeObject, 1, transactionImpl.getRegistrationList());
            }
        } else {
            PBKey pBKey = this.getPBKey();
            if (pBKey != null) {
                PBCapsule pBCapsule = new PBCapsule(pBKey, null);
                try {
                    this.prepareRealSubject(pBCapsule.getBroker());
                }
                finally {
                    pBCapsule.destroy();
                }
            } else {
                this.getLog().warn("No tx, no PBKey - can't materialise object with Identity " + this.getOid());
            }
        }
        return this.realSubject;
    }

    public void setRealSubject(Object object) {
        this.realSubject = object;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public Integer getDlistId() {
        return this.dlistId;
    }

    public void setDlistId(Integer n) {
        this.dlistId = n;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer n) {
        this.id = n;
    }

    public Identity getOid() {
        return this.oid;
    }

    public void setOid(Identity identity) {
        this.oid = identity;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("id", (Object)this.id);
        toStringBuilder.append("dListId", (Object)this.dlistId);
        toStringBuilder.append("position", this.position);
        toStringBuilder.append("identity", (Object)this.oid);
        toStringBuilder.append("realSubject", this.realSubject);
        return toStringBuilder.toString();
    }

    @Override
    public void beforeInsert(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        this.prepareForPersistency(persistenceBroker);
    }

    @Override
    public void beforeUpdate(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    @Override
    public void beforeDelete(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    @Override
    public void afterLookup(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    @Override
    public void afterDelete(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    @Override
    public void afterInsert(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    @Override
    public void afterUpdate(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }
}

