/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kns.web.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;
import org.kuali.rice.kns.datadictionary.CollectionDefinitionI;
import org.kuali.rice.kns.datadictionary.FieldDefinition;
import org.kuali.rice.kns.datadictionary.FieldDefinitionI;
import org.kuali.rice.kns.datadictionary.InquiryCollectionDefinition;
import org.kuali.rice.kns.datadictionary.InquirySectionDefinition;
import org.kuali.rice.kns.datadictionary.InquirySubSectionHeaderDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableCollectionDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableFieldDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableItemDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableSectionDefinition;
import org.kuali.rice.kns.datadictionary.MaintainableSubSectionHeaderDefinition;
import org.kuali.rice.kns.datadictionary.SubSectionHeaderDefinitionI;
import org.kuali.rice.kns.document.authorization.FieldRestriction;
import org.kuali.rice.kns.inquiry.Inquirable;
import org.kuali.rice.kns.inquiry.InquiryRestrictions;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.service.BusinessObjectAuthorizationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.rice.kns.util.FieldUtils;
import org.kuali.rice.kns.util.MaintenanceUtils;
import org.kuali.rice.kns.util.WebUtils;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.FieldBridge;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.datadictionary.mask.MaskFormatter;
import org.kuali.rice.krad.exception.ClassNotPersistableException;
import org.kuali.rice.krad.service.DataDictionaryService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.ObjectUtils;

@Deprecated
public class SectionBridge {
    private static final Logger LOG = LogManager.getLogger(SectionBridge.class);
    private static BusinessObjectAuthorizationService businessObjectAuthorizationService;
    private static DataDictionaryService dataDictionaryService;
    private static MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryService;

    private static BusinessObjectAuthorizationService getBusinessObjectAuthorizationService() {
        if (businessObjectAuthorizationService == null) {
            businessObjectAuthorizationService = KNSServiceLocator.getBusinessObjectAuthorizationService();
        }
        return businessObjectAuthorizationService;
    }

    private static DataDictionaryService getDataDictionaryService() {
        if (dataDictionaryService == null) {
            dataDictionaryService = KRADServiceLocatorWeb.getDataDictionaryService();
        }
        return dataDictionaryService;
    }

    public static Section toSection(Inquirable inquirable, InquirySectionDefinition sd, BusinessObject o, InquiryRestrictions auths) {
        Section section = new Section();
        section.setSectionId(sd.getId());
        section.setSectionTitle(sd.getTitle());
        section.setRows(new ArrayList<Row>());
        section.setDefaultOpen(sd.isDefaultOpen());
        if (sd.getNumberOfColumns() != null) {
            section.setNumberOfColumns(sd.getNumberOfColumns());
        } else {
            section.setNumberOfColumns(1);
        }
        ArrayList<Field> sectionFields = new ArrayList<Field>();
        for (FieldDefinition fieldDefinition : sd.getInquiryFields()) {
            Field f = null;
            if (fieldDefinition instanceof InquiryCollectionDefinition) {
                InquiryCollectionDefinition inquiryCollectionDefinition = (InquiryCollectionDefinition)fieldDefinition;
                List<Row> sectionRows = SectionBridge.getContainerRows(section, inquiryCollectionDefinition, o, null, null, new ArrayList<String>(), new HashSet<String>(), new StringBuffer(section.getErrorKey()), inquiryCollectionDefinition.getNumberOfColumns(), inquirable);
                section.setRows(sectionRows);
            } else {
                f = fieldDefinition instanceof InquirySubSectionHeaderDefinition ? SectionBridge.createMaintainableSubSectionHeader((InquirySubSectionHeaderDefinition)fieldDefinition) : FieldBridge.toField(fieldDefinition, o, section);
            }
            if (null == f) continue;
            sectionFields.add(f);
        }
        if (!sectionFields.isEmpty()) {
            section.setRows(FieldUtils.wrapFields(sectionFields, section.getNumberOfColumns()));
        }
        SectionBridge.applyInquirySectionAuthorizations(section, auths);
        section.setRows(SectionBridge.reArrangeRows(section.getRows(), section.getNumberOfColumns()));
        return section;
    }

    private static void applyInquirySectionAuthorizations(Section section, InquiryRestrictions inquiryRestrictions) {
        SectionBridge.applyInquiryRowsAuthorizations(section.getRows(), inquiryRestrictions);
    }

    private static void applyInquiryRowsAuthorizations(List<Row> rows, InquiryRestrictions inquiryRestrictions) {
        for (Row row : rows) {
            List<Field> rowFields = row.getFields();
            for (Field field : rowFields) {
                SectionBridge.applyInquiryFieldAuthorizations(field, inquiryRestrictions);
            }
        }
    }

    protected static void applyInquiryFieldAuthorizations(Field field, InquiryRestrictions inquiryRestrictions) {
        if ("container".equals(field.getFieldType())) {
            SectionBridge.applyInquiryRowsAuthorizations(field.getContainerRows(), inquiryRestrictions);
            field.setContainerRows(SectionBridge.reArrangeRows(field.getContainerRows(), field.getNumberOfColumnsForCollection()));
        } else if (!"imagesubmit".equals(field.getFieldType())) {
            FieldRestriction fieldRestriction = inquiryRestrictions.getFieldRestriction(field.getPropertyName());
            if (fieldRestriction.isHidden()) {
                field.setFieldType("hidden");
                field.setPropertyValue(null);
            } else if (fieldRestriction.isMasked() || fieldRestriction.isPartiallyMasked()) {
                field.setSecure(true);
                MaskFormatter maskFormatter = fieldRestriction.getMaskFormatter();
                String displayMaskValue = maskFormatter.maskValue((Object)field.getPropertyValue());
                field.setDisplayMaskValue(displayMaskValue);
                field.setEncryptedValue("");
            }
        }
    }

    private static List<Row> reArrangeRows(List<Row> rows, int numberOfColumns) {
        ArrayList<Row> rearrangedRows = new ArrayList<Row>();
        for (Row row : rows) {
            ArrayList<Field> fields = new ArrayList<Field>();
            List<Field> rowFields = row.getFields();
            for (Field field : rowFields) {
                if ("hidden".equals(field.getFieldType()) || "blankSpace".equals(field.getFieldType())) continue;
                fields.add(field);
            }
            List<Row> rewrappedFieldRows = FieldUtils.wrapFields(fields, numberOfColumns);
            if (row.isHidden()) {
                for (Row rewrappedRow : rewrappedFieldRows) {
                    rewrappedRow.setHidden(true);
                }
            }
            rearrangedRows.addAll(rewrappedFieldRows);
        }
        return rearrangedRows;
    }

    public static Section toSection(MaintainableSectionDefinition sd, BusinessObject o, Maintainable maintainable, Maintainable oldMaintainable, String maintenanceAction, List<String> displayedFieldNames, Set<String> conditionallyRequiredMaintenanceFields) throws InstantiationException, IllegalAccessException {
        Section section = new Section();
        section.setSectionId(sd.getId());
        section.setSectionTitle(sd.getTitle());
        section.setSectionClass(o.getClass());
        section.setHidden(sd.isHidden());
        section.setDefaultOpen(sd.isDefaultOpen());
        section.setHelpUrl(sd.getHelpUrl());
        List<MaintainableItemDefinition> maintItems = sd.getMaintainableItems();
        List<Row> sectionRows = new ArrayList<Row>();
        List<Field> sectionFields = new ArrayList<Field>();
        for (MaintainableItemDefinition maintItem : maintItems) {
            Field field = FieldBridge.toField(maintItem, sd, o, maintainable, section, displayedFieldNames, conditionallyRequiredMaintenanceFields);
            boolean skipAdd = false;
            if (maintItem instanceof MaintainableCollectionDefinition) {
                definition = (MaintainableCollectionDefinition)maintItem;
                section.getContainedCollectionNames().add(maintItem.getName());
                StringBuffer containerRowErrorKey = new StringBuffer();
                sectionRows = SectionBridge.getContainerRows(section, definition, o, maintainable, oldMaintainable, displayedFieldNames, conditionallyRequiredMaintenanceFields, containerRowErrorKey, 1, null);
            } else if (maintItem instanceof MaintainableSubSectionHeaderDefinition) {
                definition = (MaintainableSubSectionHeaderDefinition)maintItem;
                field = SectionBridge.createMaintainableSubSectionHeader((SubSectionHeaderDefinitionI)((Object)definition));
            }
            if (skipAdd) continue;
            sectionFields.add(field);
        }
        if (o != null) {
            sectionFields = FieldUtils.populateFieldsFromBusinessObject(sectionFields, o);
            if ("Copy".equals(maintenanceAction)) {
                for (Field element : sectionFields) {
                    if (!element.isSecure()) continue;
                    element.setPropertyValue("");
                }
            }
        }
        sectionRows.addAll(FieldUtils.wrapFields(sectionFields));
        section.setRows(sectionRows);
        return section;
    }

    public static List<Row> getContainerRows(Section s, CollectionDefinitionI collectionDefinition, BusinessObject o, Maintainable m, Maintainable oldMaintainable, List<String> displayedFieldNames, Set<String> conditionallyRequiredMaintenanceFields, StringBuffer containerRowErrorKey, int numberOfColumns, Inquirable inquirable) {
        return SectionBridge.getContainerRows(s, collectionDefinition, o, m, oldMaintainable, displayedFieldNames, conditionallyRequiredMaintenanceFields, containerRowErrorKey, "", false, numberOfColumns, inquirable);
    }

    public static List<Row> getContainerRows(Section s, CollectionDefinitionI collectionDefinition, BusinessObject o, Maintainable m, Maintainable oldMaintainable, List<String> displayedFieldNames, Set<String> conditionallyRequiredMaintenanceFields, StringBuffer containerRowErrorKey, String parents, boolean hideAdd, int numberOfColumns, Inquirable inquirable) {
        ArrayList<Row> containerRows = new ArrayList<Row>();
        String collectionName = collectionDefinition.getName();
        if (m != null && Inactivatable.class.isAssignableFrom(collectionDefinition.getBusinessObjectClass()) && StringUtils.isBlank((String)parents)) {
            SectionBridge.addShowInactiveButtonField(s, collectionName, !m.getShowInactiveRecords(collectionName));
        }
        if (inquirable != null && Inactivatable.class.isAssignableFrom(collectionDefinition.getBusinessObjectClass()) && StringUtils.isBlank((String)parents)) {
            SectionBridge.addShowInactiveButtonField(s, collectionName, !inquirable.getShowInactiveRecords(collectionName));
        }
        if (!hideAdd) {
            Object mcd;
            List<Field> newFormFields = new ArrayList<Field>();
            if (collectionDefinition.getIncludeAddLine()) {
                newFormFields = FieldBridge.getNewFormFields(collectionDefinition, o, m, displayedFieldNames, conditionallyRequiredMaintenanceFields, containerRowErrorKey, parents, hideAdd, numberOfColumns);
            } else if (collectionDefinition instanceof MaintainableCollectionDefinition && FieldUtils.isCollectionMultipleLookupEnabled((MaintainableCollectionDefinition)(mcd = (MaintainableCollectionDefinition)collectionDefinition))) {
                newFormFields = FieldBridge.constructContainerField(collectionDefinition, parents, o, hideAdd, numberOfColumns, ((MaintainableItemDefinition)((Object)mcd)).getName(), new ArrayList<Field>());
            }
            if (null != newFormFields) {
                containerRows.add(new Row(newFormFields));
            }
        }
        List<? extends CollectionDefinitionI> collections = collectionDefinition.getCollections();
        for (CollectionDefinitionI collectionDefinitionI : collections) {
            InquiryCollectionDefinition icd;
            int subCollectionNumberOfColumn = numberOfColumns;
            if (collectionDefinition instanceof InquiryCollectionDefinition && (icd = (InquiryCollectionDefinition)collectionDefinitionI).getNumberOfColumns() != null) {
                subCollectionNumberOfColumn = icd.getNumberOfColumns();
            }
            containerRows.addAll(SectionBridge.getContainerRows(s, collectionDefinitionI, o, m, oldMaintainable, displayedFieldNames, conditionallyRequiredMaintenanceFields, containerRowErrorKey, parents + collectionDefinition.getName() + ".", true, subCollectionNumberOfColumn, inquirable));
        }
        List<? extends FieldDefinitionI> collectionFields = collectionDefinition.getFields();
        String string = SectionBridge.getDataDictionaryService().getCollectionLabel(o.getClass(), collectionDefinition.getName());
        String collectionElementLabel = collectionDefinition.getSummaryTitle();
        if (StringUtils.isEmpty((String)collectionElementLabel)) {
            collectionElementLabel = SectionBridge.getDataDictionaryService().getCollectionElementLabel(o.getClass().getName(), collectionDefinition.getName(), collectionDefinition.getBusinessObjectClass());
        }
        boolean translateCodes = SectionBridge.getMaintenanceDocumentDictionaryService().translateCodes(o.getClass());
        if (o != null && PropertyUtils.isWriteable((Object)o, (String)collectionDefinition.getName()) && ObjectUtils.getPropertyValue(o, collectionDefinition.getName()) != null) {
            Object obj = ObjectUtils.getPropertyValue(o, collectionName);
            Object oldObj = null;
            if (oldMaintainable != null && oldMaintainable.getBusinessObject() != null) {
                oldObj = ObjectUtils.getPropertyValue(oldMaintainable.getBusinessObject(), collectionName);
            }
            if (obj instanceof List) {
                HashMap<String, Field> summaryFields = new HashMap<String, Field>();
                boolean hidableRowsPresent = false;
                for (int i = 0; i < ((List)obj).size(); ++i) {
                    BusinessObject lineBusinessObject = (BusinessObject)((List)obj).get(i);
                    if (lineBusinessObject instanceof PersistableBusinessObject) {
                        ((PersistableBusinessObject)lineBusinessObject).refreshNonUpdateableReferences();
                    }
                    boolean setRowHidden = false;
                    BusinessObject oldLineBusinessObject = null;
                    if (oldObj != null && ((List)oldObj).size() > i) {
                        oldLineBusinessObject = (BusinessObject)((List)oldObj).get(i);
                    }
                    if (lineBusinessObject instanceof Inactivatable && !((Inactivatable)lineBusinessObject).isActive()) {
                        if (m != null) {
                            if (!hidableRowsPresent) {
                                hidableRowsPresent = SectionBridge.isRowHideableForMaintenanceDocument(lineBusinessObject, oldLineBusinessObject);
                            }
                            setRowHidden = SectionBridge.isRowHiddenForMaintenanceDocument(lineBusinessObject, oldLineBusinessObject, m, collectionName);
                        }
                        if (inquirable != null) {
                            if (!hidableRowsPresent) {
                                hidableRowsPresent = SectionBridge.isRowHideableForInquiry(lineBusinessObject);
                            }
                            setRowHidden = SectionBridge.isRowHiddenForInquiry(lineBusinessObject, inquirable, collectionName);
                        }
                    }
                    ArrayList<Field> collFields = new ArrayList<Field>();
                    ArrayList<String> duplicateIdentificationFieldNames = new ArrayList<String>();
                    if (collectionDefinition instanceof MaintainableCollectionDefinition) {
                        List<MaintainableFieldDefinition> duplicateFieldDefs = ((MaintainableCollectionDefinition)collectionDefinition).getDuplicateIdentificationFields();
                        Iterator iterator = duplicateFieldDefs.iterator();
                        while (iterator.hasNext()) {
                            MaintainableFieldDefinition eachFieldDef = (MaintainableFieldDefinition)iterator.next();
                            duplicateIdentificationFieldNames.add(eachFieldDef.getName());
                        }
                    }
                    for (FieldDefinitionI fieldDefinitionI : collectionFields) {
                        Field collField = FieldUtils.getPropertyField(collectionDefinition.getBusinessObjectClass(), fieldDefinitionI.getName(), false);
                        if (translateCodes) {
                            FieldUtils.setAdditionalDisplayPropertyForCodes(lineBusinessObject.getClass(), collField.getPropertyName(), collField);
                        }
                        FieldBridge.setupField(collField, fieldDefinitionI, conditionallyRequiredMaintenanceFields);
                        SectionBridge.setPrimaryKeyFieldsReadOnly(collectionDefinition.getBusinessObjectClass(), collField);
                        if (duplicateIdentificationFieldNames.size() > 0) {
                            SectionBridge.setDuplicateIdentificationFieldsReadOnly(collField, duplicateIdentificationFieldNames);
                        }
                        FieldUtils.setInquiryURL(collField, lineBusinessObject, fieldDefinitionI.getName());
                        String name = collField.getPropertyName();
                        collField.setPropertyName(collectionDefinition.getName() + "[" + Integer.valueOf(i).toString() + "]." + collField.getPropertyName());
                        if (fieldDefinitionI instanceof MaintainableFieldDefinition) {
                            MaintenanceUtils.setFieldQuickfinder(lineBusinessObject, collectionDefinition.getName(), false, i, name, collField, displayedFieldNames, m, (MaintainableFieldDefinition)fieldDefinitionI);
                            MaintenanceUtils.setFieldDirectInquiry(lineBusinessObject, name, (MaintainableFieldDefinition)fieldDefinitionI, collField, displayedFieldNames);
                        } else {
                            LookupUtils.setFieldQuickfinder(lineBusinessObject, collectionDefinition.getName(), false, i, name, collField, displayedFieldNames, m);
                            LookupUtils.setFieldDirectInquiry(lineBusinessObject, name, collField);
                        }
                        String propertyValue = ObjectUtils.getFormattedPropertyValueUsingDataDictionary(lineBusinessObject, fieldDefinitionI.getName());
                        if (StringUtils.isBlank((String)propertyValue) && "file".equals(collField.getFieldType())) {
                            collField.setPropertyValue(FieldUtils.getFileName(collField, lineBusinessObject));
                        } else {
                            collField.setPropertyValue(propertyValue);
                        }
                        if ("file".equals(collField.getFieldType())) {
                            collField.setImageSrc(WebUtils.getAttachmentImageForUrl(FieldUtils.getContentType(collField, lineBusinessObject)));
                        }
                        if (StringUtils.isNotBlank((String)collField.getAlternateDisplayPropertyName())) {
                            String string2 = ObjectUtils.getFormattedPropertyValueUsingDataDictionary(lineBusinessObject, collField.getAlternateDisplayPropertyName());
                            collField.setAlternateDisplayPropertyValue(string2);
                        }
                        if (StringUtils.isNotBlank((String)collField.getAdditionalDisplayPropertyName())) {
                            String string3 = ObjectUtils.getFormattedPropertyValueUsingDataDictionary(lineBusinessObject, collField.getAdditionalDisplayPropertyName());
                            collField.setAdditionalDisplayPropertyValue(string3);
                        }
                        SectionBridge.updateUserFields(collField, lineBusinessObject);
                        if (fieldDefinitionI.isReadOnlyAfterAdd()) {
                            collField.setReadOnly(true);
                        }
                        if (collectionDefinition.hasSummaryField(fieldDefinitionI.getName())) {
                            summaryFields.put(fieldDefinitionI.getName(), collField);
                        }
                        collFields.add(collField);
                    }
                    Field containerField = FieldUtils.constructContainerField("edit[" + Integer.valueOf(i).toString() + "]", string + " " + (i + 1), collFields, numberOfColumns);
                    containerField.setContainerName(collectionDefinition.getName() + "[" + Integer.valueOf(i).toString() + "].");
                    if (lineBusinessObject instanceof PersistableBusinessObject && (((PersistableBusinessObject)lineBusinessObject).isNewCollectionRecord() || collectionDefinition.isAlwaysAllowCollectionDeletion())) {
                        containerField.getContainerRows().add(new Row(SectionBridge.getDeleteRowButtonField(parents + collectionDefinition.getName(), new Integer(i).toString())));
                    }
                    if (StringUtils.isNotEmpty((String)collectionElementLabel)) {
                        containerField.setContainerElementName(collectionElementLabel);
                        List<Field> list = SectionBridge.getSummaryFields(summaryFields, collectionDefinition);
                        containerField.setContainerDisplayFields(list);
                    }
                    Row row = new Row(containerField);
                    if (setRowHidden) {
                        row.setHidden(true);
                    }
                    containerRows.add(row);
                    List<? extends CollectionDefinitionI> subCollections = collectionDefinition.getCollections();
                    summaryFields = new HashMap();
                    for (CollectionDefinitionI collectionDefinitionI : subCollections) {
                        InquiryCollectionDefinition icd;
                        List<? extends FieldDefinitionI> subCollectionFields = collectionDefinitionI.getFields();
                        int subCollectionNumberOfColumns = numberOfColumns;
                        if (!s.getContainedCollectionNames().contains(collectionDefinition.getName() + "." + collectionDefinitionI.getName())) {
                            s.getContainedCollectionNames().add(collectionDefinition.getName() + "." + collectionDefinitionI.getName());
                        }
                        if (collectionDefinitionI instanceof InquiryCollectionDefinition && (icd = (InquiryCollectionDefinition)collectionDefinitionI).getNumberOfColumns() != null) {
                            subCollectionNumberOfColumns = icd.getNumberOfColumns();
                        }
                        String subCollectionLabel = SectionBridge.getDataDictionaryService().getCollectionLabel(o.getClass(), collectionDefinitionI.getName());
                        String subCollectionElementLabel = collectionDefinitionI.getSummaryTitle();
                        if (StringUtils.isEmpty((String)subCollectionElementLabel)) {
                            subCollectionElementLabel = SectionBridge.getDataDictionaryService().getCollectionElementLabel(o.getClass().getName(), collectionDefinitionI.getName(), collectionDefinitionI.getBusinessObjectClass());
                        }
                        String subCollectionName = collectionDefinitionI.getName();
                        Object subObj = ObjectUtils.getPropertyValue(lineBusinessObject, subCollectionName);
                        Object oldSubObj = null;
                        if (oldLineBusinessObject != null) {
                            oldSubObj = ObjectUtils.getPropertyValue(oldLineBusinessObject, subCollectionName);
                        }
                        if (!(subObj instanceof List)) continue;
                        containerField.getContainerRows().addAll(SectionBridge.getContainerRows(s, collectionDefinitionI, o, m, oldMaintainable, displayedFieldNames, conditionallyRequiredMaintenanceFields, containerRowErrorKey, parents + collectionDefinition.getName() + "[" + i + "].", false, subCollectionNumberOfColumns, inquirable));
                        for (int j = 0; j < ((List)subObj).size(); ++j) {
                            BusinessObject lineSubBusinessObject = (BusinessObject)((List)subObj).get(j);
                            if (lineSubBusinessObject instanceof PersistableBusinessObject) {
                                ((PersistableBusinessObject)lineSubBusinessObject).refreshNonUpdateableReferences();
                            }
                            boolean setSubRowHidden = false;
                            if (lineSubBusinessObject instanceof Inactivatable && !((Inactivatable)lineSubBusinessObject).isActive()) {
                                if (oldSubObj != null) {
                                    BusinessObject oldLineSubBusinessObject = (BusinessObject)((List)oldSubObj).get(j);
                                    if (m != null) {
                                        if (!hidableRowsPresent) {
                                            hidableRowsPresent = SectionBridge.isRowHideableForMaintenanceDocument(lineSubBusinessObject, oldLineSubBusinessObject);
                                        }
                                        setSubRowHidden = SectionBridge.isRowHiddenForMaintenanceDocument(lineSubBusinessObject, oldLineSubBusinessObject, m, collectionName);
                                    }
                                }
                                if (inquirable != null) {
                                    if (!hidableRowsPresent) {
                                        hidableRowsPresent = SectionBridge.isRowHideableForInquiry(lineSubBusinessObject);
                                    }
                                    setSubRowHidden = SectionBridge.isRowHiddenForInquiry(lineSubBusinessObject, inquirable, collectionName);
                                }
                            }
                            ArrayList<Field> subCollFields = new ArrayList<Field>();
                            for (FieldDefinitionI fieldDefinitionI : subCollectionFields) {
                                Field subCollField = FieldUtils.getPropertyField(collectionDefinitionI.getBusinessObjectClass(), fieldDefinitionI.getName(), false);
                                String subCollectionFullName = collectionDefinition.getName() + "[" + i + "]." + collectionDefinitionI.getName();
                                if (translateCodes) {
                                    FieldUtils.setAdditionalDisplayPropertyForCodes(lineSubBusinessObject.getClass(), subCollField.getPropertyName(), subCollField);
                                }
                                FieldBridge.setupField(subCollField, fieldDefinitionI, conditionallyRequiredMaintenanceFields);
                                SectionBridge.setPrimaryKeyFieldsReadOnly(collectionDefinitionI.getBusinessObjectClass(), subCollField);
                                String name = subCollField.getPropertyName();
                                subCollField.setPropertyName(subCollectionFullName + "[" + j + "]." + subCollField.getPropertyName());
                                if (fieldDefinitionI instanceof MaintainableFieldDefinition) {
                                    MaintenanceUtils.setFieldQuickfinder(lineSubBusinessObject, subCollectionFullName, false, j, name, subCollField, displayedFieldNames, m, (MaintainableFieldDefinition)fieldDefinitionI);
                                    MaintenanceUtils.setFieldDirectInquiry(lineSubBusinessObject, subCollectionFullName, false, j, name, subCollField, displayedFieldNames, m, (MaintainableFieldDefinition)fieldDefinitionI);
                                } else {
                                    LookupUtils.setFieldQuickfinder(lineSubBusinessObject, subCollectionFullName, false, j, name, subCollField, displayedFieldNames);
                                    LookupUtils.setFieldDirectInquiry(lineBusinessObject, name, subCollField);
                                }
                                String propertyValue = ObjectUtils.getFormattedPropertyValueUsingDataDictionary(lineSubBusinessObject, fieldDefinitionI.getName());
                                subCollField.setPropertyValue(propertyValue);
                                if (StringUtils.isNotBlank((String)subCollField.getAlternateDisplayPropertyName())) {
                                    String alternateDisplayPropertyValue = ObjectUtils.getFormattedPropertyValueUsingDataDictionary(lineSubBusinessObject, subCollField.getAlternateDisplayPropertyName());
                                    subCollField.setAlternateDisplayPropertyValue(alternateDisplayPropertyValue);
                                }
                                if (StringUtils.isNotBlank((String)subCollField.getAdditionalDisplayPropertyName())) {
                                    String additionalDisplayPropertyValue = ObjectUtils.getFormattedPropertyValueUsingDataDictionary(lineSubBusinessObject, subCollField.getAdditionalDisplayPropertyName());
                                    subCollField.setAdditionalDisplayPropertyValue(additionalDisplayPropertyValue);
                                }
                                if (collectionDefinitionI.hasSummaryField(fieldDefinitionI.getName())) {
                                    summaryFields.put(fieldDefinitionI.getName(), subCollField);
                                }
                                if (fieldDefinitionI.isReadOnlyAfterAdd()) {
                                    subCollField.setReadOnly(true);
                                }
                                subCollFields.add(subCollField);
                            }
                            Field subContainerField = FieldUtils.constructContainerField("edit[" + Integer.valueOf(j).toString() + "]", subCollectionLabel, subCollFields);
                            if (lineSubBusinessObject instanceof PersistableBusinessObject && (((PersistableBusinessObject)lineSubBusinessObject).isNewCollectionRecord() || collectionDefinitionI.isAlwaysAllowCollectionDeletion())) {
                                subContainerField.getContainerRows().add(new Row(SectionBridge.getDeleteRowButtonField(parents + collectionDefinition.getName() + "[" + i + "]." + subCollectionName, new Integer(j).toString())));
                            }
                            if (StringUtils.isNotEmpty((String)subCollectionElementLabel)) {
                                subContainerField.setContainerElementName(collectionElementLabel + "-" + subCollectionElementLabel);
                            }
                            subContainerField.setContainerName(collectionDefinition.getName() + "." + subCollectionName);
                            if (!summaryFields.isEmpty()) {
                                List<Field> list = SectionBridge.getSummaryFields(summaryFields, collectionDefinitionI);
                                subContainerField.setContainerDisplayFields(list);
                            }
                            Row row2 = new Row(subContainerField);
                            if (setRowHidden || setSubRowHidden) {
                                row2.setHidden(true);
                            }
                            containerField.getContainerRows().add(row2);
                        }
                    }
                }
                if (!hidableRowsPresent) {
                    s.setExtraButtonSource("");
                }
            }
        }
        return containerRows;
    }

    private static void updateUserFields(Field field, BusinessObject businessObject) {
        if (field.getFieldType().equals("kualiuser")) {
            try {
                Object personName;
                Object principalId;
                if (StringUtils.isNotBlank((String)field.getUniversalIdAttributeName()) && (principalId = ObjectUtils.getNestedValue(businessObject, field.getUniversalIdAttributeName())) != null) {
                    field.setUniversalIdValue(principalId.toString());
                }
                if (StringUtils.isNotBlank((String)field.getPersonNameAttributeName()) && (personName = ObjectUtils.getNestedValue(businessObject, field.getPersonNameAttributeName())) != null) {
                    field.setPersonNameValue(personName.toString());
                }
            }
            catch (Exception ex) {
                LOG.warn("Unable to get principal ID or person name property in SectionBridge.", (Throwable)ex);
            }
        }
    }

    private static Field getDeleteRowButtonField(String collectionName, String rowIndex) {
        Field deleteButtonField = new Field();
        String deleteButtonName = "methodToCall.deleteLine." + collectionName + ".(!!.line" + rowIndex;
        deleteButtonField.setPropertyName(deleteButtonName);
        deleteButtonField.setFieldType("imagesubmit");
        deleteButtonField.setPropertyValue("images/tinybutton-delete1.gif");
        return deleteButtonField;
    }

    private static void addShowInactiveButtonField(Section section, String collectionName, boolean showInactive) {
        String methodName = "methodToCall.toggleInactiveRecordDisplay." + collectionName.replace('.', '_');
        methodName = methodName + ".(!!" + showInactive + ".anchorshowInactive." + collectionName + "!!)";
        String imageSource = showInactive ? "tinybutton-showinact.gif" : "tinybutton-hideinact.gif";
        String showInactiveButton = "property=" + methodName + ";src=" + imageSource + ";alt=show(hide) inactive;title=show(hide) inactive";
        section.setExtraButtonSource(showInactiveButton);
    }

    private static void setPrimaryKeyFieldsReadOnly(Class businessObjectClass, Field field) {
        try {
            List primaryKeyPropertyNames = KRADServiceLocatorWeb.getLegacyDataAdapter().listPrimaryKeyFieldNames(businessObjectClass);
            if (primaryKeyPropertyNames.contains(field.getPropertyName())) {
                field.setReadOnly(true);
            }
        }
        catch (ClassNotPersistableException ex) {
            LOG.info("Not persistable dataObjectClass: " + String.valueOf(businessObjectClass) + ", field: " + String.valueOf(field), (Throwable)ex);
        }
    }

    private static void setDuplicateIdentificationFieldsReadOnly(Field field, List<String> duplicateIdentificationFieldNames) {
        if (duplicateIdentificationFieldNames.contains(field.getPropertyName())) {
            field.setReadOnly(true);
        }
    }

    private static List<Field> getSummaryFields(Map collSummaryFields, CollectionDefinitionI collectionDefinition) {
        ArrayList<Field> orderedSummaryFields = new ArrayList<Field>();
        for (FieldDefinitionI fieldDefinitionI : collectionDefinition.getSummaryFields()) {
            String name = fieldDefinitionI.getName();
            boolean found = false;
            Field addField = (Field)collSummaryFields.get(name);
            if (addField != null) {
                orderedSummaryFields.add(addField);
                found = true;
            }
            if (found) continue;
            LOG.error("summaryField " + String.valueOf(fieldDefinitionI) + " not present in the list");
        }
        return orderedSummaryFields;
    }

    private static Field createMaintainableSubSectionHeader(SubSectionHeaderDefinitionI definition) {
        Field separatorField = new Field();
        separatorField.setFieldLabel(definition.getName());
        separatorField.setFieldType("subSectionSeparator");
        separatorField.setReadOnly(true);
        return separatorField;
    }

    protected static boolean isRowHideableForMaintenanceDocument(BusinessObject lineBusinessObject, BusinessObject oldLineBusinessObject) {
        if (oldLineBusinessObject != null) {
            if (lineBusinessObject instanceof PersistableBusinessObject && ((PersistableBusinessObject)lineBusinessObject).isNewCollectionRecord()) {
                return false;
            }
            return !((Inactivatable)lineBusinessObject).isActive() && !((Inactivatable)oldLineBusinessObject).isActive();
        }
        return false;
    }

    protected static boolean isRowHiddenForMaintenanceDocument(BusinessObject lineBusinessObject, BusinessObject oldLineBusinessObject, Maintainable newMaintainable, String collectionName) {
        return SectionBridge.isRowHideableForMaintenanceDocument(lineBusinessObject, oldLineBusinessObject) && !newMaintainable.getShowInactiveRecords(collectionName);
    }

    protected static boolean isRowHideableForInquiry(BusinessObject lineBusinessObject) {
        return !((Inactivatable)lineBusinessObject).isActive();
    }

    protected static boolean isRowHiddenForInquiry(BusinessObject lineBusinessObject, Inquirable inquirable, String collectionName) {
        return SectionBridge.isRowHideableForInquiry(lineBusinessObject) && !inquirable.getShowInactiveRecords(collectionName);
    }

    public static MaintenanceDocumentDictionaryService getMaintenanceDocumentDictionaryService() {
        if (maintenanceDocumentDictionaryService == null) {
            maintenanceDocumentDictionaryService = KNSServiceLocator.getMaintenanceDocumentDictionaryService();
        }
        return maintenanceDocumentDictionaryService;
    }
}

