/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate;

import gov.grants.apply.system.header20V20.Header20Document;
import gov.grants.apply.system.metaGrantApplication.GrantApplicationDocument;
import gov.grants.apply.system.metaMultiGrantApplication.ApplicationDocument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.propdev.api.attachment.NarrativeService;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.s2s.S2sOppFormsContract;
import org.kuali.coeus.propdev.api.s2s.S2sUserAttachedFormFileContract;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.api.generate.FormGenerationResult;
import org.kuali.coeus.s2sgen.api.generate.FormGeneratorService;
import org.kuali.coeus.s2sgen.api.generate.MultiProjectFormGenerationResult;
import org.kuali.coeus.s2sgen.impl.datetime.S2SDateTimeService;
import org.kuali.coeus.s2sgen.impl.generate.FormApplicationService;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorRetrievalService;
import org.kuali.coeus.s2sgen.impl.util.XmlBeansUtils;
import org.kuali.coeus.s2sgen.impl.validate.S2SValidatorService;
import org.kuali.coeus.s2sgen.impl.validate.ValidationResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component(value="formGeneratorService")
public class FormGeneratorServiceImpl
implements FormGeneratorService {
    private static final String IN_SUBMISSION_OVERRIDE = " in Submission Override.";
    @Autowired
    @Qualifier(value="s2SFormGeneratorRetrievalService")
    private S2SFormGeneratorRetrievalService s2SFormGeneratorRetrievalService;
    @Autowired
    @Qualifier(value="s2SValidatorService")
    private S2SValidatorService s2SValidatorService;
    @Autowired
    @Qualifier(value="narrativeService")
    private NarrativeService narrativeService;
    @Autowired
    @Qualifier(value="s2SDateTimeService")
    private S2SDateTimeService s2SDateTimeService;
    @Autowired
    @Qualifier(value="formApplicationService")
    private FormApplicationService formApplicationService;
    @Autowired
    private ResourceLoader resourceLoader;

    public FormGenerationResult generateAndValidateForms(ProposalDevelopmentDocumentContract pdDocContract) throws S2SException {
        if (pdDocContract == null) {
            throw new IllegalArgumentException("pdDoc is null");
        }
        return this.isOverrideAvailable(pdDocContract.getDevelopmentProposal()) ? this.createOverrideResult(pdDocContract) : this.createDynamicResult(pdDocContract);
    }

    private boolean isOverrideAvailable(DevelopmentProposalContract proposal) {
        return proposal.getS2sOverride() != null && proposal.getS2sOverride().isActive() && proposal.getS2sOverride().getApplicationOverride() != null && proposal.getS2sOverride().getApplicationOverride().getApplication() != null;
    }

    private FormGenerationResult createOverrideResult(ProposalDevelopmentDocumentContract pdDocContract) throws S2SException {
        String applicationXml = pdDocContract.getDevelopmentProposal().getS2sOverride().getApplicationOverride().getApplication();
        ArrayList<AuditError> errors = new ArrayList<AuditError>();
        boolean valid = true;
        try {
            FormGenerationResult result;
            GrantApplicationDocument app = (GrantApplicationDocument)GrantApplicationDocument.Factory.parse(applicationXml);
            GrantApplicationDocument.GrantApplication.Forms forms = app.getGrantApplication().getForms();
            NodeList formNodes = forms.newDomNode().getChildNodes();
            for (int i = 0; i < formNodes.getLength(); ++i) {
                Node formNode = formNodes.item(i).getFirstChild();
                String namespace = formNode.getNamespaceURI();
                if (!StringUtils.isNotBlank((CharSequence)namespace)) continue;
                S2SFormGenerator s2SFormGenerator = this.s2SFormGeneratorRetrievalService.getS2SGenerator(namespace, pdDocContract.getDevelopmentProposal().getProposalNumber());
                String formName = s2SFormGenerator != null ? s2SFormGenerator.getFormName() : formNode.getLocalName();
                ValidationResult validationResult = this.s2SValidatorService.validateForm((XmlObject)XmlObject.Factory.parse(formNode), formName);
                valid &= validationResult.isValid();
                errors.addAll(validationResult.getErrors());
            }
            if (valid) {
                ValidationResult validationResult = this.s2SValidatorService.validateApplication(applicationXml, this.resourceLoader.getResource(pdDocContract.getDevelopmentProposal().getS2sOpportunity().getSchemaUrl()));
                valid = validationResult.isValid();
                errors.addAll(validationResult.getErrors());
                errors.forEach(error -> error.setMessageKey(this.modifyMessageForOverride(error.getMessageKey())));
                result = valid ? FormGenerationResult.valid(errors, (String)applicationXml, pdDocContract.getDevelopmentProposal().getS2sOverride().getApplicationOverride().getAttachments().stream().map(attachment -> new AttachmentData(attachment.getFileDataId(), attachment.getName(), attachment.getContentId(), attachment.getData(), attachment.getType(), "SHA-1", attachment.getSha1Hash(), attachment.getUploadUser(), attachment.getUploadTimestamp())).collect(Collectors.toList())) : FormGenerationResult.invalid(errors);
            } else {
                result = FormGenerationResult.invalid(errors);
            }
            return result;
        }
        catch (XmlException e) {
            throw new S2SException((Exception)((Object)e));
        }
    }

    private String modifyMessageForOverride(String msg) {
        return msg.endsWith(".") ? msg.substring(0, msg.length() - 1) + IN_SUBMISSION_OVERRIDE : msg + IN_SUBMISSION_OVERRIDE;
    }

    private FormGenerationResult createDynamicResult(ProposalDevelopmentDocumentContract pdDocContract) throws S2SException {
        FormGenerationResult result;
        GrantApplicationDocument.GrantApplication.Forms forms = (GrantApplicationDocument.GrantApplication.Forms)GrantApplicationDocument.GrantApplication.Forms.Factory.newInstance();
        ArrayList<AttachmentData> attList = new ArrayList<AttachmentData>();
        boolean validationSucceeded = true;
        ArrayList<AuditError> auditErrors = new ArrayList<AuditError>();
        DevelopmentProposalContract developmentProposal = pdDocContract.getDevelopmentProposal();
        this.getNarrativeService().deleteSystemGeneratedNarratives(developmentProposal.getNarratives());
        for (S2sOppFormsContract opportunityForm : developmentProposal.getS2sOppForms()) {
            S2SFormGenerator s2SFormGenerator;
            if (!opportunityForm.getInclude().booleanValue() || (s2SFormGenerator = this.s2SFormGeneratorRetrievalService.getS2SGenerator(opportunityForm.getOppNameSpace(), pdDocContract.getDevelopmentProposal().getProposalNumber())) == null) continue;
            try {
                Object formObject = s2SFormGenerator.getFormObject(pdDocContract);
                auditErrors.addAll(s2SFormGenerator.getAuditErrors());
                ValidationResult validationResult = this.s2SValidatorService.validateForm((XmlObject)formObject, s2SFormGenerator.getFormName());
                auditErrors.addAll(validationResult.getErrors());
                if (validationResult.isValid()) {
                    this.setFormObject(forms, (XmlObject)formObject);
                } else {
                    validationSucceeded = false;
                }
                attList.addAll(s2SFormGenerator.getAttachments());
            }
            catch (RuntimeException ex) {
                throw new S2SException("Could not generate form for " + opportunityForm.getFormName(), (Exception)ex);
            }
        }
        if (validationSucceeded) {
            String applicationXml = this.getFormApplicationService().getGrantApplicationDocument(pdDocContract, forms);
            ValidationResult validationResult = this.s2SValidatorService.validateApplication(applicationXml, this.resourceLoader.getResource(developmentProposal.getS2sOpportunity().getSchemaUrl()));
            validationSucceeded = validationResult.isValid();
            auditErrors.addAll(validationResult.getErrors());
            result = validationSucceeded ? FormGenerationResult.valid(auditErrors, (String)applicationXml, attList) : FormGenerationResult.invalid(auditErrors);
        } else {
            result = FormGenerationResult.invalid(auditErrors);
        }
        return result;
    }

    private String getXmlFromDocument(XmlObject grantApplicationDocument) {
        String applicationXmlText = grantApplicationDocument.xmlText(this.s2SFormGeneratorRetrievalService.getXmlOptionsPrefixes());
        return this.s2SDateTimeService.removeTimezoneFactor(applicationXmlText);
    }

    private void setFormObject(GrantApplicationDocument.GrantApplication.Forms forms, XmlObject formObject) {
        XmlCursor formCursor = formObject.newCursor();
        formCursor.toStartDoc();
        formCursor.toNextToken();
        XmlCursor metaGrantCursor = forms.newCursor();
        metaGrantCursor.toNextToken();
        formCursor.moveXml(metaGrantCursor);
    }

    public MultiProjectFormGenerationResult generateAndValidateMPForms(ProposalDevelopmentDocumentContract parent, List<ProposalDevelopmentDocumentContract> children) throws S2SException {
        if (parent == null || CollectionUtils.isEmpty(children)) {
            throw new IllegalArgumentException("parent and at least one child is required for multi-project submissions");
        }
        return this.createMPDynamicResult(parent, children);
    }

    private MultiProjectFormGenerationResult createMPDynamicResult(ProposalDevelopmentDocumentContract parent, List<ProposalDevelopmentDocumentContract> children) throws S2SException {
        MultiProjectFormGenerationResult result2;
        List<ComplexFormGeneratedResult> formResults = Stream.concat(children.stream(), Stream.of(parent)).map(this::generateAndValidateMPForms).collect(Collectors.toList());
        boolean validationSucceeded = formResults.stream().allMatch(result -> result.isValid);
        Map<String, List> auditErrors = formResults.stream().collect(Collectors.toMap(r -> r.getDevelopmentDocumentContract().getDevelopmentProposal().getProposalNumber(), ComplexFormGeneratedResult::getAuditErrors, (e1, e2) -> Stream.concat(e1.stream(), e2.stream()).collect(Collectors.toList())));
        Map<String, List> attachments = formResults.stream().collect(Collectors.toMap(r -> r.getDevelopmentDocumentContract().getDevelopmentProposal().getProposalNumber(), ComplexFormGeneratedResult::getAttachments, (e1, e2) -> Stream.concat(e1.stream(), e2.stream()).collect(Collectors.toList())));
        if (validationSucceeded) {
            String applicationXml = this.getComplexGrantApplicationDocument(formResults);
            DevelopmentProposalContract parentProposal = parent.getDevelopmentProposal();
            ValidationResult validationResult = this.s2SValidatorService.validateApplication(applicationXml, this.resourceLoader.getResource(parentProposal.getS2sOpportunity().getSchemaUrl()));
            validationSucceeded = validationResult.isValid();
            if (!validationResult.isValid()) {
                if (auditErrors.containsKey(parentProposal.getProposalNumber())) {
                    auditErrors.get(parentProposal.getProposalNumber()).addAll(validationResult.getErrors());
                } else {
                    auditErrors.put(parentProposal.getProposalNumber(), validationResult.getErrors());
                }
            }
            result2 = validationSucceeded ? MultiProjectFormGenerationResult.valid(auditErrors, (String)applicationXml, attachments) : MultiProjectFormGenerationResult.invalid(auditErrors);
        } else {
            result2 = MultiProjectFormGenerationResult.invalid(auditErrors);
        }
        return result2;
    }

    private ComplexFormGeneratedResult generateAndValidateMPForms(ProposalDevelopmentDocumentContract proposalContract) throws S2SException {
        ComplexFormGeneratedResult complexFormGeneratedResult = new ComplexFormGeneratedResult(proposalContract);
        DevelopmentProposalContract parentProposal = proposalContract.getDevelopmentProposal();
        this.getNarrativeService().deleteSystemGeneratedNarratives(parentProposal.getNarratives());
        for (S2sOppFormsContract opportunityForm : parentProposal.getS2sOppForms()) {
            S2SFormGenerator s2sFormGenerator;
            if (!opportunityForm.getInclude().booleanValue() || (s2sFormGenerator = this.s2SFormGeneratorRetrievalService.getS2SGenerator(opportunityForm.getOppNameSpace(), parentProposal.getProposalNumber())) == null) continue;
            try {
                Object formObject = s2sFormGenerator.getFormObject(proposalContract);
                complexFormGeneratedResult.addAuditErrors(s2sFormGenerator.getAuditErrors());
                ValidationResult validationResult = this.s2SValidatorService.validateForm((XmlObject)formObject, s2sFormGenerator.getFormName());
                complexFormGeneratedResult.addAuditErrors(validationResult.getErrors());
                if (validationResult.isValid()) {
                    complexFormGeneratedResult.addForm((XmlObject)formObject);
                } else {
                    complexFormGeneratedResult.setValid(false);
                }
                complexFormGeneratedResult.addAttachments(s2sFormGenerator.getAttachments());
            }
            catch (RuntimeException ex) {
                throw new S2SException("Could not generate form for " + opportunityForm.getFormName(), (Exception)ex);
            }
        }
        return complexFormGeneratedResult;
    }

    private String getComplexGrantApplicationDocument(List<ComplexFormGeneratedResult> formResults) throws S2SException {
        ApplicationDocument applicationDocument = (ApplicationDocument)ApplicationDocument.Factory.newInstance();
        ApplicationDocument.Application application = applicationDocument.addNewApplication();
        ApplicationDocument.Application.ApplicationHeader applicationHeader = application.addNewApplicationHeader();
        ApplicationDocument.Application.ApplicationPackage applicationPackage = application.addNewApplicationPackage();
        ComplexFormGeneratedResult overallFormResults = formResults.stream().filter(r -> "Overall".equalsIgnoreCase(r.getComponentType())).findFirst().orElseThrow(() -> new S2SException("Missing overall component"));
        ProposalDevelopmentDocumentContract overallPdDoc = overallFormResults.getDevelopmentDocumentContract();
        applicationHeader.setSchemaVersion(FormVersion.v1_0.getVersion());
        this.setHeader2(applicationHeader, overallPdDoc);
        this.createOverallApplication(applicationPackage, overallFormResults);
        formResults.stream().filter(r -> !"Overall".equalsIgnoreCase(r.getComponentType())).collect(Collectors.groupingBy(ComplexFormGeneratedResult::getComponentType)).entrySet().stream().sorted((e1, e2) -> this.compareRefs((String)e1.getKey(), (String)e2.getKey(), overallPdDoc)).forEach(entry -> this.createSubApplicationGroup(applicationPackage, (String)entry.getKey(), (List)entry.getValue()));
        try (XmlCursor cursor = applicationDocument.newCursor();){
            cursor.toStartDoc();
            if (cursor.toFirstChild()) {
                String defaultNameSpace = cursor.getName().getNamespaceURI();
                String schemaLocation = defaultNameSpace + " " + overallPdDoc.getDevelopmentProposal().getS2sOpportunity().getSchemaUrl();
                cursor.setAttributeText(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"), schemaLocation);
            }
        }
        this.fixNamespaces(applicationDocument);
        return this.getXmlFromDocument(applicationDocument);
    }

    private void fixNamespaces(ApplicationDocument applicationDocument) {
        HashSet<QName> componentNamespaces = new HashSet<QName>();
        try (XmlCursor cursor = applicationDocument.newCursor();){
            cursor.toFirstChild();
            cursor.toFirstChild();
            cursor.toNextSibling();
            cursor.toFirstChild();
            do {
                componentNamespaces.add(cursor.getName());
            } while (cursor.toNextSibling());
            cursor.toStartDoc();
            cursor.toFirstChild();
            cursor.toNextToken();
            componentNamespaces.forEach(ns -> cursor.insertNamespace(ns.getPrefix(), ns.getNamespaceURI()));
        }
    }

    private int compareRefs(String component1, String component2, ProposalDevelopmentDocumentContract proposalDocument) {
        String opportunityXsd = proposalDocument.getDevelopmentProposal().getS2sOpportunity().getOpportunity();
        String subApplicationGroup1 = component1 + ":SubApplicationGroup";
        String subApplicationGroup2 = component2 + ":SubApplicationGroup";
        return Integer.valueOf(opportunityXsd.indexOf(subApplicationGroup1)).compareTo(opportunityXsd.indexOf(subApplicationGroup2));
    }

    private void createOverallApplication(ApplicationDocument.Application.ApplicationPackage applicationPackage, ComplexFormGeneratedResult overallFormResults) {
        XmlCursor packageCursor = applicationPackage.newCursor();
        packageCursor.toNextToken();
        packageCursor.push();
        packageCursor.beginElement(XmlBeansUtils.createMPElement("Overall", "OverallApplication"));
        packageCursor.push();
        packageCursor.beginElement(XmlBeansUtils.createMPElement("Overall", "OverallApplicationHeader"));
        packageCursor.beginElement(XmlBeansUtils.createMPElement("Overall", "OverallApplicationID"));
        packageCursor.insertChars("Overall");
        packageCursor.pop();
        packageCursor.toNextSibling();
        this.createGrantApplication(packageCursor, "Overall", overallFormResults);
        packageCursor.dispose();
    }

    private void setHeader2(ApplicationDocument.Application.ApplicationHeader header, ProposalDevelopmentDocumentContract pdDoc) {
        Header20Document.Header20 header20 = header.addNewHeader20();
        header20.setApplicationFilingName(pdDoc.getDevelopmentProposal().getTitle());
        header20.setPackageID(pdDoc.getDevelopmentProposal().getS2sOpportunity().getPackageId());
        header20.setSchemaVersion(FormVersion.v2_0.getVersion());
    }

    private void createSubApplicationGroup(XmlObject applicationPackage, String componentType, List<ComplexFormGeneratedResult> groupFormResults) {
        XmlCursor cursor = applicationPackage.newCursor();
        cursor.toEndToken();
        cursor.beginElement(XmlBeansUtils.createMPElement(componentType, "SubApplicationGroup"));
        cursor.push();
        cursor.beginElement(XmlBeansUtils.createMPElement(componentType, "SubApplicationGroupHeader"));
        cursor.beginElement(XmlBeansUtils.createMPElement(componentType, "SubApplicationGroupID"));
        cursor.insertChars(componentType);
        cursor.pop();
        cursor.toNextSibling();
        int i = 1;
        for (ComplexFormGeneratedResult groupFormResult : groupFormResults) {
            this.createSubApplication(cursor, groupFormResult, i, componentType);
            ++i;
        }
        cursor.dispose();
    }

    private void createSubApplication(XmlCursor cursor, ComplexFormGeneratedResult formResults, int applicationIndex, String componentType) {
        cursor.push();
        cursor.beginElement(XmlBeansUtils.createMPElement(componentType, "SubApplication"));
        cursor.push();
        cursor.beginElement(XmlBeansUtils.createMPElement(componentType, "SubApplicationHeader"));
        cursor.beginElement(XmlBeansUtils.createMPElement(componentType, "SubApplicationID"));
        cursor.insertChars(String.format("%03d-%s", applicationIndex, componentType));
        cursor.pop();
        cursor.toNextSibling();
        this.createGrantApplication(cursor, componentType, formResults);
        cursor.pop();
        cursor.toNextSibling();
    }

    private void createGrantApplication(XmlCursor cursor, String componentType, ComplexFormGeneratedResult formResults) {
        cursor.beginElement(XmlBeansUtils.createMPElement(componentType, "GrantApplication"));
        cursor.beginElement(XmlBeansUtils.createMPElement(componentType, "Forms"));
        formResults.getForms().forEach(formObject -> {
            try (XmlCursor formsCursor = formObject.newCursor();){
                formsCursor.toNextToken();
                formsCursor.moveXml(cursor);
            }
        });
    }

    public MultiProjectFormGenerationResult generateAndValidateMPComponentForms(ProposalDevelopmentDocumentContract child, String parentSchemaUrl) throws S2SException {
        if (child == null) {
            throw new IllegalArgumentException("a child is required for component validation");
        }
        return this.createMPComponentDynamicResult(child, parentSchemaUrl);
    }

    private MultiProjectFormGenerationResult createMPComponentDynamicResult(ProposalDevelopmentDocumentContract child, String parentSchemaUrl) throws S2SException {
        ComplexFormGeneratedResult formResults = this.generateAndValidateMPForms(child);
        MultiProjectFormGenerationResult result = formResults.isValid() ? MultiProjectFormGenerationResult.valid(Map.of(child.getDevelopmentProposal().getProposalNumber(), formResults.getAuditErrors()), (String)this.getMPComponentDocument(formResults, child.getDevelopmentProposal().getS2sOpportunity().getComponentType(), parentSchemaUrl), Map.of(child.getDevelopmentProposal().getProposalNumber(), formResults.getAttachments())) : MultiProjectFormGenerationResult.invalid(Map.of(child.getDevelopmentProposal().getProposalNumber(), formResults.getAuditErrors()));
        return result;
    }

    private String getMPComponentDocument(ComplexFormGeneratedResult formResults, String componentType, String parentSchemaUrl) {
        ApplicationDocument applicationDocument = (ApplicationDocument)ApplicationDocument.Factory.newInstance();
        this.createSubApplicationGroup(applicationDocument, componentType, List.of(formResults));
        try (XmlCursor cursor = applicationDocument.newCursor();){
            cursor.toStartDoc();
            if (cursor.toFirstChild()) {
                String defaultNameSpace = cursor.getName().getNamespaceURI();
                String schemaLocation = defaultNameSpace + " " + parentSchemaUrl;
                cursor.setAttributeText(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"), schemaLocation);
            }
        }
        return this.getXmlFromDocument(applicationDocument);
    }

    public FormGenerationResult validateUserAttachedFormFile(S2sUserAttachedFormFileContract s2sUserAttachedFormFile, String formName) throws S2SException {
        if (s2sUserAttachedFormFile == null) {
            throw new IllegalArgumentException("s2sUserAttachedFormFile is null");
        }
        if (StringUtils.isBlank((CharSequence)formName)) {
            throw new IllegalArgumentException("formName is blank");
        }
        try {
            XmlObject xmlObject = (XmlObject)XmlObject.Factory.parse(s2sUserAttachedFormFile.getXmlFile());
            ValidationResult result = this.s2SValidatorService.validateForm(xmlObject, formName);
            if (result.isValid()) {
                return FormGenerationResult.valid(result.getErrors(), (String)s2sUserAttachedFormFile.getXmlFile(), Collections.emptyList());
            }
            return FormGenerationResult.invalid(result.getErrors());
        }
        catch (RuntimeException | XmlException e) {
            throw new S2SException(e.getMessage(), (Exception)e);
        }
    }

    public S2SFormGeneratorRetrievalService getS2SFormGeneratorRetrievalService() {
        return this.s2SFormGeneratorRetrievalService;
    }

    public void setS2SFormGeneratorRetrievalService(S2SFormGeneratorRetrievalService s2SFormGeneratorRetrievalService) {
        this.s2SFormGeneratorRetrievalService = s2SFormGeneratorRetrievalService;
    }

    public S2SValidatorService getS2SValidatorService() {
        return this.s2SValidatorService;
    }

    public void setS2SValidatorService(S2SValidatorService validatorService) {
        this.s2SValidatorService = validatorService;
    }

    public NarrativeService getNarrativeService() {
        return this.narrativeService;
    }

    public void setNarrativeService(NarrativeService narrativeService) {
        this.narrativeService = narrativeService;
    }

    public S2SDateTimeService getS2SDateTimeService() {
        return this.s2SDateTimeService;
    }

    public void setS2SDateTimeService(S2SDateTimeService s2SDateTimeService) {
        this.s2SDateTimeService = s2SDateTimeService;
    }

    public FormApplicationService getFormApplicationService() {
        return this.formApplicationService;
    }

    public void setFormApplicationService(FormApplicationService formApplicationService) {
        this.formApplicationService = formApplicationService;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    private static class ComplexFormGeneratedResult {
        private ProposalDevelopmentDocumentContract developmentDocumentContract;
        private List<XmlObject> forms = new ArrayList<XmlObject>();
        private List<AttachmentData> attachments = new ArrayList<AttachmentData>();
        private List<AuditError> auditErrors = new ArrayList<AuditError>();
        private boolean isValid = true;

        public ComplexFormGeneratedResult(ProposalDevelopmentDocumentContract proposalDevelopmentDocumentContract) {
            this.developmentDocumentContract = proposalDevelopmentDocumentContract;
        }

        public void addAuditErrors(List<AuditError> newErrors) {
            this.auditErrors.addAll(newErrors);
        }

        public void addAttachments(List<AttachmentData> newAttachments) {
            this.attachments.addAll(newAttachments);
        }

        public List<XmlObject> getForms() {
            return this.forms;
        }

        public void addForm(XmlObject form) {
            this.forms.add(form);
        }

        public boolean isValid() {
            return this.isValid;
        }

        public void setValid(boolean valid) {
            this.isValid = valid;
        }

        public ProposalDevelopmentDocumentContract getDevelopmentDocumentContract() {
            return this.developmentDocumentContract;
        }

        public List<AuditError> getAuditErrors() {
            return this.auditErrors;
        }

        public List<AttachmentData> getAttachments() {
            return this.attachments;
        }

        public String getComponentType() {
            return this.developmentDocumentContract.getDevelopmentProposal().getS2sOpportunity().getComponentType();
        }
    }
}

