/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.nsfCoverPage13V13.NSFCoverPage13Document;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin1Max100DataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.List;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.org.OrganizationYnqContract;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.NSFCoverPageBaseGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="NSFCoverPageV1_3Generator")
public class NSFCoverPageV1_3Generator
extends NSFCoverPageBaseGenerator<NSFCoverPage13Document> {
    @Value(value="http://apply.grants.gov/forms/NSF_CoverPage_1_3-V1.3")
    private String namespace;
    @Value(value="NSF_CoverPage_1_3-V1.3")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/NSF_CoverPage-V1.3.xsl")
    private List<Resource> stylesheets;
    @Value(value="1000")
    private int sortIndex;

    private NSFCoverPage13Document getNSFCoverPage13() {
        NSFCoverPage13Document nsfCoverPage13Document = (NSFCoverPage13Document)NSFCoverPage13Document.Factory.newInstance();
        NSFCoverPage13Document.NSFCoverPage13 nsfCoverPage13 = (NSFCoverPage13Document.NSFCoverPage13)NSFCoverPage13Document.NSFCoverPage13.Factory.newInstance();
        nsfCoverPage13.setFormVersion(FormVersion.v1_3.getVersion());
        this.setFundingOpportunityNumber(nsfCoverPage13);
        if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity() != null && this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getClosingDate() != null) {
            nsfCoverPage13.setDueDate(this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getClosingDate());
        }
        nsfCoverPage13.setNSFUnitConsideration(this.getNSFUnitConsideration());
        this.setOtherInfo(nsfCoverPage13);
        AttachmentGroupMin1Max100DataType attachmentGroup = (AttachmentGroupMin1Max100DataType)AttachmentGroupMin1Max100DataType.Factory.newInstance();
        attachmentGroup.setAttachedFileArray(this.getAttachedFileDataTypes());
        if (attachmentGroup.getAttachedFileArray().length > 0) {
            nsfCoverPage13.setSingleCopyDocuments(attachmentGroup);
        }
        nsfCoverPage13Document.setNSFCoverPage13(nsfCoverPage13);
        return nsfCoverPage13Document;
    }

    private void setFundingOpportunityNumber(NSFCoverPage13Document.NSFCoverPage13 nsfCoverPage13) {
        if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber() != null) {
            if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber().length() > 40) {
                nsfCoverPage13.setFundingOpportunityNumber(this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber().substring(0, 40));
            } else {
                nsfCoverPage13.setFundingOpportunityNumber(this.pdDoc.getDevelopmentProposal().getProgramAnnouncementNumber());
            }
        }
    }

    private void setOtherInfo(NSFCoverPage13Document.NSFCoverPage13 nsfCoverPage13) {
        NSFCoverPage13Document.NSFCoverPage13.OtherInfo otherInfo = (NSFCoverPage13Document.NSFCoverPage13.OtherInfo)NSFCoverPage13Document.NSFCoverPage13.OtherInfo.Factory.newInstance();
        NSFCoverPage13Document.NSFCoverPage13.PIInfo pInfo = (NSFCoverPage13Document.NSFCoverPage13.PIInfo)NSFCoverPage13Document.NSFCoverPage13.PIInfo.Factory.newInstance();
        for (AnswerContract questionnaireAnswer : this.getPropDevQuestionAnswerService().getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal().getProposalNumber(), this.getNamespace(), this.getFormName())) {
            String answer = questionnaireAnswer.getAnswer();
            int questionId = questionnaireAnswer.getQuestionNumber();
            if (answer == null) continue;
            switch (questionId) {
                case 1: {
                    pInfo.setIsCurrentPI(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 2: {
                    otherInfo.setIsBeginInvestigator(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 4: {
                    otherInfo.setIsEarlyConceptGrant(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 3: {
                    otherInfo.setIsRapidResponseGrant(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 5: {
                    otherInfo.setIsAccomplishmentRenewal(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
                case 6: {
                    otherInfo.setIsHighResolutionGraphics(answer.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO);
                    break;
                }
            }
        }
        nsfCoverPage13.setPIInfo(pInfo);
        otherInfo.setIsDisclosureLobbyingActivities(this.getLobbyingAnswer());
        nsfCoverPage13.setOtherInfo(otherInfo);
    }

    private YesNoDataType.Enum getLobbyingAnswer() {
        YesNoDataType.Enum answer = YesNoDataType.N_NO;
        for (ProposalPersonContract proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            List headers;
            if ((proposalPerson.getProposalPersonRoleId() == null || !proposalPerson.getProposalPersonRoleId().equals("PI")) && !"COI".equals(proposalPerson.getProposalPersonRoleId()) || (headers = this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(this.pdDoc.getDevelopmentProposal().getProposalNumber())).isEmpty()) continue;
            AnswerHeaderContract answerHeader = (AnswerHeaderContract)headers.get(0);
            List certificationAnswers = answerHeader.getAnswers();
            for (AnswerContract certificatonAnswer : certificationAnswers) {
                if (certificatonAnswer == null || !"-10088".equals(certificatonAnswer.getQuestionId().toString()) || !YnqConstant.YES.code().equals(certificatonAnswer.getAnswer())) continue;
                return YesNoDataType.Y_YES;
            }
        }
        OrganizationContract organization = this.getOrganizationFromDevelopmentProposal(this.pdDoc.getDevelopmentProposal());
        if (organization != null) {
            for (OrganizationYnqContract organizationYnq : organization.getOrganizationYnqs()) {
                if (!organizationYnq.getQuestionId().equals("H0") || !this.getAnswerFromOrganizationYnq(organizationYnq)) continue;
                return YesNoDataType.Y_YES;
            }
        }
        return answer;
    }

    protected boolean getAnswerFromOrganizationYnq(OrganizationYnqContract organizationYnq) {
        return organizationYnq.getAnswer().equals("Y");
    }

    private OrganizationContract getOrganizationFromDevelopmentProposal(DevelopmentProposalContract developmentProposal) {
        OrganizationContract organization = null;
        ProposalSiteContract proposalSite = developmentProposal.getApplicantOrganization();
        if (proposalSite != null) {
            organization = proposalSite.getOrganization();
        }
        return organization;
    }

    private NSFCoverPage13Document.NSFCoverPage13.NSFUnitConsideration getNSFUnitConsideration() {
        NSFCoverPage13Document.NSFCoverPage13.NSFUnitConsideration nsfConsideration = (NSFCoverPage13Document.NSFCoverPage13.NSFUnitConsideration)NSFCoverPage13Document.NSFCoverPage13.NSFUnitConsideration.Factory.newInstance();
        nsfConsideration.setDivisionCode(this.pdDoc.getDevelopmentProposal().getAgencyDivisionCode());
        nsfConsideration.setProgramCode(this.pdDoc.getDevelopmentProposal().getAgencyProgramCode());
        return nsfConsideration;
    }

    @Override
    public NSFCoverPage13Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getNSFCoverPage13();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public DocumentFactory<NSFCoverPage13Document> factory() {
        return NSFCoverPage13Document.Factory;
    }
}

