/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.coeus.personProfile.PersonProfileListDocument;
import gov.grants.apply.forms.nsfKeyPersonExpanded11V11.NSFKeyPersonExpanded11Document;
import gov.grants.apply.forms.nsfKeyPersonExpanded11V11.PersonProfileDataType;
import gov.grants.apply.forms.nsfKeyPersonExpanded11V11.ProjectRoleDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.address.Addressable;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.common.api.unit.UnitContract;
import org.kuali.coeus.common.api.unit.UnitRepositoryService;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonDegreeContract;
import org.kuali.coeus.propdev.api.person.attachment.ProposalPersonBiographyContract;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.ProposalPersonComparator;
import org.kuali.coeus.s2sgen.impl.person.S2SProposalPersonService;
import org.kuali.coeus.s2sgen.impl.person.S2sDivisionService;
import org.kuali.coeus.s2sgen.impl.print.GenericPrintable;
import org.kuali.coeus.s2sgen.impl.print.S2SFile;
import org.kuali.coeus.s2sgen.impl.print.S2SPrintingService;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="NSFKeyPersonExpandedV1_1Generator")
public class NSFKeyPersonExpandedV1_1Generator
extends S2SBaseFormGenerator<NSFKeyPersonExpanded11Document>
implements S2SFormGeneratorPdfFillable<NSFKeyPersonExpanded11Document> {
    private static final Logger LOG = LogManager.getLogger(NSFKeyPersonExpandedV1_1Generator.class);
    protected static final int TITLE_MAX_LENGTH = 45;
    protected static final int ROLE_DESCRIPTION_MAX_LENGTH = 40;
    private static final int MAX_KEY_PERSON_COUNT = 100;
    protected static final int BIOSKETCH_DOC_TYPE = 16;
    protected static final int CURRENTPENDING_DOC_TYPE = 17;
    protected static final int COLLABORATOR_DOC_TYPE = 148;
    protected static final String BIOSKETCH_TYPE = "1";
    protected static final String COLLABORATOR_TYPE = "6";
    protected static final String CURRENT_PENDING_TYPE = "2";
    private static final String COMMENT = "Auto generated document for ";
    private static final String BIOSKETCH_COMMENT = "BIOSKETCH";
    private static final String CURRENT_PENDING_COMMENT = "CURRENTPENDING";
    private static final String COLLABORATOR_COMMENT = "COLLABORATOR";
    protected static final String PROFILE_COMMENT = "PROFILE";
    protected static final int PROFILE_TYPE = 18;
    protected static final String NIH_CO_INVESTIGATOR = "Co-Investigator";
    protected static final int DEPARTMENT_NAME_MAX_LENGTH = 30;
    private static final int ADDRESS_LINE_MAX_LENGTH = 55;
    protected RolodexContract rolodex;
    protected List<ProposalPersonContract> extraPersons = null;
    protected String pIPersonOrRolodexId = null;
    @Autowired
    @Qualifier(value="s2SPrintingService")
    private S2SPrintingService s2SPrintingService;
    @Autowired
    @Qualifier(value="s2SProposalPersonService")
    protected S2SProposalPersonService s2SProposalPersonService;
    @Autowired
    @Qualifier(value="s2sDivisionService")
    private S2sDivisionService s2sDivisionService;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/additionalkeypersonprofiles.xsl")
    private Resource additionalkeypersonprofilesStyleSheet;
    @Value(value="http://apply.grants.gov/forms/NSF_KeyPersonExpanded_1_1-V1.1")
    private String namespace;
    @Value(value="NSF_KeyPersonExpanded_1_1")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/NSF_KeyPersonExpanded-V1.1.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/NSF_KeyPersonExpanded_1_1-V1.1.pdf")
    private Resource pdfForm;
    @Value(value="155")
    private int sortIndex;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;
    @Autowired
    @Qualifier(value="unitRepositoryService")
    private UnitRepositoryService unitRepositoryService;

    protected void saveKeyPersonAttachmentsToProposal() {
        if (!org.springframework.util.CollectionUtils.isEmpty(this.extraPersons)) {
            this.saveKeyPersonAttachments();
            this.saveKeypersonProfileObject();
        }
    }

    private void saveKeyPersonAttachments() {
        ArrayList<String> bioSketchBookMarks = new ArrayList<String>();
        ArrayList<String> curPendBookMarks = new ArrayList<String>();
        ArrayList<String> collaboratorBookMarks = new ArrayList<String>();
        ArrayList<byte[]> bioSketchDataList = new ArrayList<byte[]>();
        ArrayList<byte[]> curPendDataList = new ArrayList<byte[]>();
        ArrayList<byte[]> collaboratorDataList = new ArrayList<byte[]>();
        for (ProposalPersonContract proposalPerson : this.extraPersons) {
            this.setBookMarkAndData(bioSketchBookMarks, bioSketchDataList, proposalPerson, BIOSKETCH_TYPE);
            this.setBookMarkAndData(curPendBookMarks, curPendDataList, proposalPerson, CURRENT_PENDING_TYPE);
            this.setBookMarkAndData(collaboratorBookMarks, collaboratorDataList, proposalPerson, COLLABORATOR_TYPE);
        }
        try {
            String fileName;
            byte[] bioSketchData = this.s2SPrintingService.mergePdfBytes(bioSketchDataList, bioSketchBookMarks, true);
            byte[] curPendData = this.s2SPrintingService.mergePdfBytes(curPendDataList, curPendBookMarks, true);
            byte[] collaboratorData = this.s2SPrintingService.mergePdfBytes(collaboratorDataList, collaboratorBookMarks, true);
            if (bioSketchData != null && bioSketchData.length > 0) {
                fileName = this.pdDoc.getDevelopmentProposal().getProposalNumber() + "_BIOSKETCH.pdf";
                this.saveNarrative(bioSketchData, "16", fileName, "Auto generated document for BIOSKETCH");
            }
            if (curPendData != null && curPendData.length > 0) {
                fileName = this.pdDoc.getDevelopmentProposal().getProposalNumber() + "_CURRENTPENDING.pdf";
                this.saveNarrative(curPendData, "17", fileName, "Auto generated document for CURRENTPENDING");
            }
            if (collaboratorData != null && collaboratorData.length > 0) {
                fileName = this.pdDoc.getDevelopmentProposal().getProposalNumber() + "_COLLABORATOR.pdf";
                this.saveNarrative(collaboratorData, "148", fileName, "Auto generated document for COLLABORATOR");
            }
        }
        catch (S2SException e) {
            LOG.error("Auto generation of Biosketch/Currend Pending report for extra Keypersons is failed", (Throwable)e);
        }
    }

    private void setBookMarkAndData(List<String> bookMarksList, List<byte[]> dataList, ProposalPersonContract proposalPerson, String docType) {
        Object personId = proposalPerson.getPersonId() != null && proposalPerson.getPersonId().length() > 0 ? proposalPerson.getPersonId() : "" + proposalPerson.getRolodexId();
        for (ProposalPersonBiographyContract personBiography : this.getPernonnelAttachments(this.pdDoc, proposalPerson, docType)) {
            byte[] content = personBiography.getPersonnelAttachment().getData();
            if (content == null || content.length <= 0) continue;
            dataList.add(content);
            bookMarksList.add((String)personId);
        }
    }

    private List<ProposalPersonBiographyContract> getPernonnelAttachments(ProposalDevelopmentDocumentContract pdDoc, ProposalPersonContract proposalPerson, String documentType) {
        ArrayList<ProposalPersonBiographyContract> result = new ArrayList<ProposalPersonBiographyContract>();
        for (ProposalPersonBiographyContract proposalPersonBiography : pdDoc.getDevelopmentProposal().getPropPersonBios()) {
            String personId = proposalPerson.getPersonId();
            Integer rolodexId = proposalPerson.getRolodexId();
            if (personId != null && proposalPersonBiography.getPersonId() != null && proposalPersonBiography.getPersonId().equals(personId) && documentType.equals(proposalPersonBiography.getPropPerDocType().getCode())) {
                result.add(proposalPersonBiography);
                continue;
            }
            if (rolodexId == null || proposalPersonBiography.getRolodexId() == null || !proposalPersonBiography.getRolodexId().toString().equals(rolodexId.toString()) || !documentType.equals(proposalPersonBiography.getPropPerDocType().getCode())) continue;
            result.add(proposalPersonBiography);
        }
        return result;
    }

    protected PersonProfileListDocument.PersonProfileList.ExtraKeyPerson[] getExtraKeyPersons() {
        ArrayList<PersonProfileListDocument.PersonProfileList.ExtraKeyPerson> extraPersonList = new ArrayList<PersonProfileListDocument.PersonProfileList.ExtraKeyPerson>();
        for (ProposalPersonContract proposalPerson : this.extraPersons) {
            AttachedFileDataType collaboratorAttachment;
            AttachedFileDataType curPendingAttachment;
            AttachedFileDataType bioSketchAttachment;
            UnitContract unit;
            PersonProfileListDocument.PersonProfileList.ExtraKeyPerson extraPerson = (PersonProfileListDocument.PersonProfileList.ExtraKeyPerson)PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Factory.newInstance();
            extraPerson.setName(this.getExtraPersonName(proposalPerson));
            extraPerson.setAddress(this.getExtraPersonAddress(proposalPerson));
            if (proposalPerson.getPrimaryTitle() != null && proposalPerson.getPrimaryTitle().length() > 45) {
                extraPerson.setTitle(proposalPerson.getPrimaryTitle().substring(0, 45));
            } else {
                extraPerson.setTitle(proposalPerson.getPrimaryTitle());
            }
            if (proposalPerson.getProposalPersonRoleId() != null) {
                if (proposalPerson.isPrincipalInvestigator()) {
                    extraPerson.setProjectRole(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.ProjectRole.PD_PI);
                } else if (proposalPerson.isCoInvestigator()) {
                    if (this.isSponsorNIH(this.pdDoc)) {
                        extraPerson.setProjectRole(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.ProjectRole.OTHER_SPECIFY);
                        extraPerson.setOtherProjectRoleCategory(NIH_CO_INVESTIGATOR);
                    } else {
                        extraPerson.setProjectRole(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.ProjectRole.CO_PD_PI);
                    }
                } else {
                    String otherRole = proposalPerson.getProjectRole() != null && proposalPerson.getProjectRole().length() > 40 ? proposalPerson.getProjectRole().substring(0, 40) : proposalPerson.getProjectRole();
                    extraPerson.setOtherProjectRoleCategory(otherRole);
                    extraPerson.setProjectRole(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.ProjectRole.OTHER_SPECIFY);
                }
            }
            if (proposalPerson.getEraCommonsUserName() != null) {
                extraPerson.setCredential(proposalPerson.getEraCommonsUserName());
            }
            this.setDepartmentName(extraPerson);
            this.setDivisionName(extraPerson);
            if (proposalPerson.getEmailAddress() != null) {
                extraPerson.setEmail(proposalPerson.getEmailAddress());
            }
            if (StringUtils.isNotEmpty((CharSequence)proposalPerson.getFaxNumber())) {
                extraPerson.setFax(proposalPerson.getFaxNumber());
            }
            if ((unit = this.unitRepositoryService.findUnitByUnitNumber(proposalPerson.getHomeUnit())) != null && unit.getUnitName() != null) {
                extraPerson.setOrganizationName(unit.getUnitName());
            }
            if (proposalPerson.getOfficePhone() != null) {
                extraPerson.setPhone(proposalPerson.getOfficePhone());
            }
            if (proposalPerson.getDegree() != null) {
                extraPerson.setDegreeType(proposalPerson.getDegree());
            }
            if (proposalPerson.getYearGraduated() != null) {
                extraPerson.setDegreeYear(proposalPerson.getYearGraduated());
            }
            if ((bioSketchAttachment = this.getPersonnelAttachments(this.pdDoc, proposalPerson.getPersonId(), proposalPerson.getRolodexId(), BIOSKETCH_TYPE)) != null) {
                extraPerson.setBioSketchAttached(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.BioSketchAttached.YES);
            }
            if ((curPendingAttachment = this.getPersonnelAttachments(this.pdDoc, proposalPerson.getPersonId(), proposalPerson.getRolodexId(), CURRENT_PENDING_TYPE)) != null) {
                extraPerson.setSupportsAttached(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.SupportsAttached.YES);
            }
            if ((collaboratorAttachment = this.getPersonnelAttachments(this.pdDoc, proposalPerson.getPersonId(), proposalPerson.getRolodexId(), COLLABORATOR_TYPE)) != null) {
                extraPerson.setCollaboratorAttached(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.CollaboratorAttached.YES);
            }
            extraPersonList.add(extraPerson);
        }
        return extraPersonList.toArray(new PersonProfileListDocument.PersonProfileList.ExtraKeyPerson[0]);
    }

    private PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Address getExtraPersonAddress(ProposalPersonContract proposalPerson) {
        PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Address address = (PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Address)PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Address.Factory.newInstance();
        if (proposalPerson.getAddressLine1() != null) {
            if (proposalPerson.getAddressLine1().length() > 55) {
                address.setStreet1(proposalPerson.getAddressLine1().substring(0, 55));
            } else {
                address.setStreet1(proposalPerson.getAddressLine1());
            }
        }
        if (proposalPerson.getAddressLine2() != null) {
            if (proposalPerson.getAddressLine2().length() > 55) {
                address.setStreet2(proposalPerson.getAddressLine2().substring(0, 55));
            } else {
                address.setStreet2(proposalPerson.getAddressLine2());
            }
        }
        if (proposalPerson.getCity() != null) {
            address.setCity(proposalPerson.getCity());
        }
        if (proposalPerson.getCounty() != null) {
            address.setCounty(proposalPerson.getCounty());
        }
        if (proposalPerson.getPostalCode() != null) {
            address.setZipCode(proposalPerson.getPostalCode());
        }
        if (proposalPerson.getCountryCode() != null) {
            PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Address.Country.Enum county = PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Address.Country.Enum.forString(proposalPerson.getCountryCode());
            address.setCountry(county);
        }
        if (proposalPerson.getState() != null) {
            address.setState(proposalPerson.getState());
        }
        return address;
    }

    private PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Name getExtraPersonName(ProposalPersonContract proposalPerson) {
        PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Name name = (PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Name)PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Name.Factory.newInstance();
        if (proposalPerson.getFirstName() != null) {
            name.setFirstName(proposalPerson.getFirstName());
        }
        if (proposalPerson.getMiddleName() != null) {
            name.setMiddleName(proposalPerson.getMiddleName());
        }
        if (proposalPerson.getLastName() != null) {
            name.setLastName(proposalPerson.getLastName());
        }
        return name;
    }

    private void setDivisionName(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson extraPerson) {
        extraPerson.setDivisionName("");
    }

    private void setDepartmentName(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson extraPerson) {
        extraPerson.setDepartmentName("");
    }

    private void saveKeypersonProfileObject() {
        if (!org.springframework.util.CollectionUtils.isEmpty(this.extraPersons)) {
            PersonProfileListDocument.PersonProfileList extraPersonProfileList = (PersonProfileListDocument.PersonProfileList)PersonProfileListDocument.PersonProfileList.Factory.newInstance();
            extraPersonProfileList.setProposalNumber(this.pdDoc.getDevelopmentProposal().getProposalNumber());
            extraPersonProfileList.setExtraKeyPersonArray(this.getExtraKeyPersons());
            PersonProfileListDocument extraPersonDoc = (PersonProfileListDocument)PersonProfileListDocument.Factory.newInstance();
            extraPersonDoc.setPersonProfileList(extraPersonProfileList);
            String xmlData = extraPersonDoc.xmlText();
            GenericPrintable printable = new GenericPrintable();
            printable.setXslTemplates(Collections.singletonList(this.additionalkeypersonprofilesStyleSheet));
            printable.setName("");
            printable.setXml(xmlData);
            try {
                S2SFile printData = this.s2SPrintingService.print(printable);
                String fileName = this.pdDoc.getDevelopmentProposal().getProposalNumber() + "_PROFILE.pdf";
                this.saveNarrative(printData.getData(), "18", fileName, "Auto generated document for PROFILE");
            }
            catch (S2SException e) {
                LOG.error("Auto generation of Profile attachment for extra Keypersons failed", (Throwable)e);
            }
        }
    }

    private NSFKeyPersonExpanded11Document getNSFKeyPersonExpanded() {
        NSFKeyPersonExpanded11Document nsfKeyPersonExpandedDocument = (NSFKeyPersonExpanded11Document)NSFKeyPersonExpanded11Document.Factory.newInstance();
        NSFKeyPersonExpanded11Document.NSFKeyPersonExpanded11 nsfKeyPersonExpanded = (NSFKeyPersonExpanded11Document.NSFKeyPersonExpanded11)NSFKeyPersonExpanded11Document.NSFKeyPersonExpanded11.Factory.newInstance();
        this.setNSFKeyPersonExpandedAttributes(nsfKeyPersonExpanded);
        nsfKeyPersonExpandedDocument.setNSFKeyPersonExpanded11(nsfKeyPersonExpanded);
        return nsfKeyPersonExpandedDocument;
    }

    private void setNSFKeyPersonExpandedAttributes(NSFKeyPersonExpanded11Document.NSFKeyPersonExpanded11 nsfKeyPersonExpanded) {
        nsfKeyPersonExpanded.setFormVersion(FormVersion.v1_1.getVersion());
        nsfKeyPersonExpanded.setPDPI(this.getPersonProfilePI());
        PersonProfileDataType[] keyPersonArray = this.getPersonProfileKeyPerson();
        if (keyPersonArray.length > 0) {
            nsfKeyPersonExpanded.setKeyPersonArray(keyPersonArray);
        }
        this.saveKeyPersonAttachmentsToProposal();
        if (this.extraPersons.size() > 0) {
            for (ProposalPersonContract extraPerson : this.extraPersons) {
                this.setBioSketchAttchment(nsfKeyPersonExpanded, extraPerson);
                this.setCurrentPendingTypeAttachment(nsfKeyPersonExpanded, extraPerson);
            }
            for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
                if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 18) continue;
                this.setProfileTypeAttachment(nsfKeyPersonExpanded, narrative);
            }
        }
    }

    private void setProfileTypeAttachment(NSFKeyPersonExpanded11Document.NSFKeyPersonExpanded11 nsfKeyPersonExpanded, NarrativeContract narrative) {
        AttachedFileDataType attachedFileDataType = this.addAttachedFileType(narrative);
        if (attachedFileDataType != null) {
            NSFKeyPersonExpanded11Document.NSFKeyPersonExpanded11.AdditionalProfilesAttached additionalProfilesAttached = (NSFKeyPersonExpanded11Document.NSFKeyPersonExpanded11.AdditionalProfilesAttached)NSFKeyPersonExpanded11Document.NSFKeyPersonExpanded11.AdditionalProfilesAttached.Factory.newInstance();
            additionalProfilesAttached.setAdditionalProfileAttached(attachedFileDataType);
            nsfKeyPersonExpanded.setAdditionalProfilesAttached(additionalProfilesAttached);
        }
    }

    private void setCurrentPendingTypeAttachment(NSFKeyPersonExpanded11Document.NSFKeyPersonExpanded11 nsfKeyPersonExpanded, ProposalPersonContract extraPerson) {
        AttachedFileDataType supportAttachment = this.getPersonnelAttachments(this.pdDoc, extraPerson.getPersonId(), extraPerson.getRolodexId(), CURRENT_PENDING_TYPE);
        if (supportAttachment != null) {
            NSFKeyPersonExpanded11Document.NSFKeyPersonExpanded11.SupportsAttached supportsAttached = (NSFKeyPersonExpanded11Document.NSFKeyPersonExpanded11.SupportsAttached)NSFKeyPersonExpanded11Document.NSFKeyPersonExpanded11.SupportsAttached.Factory.newInstance();
            supportsAttached.setSupportAttached(supportAttachment);
            nsfKeyPersonExpanded.setSupportsAttached(supportsAttached);
        }
    }

    private void setBioSketchAttchment(NSFKeyPersonExpanded11Document.NSFKeyPersonExpanded11 nsfKeyPersonExpanded, ProposalPersonContract extraPerson) {
        NSFKeyPersonExpanded11Document.NSFKeyPersonExpanded11.BioSketchsAttached personBioSketch = (NSFKeyPersonExpanded11Document.NSFKeyPersonExpanded11.BioSketchsAttached)NSFKeyPersonExpanded11Document.NSFKeyPersonExpanded11.BioSketchsAttached.Factory.newInstance();
        AttachedFileDataType bioSketchAttachment = this.getPersonnelAttachments(this.pdDoc, extraPerson.getPersonId(), extraPerson.getRolodexId(), BIOSKETCH_TYPE);
        personBioSketch.setBioSketchAttached(bioSketchAttachment);
        nsfKeyPersonExpanded.setBioSketchsAttached(personBioSketch);
    }

    private PersonProfileDataType getPersonProfilePI() {
        PersonProfileDataType profileDataType = (PersonProfileDataType)PersonProfileDataType.Factory.newInstance();
        profileDataType.setProfile((PersonProfileDataType.Profile)PersonProfileDataType.Profile.Factory.newInstance());
        ProposalPersonContract PI = this.s2SProposalPersonService.getPrincipalInvestigator(this.pdDoc);
        if (PI != null) {
            this.setPersonalProfileDetailsToProfile(profileDataType, PI);
        }
        return profileDataType;
    }

    private void setPersonalProfileDetailsToProfile(PersonProfileDataType profileDataType, ProposalPersonContract principalInvestigator) {
        PersonProfileDataType.Profile profile = profileDataType.getProfile();
        this.assignRolodexId(principalInvestigator);
        profile.setName(this.globLibV20Generator.getHumanNameDataType(principalInvestigator));
        this.setDirectoryTitleToProfile(profile, principalInvestigator);
        profile.setAddress(this.globLibV20Generator.getAddressDataType((Addressable)principalInvestigator));
        profile.setPhone(principalInvestigator.getOfficePhone());
        if (StringUtils.isNotEmpty((CharSequence)principalInvestigator.getFaxNumber())) {
            profile.setFax(principalInvestigator.getFaxNumber());
        }
        this.setDegreeInfo(principalInvestigator, profile);
        profile.setEmail(principalInvestigator.getEmailAddress());
        DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
        this.setOrganizationName(profile, developmentProposal);
        this.setDepartmentNameToProfile(profile, principalInvestigator);
        String divisionName = this.getS2sDivisionService().getDivision(principalInvestigator);
        if (divisionName != null) {
            profile.setDivisionName(divisionName);
        }
        profile.setNSFID(principalInvestigator.getNsfId());
        profile.setProjectRole(ProjectRoleDataType.PD_PI);
        this.setAttachments(profile, principalInvestigator);
    }

    private void setDepartmentNameToProfile(PersonProfileDataType.Profile profile, ProposalPersonContract PI) {
        if (PI.getHomeUnit() != null && PI.getPerson() != null && PI.getPerson().getUnit() != null) {
            String departmentName = PI.getPerson().getUnit().getUnitName();
            profile.setDepartmentName(StringUtils.substring((String)departmentName, (int)0, (int)30));
        } else {
            DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
            profile.setDepartmentName(StringUtils.substring((String)developmentProposal.getOwnedByUnit().getUnitName(), (int)0, (int)30));
        }
    }

    private void setDirectoryTitleToProfile(PersonProfileDataType.Profile profile, ProposalPersonContract PI) {
        if (PI.getDirectoryTitle() != null) {
            if (PI.getDirectoryTitle().length() > 45) {
                profile.setTitle(PI.getDirectoryTitle().substring(0, 45));
            } else {
                profile.setTitle(PI.getDirectoryTitle());
            }
        }
    }

    private void assignRolodexId(ProposalPersonContract PI) {
        if (PI.getPersonId() != null) {
            this.pIPersonOrRolodexId = PI.getPersonId();
            this.rolodex = null;
        } else if (PI.getRolodexId() != null) {
            this.pIPersonOrRolodexId = PI.getRolodexId().toString();
            this.rolodex = this.rolodexService.getRolodex(Integer.valueOf(this.pIPersonOrRolodexId));
        }
    }

    private void setAttachments(PersonProfileDataType.Profile profile, ProposalPersonContract PI) {
        this.setBioSketchAttachment(profile, PI);
        this.setCurrentPendingAttachment(profile, PI);
        this.setCollaboratorsAttachment(profile, PI);
    }

    private void setCurrentPendingAttachment(PersonProfileDataType.Profile profile, ProposalPersonContract PI) {
        profile.setSupportsAttached((PersonProfileDataType.Profile.SupportsAttached)PersonProfileDataType.Profile.SupportsAttached.Factory.newInstance());
        AttachedFileDataType supportAttachment = this.getPersonnelAttachments(this.pdDoc, PI.getPersonId(), PI.getRolodexId(), CURRENT_PENDING_TYPE);
        if (supportAttachment == null) {
            supportAttachment = (AttachedFileDataType)AttachedFileDataType.Factory.newInstance();
        }
        profile.getSupportsAttached().setSupportAttached(supportAttachment);
    }

    private void setBioSketchAttachment(PersonProfileDataType.Profile profile, ProposalPersonContract PI) {
        profile.setBioSketchsAttached((PersonProfileDataType.Profile.BioSketchsAttached)PersonProfileDataType.Profile.BioSketchsAttached.Factory.newInstance());
        AttachedFileDataType bioSketchAttachment = this.getPersonnelAttachments(this.pdDoc, PI.getPersonId(), PI.getRolodexId(), BIOSKETCH_TYPE);
        if (bioSketchAttachment == null) {
            bioSketchAttachment = (AttachedFileDataType)AttachedFileDataType.Factory.newInstance();
        }
        profile.getBioSketchsAttached().setBioSketchAttached(bioSketchAttachment);
    }

    private void setCollaboratorsAttachment(PersonProfileDataType.Profile profile, ProposalPersonContract PI) {
        profile.setCollaboratorsAttached((PersonProfileDataType.Profile.CollaboratorsAttached)PersonProfileDataType.Profile.CollaboratorsAttached.Factory.newInstance());
        AttachedFileDataType collaboratorAttachment = this.getPersonnelAttachments(this.pdDoc, PI.getPersonId(), PI.getRolodexId(), COLLABORATOR_TYPE);
        if (collaboratorAttachment == null) {
            collaboratorAttachment = (AttachedFileDataType)AttachedFileDataType.Factory.newInstance();
        }
        profile.getCollaboratorsAttached().setCollaboratorAttached(collaboratorAttachment);
    }

    private PersonProfileDataType[] getPersonProfileKeyPerson() {
        ArrayList<PersonProfileDataType> personProfileDataTypeList = new ArrayList<PersonProfileDataType>();
        DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
        List keyPersons = developmentProposal.getProposalPersons();
        if (keyPersons != null) {
            keyPersons.sort(new ProposalPersonComparator());
        }
        List<ProposalPersonContract> nKeyPersons = this.s2SProposalPersonService.getNKeyPersons(keyPersons, 100);
        List<Object> list = this.extraPersons = keyPersons != null ? keyPersons.stream().filter(kp -> !nKeyPersons.contains(kp)).collect(Collectors.toList()) : Collections.emptyList();
        if (nKeyPersons.size() > 0) {
            this.setKeyPersonToPersonProfileDataType(personProfileDataTypeList, nKeyPersons);
        }
        return personProfileDataTypeList.toArray(new PersonProfileDataType[0]);
    }

    private void setKeyPersonToPersonProfileDataType(List<PersonProfileDataType> personProfileDataTypeList, List<ProposalPersonContract> nKeyPersons) {
        for (ProposalPersonContract keyPerson : nKeyPersons) {
            if (this.pIPersonOrRolodexId != null && (keyPerson.getPersonId() != null && keyPerson.getPersonId().equals(this.pIPersonOrRolodexId) || keyPerson.getRolodexId() != null && this.pIPersonOrRolodexId.equals(keyPerson.getRolodexId().toString()))) continue;
            PersonProfileDataType.Profile profileKeyPerson = (PersonProfileDataType.Profile)PersonProfileDataType.Profile.Factory.newInstance();
            this.setAllkeyPersonDetailsToKeyPerson(keyPerson, profileKeyPerson);
            this.setAttachments(profileKeyPerson, keyPerson);
            PersonProfileDataType personProfileDataTypeKeyPerson = (PersonProfileDataType)PersonProfileDataType.Factory.newInstance();
            personProfileDataTypeKeyPerson.setProfile(profileKeyPerson);
            personProfileDataTypeList.add(personProfileDataTypeKeyPerson);
        }
    }

    private void setAllkeyPersonDetailsToKeyPerson(ProposalPersonContract keyPerson, PersonProfileDataType.Profile profileKeyPerson) {
        this.assignRolodexId(keyPerson);
        profileKeyPerson.setName(this.globLibV20Generator.getHumanNameDataType(keyPerson));
        this.setDirectoryTitleToProfile(profileKeyPerson, keyPerson);
        profileKeyPerson.setAddress(this.globLibV20Generator.getAddressDataType((Addressable)keyPerson));
        profileKeyPerson.setPhone(keyPerson.getOfficePhone());
        if (StringUtils.isNotEmpty((CharSequence)keyPerson.getFaxNumber())) {
            profileKeyPerson.setFax(keyPerson.getFaxNumber());
        }
        this.setDegreeInfo(keyPerson, profileKeyPerson);
        profileKeyPerson.setEmail(keyPerson.getEmailAddress());
        DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
        this.setOrganizationName(profileKeyPerson, developmentProposal);
        this.setDepartmentNameToProfile(profileKeyPerson, keyPerson);
        String divisionName = this.getS2sDivisionService().getDivision(keyPerson);
        if (divisionName != null) {
            profileKeyPerson.setDivisionName(divisionName);
        }
        profileKeyPerson.setNSFID(keyPerson.getNsfId() == null ? "" : keyPerson.getNsfId());
        this.setProjectRole(keyPerson, profileKeyPerson);
    }

    private void setDegreeInfo(ProposalPersonContract keyPerson, PersonProfileDataType.Profile profileKeyPerson) {
        ProposalPersonDegreeContract proposalPersonDegree;
        if (keyPerson.getDegree() != null) {
            profileKeyPerson.setDegreeType(keyPerson.getDegree());
        }
        if (keyPerson.getYearGraduated() != null) {
            profileKeyPerson.setDegreeYear(keyPerson.getYearGraduated());
        }
        if (keyPerson.getDegree() == null && keyPerson.getYearGraduated() == null && keyPerson.getProposalPersonDegrees() != null && keyPerson.getProposalPersonDegrees().size() > 0 && (proposalPersonDegree = (ProposalPersonDegreeContract)keyPerson.getProposalPersonDegrees().get(0)) != null) {
            if (proposalPersonDegree.getDegreeType() != null && proposalPersonDegree.getDegreeType().getDescription() != null) {
                profileKeyPerson.setDegreeType(proposalPersonDegree.getDegreeType().getDescription());
            }
            if (proposalPersonDegree.getGraduationYear() != null) {
                profileKeyPerson.setDegreeYear(proposalPersonDegree.getGraduationYear());
            }
        }
    }

    private void setProjectRole(ProposalPersonContract keyPerson, PersonProfileDataType.Profile profileKeyPerson) {
        if (keyPerson.isMultiplePi() || keyPerson.isCoInvestigator()) {
            if (this.getSponsorHierarchyService().isSponsorNihMultiplePi(this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorCode())) {
                if (keyPerson.isMultiplePi()) {
                    profileKeyPerson.setProjectRole(ProjectRoleDataType.PD_PI);
                } else {
                    profileKeyPerson.setProjectRole(ProjectRoleDataType.CO_INVESTIGATOR);
                }
            } else {
                profileKeyPerson.setProjectRole(ProjectRoleDataType.CO_PD_PI);
            }
        } else {
            this.setProjectRoleCategoryToProfile(keyPerson, profileKeyPerson);
        }
    }

    private void setOrganizationName(PersonProfileDataType.Profile profileKeyPerson, DevelopmentProposalContract developmentProposal) {
        if (developmentProposal.getApplicantOrganization() != null) {
            profileKeyPerson.setOrganizationName(StringUtils.substring((String)developmentProposal.getApplicantOrganization().getLocationName(), (int)0, (int)60));
        }
    }

    private void setProjectRoleCategoryToProfile(ProposalPersonContract keyPerson, PersonProfileDataType.Profile profileKeyPerson) {
        if (keyPerson.getRolodexId() != null && keyPerson.getProjectRole().equals(ProjectRoleDataType.PD_PI.toString())) {
            profileKeyPerson.setProjectRole(ProjectRoleDataType.PD_PI);
        } else {
            profileKeyPerson.setProjectRole(ProjectRoleDataType.OTHER_SPECIFY);
            PersonProfileDataType.Profile.OtherProjectRoleCategory otherProjectRole = (PersonProfileDataType.Profile.OtherProjectRoleCategory)PersonProfileDataType.Profile.OtherProjectRoleCategory.Factory.newInstance();
            String otherRole = keyPerson.getProjectRole() != null ? (keyPerson.getProjectRole().length() > 40 ? keyPerson.getProjectRole().substring(0, 40) : keyPerson.getProjectRole()) : "Unknown";
            otherProjectRole.setStringValue(otherRole);
            profileKeyPerson.setOtherProjectRoleCategory(otherProjectRole);
        }
    }

    @Override
    public NSFKeyPersonExpanded11Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getNSFKeyPersonExpanded();
    }

    public UnitRepositoryService getUnitRepositoryService() {
        return this.unitRepositoryService;
    }

    public void setUnitRepositoryService(UnitRepositoryService unitRepositoryService) {
        this.unitRepositoryService = unitRepositoryService;
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    public S2SPrintingService getS2SPrintingService() {
        return this.s2SPrintingService;
    }

    public void setS2SPrintingService(S2SPrintingService s2SPrintingService) {
        this.s2SPrintingService = s2SPrintingService;
    }

    public S2SProposalPersonService getS2SProposalPersonService() {
        return this.s2SProposalPersonService;
    }

    public void setS2SProposalPersonService(S2SProposalPersonService s2SProposalPersonService) {
        this.s2SProposalPersonService = s2SProposalPersonService;
    }

    public S2sDivisionService getS2sDivisionService() {
        return this.s2sDivisionService;
    }

    public void setS2sDivisionService(S2sDivisionService s2sDivisionService) {
        this.s2sDivisionService = s2sDivisionService;
    }

    public Resource getAdditionalkeypersonprofilesStyleSheet() {
        return this.additionalkeypersonprofilesStyleSheet;
    }

    public void setAdditionalkeypersonprofilesStyleSheet(Resource additionalkeypersonprofilesStyleSheet) {
        this.additionalkeypersonprofilesStyleSheet = additionalkeypersonprofilesStyleSheet;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(NSFKeyPersonExpanded11Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            NSFKeyPersonExpanded11Document.NSFKeyPersonExpanded11.BioSketchsAttached bioSketchAttached;
            if (form.getNSFKeyPersonExpanded11().getKeyPersonList() != null) {
                List<PersonProfileDataType> keyPersonList = form.getNSFKeyPersonExpanded11().getKeyPersonList();
                for (int i = 0; i < keyPersonList.size(); ++i) {
                    PersonProfileDataType personProfile = keyPersonList.get(i);
                    PersonProfileDataType.Profile.BioSketchsAttached biosketch = personProfile.getProfile().getBioSketchsAttached();
                    PersonProfileDataType.Profile.SupportsAttached supports = personProfile.getProfile().getSupportsAttached();
                    PersonProfileDataType.Profile.CollaboratorsAttached collaborators = personProfile.getProfile().getCollaboratorsAttached();
                    if (biosketch != null && biosketch.getBioSketchAttached() != null && a.getContentId().equals(biosketch.getBioSketchAttached().getFileLocation().getHref())) {
                        return CollectionUtils.entry("NSF_KeyPersonExpanded_1_1_P1.KeyPerson.optionalFile0_" + i, a);
                    }
                    if (supports != null && supports.getSupportAttached() != null && a.getContentId().equals(supports.getSupportAttached().getFileLocation().getHref())) {
                        return CollectionUtils.entry("NSF_KeyPersonExpanded_1_1_P1.KeyPerson.optionalFile1_" + i, a);
                    }
                    if (collaborators == null || collaborators.getCollaboratorAttached() == null || !a.getContentId().equals(collaborators.getCollaboratorAttached().getFileLocation().getHref())) continue;
                    return CollectionUtils.entry("NSF_KeyPersonExpanded_1_1_P1.KeyPerson.mandatoryFile0_" + i, a);
                }
            }
            if ((bioSketchAttached = form.getNSFKeyPersonExpanded11().getBioSketchsAttached()) != null && bioSketchAttached.getBioSketchAttached() != null && a.getContentId().equals(bioSketchAttached.getBioSketchAttached().getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_KeyPersonExpanded_1_1_P1.PDPI.mandatoryFile0", a);
            }
            NSFKeyPersonExpanded11Document.NSFKeyPersonExpanded11.SupportsAttached supportAttached = form.getNSFKeyPersonExpanded11().getSupportsAttached();
            if (supportAttached != null && supportAttached.getSupportAttached() != null && a.getContentId().equals(supportAttached.getSupportAttached().getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_KeyPersonExpanded_1_1_P1.PDPI.optionalFile0", a);
            }
            NSFKeyPersonExpanded11Document.NSFKeyPersonExpanded11.CollaboratorsAttached collaboratorAttached = form.getNSFKeyPersonExpanded11().getCollaboratorsAttached();
            if (collaboratorAttached != null && collaboratorAttached.getCollaboratorAttached() != null && a.getContentId().equals(collaboratorAttached.getCollaboratorAttached().getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_KeyPersonExpanded_1_1_P1.PDPI.mandatoryFile1", a);
            }
            NSFKeyPersonExpanded11Document.NSFKeyPersonExpanded11.AdditionalProfilesAttached additionalProfileAttached = form.getNSFKeyPersonExpanded11().getAdditionalProfilesAttached();
            if (additionalProfileAttached != null && additionalProfileAttached.getAdditionalProfileAttached() != null && a.getContentId().equals(additionalProfileAttached.getAdditionalProfileAttached().getFileLocation().getHref())) {
                return CollectionUtils.entry("NSF_KeyPersonExpanded_1_1_P1.optionalFile1", a);
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<NSFKeyPersonExpanded11Document> factory() {
        return NSFKeyPersonExpanded11Document.Factory;
    }
}

