/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phs398CoverPageSupplementV11.PHS398CoverPageSupplementDocument;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonDegreeContract;
import org.kuali.coeus.propdev.api.ynq.ProposalYnqContract;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.support.PHS398CoverPageSupplementBaseGenerator;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="PHS398CoverPageSupplementV1_1Generator")
public class PHS398CoverPageSupplementV1_1Generator
extends PHS398CoverPageSupplementBaseGenerator<PHS398CoverPageSupplementDocument> {
    @Value(value="http://apply.grants.gov/forms/PHS398_CoverPageSupplement-V1.1")
    private String namespace;
    @Value(value="PHS398_CoverPageSupplement-V1.1")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS398_CoverPageSupplement-V1.1.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="158")
    private int sortIndex;
    private List<? extends AnswerHeaderContract> answerHeaders;

    private PHS398CoverPageSupplementDocument getCoverPageSupplement() {
        PHS398CoverPageSupplementDocument coverPageSupplementDocument = (PHS398CoverPageSupplementDocument)PHS398CoverPageSupplementDocument.Factory.newInstance();
        PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement coverPageSupplement = (PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement)PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.Factory.newInstance();
        this.answerHeaders = this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        coverPageSupplement.setFormVersion(FormVersion.v1_1.getVersion());
        coverPageSupplement.setPDPI(this.getPDPI());
        coverPageSupplement.setClinicalTrial(this.getClinicalTrial());
        coverPageSupplement.setContactPersonInfo(this.getContactPersonInfo());
        PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.StemCells stemCells = this.getStemCells();
        coverPageSupplement.setStemCells(stemCells);
        coverPageSupplementDocument.setPHS398CoverPageSupplement(coverPageSupplement);
        return coverPageSupplementDocument;
    }

    private PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.PDPI getPDPI() {
        PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.PDPI pdpi = (PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.PDPI)PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.PDPI.Factory.newInstance();
        ProposalPersonContract PI = this.s2SProposalPersonService.getPrincipalInvestigator(this.pdDoc);
        pdpi.setPDPIName(this.globLibV20Generator.getHumanNameDataType(PI));
        pdpi.setIsNewInvestigator(YesNoDataType.N_NO);
        ProposalYnqContract proposalYnq = this.getProposalYnQ(IS_NEW_INVESTIGATOR);
        if (PI != null) {
            if (proposalYnq != null && proposalYnq.getAnswer() != null) {
                YesNoDataType.Enum answer = proposalYnq.getAnswer().equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
                pdpi.setIsNewInvestigator(answer);
            }
            String[] degreeArr = null;
            if (PI.getProposalPersonDegrees() != null) {
                degreeArr = new String[PI.getProposalPersonDegrees().size()];
            }
            int size = 0;
            for (ProposalPersonDegreeContract personDegree : PI.getProposalPersonDegrees()) {
                if (size > 3) break;
                if (personDegree.getDegree() == null) continue;
                degreeArr[size] = personDegree.getDegree().length() > 10 ? personDegree.getDegree().substring(0, 10) : personDegree.getDegree();
                ++size;
            }
            pdpi.setDegreesArray(degreeArr);
        }
        return pdpi;
    }

    private PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.ClinicalTrial getClinicalTrial() {
        PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.ClinicalTrial clinicalTrial = (PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.ClinicalTrial)PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.ClinicalTrial.Factory.newInstance();
        String answer = this.getAnswer(IS_CLINICAL_TRIAL, this.answerHeaders);
        if (answer != null && !answer.equals("No")) {
            if (YnqConstant.YES.code().equals(answer)) {
                clinicalTrial.setIsClinicalTrial(YesNoDataType.Y_YES);
                String subAnswer = this.getAnswer(PHASE_III_CLINICAL_TRIAL, this.answerHeaders);
                if (subAnswer != null && !subAnswer.equals("No")) {
                    if (YnqConstant.YES.code().equals(subAnswer)) {
                        clinicalTrial.setIsPhaseIIIClinicalTrial(YesNoDataType.Y_YES);
                    } else {
                        clinicalTrial.setIsPhaseIIIClinicalTrial(YesNoDataType.N_NO);
                    }
                }
            } else {
                clinicalTrial.setIsClinicalTrial(YesNoDataType.N_NO);
            }
        }
        return clinicalTrial;
    }

    private PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.ContactPersonInfo getContactPersonInfo() {
        PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.ContactPersonInfo contactPersonInfo = (PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.ContactPersonInfo)PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.ContactPersonInfo.Factory.newInstance();
        DepartmentalPersonDto person = this.departmentalPersonService.getContactPerson(this.pdDoc);
        contactPersonInfo.setContactName(this.globLibV20Generator.getHumanNameDataType(person));
        contactPersonInfo.setContactPhone(person.getOfficePhone());
        if (StringUtils.isNotEmpty((CharSequence)person.getFaxNumber())) {
            contactPersonInfo.setContactFax(person.getFaxNumber());
        }
        if (person.getEmailAddress() != null && !person.getEmailAddress().equals("")) {
            contactPersonInfo.setContactEmail(person.getEmailAddress());
        }
        if (person.getPrimaryTitle() != null) {
            contactPersonInfo.setContactTitle(StringUtils.substring((String)person.getPrimaryTitle(), (int)0, (int)45));
        }
        contactPersonInfo.setContactAddress(this.globLibV20Generator.getAddressDataType(person));
        return contactPersonInfo;
    }

    private PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.StemCells getStemCells() {
        PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.StemCells stemCells = (PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.StemCells)PHS398CoverPageSupplementDocument.PHS398CoverPageSupplement.StemCells.Factory.newInstance();
        String childAnswer = null;
        String answer = this.getAnswer(IS_HUMAN_STEM_CELLS_INVOLVED, this.answerHeaders);
        if (answer != null && !answer.equals("No")) {
            YesNoDataType.Enum answers;
            YesNoDataType.Enum enum_ = answers = YnqConstant.YES.code().equals(this.getAnswer(IS_HUMAN_STEM_CELLS_INVOLVED, this.answerHeaders)) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            if (YnqConstant.YES.code().equals(answer)) {
                stemCells.setIsHumanStemCellsInvolved(YesNoDataType.Y_YES);
                String subAnswer = this.getAnswer(SPECIFIC_STEM_CELL_LINE, this.answerHeaders);
                if (subAnswer != null && !subAnswer.equals("No")) {
                    if (YnqConstant.YES.code().equals(subAnswer)) {
                        stemCells.setStemCellsIndicator(YesNoDataType.N_NO);
                        childAnswer = this.getAnswers(REGISTRATION_NUMBER, this.answerHeaders);
                    } else {
                        stemCells.setStemCellsIndicator(YesNoDataType.Y_YES);
                    }
                }
                if (childAnswer != null) {
                    if ("Unknown".equalsIgnoreCase(childAnswer)) {
                        stemCells.setStemCellsIndicator(answers);
                    } else {
                        List<String> cellLines = this.getCellLines(childAnswer);
                        if (cellLines.size() > 0) {
                            stemCells.setCellLinesArray(cellLines.toArray(new String[0]));
                        }
                    }
                }
            } else {
                stemCells.setIsHumanStemCellsInvolved(YesNoDataType.N_NO);
            }
        }
        return stemCells;
    }

    @Override
    public PHS398CoverPageSupplementDocument getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getCoverPageSupplement();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public DocumentFactory<PHS398CoverPageSupplementDocument> factory() {
        return PHS398CoverPageSupplementDocument.Factory;
    }
}

