/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.phs398CoverPageSupplement20V20.PHS398CoverPageSupplement20Document;
import gov.grants.apply.system.globalLibraryV20.HumanNameDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.budget.api.income.BudgetProjectIncomeContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.budget.S2SCommonBudgetService;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.PHS398CoverPageSupplementBaseGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="PHS398CoverPageSupplement_2_0V2_0Generator")
public class PHS398CoverPageSupplement_2_0V2_0Generator
extends PHS398CoverPageSupplementBaseGenerator<PHS398CoverPageSupplement20Document>
implements S2SFormGeneratorPdfFillable<PHS398CoverPageSupplement20Document> {
    private static final Integer YNQANSWER_121 = 121;
    protected static final Integer PROPOSAL_YNQ_QUESTION_114 = 114;
    protected static final Integer PROPOSAL_YNQ_QUESTION_115 = 115;
    protected static final Integer PROPOSAL_YNQ_QUESTION_116 = 116;
    protected static final Integer PROPOSAL_YNQ_QUESTION_117 = 117;
    protected static final Integer PROPOSAL_YNQ_QUESTION_118 = 118;
    protected static final Integer PROPOSAL_YNQ_QUESTION_119 = 119;
    protected static final Integer PROPOSAL_YNQ_QUESTION_120 = 120;
    protected static final int PROJECT_INCOME_DESCRIPTION_MAX_LENGTH = 150;
    private List<? extends AnswerHeaderContract> answerHeaders;
    @Value(value="http://apply.grants.gov/forms/PHS398_CoverPageSupplement_2_0-V2.0")
    private String namespace;
    @Value(value="PHS398_CoverPageSupplement_2_0-V2.0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/PHS398_CoverPageSupplement_2_0-V2.0.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/PHS398_CoverPageSupplement_2_0-V2.0.pdf")
    private Resource pdfForm;
    @Value(value="158")
    private int sortIndex;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;
    @Autowired
    @Qualifier(value="s2SCommonBudgetService")
    private S2SCommonBudgetService s2SCommonBudgetService;

    private PHS398CoverPageSupplement20Document getCoverPageSupplement() {
        PHS398CoverPageSupplement20Document coverPageSupplementDocument = (PHS398CoverPageSupplement20Document)PHS398CoverPageSupplement20Document.Factory.newInstance();
        PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20 coverPageSupplement = (PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20)PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.Factory.newInstance();
        this.answerHeaders = this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        coverPageSupplement.setFormVersion(FormVersion.v2_0.getVersion());
        coverPageSupplement.setPDPI(this.getPDPI());
        coverPageSupplement.setClinicalTrial(this.getClinicalTrial());
        this.setIsInventionsAndPatentsAndIsPreviouslyReported(coverPageSupplement);
        this.setFormerPDNameAndIsChangeOfPDPI(coverPageSupplement);
        this.setFormerInstitutionNameAndChangeOfInstitution(coverPageSupplement);
        ProposalDevelopmentBudgetExtContract budget = this.s2SCommonBudgetService.getBudget(this.pdDoc.getDevelopmentProposal());
        if (budget != null) {
            PHS398CoverPageSupplement_2_0V2_0Generator.setIncomeBudgetPeriods(coverPageSupplement, budget.getBudgetProjectIncomes());
        } else {
            coverPageSupplement.setProgramIncome(YesNoDataType.N_NO);
        }
        YesNoDataType.Enum ynqAnswer = this.getYNQAnswer(YNQANSWER_121);
        coverPageSupplement.setDisclosurePermission(ynqAnswer);
        PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.StemCells stemCells = this.getStemCells();
        coverPageSupplement.setStemCells(stemCells);
        coverPageSupplementDocument.setPHS398CoverPageSupplement20(coverPageSupplement);
        return coverPageSupplementDocument;
    }

    private PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.PDPI getPDPI() {
        PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.PDPI pdpi = (PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.PDPI)PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.PDPI.Factory.newInstance();
        ProposalPersonContract PI = this.s2SProposalPersonService.getPrincipalInvestigator(this.pdDoc);
        pdpi.setPDPIName(this.globLibV20Generator.getHumanNameDataType(PI));
        return pdpi;
    }

    private PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.ClinicalTrial getClinicalTrial() {
        PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.ClinicalTrial clinicalTrial = (PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.ClinicalTrial)PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.ClinicalTrial.Factory.newInstance();
        String answer = this.getAnswer(IS_CLINICAL_TRIAL, this.answerHeaders);
        if (answer != null && !answer.equals("No")) {
            if (YnqConstant.YES.code().equals(answer)) {
                clinicalTrial.setIsClinicalTrial(YesNoDataType.Y_YES);
                String subAnswer = this.getAnswer(PHASE_III_CLINICAL_TRIAL, this.answerHeaders);
                if (subAnswer != null && !subAnswer.equals("No")) {
                    if (YnqConstant.YES.code().equals(subAnswer)) {
                        clinicalTrial.setIsPhaseIIIClinicalTrial(YesNoDataType.Y_YES);
                    } else {
                        clinicalTrial.setIsPhaseIIIClinicalTrial(YesNoDataType.N_NO);
                    }
                } else {
                    clinicalTrial.setIsPhaseIIIClinicalTrial(null);
                }
            } else {
                clinicalTrial.setIsClinicalTrial(YesNoDataType.N_NO);
            }
        }
        return clinicalTrial;
    }

    private void setIsInventionsAndPatentsAndIsPreviouslyReported(PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20 coverPageSupplement) {
        String answer = this.getAnswer(PROPOSAL_YNQ_QUESTION_118, this.answerHeaders);
        if (answer != null && !answer.equals("No") && YnqConstant.YES.code().equals(answer)) {
            String explanation = this.getAnswer(PROPOSAL_YNQ_QUESTION_119, this.answerHeaders);
            if (explanation != null && !explanation.equals("No")) {
                if (YnqConstant.YES.code().equals(explanation)) {
                    coverPageSupplement.setIsInventionsAndPatents(YesNoDataType.Y_YES);
                    String subQuestionExplanation = this.getAnswer(PROPOSAL_YNQ_QUESTION_120, this.answerHeaders);
                    if (subQuestionExplanation != null && !subQuestionExplanation.equals("No")) {
                        if (YnqConstant.YES.code().equals(subQuestionExplanation)) {
                            coverPageSupplement.setIsPreviouslyReported(YesNoDataType.Y_YES);
                        } else if (YnqConstant.NO.code().equals(subQuestionExplanation)) {
                            coverPageSupplement.setIsPreviouslyReported(YesNoDataType.N_NO);
                        }
                    } else {
                        coverPageSupplement.setIsPreviouslyReported(null);
                    }
                } else if (YnqConstant.NO.code().equals(explanation)) {
                    coverPageSupplement.setIsInventionsAndPatents(YesNoDataType.N_NO);
                }
            } else {
                coverPageSupplement.setIsInventionsAndPatents(null);
            }
        }
    }

    private void setFormerPDNameAndIsChangeOfPDPI(PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20 coverPageSupplement) {
        String answer = this.getAnswer(PROPOSAL_YNQ_QUESTION_114, this.answerHeaders);
        String explanation = this.getAnswer(PROPOSAL_YNQ_QUESTION_115, this.answerHeaders);
        if (YnqConstant.YES.code().equals(answer)) {
            coverPageSupplement.setIsChangeOfPDPI(YesNoDataType.Y_YES);
            if (explanation != null) {
                RolodexContract rolodex = this.rolodexService.getRolodex(Integer.valueOf(explanation));
                HumanNameDataType formerPDName = this.globLibV20Generator.getHumanNameDataType(rolodex);
                if (formerPDName != null && formerPDName.getFirstName() != null && formerPDName.getLastName() != null) {
                    coverPageSupplement.setFormerPDName(formerPDName);
                }
            } else {
                coverPageSupplement.setFormerPDName(null);
            }
        } else {
            coverPageSupplement.setIsChangeOfPDPI(YesNoDataType.N_NO);
        }
    }

    private void setFormerInstitutionNameAndChangeOfInstitution(PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20 coverPageSupplement) {
        String answer = this.getAnswer(PROPOSAL_YNQ_QUESTION_116, this.answerHeaders);
        String explanation = this.getAnswer(PROPOSAL_YNQ_QUESTION_117, this.answerHeaders);
        if (YnqConstant.YES.code().equals(answer)) {
            coverPageSupplement.setIsChangeOfInstitution(YesNoDataType.Y_YES);
            if (explanation != null) {
                coverPageSupplement.setFormerInstitutionName(explanation);
            } else {
                coverPageSupplement.setFormerInstitutionName(null);
            }
        } else {
            coverPageSupplement.setIsChangeOfInstitution(YesNoDataType.N_NO);
        }
    }

    private static void setIncomeBudgetPeriods(PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20 coverPageSupplement, List<? extends BudgetProjectIncomeContract> projectIncomes) {
        if (projectIncomes.isEmpty()) {
            coverPageSupplement.setProgramIncome(YesNoDataType.N_NO);
        } else {
            coverPageSupplement.setProgramIncome(YesNoDataType.Y_YES);
        }
        coverPageSupplement.setIncomeBudgetPeriodArray(PHS398CoverPageSupplement_2_0V2_0Generator.getIncomeBudgetPeriod(projectIncomes));
    }

    private static PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.IncomeBudgetPeriod[] getIncomeBudgetPeriod(List<? extends BudgetProjectIncomeContract> projectIncomes) {
        TreeMap<Integer, PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.IncomeBudgetPeriod> incomeBudgetPeriodMap = new TreeMap<Integer, PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.IncomeBudgetPeriod>();
        for (BudgetProjectIncomeContract budgetProjectIncomeContract : projectIncomes) {
            BigDecimal anticipatedAmount;
            Integer budgetPeriodNumber = budgetProjectIncomeContract.getBudgetPeriodNumber();
            PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.IncomeBudgetPeriod incomeBudgPeriod = (PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.IncomeBudgetPeriod)incomeBudgetPeriodMap.get(budgetPeriodNumber);
            if (incomeBudgPeriod == null) {
                incomeBudgPeriod = (PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.IncomeBudgetPeriod)PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.IncomeBudgetPeriod.Factory.newInstance();
                incomeBudgPeriod.setBudgetPeriod(budgetPeriodNumber);
                anticipatedAmount = BigDecimal.ZERO;
            } else {
                anticipatedAmount = incomeBudgPeriod.getAnticipatedAmount();
            }
            anticipatedAmount = anticipatedAmount.add(budgetProjectIncomeContract.getProjectIncome().bigDecimalValue());
            incomeBudgPeriod.setAnticipatedAmount(anticipatedAmount);
            String description = PHS398CoverPageSupplement_2_0V2_0Generator.getProjectIncomeDescription(budgetProjectIncomeContract);
            if (description != null) {
                if (incomeBudgPeriod.getSource() != null) {
                    incomeBudgPeriod.setSource(incomeBudgPeriod.getSource() + ";" + description);
                } else {
                    incomeBudgPeriod.setSource(description);
                }
            }
            incomeBudgetPeriodMap.put(budgetPeriodNumber, incomeBudgPeriod);
        }
        Collection incomeBudgetPeriodCollection = incomeBudgetPeriodMap.values();
        return incomeBudgetPeriodCollection.toArray(new PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.IncomeBudgetPeriod[0]);
    }

    protected static String getProjectIncomeDescription(BudgetProjectIncomeContract projectIncome) {
        String description = null;
        if (projectIncome.getDescription() != null) {
            description = projectIncome.getDescription().length() > 150 ? projectIncome.getDescription().substring(0, 150) : projectIncome.getDescription();
        }
        return description;
    }

    private PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.StemCells getStemCells() {
        PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.StemCells stemCells = (PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.StemCells)PHS398CoverPageSupplement20Document.PHS398CoverPageSupplement20.StemCells.Factory.newInstance();
        String childAnswer = null;
        String answer = this.getAnswer(IS_HUMAN_STEM_CELLS_INVOLVED, this.answerHeaders);
        if (answer != null && !answer.equals("No")) {
            YesNoDataType.Enum answers;
            YesNoDataType.Enum enum_ = answers = YnqConstant.YES.code().equals(this.getAnswer(IS_HUMAN_STEM_CELLS_INVOLVED, this.answerHeaders)) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            if (YnqConstant.YES.code().equals(answer)) {
                stemCells.setIsHumanStemCellsInvolved(YesNoDataType.Y_YES);
                String subAnswer = this.getAnswer(SPECIFIC_STEM_CELL_LINE, this.answerHeaders);
                if (subAnswer != null && !subAnswer.equals("No")) {
                    if (YnqConstant.YES.code().equals(subAnswer)) {
                        stemCells.setStemCellsIndicator(YesNoDataType.N_NO);
                        childAnswer = this.getAnswers(REGISTRATION_NUMBER, this.answerHeaders);
                    } else {
                        stemCells.setStemCellsIndicator(YesNoDataType.Y_YES);
                    }
                }
                if (childAnswer != null) {
                    if ("Unknown".equalsIgnoreCase(childAnswer)) {
                        stemCells.setStemCellsIndicator(answers);
                    } else {
                        List<String> cellLines = this.getCellLines(childAnswer);
                        if (cellLines.size() > 0) {
                            stemCells.setCellLinesArray(cellLines.toArray(new String[0]));
                        }
                    }
                }
            } else {
                stemCells.setIsHumanStemCellsInvolved(YesNoDataType.N_NO);
            }
        }
        return stemCells;
    }

    private YesNoDataType.Enum getYNQAnswer(Integer questionID) {
        String answer = this.getAnswer(questionID, this.answerHeaders);
        if (answer != null && !answer.equals("No")) {
            return "Y".equals(answer) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
        }
        return null;
    }

    @Override
    public PHS398CoverPageSupplement20Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getCoverPageSupplement();
    }

    public RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    public S2SCommonBudgetService getS2SCommonBudgetService() {
        return this.s2SCommonBudgetService;
    }

    public void setS2SCommonBudgetService(S2SCommonBudgetService s2SCommonBudgetService) {
        this.s2SCommonBudgetService = s2SCommonBudgetService;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(PHS398CoverPageSupplement20Document form, List<AttachmentData> attachments) {
        return new S2SFormGeneratorPdfFillable.Attachments(Collections.emptyMap(), attachments);
    }

    @Override
    public DocumentFactory<PHS398CoverPageSupplement20Document> factory() {
        return PHS398CoverPageSupplement20Document.Factory;
    }
}

