/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;

public class ProposalPersonComparator
implements Comparator<ProposalPersonContract> {
    private static final Logger LOG = LogManager.getLogger(ProposalPersonComparator.class);

    @Override
    public int compare(ProposalPersonContract person1, ProposalPersonContract person2) {
        int retval = 0;
        if ((person1.isInvestigator() || person2.isInvestigator()) && (person1.isPrincipalInvestigator() || person2.isPrincipalInvestigator())) {
            if (person1.isPrincipalInvestigator()) {
                --retval;
            }
            if (person2.isPrincipalInvestigator()) {
                ++retval;
            }
        }
        if (retval == 0) {
            retval = this.massageOrdinalNumber(person1).compareTo(this.massageOrdinalNumber(person2));
        }
        if (retval == 0) {
            if (StringUtils.isNotBlank((CharSequence)person1.getFullName())) {
                retval = person1.getLastName().compareTo(person2.getLastName());
            } else if (StringUtils.isNotBlank((CharSequence)person2.getLastName())) {
                --retval;
            }
        }
        LOG.info("retval = " + retval);
        return retval;
    }

    private Integer massageOrdinalNumber(ProposalPersonContract person) {
        return person.getOrdinalPosition() != null ? person.getOrdinalPosition() : -1;
    }
}

