/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.coeus.additionalEquipment.AdditionalEquipmentListDocument;
import gov.grants.apply.coeus.extraKeyPerson.ExtraKeyPersonListDocument;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemContract;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.common.budget.api.personnel.BudgetPersonnelDetailsContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeService;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.s2sgen.api.budget.S2SBudgetInfoService;
import org.kuali.coeus.s2sgen.api.budget.S2SBudgetPeriodDto;
import org.kuali.coeus.s2sgen.api.budget.S2SCostDto;
import org.kuali.coeus.s2sgen.api.budget.S2SKeyPersonDto;
import org.kuali.coeus.s2sgen.api.core.AuditError;
import org.kuali.coeus.s2sgen.api.core.S2SException;
import org.kuali.coeus.s2sgen.impl.budget.S2SBudgetValidationService;
import org.kuali.coeus.s2sgen.impl.budget.S2SCommonBudgetService;
import org.kuali.coeus.s2sgen.impl.datetime.S2SDateTimeService;
import org.kuali.coeus.s2sgen.impl.generate.S2SBaseFormGenerator;
import org.kuali.coeus.s2sgen.impl.print.GenericPrintable;
import org.kuali.coeus.s2sgen.impl.print.S2SFile;
import org.kuali.coeus.s2sgen.impl.print.S2SPrintingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

public abstract class RRBudgetBaseGenerator<T extends XmlObject>
extends S2SBaseFormGenerator<T> {
    private static final Logger LOG = LogManager.getLogger(RRBudgetBaseGenerator.class);
    private static final String ADDITIONAL_EQUIPMENT = "ADDITIONAL_EQUIPMENT";
    public static final String OTHERCOST_DESCRIPTION = "Other";
    public static final String OTHERPERSONNEL_POSTDOC = "PostDoc";
    public static final String OTHERPERSONNEL_GRADUATE = "Grad";
    public static final String OTHERPERSONNEL_UNDERGRADUATE = "UnderGrad";
    public static final String OTHERPERSONNEL_SECRETARIAL = "Sec";
    public static final int BUDGET_JUSTIFICATION_ATTACHMENT = 7;
    protected static final int OTHERPERSONNEL_MAX_ALLOWED = 6;
    protected static final int ARRAY_LIMIT_IN_SCHEMA = 4;
    protected static final String NID_PD_PI = "PD/PI";
    protected static final String NID_CO_PD_PI = "CO-INVESTIGATOR";
    protected static final String KEYPERSON_CO_PD_PI = "CO-PD/PI";
    private static final String EXTRA_KEYPERSONS = "EXTRA_KEYPERSONS";
    private static final String EQUIPMENT_NARRATIVE_TYPE_CODE = "12";
    private static final String EXTRA_KEYPERSONS_TYPE = "11";
    @Autowired
    @Qualifier(value="s2SBudgetInfoService")
    protected S2SBudgetInfoService s2sBudgetInfoService;
    @Autowired
    @Qualifier(value="s2SDateTimeService")
    protected S2SDateTimeService s2SDateTimeService;
    @Autowired
    @Qualifier(value="narrativeService")
    protected NarrativeService narrativeCleanupService;
    @Autowired
    @Qualifier(value="s2SPrintingService")
    protected S2SPrintingService s2SPrintingService;
    @Autowired
    @Qualifier(value="s2SCommonBudgetService")
    protected S2SCommonBudgetService s2SCommonBudgetService;
    @Autowired
    @Qualifier(value="s2SBudgetValidationService")
    protected S2SBudgetValidationService s2SBudgetValidationService;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/AdditionalEquipmentAttachment.xsl")
    private Resource additionalEquipmentAttachmentStyleSheet;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/ExtraKeyPersonAttachment.xsl")
    private Resource extraKeyPersonAttachmentStyleSheet;

    protected void deleteAutoGenNarratives() {
        this.narrativeCleanupService.deleteAutoGeneratedNarratives(this.pdDoc.getDevelopmentProposal().getNarratives());
    }

    protected NarrativeContract saveAdditionalEquipments(S2SBudgetPeriodDto periodInfo, List<S2SCostDto> extraEquipmentArrayList) {
        NarrativeContract narrative = null;
        if (extraEquipmentArrayList.size() > 0) {
            AdditionalEquipmentListDocument.AdditionalEquipmentList additionalEquipmentList = (AdditionalEquipmentListDocument.AdditionalEquipmentList)AdditionalEquipmentListDocument.AdditionalEquipmentList.Factory.newInstance();
            additionalEquipmentList.setProposalNumber(this.pdDoc.getDevelopmentProposal().getProposalNumber());
            additionalEquipmentList.setBudgetPeriod(new BigInteger(Integer.toString(periodInfo.getBudgetPeriod())));
            additionalEquipmentList.setEquipmentListArray(this.getEquipmentListArray(extraEquipmentArrayList));
            AdditionalEquipmentListDocument additionalEquipmentDoc = (AdditionalEquipmentListDocument)AdditionalEquipmentListDocument.Factory.newInstance();
            additionalEquipmentDoc.setAdditionalEquipmentList(additionalEquipmentList);
            String xmlData = additionalEquipmentDoc.xmlText();
            GenericPrintable printable = new GenericPrintable();
            printable.setXslTemplates(Collections.singletonList(this.additionalEquipmentAttachmentStyleSheet));
            printable.setName("");
            printable.setXml(xmlData);
            try {
                S2SFile printData = this.s2SPrintingService.print(printable);
                String name = this.pdDoc.getDevelopmentProposal().getProposalNumber() + periodInfo.getBudgetPeriod() + ADDITIONAL_EQUIPMENT;
                narrative = this.saveNarrative(printData.getData(), EQUIPMENT_NARRATIVE_TYPE_CODE, name + ".pdf", name);
            }
            catch (S2SException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return narrative;
    }

    private AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList[] getEquipmentListArray(List<S2SCostDto> extraEquipmentArrayList) {
        ArrayList<AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList> additionalEquipmentListList = new ArrayList<AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList>();
        AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList equipmentList = null;
        for (S2SCostDto costInfo : extraEquipmentArrayList) {
            equipmentList = (AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList)AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList.Factory.newInstance();
            equipmentList.setFundsRequested(costInfo.getCost().bigDecimalValue());
            equipmentList.setEquipmentItem(costInfo.getDescription() != null ? costInfo.getDescription() : costInfo.getCategory());
            additionalEquipmentListList.add(equipmentList);
        }
        return additionalEquipmentListList.toArray(new AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList[0]);
    }

    protected NarrativeContract saveExtraKeyPersons(S2SBudgetPeriodDto periodInfo) {
        NarrativeContract extraKPNarrative = null;
        if (periodInfo.getExtraKeyPersons() != null && !periodInfo.getExtraKeyPersons().isEmpty()) {
            ExtraKeyPersonListDocument extraKeyPersonListDocument = (ExtraKeyPersonListDocument)ExtraKeyPersonListDocument.Factory.newInstance();
            ExtraKeyPersonListDocument.ExtraKeyPersonList extraKeyPersonList = (ExtraKeyPersonListDocument.ExtraKeyPersonList)ExtraKeyPersonListDocument.ExtraKeyPersonList.Factory.newInstance();
            extraKeyPersonList.setProposalNumber(this.pdDoc.getDevelopmentProposal().getProposalNumber());
            extraKeyPersonList.setBudgetPeriod(new BigInteger("" + periodInfo.getBudgetPeriod()));
            extraKeyPersonList.setKeyPersonsArray(this.getExtraKeyPersons(periodInfo.getExtraKeyPersons()));
            extraKeyPersonListDocument.setExtraKeyPersonList(extraKeyPersonList);
            String xmlData = extraKeyPersonListDocument.xmlText();
            GenericPrintable printable = new GenericPrintable();
            printable.setXslTemplates(Collections.singletonList(this.extraKeyPersonAttachmentStyleSheet));
            printable.setName("");
            printable.setXml(xmlData);
            try {
                S2SFile printData = this.s2SPrintingService.print(printable);
                String name = this.pdDoc.getDevelopmentProposal().getProposalNumber() + periodInfo.getBudgetPeriod() + "_EXTRA_KEYPERSONS";
                extraKPNarrative = this.saveNarrative(printData.getData(), EXTRA_KEYPERSONS_TYPE, name + ".pdf", name);
            }
            catch (S2SException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        return extraKPNarrative;
    }

    private ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons[] getExtraKeyPersons(List<S2SKeyPersonDto> keyPersonList) {
        ArrayList<ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons> keypersonslist = new ArrayList<ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons>();
        for (S2SKeyPersonDto keyPersonInfo : keyPersonList) {
            ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons keyPerson = (ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons)ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons.Factory.newInstance();
            keyPerson.setFirstName(keyPersonInfo.getFirstName());
            keyPerson.setMiddleName(keyPersonInfo.getMiddleName());
            keyPerson.setLastName(keyPersonInfo.getLastName());
            keyPerson.setProjectRole(keyPersonInfo.getKeyPersonRole());
            keyPerson.setCompensation(this.getExtraKeyPersonCompensation(keyPersonInfo));
            keypersonslist.add(keyPerson);
        }
        return keypersonslist.toArray(new ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons[0]);
    }

    private ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons.Compensation getExtraKeyPersonCompensation(S2SKeyPersonDto keyPersonInfo) {
        ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons.Compensation compensation = (ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons.Compensation)ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons.Compensation.Factory.newInstance();
        if (keyPersonInfo.getCompensation().getAcademicMonths() != null) {
            compensation.setAcademicMonths(keyPersonInfo.getCompensation().getAcademicMonths().bigDecimalValue());
        }
        if (keyPersonInfo.getCompensation().getBaseSalary() != null) {
            compensation.setBaseSalary(keyPersonInfo.getCompensation().getBaseSalary().bigDecimalValue());
        }
        if (keyPersonInfo.getCompensation().getCalendarMonths() != null) {
            compensation.setCalendarMonths(keyPersonInfo.getCompensation().getCalendarMonths().bigDecimalValue());
        }
        if (keyPersonInfo.getCompensation().getFringe() != null) {
            compensation.setFringeBenefits(keyPersonInfo.getCompensation().getFringe().bigDecimalValue());
        }
        if (keyPersonInfo.getCompensation().getFundsRequested() != null) {
            compensation.setFundsRequested(keyPersonInfo.getCompensation().getFundsRequested().bigDecimalValue());
        }
        if (keyPersonInfo.getCompensation().getRequestedSalary() != null) {
            compensation.setRequestedSalary(keyPersonInfo.getCompensation().getRequestedSalary().bigDecimalValue());
        }
        if (keyPersonInfo.getCompensation().getSummerMonths() != null) {
            compensation.setSummerMonths(keyPersonInfo.getCompensation().getSummerMonths().bigDecimalValue());
        }
        return compensation;
    }

    protected boolean isProposalPersonEqualsKeyPerson(ProposalPersonContract proposalPerson, S2SKeyPersonDto keyPerson) {
        if (keyPerson.getPersonId() != null) {
            return keyPerson.getPersonId().equals(proposalPerson.getPersonId());
        }
        if (keyPerson.getRolodexId() != null) {
            return keyPerson.getRolodexId().equals(proposalPerson.getRolodexId());
        }
        return false;
    }

    protected Boolean hasPersonnelBudget(S2SKeyPersonDto keyPerson, int period) {
        ProposalDevelopmentBudgetExtContract budget = this.s2SCommonBudgetService.getBudget(this.pdDoc.getDevelopmentProposal());
        List budgetLineItemList = ((BudgetPeriodContract)budget.getBudgetPeriods().get(period - 1)).getBudgetLineItems();
        for (BudgetLineItemContract budgetLineItem : budgetLineItemList) {
            for (BudgetPersonnelDetailsContract budgetPersonnelDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                if (budgetPersonnelDetails.getPersonId().equals(keyPerson.getPersonId())) {
                    return true;
                }
                if (keyPerson.getRolodexId() == null || !budgetPersonnelDetails.getPersonId().equals(keyPerson.getRolodexId().toString())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean validateBudgetForForm(ProposalDevelopmentDocumentContract pdDoc) {
        List<AuditError> errors = this.s2SBudgetValidationService.validateBudgetForForm(pdDoc, this.getFormName());
        this.getAuditErrors().addAll(errors);
        return errors.isEmpty();
    }

    public S2SBudgetInfoService getS2sBudgetInfoService() {
        return this.s2sBudgetInfoService;
    }

    public void setS2sBudgetInfoService(S2SBudgetInfoService s2sBudgetInfoService) {
        this.s2sBudgetInfoService = s2sBudgetInfoService;
    }

    public S2SBudgetValidationService getS2SBudgetValidationService() {
        return this.s2SBudgetValidationService;
    }

    public void setS2SBudgetValidationService(S2SBudgetValidationService s2SBudgetValidationService) {
        this.s2SBudgetValidationService = s2SBudgetValidationService;
    }

    public NarrativeService getNarrativeCleanupService() {
        return this.narrativeCleanupService;
    }

    public void setNarrativeCleanupService(NarrativeService narrativeCleanupService) {
        this.narrativeCleanupService = narrativeCleanupService;
    }

    public S2SPrintingService getS2SPrintingService() {
        return this.s2SPrintingService;
    }

    public void setS2SPrintingService(S2SPrintingService s2SPrintingService) {
        this.s2SPrintingService = s2SPrintingService;
    }

    public S2SDateTimeService getS2SDateTimeService() {
        return this.s2SDateTimeService;
    }

    public void setS2SDateTimeService(S2SDateTimeService s2SDateTimeService) {
        this.s2SDateTimeService = s2SDateTimeService;
    }

    public S2SCommonBudgetService getS2SCommonBudgetService() {
        return this.s2SCommonBudgetService;
    }

    public void setS2SCommonBudgetService(S2SCommonBudgetService s2SCommonBudgetService) {
        this.s2SCommonBudgetService = s2SCommonBudgetService;
    }

    public Resource getAdditionalEquipmentAttachmentStyleSheet() {
        return this.additionalEquipmentAttachmentStyleSheet;
    }

    public void setAdditionalEquipmentAttachmentStyleSheet(Resource additionalEquipmentAttachmentStyleSheet) {
        this.additionalEquipmentAttachmentStyleSheet = additionalEquipmentAttachmentStyleSheet;
    }

    public Resource getExtraKeyPersonAttachmentStyleSheet() {
        return this.extraKeyPersonAttachmentStyleSheet;
    }

    public void setExtraKeyPersonAttachmentStyleSheet(Resource extraKeyPersonAttachmentStyleSheet) {
        this.extraKeyPersonAttachmentStyleSheet = extraKeyPersonAttachmentStyleSheet;
    }
}

