/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.s2sgen.impl.generate.support;

import gov.grants.apply.forms.rrSF424MultiProjectCover30V30.AORInfoType;
import gov.grants.apply.forms.rrSF424MultiProjectCover30V30.ApplicationTypeCodeDataType;
import gov.grants.apply.forms.rrSF424MultiProjectCover30V30.OptionalAddressType;
import gov.grants.apply.forms.rrSF424MultiProjectCover30V30.OptionalHumanNameType;
import gov.grants.apply.forms.rrSF424MultiProjectCover30V30.OptionalOrganizationType;
import gov.grants.apply.forms.rrSF424MultiProjectCover30V30.OrganizationContactPersonDataType;
import gov.grants.apply.forms.rrSF424MultiProjectCover30V30.RRSF424MultiProjectCover30Document;
import gov.grants.apply.forms.rrSF424MultiProjectCover30V30.RevisionTypeCodeDataType;
import gov.grants.apply.forms.rrSF424MultiProjectCover30V30.StateReviewCodeTypeDataType;
import gov.grants.apply.forms.rrSF424MultiProjectCover30V30.SubmissionTypeDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.AddressDataTypeV3;
import gov.grants.apply.system.globalLibraryV20.ApplicantTypeCodeDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.impl.schema.DocumentFactory;
import org.kuali.coeus.common.api.address.Addressable;
import org.kuali.coeus.common.api.org.OrganizationContract;
import org.kuali.coeus.common.api.org.type.OrganizationTypeContract;
import org.kuali.coeus.common.api.rolodex.RolodexContract;
import org.kuali.coeus.common.api.unit.UnitContract;
import org.kuali.coeus.common.api.ynq.YnqConstant;
import org.kuali.coeus.common.budget.api.core.BudgetContract;
import org.kuali.coeus.common.budget.api.income.BudgetProjectIncomeContract;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemCalculatedAmountContract;
import org.kuali.coeus.common.budget.api.nonpersonnel.BudgetLineItemContract;
import org.kuali.coeus.common.budget.api.period.BudgetPeriodContract;
import org.kuali.coeus.common.questionnaire.api.answer.AnswerHeaderContract;
import org.kuali.coeus.propdev.api.attachment.NarrativeContract;
import org.kuali.coeus.propdev.api.budget.ProposalDevelopmentBudgetExtContract;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularContract;
import org.kuali.coeus.propdev.api.budget.modular.BudgetModularIdcContract;
import org.kuali.coeus.propdev.api.core.DevelopmentProposalContract;
import org.kuali.coeus.propdev.api.core.ProposalDevelopmentDocumentContract;
import org.kuali.coeus.propdev.api.location.ProposalSiteContract;
import org.kuali.coeus.propdev.api.person.ProposalPersonContract;
import org.kuali.coeus.propdev.api.s2s.S2sOpportunityContract;
import org.kuali.coeus.s2sgen.api.generate.AttachmentData;
import org.kuali.coeus.s2sgen.impl.generate.FormGenerator;
import org.kuali.coeus.s2sgen.impl.generate.FormStylesheet;
import org.kuali.coeus.s2sgen.impl.generate.FormVersion;
import org.kuali.coeus.s2sgen.impl.generate.S2SFormGeneratorPdfFillable;
import org.kuali.coeus.s2sgen.impl.generate.support.RRSF424BaseGenerator;
import org.kuali.coeus.s2sgen.impl.person.DepartmentalPersonDto;
import org.kuali.coeus.s2sgen.impl.util.CollectionUtils;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.Cfda;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

@FormGenerator(value="RRSF424MultiProjectCover_3_0V3_0Generator")
public class RRSF424MultiProjectCover_3_0V3_0Generator
extends RRSF424BaseGenerator<RRSF424MultiProjectCover30Document>
implements S2SFormGeneratorPdfFillable<RRSF424MultiProjectCover30Document> {
    private static final int CFDA_TITLE_MAX_LENGTH = 119;
    private static final int PROJECT_TITLE_MAX_LENGTH = 200;
    private DepartmentalPersonDto departmentalPerson;
    private static final int RRSF424_Cover_Letter = 139;
    private List<? extends AnswerHeaderContract> answerHeaders;
    @Value(value="http://apply.grants.gov/forms/RR_SF424_Multi_Project_Cover_3_0-V3.0")
    private String namespace;
    @Value(value="RR_SF424_Multi_Project_Cover_3_0-V3.0")
    private String formName;
    @FormStylesheet
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/stylesheet/RR_SF424_Multi_Project_Cover_3_0-V3.0.fo.xsl")
    private List<Resource> stylesheets;
    @Value(value="classpath:org/kuali/coeus/s2sgen/impl/generate/support/pdf/RR_SF424_Multi_Project_Cover_3_0-V3.0.pdf")
    private Resource pdfForm;
    @Value(value="120")
    private int sortIndex;

    private RRSF424MultiProjectCover30Document getRRSF424MultiProjectCover() {
        String activityTitle;
        this.answerHeaders = this.getPropDevQuestionAnswerService().getQuestionnaireAnswerHeaders(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        RRSF424MultiProjectCover30Document rrSF424MultiProjectCover30Document = (RRSF424MultiProjectCover30Document)RRSF424MultiProjectCover30Document.Factory.newInstance();
        RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30 rrsf424mpc30 = (RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30)RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.Factory.newInstance();
        rrsf424mpc30.setFormVersion(FormVersion.v3_0.getVersion());
        rrsf424mpc30.setSubmittedDate(this.departmentalPerson.getSubmittedDate());
        if (this.getSubmissionTypeCode() != null) {
            rrsf424mpc30.setSubmissionTypeCode(SubmissionTypeDataType.Enum.forInt(Integer.parseInt(this.getSubmissionTypeCode())));
        }
        rrsf424mpc30.setStateID(this.getProposalSiteState());
        rrsf424mpc30.setApplicantInfo(this.getApplicationInfo());
        rrsf424mpc30.setEmployerID(this.getEmployerId());
        rrsf424mpc30.setApplicantType(this.getApplicantType());
        if (this.getAgencyRoutingNumber() != null) {
            rrsf424mpc30.setAgencyRoutingNumber(this.getAgencyRoutingNumber());
        }
        if (this.getGGTrackingID() != null) {
            rrsf424mpc30.setGrantsTrackingNumber(this.getGGTrackingID());
        }
        rrsf424mpc30.setApplicationType(this.getApplicationType());
        rrsf424mpc30.setApplicantID(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        rrsf424mpc30.setFederalAgencyName(this.getFederalAgencyName());
        rrsf424mpc30.setProjectTitle(this.getProjectTitle());
        rrsf424mpc30.setProposedProjectPeriod(this.getProjectPeriod());
        rrsf424mpc30.setCongressionalDistrict(this.getCongDistrict());
        String cfdaNumber = this.getFirstCfdaNumber();
        if (cfdaNumber != null) {
            rrsf424mpc30.setCFDANumber(cfdaNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)(activityTitle = this.getActivityTitle()))) {
            rrsf424mpc30.setActivityTitle(activityTitle);
        }
        this.setFederalId(rrsf424mpc30);
        rrsf424mpc30.setPDPIContactInfo(this.getPDPI());
        rrsf424mpc30.setEstimatedProjectFunding(this.getProjectFunding());
        rrsf424mpc30.setTrustAgree(YesNoDataType.Y_YES);
        rrsf424mpc30.setStateReview(this.getStateReview());
        rrsf424mpc30.setAORInfo(this.getAORInfoType());
        rrsf424mpc30.setAORSignature(this.getAORSignature());
        rrsf424mpc30.setAORSignedDate(this.departmentalPerson.getSubmittedDate());
        this.setPreApplicationAttachment(rrsf424mpc30);
        this.setSFLLLAttachment(rrsf424mpc30);
        this.setCoverLetterAttachment(rrsf424mpc30);
        rrSF424MultiProjectCover30Document.setRRSF424MultiProjectCover30(rrsf424mpc30);
        return rrSF424MultiProjectCover30Document;
    }

    private RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.EstimatedProjectFunding getProjectFunding() {
        RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.EstimatedProjectFunding funding = (RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.EstimatedProjectFunding)RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.EstimatedProjectFunding.Factory.newInstance();
        funding.setTotalEstimatedAmount(BigDecimal.ZERO);
        funding.setTotalNonfedrequested(BigDecimal.ZERO);
        funding.setTotalfedNonfedrequested(BigDecimal.ZERO);
        funding.setEstimatedProgramIncome(BigDecimal.ZERO);
        boolean hasBudgetLineItem = false;
        ProposalDevelopmentBudgetExtContract budget = this.getS2SCommonBudgetService().getBudget(this.pdDoc.getDevelopmentProposal());
        if (budget != null) {
            ScaleTwoDecimal totalCost = ScaleTwoDecimal.ZERO;
            if (budget.getModularBudgetFlag().booleanValue()) {
                List allModularAmounts = this.modularBudgetService.getModularBudgetAmounts((BudgetContract)budget);
                ScaleTwoDecimal fundsRequested = ScaleTwoDecimal.ZERO;
                ScaleTwoDecimal totalDirectCost = ScaleTwoDecimal.ZERO;
                for (BudgetPeriodContract budgetPeriod : budget.getBudgetPeriods()) {
                    BudgetModularContract modularAmounts = this.modularBudgetService.getModularBudgetForPeriod(allModularAmounts, budgetPeriod);
                    totalDirectCost = (ScaleTwoDecimal)totalDirectCost.add((AbstractDecimal)modularAmounts.getTotalDirectCost());
                    for (BudgetModularIdcContract budgetModularIdc : modularAmounts.getBudgetModularIdcs()) {
                        fundsRequested = (ScaleTwoDecimal)fundsRequested.add((AbstractDecimal)budgetModularIdc.getFundsRequested());
                    }
                }
                totalCost = (ScaleTwoDecimal)totalCost.add((AbstractDecimal)totalDirectCost);
                totalCost = (ScaleTwoDecimal)totalCost.add((AbstractDecimal)fundsRequested);
            } else {
                totalCost = budget.getTotalCost();
            }
            ScaleTwoDecimal fedNonFedCost = totalCost;
            ScaleTwoDecimal costSharingAmount = ScaleTwoDecimal.ZERO;
            for (BudgetPeriodContract budgetPeriod : budget.getBudgetPeriods()) {
                for (BudgetLineItemContract lineItem : budgetPeriod.getBudgetLineItems()) {
                    hasBudgetLineItem = true;
                    if (!budget.getSubmitCostSharingFlag().booleanValue() || !lineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                    costSharingAmount = (ScaleTwoDecimal)costSharingAmount.add((AbstractDecimal)lineItem.getCostSharingAmount());
                    List calculatedAmounts = lineItem.getBudgetLineItemCalculatedAmounts();
                    for (BudgetLineItemCalculatedAmountContract budgetLineItemCalculatedAmount : calculatedAmounts) {
                        costSharingAmount = (ScaleTwoDecimal)costSharingAmount.add((AbstractDecimal)budgetLineItemCalculatedAmount.getCalculatedCostSharing());
                    }
                }
            }
            if (!hasBudgetLineItem && budget.getSubmitCostSharingFlag().booleanValue()) {
                costSharingAmount = budget.getCostSharingAmount();
            }
            fedNonFedCost = (ScaleTwoDecimal)fedNonFedCost.add((AbstractDecimal)costSharingAmount);
            funding = (RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.EstimatedProjectFunding)RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.EstimatedProjectFunding.Factory.newInstance();
            funding.setTotalEstimatedAmount(totalCost.bigDecimalValue());
            funding.setTotalNonfedrequested(costSharingAmount.bigDecimalValue());
            funding.setTotalfedNonfedrequested(fedNonFedCost.bigDecimalValue());
            funding.setEstimatedProgramIncome(this.getTotalProjectIncome((BudgetContract)budget));
        }
        return funding;
    }

    private BigDecimal getTotalProjectIncome(BudgetContract budget) {
        BigDecimal totalProjectIncome = BigDecimal.ZERO;
        for (BudgetProjectIncomeContract budgetProjectIncome : budget.getBudgetProjectIncomes()) {
            totalProjectIncome = totalProjectIncome.add(budgetProjectIncome.getProjectIncome().bigDecimalValue());
        }
        return totalProjectIncome;
    }

    private RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantInfo getApplicationInfo() {
        RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantInfo appInfo = (RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantInfo)RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantInfo.Factory.newInstance();
        appInfo.setContactPersonInfo(this.getContactPersonInfo());
        appInfo.setOrganizationInfo(this.getOrganizationDataType());
        return appInfo;
    }

    private RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantInfo.ContactPersonInfo getContactPersonInfo() {
        String contactType = this.getContactType();
        RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantInfo.ContactPersonInfo contactInfo = (RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantInfo.ContactPersonInfo)RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantInfo.ContactPersonInfo.Factory.newInstance();
        if (contactType.equals("I")) {
            if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
                contactInfo = this.getContactInfo(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getRolodex());
            }
        } else {
            DepartmentalPersonDto depPerson = this.getContactPerson(this.pdDoc);
            if (depPerson != null) {
                contactInfo.setName(this.getOptionalHumanNameDataType(depPerson));
                contactInfo.setPhone(depPerson.getOfficePhone());
                if (StringUtils.isNotBlank((CharSequence)depPerson.getFaxNumber())) {
                    contactInfo.setFax(depPerson.getFaxNumber());
                }
                if (depPerson.getEmailAddress() != null) {
                    contactInfo.setEmail(depPerson.getEmailAddress());
                }
                if (depPerson.getPrimaryTitle() != null) {
                    contactInfo.setTitle(StringUtils.substring((String)depPerson.getPrimaryTitle(), (int)0, (int)45));
                }
                contactInfo.setAddress(this.getOptionalAddress(depPerson));
            }
        }
        return contactInfo;
    }

    private OptionalHumanNameType getOptionalHumanNameDataType(DepartmentalPersonDto depPerson) {
        OptionalHumanNameType optionalHumanNameType = (OptionalHumanNameType)OptionalHumanNameType.Factory.newInstance();
        if (depPerson != null) {
            optionalHumanNameType.setFirstName(depPerson.getFirstName());
            optionalHumanNameType.setLastName(depPerson.getLastName());
            if (StringUtils.isNotBlank((CharSequence)depPerson.getMiddleName())) {
                optionalHumanNameType.setMiddleName(depPerson.getMiddleName());
            }
        }
        return optionalHumanNameType;
    }

    private OptionalHumanNameType getOptionalHumanNameDataType(ProposalPersonContract depPerson) {
        OptionalHumanNameType optionalHumanNameType = (OptionalHumanNameType)OptionalHumanNameType.Factory.newInstance();
        if (depPerson != null) {
            optionalHumanNameType.setFirstName(depPerson.getFirstName());
            optionalHumanNameType.setLastName(depPerson.getLastName());
            if (StringUtils.isNotBlank((CharSequence)depPerson.getMiddleName())) {
                optionalHumanNameType.setMiddleName(depPerson.getMiddleName());
            }
        }
        return optionalHumanNameType;
    }

    private OptionalAddressType getOptionalAddress(Addressable depPerson) {
        OptionalAddressType optionalAddressType = (OptionalAddressType)OptionalAddressType.Factory.newInstance();
        if (depPerson != null) {
            AddressDataTypeV3 addressType = this.globLibV20Generator.getAddressDataTypeV3(depPerson);
            if (StringUtils.isNotBlank((CharSequence)addressType.getStreet1())) {
                optionalAddressType.setStreet1(addressType.getStreet1());
            }
            if (StringUtils.isNotBlank((CharSequence)addressType.getStreet2())) {
                optionalAddressType.setStreet2(addressType.getStreet2());
            }
            if (StringUtils.isNotBlank((CharSequence)addressType.getCity())) {
                optionalAddressType.setCity(addressType.getCity());
            }
            if (StringUtils.isNotBlank((CharSequence)addressType.getCounty())) {
                optionalAddressType.setCounty(addressType.getCounty());
            }
            if (StringUtils.isNotBlank((CharSequence)addressType.getZipPostalCode())) {
                optionalAddressType.setZipPostalCode(addressType.getZipPostalCode());
            }
            optionalAddressType.setCountry(addressType.getCountry());
            if (addressType.getState() != null) {
                optionalAddressType.setState(addressType.getState());
            }
            if (StringUtils.isNotBlank((CharSequence)addressType.getProvince())) {
                optionalAddressType.setProvince(addressType.getProvince());
            }
        }
        return optionalAddressType;
    }

    private OptionalOrganizationType getOrganizationDataType() {
        UnitContract leadUnit;
        OptionalOrganizationType orgType = (OptionalOrganizationType)OptionalOrganizationType.Factory.newInstance();
        ProposalSiteContract proposalSite = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        orgType.setAddress(this.getOptionalAddress((Addressable)proposalSite));
        OrganizationContract organization = proposalSite.getOrganization();
        if (organization != null) {
            orgType.setOrganizationName(StringUtils.substring((String)proposalSite.getLocationName(), (int)0, (int)60));
            orgType.setSAMUEI(organization.getUei());
        }
        if ((leadUnit = this.pdDoc.getDevelopmentProposal().getOwnedByUnit()) != null) {
            String departmentName = leadUnit.getUnitName();
            if (departmentName != null && departmentName.length() > 30) {
                departmentName = departmentName.substring(0, 29);
            }
            orgType.setDepartmentName(departmentName);
            String divisionName = this.s2sDivisionService.getDivisionFromUnit(leadUnit.getUnitNumber());
            if (divisionName != null) {
                orgType.setDivisionName(divisionName);
            }
        }
        return orgType;
    }

    private OptionalHumanNameType getOptionalHumanNameType(RolodexContract rolodex) {
        OptionalHumanNameType humanNameType = (OptionalHumanNameType)OptionalHumanNameType.Factory.newInstance();
        if (rolodex != null) {
            humanNameType.setFirstName(rolodex.getFirstName());
            humanNameType.setLastName(rolodex.getLastName());
            String middleName = rolodex.getMiddleName();
            if (StringUtils.isNotBlank((CharSequence)middleName)) {
                humanNameType.setMiddleName(middleName);
            }
        }
        return humanNameType;
    }

    private RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantInfo.ContactPersonInfo getContactInfo(RolodexContract rolodex) {
        RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantInfo.ContactPersonInfo contactInfo = (RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantInfo.ContactPersonInfo)RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantInfo.ContactPersonInfo.Factory.newInstance();
        contactInfo.setName(this.getOptionalHumanNameType(rolodex));
        contactInfo.setPhone("");
        if (rolodex != null) {
            contactInfo.setPhone(rolodex.getPhoneNumber());
            if (StringUtils.isNotBlank((CharSequence)rolodex.getFaxNumber())) {
                contactInfo.setFax(rolodex.getFaxNumber());
            }
            if (rolodex.getEmailAddress() != null) {
                contactInfo.setEmail(rolodex.getEmailAddress());
            }
        }
        return contactInfo;
    }

    private RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.StateReview getStateReview() {
        RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.StateReview stateReview = (RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.StateReview)RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.StateReview.Factory.newInstance();
        Map<String, String> eoStateReview = this.getEOStateReview(this.pdDoc);
        StateReviewCodeTypeDataType.Enum stateReviewCodeType = null;
        String strReview = eoStateReview.get("answer");
        if ("Y".equals(strReview)) {
            stateReviewCodeType = StateReviewCodeTypeDataType.Y_YES;
            String stateReviewDate = eoStateReview.get("reviewDate");
            Calendar reviewDate = this.s2SDateTimeService.convertDateStringToCalendar(stateReviewDate);
            stateReview.setStateReviewDate(reviewDate);
        } else if ("N".equals(strReview)) {
            String stateReviewData = eoStateReview.get("stateReviewData");
            if ("Not Covered".equals(stateReviewData)) {
                stateReviewCodeType = StateReviewCodeTypeDataType.PROGRAM_IS_NOT_COVERED_BY_E_O_12372;
            } else if ("Not Selected".equals(stateReviewData)) {
                stateReviewCodeType = StateReviewCodeTypeDataType.PROGRAM_HAS_NOT_BEEN_SELECTED_BY_STATE_FOR_REVIEW;
            }
        }
        stateReview.setStateReviewCodeType(stateReviewCodeType);
        return stateReview;
    }

    private RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicationType getApplicationType() {
        RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicationType applicationType = (RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicationType)RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicationType.Factory.newInstance();
        Map<String, String> submissionInfo = this.getSubmissionType(this.pdDoc);
        String proposalTypeCode = this.pdDoc.getDevelopmentProposal().getProposalType().getCode();
        if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_REVISION").contains(proposalTypeCode)) {
            applicationType.setApplicationTypeCode(ApplicationTypeCodeDataType.Enum.forInt(5));
            if (submissionInfo.get("revisionCode") != null) {
                String revisionCode = submissionInfo.get("revisionCode");
                RevisionTypeCodeDataType.Enum revisionCodeApplication = RevisionTypeCodeDataType.Enum.forString(revisionCode);
                applicationType.setRevisionCode(revisionCodeApplication);
            }
            if (submissionInfo.get("revisionOtherDescription") != null) {
                String revisionCodeOtherDesc = submissionInfo.get("revisionOtherDescription");
                applicationType.setRevisionCodeOtherExplanation(revisionCodeOtherDesc);
            }
        }
        if (this.pdDoc.getDevelopmentProposal().getProposalType() != null) {
            this.setProposalApplicationType(proposalTypeCode, applicationType);
        }
        this.setOtherAgencySubmissionDetails(applicationType);
        return applicationType;
    }

    private void setProposalApplicationType(String proposalTypeCode, RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicationType applicationType) {
        if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_NEW").contains(proposalTypeCode)) {
            applicationType.setApplicationTypeCode(ApplicationTypeCodeDataType.Enum.forInt(1));
        } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_REVISION").contains(proposalTypeCode)) {
            applicationType.setApplicationTypeCode(ApplicationTypeCodeDataType.Enum.forInt(5));
        } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_RENEWAL").contains(proposalTypeCode)) {
            applicationType.setApplicationTypeCode(ApplicationTypeCodeDataType.Enum.forInt(3));
        } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_RESUBMISSION").contains(proposalTypeCode)) {
            applicationType.setApplicationTypeCode(ApplicationTypeCodeDataType.Enum.forInt(2));
        } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_CONTINUATION").contains(proposalTypeCode)) {
            applicationType.setApplicationTypeCode(ApplicationTypeCodeDataType.Enum.forInt(4));
        }
    }

    private void setOtherAgencySubmissionDetails(RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicationType applicationType) {
        Object answer = null;
        String answerdetails = this.getAnswer(ANSWER_128, this.answerHeaders);
        if (answerdetails != null && !answerdetails.equals("No")) {
            answer = answerdetails.equals(YnqConstant.YES.code()) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            applicationType.setIsOtherAgencySubmission((YesNoDataType.Enum)((Object)answer));
        } else {
            applicationType.setIsOtherAgencySubmission(null);
        }
        if (answer != null && answer.equals((Object)YesNoDataType.Y_YES)) {
            applicationType.setOtherAgencySubmissionExplanation(this.getOtherAgencySubmissionExplanation());
        }
    }

    private RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ProposedProjectPeriod getProjectPeriod() {
        RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ProposedProjectPeriod proposedProjectPeriod = (RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ProposedProjectPeriod)RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ProposedProjectPeriod.Factory.newInstance();
        proposedProjectPeriod.setProposedStartDate(this.s2SDateTimeService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedStartDateInitial()));
        proposedProjectPeriod.setProposedEndDate(this.s2SDateTimeService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedEndDateInitial()));
        return proposedProjectPeriod;
    }

    private RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.CongressionalDistrict getCongDistrict() {
        ProposalSiteContract applicantOrganization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.CongressionalDistrict congressionalDistrict = (RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.CongressionalDistrict)RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.CongressionalDistrict.Factory.newInstance();
        if (applicantOrganization != null) {
            congressionalDistrict.setApplicantCongressionalDistrict(applicantOrganization.getFirstCongressionalDistrictName());
        } else {
            congressionalDistrict.setApplicantCongressionalDistrict("");
        }
        return congressionalDistrict;
    }

    private OrganizationContactPersonDataType getPDPI() {
        OrganizationContactPersonDataType PDPI2 = (OrganizationContactPersonDataType)OrganizationContactPersonDataType.Factory.newInstance();
        for (ProposalPersonContract proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            if (!"PI".equals(proposalPerson.getProposalPersonRoleId())) continue;
            ProposalPersonContract PI = proposalPerson;
            ProposalSiteContract applicantOrganization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
            PDPI2.setName(this.getOptionalHumanNameDataType(PI));
            PDPI2.setPhone(PI.getOfficePhone());
            PDPI2.setEmail(PI.getEmailAddress());
            if (StringUtils.isNotBlank((CharSequence)PI.getFaxNumber())) {
                PDPI2.setFax(PI.getFaxNumber());
            }
            PDPI2.setAddress(this.getOptionalAddress((Addressable)PI));
            this.setDirectoryTitle(PDPI2, PI);
            this.setDepartmentName(PDPI2, PI);
            this.setDivisionName(PDPI2, PI);
            if (applicantOrganization == null) continue;
            PDPI2.setOrganizationName(StringUtils.substring((String)applicantOrganization.getLocationName(), (int)0, (int)60));
        }
        return PDPI2;
    }

    private void setDivisionName(OrganizationContactPersonDataType PDPI2, ProposalPersonContract PI) {
        String divisionName = this.s2sDivisionService.getDivision(PI);
        if (divisionName != null) {
            PDPI2.setDivisionName(divisionName);
        }
    }

    private void setDepartmentName(OrganizationContactPersonDataType PDPI2, ProposalPersonContract PI) {
        if (PI.getHomeUnit() != null) {
            PDPI2.setDepartmentName(this.getDepartmentName(PI.getPerson()));
        } else {
            DevelopmentProposalContract developmentProposal = this.pdDoc.getDevelopmentProposal();
            PDPI2.setDepartmentName(StringUtils.substring((String)developmentProposal.getOwnedByUnit().getUnitName(), (int)0, (int)30));
        }
    }

    private void setDirectoryTitle(OrganizationContactPersonDataType PDPI2, ProposalPersonContract PI) {
        if (PI.getDirectoryTitle() != null) {
            if (PI.getDirectoryTitle().length() > 45) {
                PDPI2.setTitle(PI.getDirectoryTitle().substring(0, 45));
            } else {
                PDPI2.setTitle(PI.getDirectoryTitle());
            }
        }
    }

    private AORInfoType getAORInfoType() {
        ProposalSiteContract applicantOrganization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        AORInfoType aorInfoType = (AORInfoType)AORInfoType.Factory.newInstance();
        if (this.departmentalPerson != null) {
            aorInfoType.setName(this.getOptionalHumanNameDataType(this.departmentalPerson));
            this.setTitle(aorInfoType);
            this.setAddress(aorInfoType);
            this.setDivisionName(aorInfoType, this.departmentalPerson);
        }
        if (applicantOrganization != null) {
            aorInfoType.setOrganizationName(StringUtils.substring((String)applicantOrganization.getLocationName(), (int)0, (int)60));
        }
        return aorInfoType;
    }

    private void setTitle(AORInfoType aorInfoType) {
        if (this.departmentalPerson.getPrimaryTitle() != null) {
            aorInfoType.setTitle(StringUtils.substring((String)this.departmentalPerson.getPrimaryTitle(), (int)0, (int)45));
        } else {
            aorInfoType.setTitle("");
        }
    }

    private void setAddress(AORInfoType aorInfoType) {
        aorInfoType.setAddress(this.getOptionalAddress(this.departmentalPerson));
        aorInfoType.setPhone(this.departmentalPerson.getOfficePhone());
        if (StringUtils.isNotBlank((CharSequence)this.departmentalPerson.getFaxNumber())) {
            aorInfoType.setFax(this.departmentalPerson.getFaxNumber());
        }
        aorInfoType.setEmail(this.departmentalPerson.getEmailAddress());
    }

    private void setDivisionName(AORInfoType aorInfoType, DepartmentalPersonDto departmentalPerson) {
        String divisionName = this.getS2sDivisionService().getDivision(departmentalPerson);
        if (divisionName != null) {
            aorInfoType.setDivisionName(divisionName);
        }
    }

    private RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantType getApplicantType() {
        ApplicantTypeCodeDataType.Enum applicantTypeCode;
        RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantType applicantType = (RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantType)RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantType.Factory.newInstance();
        RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantType.SmallBusinessOrganizationType smallOrganizationType = (RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantType.SmallBusinessOrganizationType)RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantType.SmallBusinessOrganizationType.Factory.newInstance();
        RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantType.SmallBusinessOrganizationType.IsSociallyEconomicallyDisadvantaged isSociallyEconomicallyDisadvantaged = (RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantType.SmallBusinessOrganizationType.IsSociallyEconomicallyDisadvantaged)RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantType.SmallBusinessOrganizationType.IsSociallyEconomicallyDisadvantaged.Factory.newInstance();
        RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantType.SmallBusinessOrganizationType.IsWomenOwned isWomenOwned = (RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantType.SmallBusinessOrganizationType.IsWomenOwned)RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30.ApplicantType.SmallBusinessOrganizationType.IsWomenOwned.Factory.newInstance();
        boolean smallBusflag = false;
        int orgTypeCode = 0;
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null && this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationTypes() != null && this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationTypes().size() > 0) {
            orgTypeCode = ((OrganizationTypeContract)this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationTypes().get(0)).getOrganizationTypeList().getCode();
        }
        switch (orgTypeCode) {
            case 1: {
                applicantTypeCode = ApplicantTypeCodeDataType.C_CITY_OR_TOWNSHIP_GOVERNMENT;
                break;
            }
            case 2: {
                applicantTypeCode = ApplicantTypeCodeDataType.A_STATE_GOVERNMENT;
                break;
            }
            case 3: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                break;
            }
            case 4: {
                applicantTypeCode = ApplicantTypeCodeDataType.M_NONPROFIT_WITH_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 5: {
                applicantTypeCode = ApplicantTypeCodeDataType.N_NONPROFIT_WITHOUT_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 6: {
                applicantTypeCode = ApplicantTypeCodeDataType.Q_FOR_PROFIT_ORGANIZATION_OTHER_THAN_SMALL_BUSINESS;
                break;
            }
            case 7: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                break;
            }
            case 8: {
                applicantTypeCode = ApplicantTypeCodeDataType.I_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_FEDERALLY_RECOGNIZED;
                break;
            }
            case 9: {
                applicantTypeCode = ApplicantTypeCodeDataType.P_INDIVIDUAL;
                break;
            }
            case 10: {
                applicantTypeCode = ApplicantTypeCodeDataType.O_PRIVATE_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 11: {
                applicantTypeCode = ApplicantTypeCodeDataType.R_SMALL_BUSINESS;
                break;
            }
            case 14: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                isSociallyEconomicallyDisadvantaged.setStringValue("Yes");
                smallOrganizationType.setIsSociallyEconomicallyDisadvantaged(isSociallyEconomicallyDisadvantaged);
                smallBusflag = true;
                break;
            }
            case 15: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                isWomenOwned.setStringValue("Yes");
                smallOrganizationType.setIsWomenOwned(isWomenOwned);
                smallBusflag = true;
                break;
            }
            case 21: {
                applicantTypeCode = ApplicantTypeCodeDataType.H_PUBLIC_STATE_CONTROLLED_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 22: {
                applicantTypeCode = ApplicantTypeCodeDataType.B_COUNTY_GOVERNMENT;
                break;
            }
            case 23: {
                applicantTypeCode = ApplicantTypeCodeDataType.D_SPECIAL_DISTRICT_GOVERNMENT;
                break;
            }
            case 24: {
                applicantTypeCode = ApplicantTypeCodeDataType.G_INDEPENDENT_SCHOOL_DISTRICT;
                break;
            }
            case 25: {
                applicantTypeCode = ApplicantTypeCodeDataType.L_PUBLIC_INDIAN_HOUSING_AUTHORITY;
                break;
            }
            case 26: {
                applicantTypeCode = ApplicantTypeCodeDataType.J_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_OTHER_THAN_FEDERALLY_RECOGNIZED;
                break;
            }
            case 100: {
                applicantTypeCode = ApplicantTypeCodeDataType.E_REGIONAL_ORGANIZATION;
                break;
            }
            case 101: {
                applicantTypeCode = ApplicantTypeCodeDataType.F_U_S_TERRITORY_OR_POSSESSION;
                break;
            }
            case 102: {
                applicantTypeCode = ApplicantTypeCodeDataType.K_INDIAN_NATIVE_AMERICAN_TRIBALLY_DESIGNATED_ORGANIZATION;
                break;
            }
            case 103: {
                applicantTypeCode = ApplicantTypeCodeDataType.S_HISPANIC_SERVING_INSTITUTION;
                break;
            }
            case 104: {
                applicantTypeCode = ApplicantTypeCodeDataType.T_HISTORICALLY_BLACK_COLLEGES_AND_UNIVERSITIES_HBC_US;
                break;
            }
            case 105: {
                applicantTypeCode = ApplicantTypeCodeDataType.U_TRIBALLY_CONTROLLED_COLLEGES_AND_UNIVERSITIES_TCC_US;
                break;
            }
            case 106: {
                applicantTypeCode = ApplicantTypeCodeDataType.V_ALASKA_NATIVE_AND_NATIVE_HAWAIIAN_SERVING_INSTITUTIONS;
                break;
            }
            case 107: {
                applicantTypeCode = ApplicantTypeCodeDataType.W_NON_DOMESTIC_NON_US_ENTITY;
                break;
            }
            default: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
            }
        }
        if (smallBusflag) {
            applicantType.setSmallBusinessOrganizationType(smallOrganizationType);
        }
        if (orgTypeCode == 3) {
            applicantType.setApplicantTypeCodeOtherExplanation("Federal Government");
        }
        applicantType.setApplicantTypeCode(applicantTypeCode);
        return applicantType;
    }

    private String getSubmissionTypeCode() {
        String submissionTypeCode = null;
        S2sOpportunityContract s2sOpportunity = this.pdDoc.getDevelopmentProposal().getS2sOpportunity();
        if (s2sOpportunity != null && s2sOpportunity.getS2sSubmissionType() != null) {
            submissionTypeCode = s2sOpportunity.getS2sSubmissionType().getCode();
        }
        if (this.pdDoc.getDevelopmentProposal().getProposalType() != null) {
            String proposalTypeCode = this.pdDoc.getDevelopmentProposal().getProposalType().getCode();
            if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_NEW_CHANGE_CORRECTED").contains(proposalTypeCode) || this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_SUPPLEMENT_CHANGE_CORRECTED").contains(proposalTypeCode) || this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_RENEWAL_CHANGE_CORRECTED").contains(proposalTypeCode) || this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_RESUBMISSION_CHANGE_CORRECTED").contains(proposalTypeCode)) {
                submissionTypeCode = Integer.toString(3);
            } else if (this.s2SConfigurationService.getValuesFromCommaSeparatedParam("PROPOSAL_TYPE_CODE_PRE_PROPOSAL").contains(proposalTypeCode)) {
                submissionTypeCode = Integer.toString(1);
            }
        }
        return submissionTypeCode;
    }

    private String getProposalSiteState() {
        ProposalSiteContract proposalSite = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        return proposalSite != null && proposalSite.getState() != null ? proposalSite.getState() : "";
    }

    private void setPreApplicationAttachment(RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30 rrsf424MultiProjectCover10) {
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType preAttachment;
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 6 || (preAttachment = this.addAttachedFileType(narrative)) == null) continue;
            rrsf424MultiProjectCover10.setPreApplicationAttachment(preAttachment);
            break;
        }
    }

    private void setSFLLLAttachment(RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30 rrsf424MultiProjectCover10) {
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType preAttachment;
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 86 || (preAttachment = this.addAttachedFileType(narrative)) == null) continue;
            rrsf424MultiProjectCover10.setSFLLLAttachment(preAttachment);
            break;
        }
    }

    private void setCoverLetterAttachment(RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30 rrsf424MultiProjectCover10) {
        for (NarrativeContract narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType preAttachment;
            if (narrative.getNarrativeType().getCode() == null || Integer.parseInt(narrative.getNarrativeType().getCode()) != 139 || (preAttachment = this.addAttachedFileType(narrative)) == null) continue;
            rrsf424MultiProjectCover10.setCoverLetterAttachment(preAttachment);
            break;
        }
    }

    private String getAORSignature() {
        String AORSignature = "";
        if (this.departmentalPerson != null) {
            AORSignature = this.departmentalPerson.getFullName();
        }
        return AORSignature;
    }

    private void setFederalId(RRSF424MultiProjectCover30Document.RRSF424MultiProjectCover30 rrsf42430) {
        String federalId = this.getFederalId();
        if (StringUtils.isNotBlank((CharSequence)federalId)) {
            rrsf42430.setFederalID(federalId);
        }
    }

    private String getActivityTitle() {
        return this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getS2sOpportunityCfdas().stream().map(Cfda::getCfdaDescription).filter(Objects::nonNull).map(cfda -> StringUtils.substring((String)cfda, (int)0, (int)119)).findFirst().orElse("");
    }

    private String getProjectTitle() {
        return StringUtils.substring((String)this.pdDoc.getDevelopmentProposal().getTitle(), (int)0, (int)200);
    }

    private String getAgencyRoutingNumber() {
        return this.pdDoc.getDevelopmentProposal().getAgencyRoutingIdentifier();
    }

    private String getGGTrackingID() {
        return this.pdDoc.getDevelopmentProposal().getPrevGrantsGovTrackingID();
    }

    @Override
    public RRSF424MultiProjectCover30Document getFormObject(ProposalDevelopmentDocumentContract proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        this.departmentalPerson = this.departmentalPersonService.getDepartmentalPerson(proposalDevelopmentDocument);
        return this.getRRSF424MultiProjectCover();
    }

    @Override
    protected List<? extends AnswerHeaderContract> getAnswerHeaders() {
        return this.answerHeaders;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    @Override
    public List<Resource> getStylesheets() {
        return this.stylesheets;
    }

    public void setStylesheets(List<Resource> stylesheets) {
        this.stylesheets = stylesheets;
    }

    @Override
    public Resource getPdfForm() {
        return this.pdfForm;
    }

    public void setPdfForm(Resource pdfForm) {
        this.pdfForm = pdfForm;
    }

    @Override
    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    @Override
    public S2SFormGeneratorPdfFillable.Attachments getMappedAttachments(RRSF424MultiProjectCover30Document form, List<AttachmentData> attachments) {
        Map<Boolean, List<Map.Entry>> attachmentPartition = attachments.stream().map(a -> {
            AttachedFileDataType sflllAttachment = form.getRRSF424MultiProjectCover30().getSFLLLAttachment();
            if (sflllAttachment != null && a.getContentId().equals(sflllAttachment.getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_SF424_Multi_Project_Cover_3_0_P2.optionalFile0", a);
            }
            AttachedFileDataType preApplicationAttachment = form.getRRSF424MultiProjectCover30().getPreApplicationAttachment();
            if (preApplicationAttachment != null && a.getContentId().equals(preApplicationAttachment.getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_SF424_Multi_Project_Cover_3_0_P2.optionalFile1", a);
            }
            AttachedFileDataType coverLetterAttachment = form.getRRSF424MultiProjectCover30().getCoverLetterAttachment();
            if (coverLetterAttachment != null && a.getContentId().equals(coverLetterAttachment.getFileLocation().getHref())) {
                return CollectionUtils.entry("RR_SF424_Multi_Project_Cover_3_0_P2.optionalFile2", a);
            }
            return CollectionUtils.entry(null, a);
        }).collect(Collectors.partitioningBy(a -> StringUtils.isNotBlank((CharSequence)((CharSequence)a.getKey()))));
        return new S2SFormGeneratorPdfFillable.Attachments(attachmentPartition.get(Boolean.TRUE).stream().collect(CollectionUtils.entriesToMap()), attachmentPartition.get(Boolean.FALSE).stream().map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    @Override
    public DocumentFactory<RRSF424MultiProjectCover30Document> factory() {
        return RRSF424MultiProjectCover30Document.Factory;
    }
}

