/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.disk;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.ehcache.core.spi.service.ExecutionService;
import org.terracotta.offheapstore.util.Factory;

public class DiskWriteThreadPool
implements Factory<ExecutorService> {
    private final List<ExecutorService> writers = new CopyOnWriteArrayList<ExecutorService>();
    private final ExecutionService executionService;
    private final String poolAlias;
    private final int threads;
    private int index = 0;

    public DiskWriteThreadPool(ExecutionService executionService, String poolAlias, int threads) {
        this.executionService = executionService;
        this.poolAlias = poolAlias;
        this.threads = threads;
    }

    public ExecutorService newInstance() {
        ExecutorService writer;
        if (this.writers.size() < this.threads) {
            writer = this.executionService.getOrderedExecutor(this.poolAlias, new LinkedBlockingQueue());
            this.writers.add(writer);
        } else {
            writer = this.writers.get(this.index++);
            if (this.index == this.writers.size()) {
                this.index = 0;
            }
        }
        return writer;
    }
}

