/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.fieldcaps.IndexFieldCapabilities;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class FieldCapabilitiesIndexResponse
extends ActionResponse
implements Writeable {
    private final String indexName;
    private final Collection<IndexFieldCapabilities> fields;
    private final boolean canMatch;
    private final transient Version originVersion;

    FieldCapabilitiesIndexResponse(String indexName, Collection<IndexFieldCapabilities> fields, boolean canMatch) {
        this.indexName = indexName;
        this.fields = fields;
        this.canMatch = canMatch;
        this.originVersion = Version.CURRENT;
    }

    FieldCapabilitiesIndexResponse(StreamInput in, IndexFieldCapabilities.Deduplicator fieldDeduplicator) throws IOException {
        super(in);
        this.indexName = in.readString();
        this.fields = FieldCapabilitiesIndexResponse.readFields(in, fieldDeduplicator);
        this.canMatch = in.getVersion().onOrAfter(Version.V_7_9_0) ? in.readBoolean() : true;
        this.originVersion = in.getVersion();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public boolean canMatch() {
        return this.canMatch;
    }

    public Collection<IndexFieldCapabilities> getFields() {
        return this.fields;
    }

    private static Collection<IndexFieldCapabilities> readFields(StreamInput in, IndexFieldCapabilities.Deduplicator fieldDeduplicator) throws IOException {
        int size = in.readVInt();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<IndexFieldCapabilities> fields = new ArrayList<IndexFieldCapabilities>(size);
        for (int i = 0; i < size; ++i) {
            String fieldName = in.readString();
            IndexFieldCapabilities fieldCaps = new IndexFieldCapabilities(in);
            assert (fieldName.equals(fieldCaps.getName())) : fieldName + " != " + fieldCaps.getName();
            fields.add(fieldDeduplicator.deduplicate(fieldCaps));
        }
        return fields;
    }

    private static void writeFields(StreamOutput out, Collection<IndexFieldCapabilities> fields) throws IOException {
        out.writeVInt(fields.size());
        for (IndexFieldCapabilities field : fields) {
            out.writeString(field.getName());
            field.writeTo(out);
        }
    }

    Version getOriginVersion() {
        return this.originVersion;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.indexName);
        FieldCapabilitiesIndexResponse.writeFields(out, this.fields);
        if (out.getVersion().onOrAfter(Version.V_7_9_0)) {
            out.writeBoolean(this.canMatch);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilitiesIndexResponse that = (FieldCapabilitiesIndexResponse)o;
        return this.canMatch == that.canMatch && Objects.equals(this.indexName, that.indexName) && Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.indexName, this.fields, this.canMatch);
    }
}

