/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.group;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.mo.common.active.InactivatableFromToUtils;
import org.kuali.rice.core.api.util.jaxb.DateTimeAdapter;
import org.kuali.rice.kim.api.group.GroupMemberContract;
import org.w3c.dom.Element;

@XmlRootElement(name="groupMember")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="GroupMemberType", propOrder={"id", "groupId", "memberId", "typeCode", "activeFromDate", "activeToDate", "versionNumber", "objectId", "_futureElements"})
public class GroupMember
extends AbstractDataTransferObject
implements GroupMemberContract {
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="groupId", required=true)
    private final String groupId;
    @XmlElement(name="memberId", required=true)
    private final String memberId;
    @XmlElement(name="typeCode", required=true)
    private final String typeCode;
    @XmlElement(name="activeFromDate", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime activeFromDate;
    @XmlElement(name="activeToDate", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime activeToDate;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private GroupMember() {
        this.id = null;
        this.groupId = null;
        this.memberId = null;
        this.typeCode = null;
        this.versionNumber = null;
        this.objectId = null;
        this.activeFromDate = null;
        this.activeToDate = null;
    }

    public GroupMember(Builder builder) {
        this.id = builder.getId();
        this.groupId = builder.getGroupId();
        this.memberId = builder.getMemberId();
        this.typeCode = builder.getType().getCode();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
        this.activeFromDate = builder.getActiveFromDate();
        this.activeToDate = builder.getActiveToDate();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getMemberId() {
        return this.memberId;
    }

    @Override
    public MemberType getType() {
        return MemberType.fromCode((String)this.typeCode);
    }

    public DateTime getActiveFromDate() {
        return this.activeFromDate;
    }

    public DateTime getActiveToDate() {
        return this.activeToDate;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public boolean isActive(DateTime activeAsOf) {
        return InactivatableFromToUtils.isActive((DateTime)this.activeFromDate, (DateTime)this.activeToDate, (DateTime)activeAsOf);
    }

    public boolean isActive() {
        return InactivatableFromToUtils.isActive((DateTime)this.activeFromDate, (DateTime)this.activeToDate, null);
    }

    public static class Builder
    implements GroupMemberContract,
    ModelBuilder,
    Serializable {
        private String id;
        private String groupId;
        private String memberId;
        private MemberType type;
        private DateTime activeFromDate;
        private DateTime activeToDate;
        private Long versionNumber;
        private String objectId;

        private Builder(String groupId, String memberId, MemberType type) {
            this.setGroupId(groupId);
            this.setMemberId(memberId);
            this.setType(type);
        }

        public static Builder create(String groupId, String memberId, MemberType type) {
            return new Builder(groupId, memberId, type);
        }

        public static Builder create(GroupMemberContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = new Builder(contract.getGroupId(), contract.getMemberId(), contract.getType());
            builder.setId(contract.getId());
            builder.setActiveFromDate(contract.getActiveFromDate());
            builder.setActiveToDate(contract.getActiveToDate());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            return builder;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            if (StringUtils.isWhitespace((String)id)) {
                throw new IllegalArgumentException("id is blank");
            }
            this.id = id;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            if (StringUtils.isEmpty((String)groupId)) {
                throw new IllegalArgumentException("groupId is empty");
            }
            this.groupId = groupId;
        }

        @Override
        public String getMemberId() {
            return this.memberId;
        }

        public void setMemberId(String memberId) {
            if (StringUtils.isEmpty((String)memberId)) {
                throw new IllegalArgumentException("memberId is empty");
            }
            this.memberId = memberId;
        }

        @Override
        public MemberType getType() {
            return this.type;
        }

        public void setType(MemberType type) {
            if (type == null) {
                throw new IllegalArgumentException("type is null");
            }
            this.type = type;
        }

        public DateTime getActiveFromDate() {
            return this.activeFromDate;
        }

        public void setActiveFromDate(DateTime activeFromDate) {
            this.activeFromDate = activeFromDate;
        }

        public DateTime getActiveToDate() {
            return this.activeToDate;
        }

        public void setActiveToDate(DateTime activeToDate) {
            this.activeToDate = activeToDate;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public boolean isActive(DateTime activeAsOf) {
            return InactivatableFromToUtils.isActive((DateTime)this.activeFromDate, (DateTime)this.activeToDate, (DateTime)activeAsOf);
        }

        public boolean isActive() {
            return InactivatableFromToUtils.isActive((DateTime)this.activeFromDate, (DateTime)this.activeToDate, null);
        }

        public GroupMember build() {
            return new GroupMember(this);
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/kim/v2_0/GroupMemberType";
    }

    static class Elements {
        static final String ID = "id";
        static final String GROUP_ID = "groupId";
        static final String MEMBER_ID = "memberId";
        static final String TYPE_CODE = "typeCode";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "groupMember";
        static final String TYPE_NAME = "GroupMemberType";

        Constants() {
        }
    }
}

