/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.framework.document.search;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="documentSearchResultField")
@XmlType(name="DocumentSearchResultFieldType")
@XmlEnum
public enum StandardResultField {
    DOCUMENT_ID("documentId", new String[0]),
    STATUS("status", "statusLabel"),
    DOCUMENT_TYPE("documentType", "documentTypeLabel"),
    TITLE("title", new String[0]),
    INITIATOR("initiator", "initiatorDisplayName"),
    DATE_CREATED("dateCreated", new String[0]),
    ROUTE_LOG("routeLog", new String[0]);

    private final String standardFieldName;
    private final Set<String> additionalFieldNames;

    private StandardResultField(String standardFieldName, String ... additionalFieldNames) {
        this.standardFieldName = standardFieldName;
        HashSet<String> additionalFieldNameSet = new HashSet<String>(Arrays.asList(additionalFieldNames));
        this.additionalFieldNames = Collections.unmodifiableSet(additionalFieldNameSet);
    }

    public String getStandardFieldName() {
        return this.standardFieldName;
    }

    public Set<String> getAdditionalFieldNames() {
        return this.additionalFieldNames;
    }

    public boolean isFieldNameValid(String fieldName) {
        return fieldName.equals(this.standardFieldName) || this.additionalFieldNames.contains(fieldName);
    }

    public static StandardResultField fromFieldName(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        for (StandardResultField resultField : StandardResultField.values()) {
            if (!resultField.isFieldNameValid(fieldName)) continue;
            return resultField;
        }
        throw new IllegalArgumentException("Failed to locate the StandardResultField with the field name: " + fieldName);
    }
}

