/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.mail;

import java.io.IOException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.mail.EmailBcList;
import org.kuali.rice.core.api.mail.EmailBody;
import org.kuali.rice.core.api.mail.EmailCcList;
import org.kuali.rice.core.api.mail.EmailFrom;
import org.kuali.rice.core.api.mail.EmailSubject;
import org.kuali.rice.core.api.mail.EmailTo;
import org.kuali.rice.core.api.mail.EmailToList;
import org.kuali.rice.core.api.mail.MailMessage;
import org.kuali.rice.core.api.mail.Mailer;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public class MailerImpl
implements Mailer {
    protected final Logger LOG = LogManager.getLogger(MailerImpl.class);
    private JavaMailSenderImpl mailSender;

    public void setMailSender(JavaMailSenderImpl mailSender) {
        this.mailSender = mailSender;
    }

    public void sendEmail(MailMessage message) throws MessagingException {
        SimpleMailMessage smm = new SimpleMailMessage();
        smm.setTo(message.getToAddresses().toArray(new String[message.getToAddresses().size()]));
        smm.setBcc(message.getBccAddresses().toArray(new String[message.getBccAddresses().size()]));
        smm.setCc(message.getCcAddresses().toArray(new String[message.getCcAddresses().size()]));
        smm.setSubject(message.getSubject());
        smm.setText(message.getMessage());
        smm.setFrom(message.getFromAddress());
        try {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("sendEmail() - Sending message: " + smm.toString());
            }
            this.mailSender.send(smm);
        }
        catch (Exception e) {
            this.LOG.error("sendEmail() - Error sending email.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void sendEmail(EmailFrom from, EmailTo to, EmailSubject subject, EmailBody body, boolean htmlMessage) {
        if (to.getToAddress() == null) {
            this.LOG.warn("No To address specified. Refraining from sending mail.");
            return;
        }
        try {
            Address[] singleRecipient = new Address[]{new InternetAddress(to.getToAddress())};
            this.sendMessage(from.getFromAddress(), singleRecipient, subject.getSubject(), body.getBody(), null, null, htmlMessage);
        }
        catch (Exception e) {
            this.LOG.error("sendEmail(): ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void sendEmail(EmailFrom from, EmailToList to, EmailSubject subject, EmailBody body, EmailCcList cc, EmailBcList bc, boolean htmlMessage) {
        if (to.getToAddresses().isEmpty()) {
            this.LOG.error("List of To addresses must contain at least one entry. Refraining from sending mail.");
            return;
        }
        try {
            this.sendMessage(from.getFromAddress(), to.getToAddressesAsAddressArray(), subject.getSubject(), body.getBody(), cc == null ? null : cc.getToAddressesAsAddressArray(), bc == null ? null : bc.getToAddressesAsAddressArray(), htmlMessage);
        }
        catch (Exception e) {
            this.LOG.error("sendEmail(): ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected void sendMessage(String from, Address[] to, String subject, String messageBody, Address[] cc, Address[] bcc, boolean htmlMessage) throws AddressException, MessagingException, MailException {
        MimeMessage message = this.mailSender.createMimeMessage();
        message.setFrom((Address)new InternetAddress(from));
        if (to != null && to.length > 0) {
            message.addRecipients(Message.RecipientType.TO, to);
        } else {
            this.LOG.error("No recipients indicated.");
        }
        if (cc != null && cc.length > 0) {
            message.addRecipients(Message.RecipientType.CC, cc);
        }
        if (bcc != null && bcc.length > 0) {
            message.addRecipients(Message.RecipientType.BCC, bcc);
        }
        message.setSubject(subject);
        if (subject == null || "".equals(subject)) {
            this.LOG.warn("Empty subject being sent.");
        }
        if (htmlMessage) {
            this.prepareHtmlMessage(messageBody, (Message)message);
        } else {
            message.setText(messageBody);
            if (messageBody == null || "".equals(messageBody)) {
                this.LOG.warn("Empty message body being sent.");
            }
        }
        try {
            this.mailSender.send(message);
        }
        catch (Exception e) {
            this.LOG.error("sendMessage(): ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected void prepareHtmlMessage(String messageText, Message message) throws MessagingException {
        try {
            message.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(messageText, "text/html")));
        }
        catch (IOException e) {
            this.LOG.warn(e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

