/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.repository;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krms.api.repository.context.ContextDefinition;
import org.kuali.rice.krms.api.repository.context.ContextDefinitionContract;
import org.kuali.rice.krms.impl.repository.BusinessObjectServiceMigrationUtils;
import org.kuali.rice.krms.impl.repository.ContextAttributeBo;
import org.kuali.rice.krms.impl.repository.ContextBo;
import org.kuali.rice.krms.impl.repository.ContextBoService;

public class ContextBoServiceImpl
implements ContextBoService {
    private DataObjectService dataObjectService;

    @Override
    public ContextDefinition createContext(ContextDefinition context) {
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        String contextIdKey = context.getId();
        ContextDefinition existing = this.getContextByContextId(contextIdKey);
        if (existing != null) {
            throw new IllegalStateException("the context to create already exists: " + String.valueOf(context));
        }
        ContextBo bo = (ContextBo)this.dataObjectService.save((Object)ContextBo.from(context), new PersistenceOption[0]);
        return ContextBo.to(bo);
    }

    @Override
    public ContextDefinition updateContext(ContextDefinition context) {
        ContextDefinition toUpdate;
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        String contextIdKey = context.getId();
        ContextBo existing = (ContextBo)this.dataObjectService.find(ContextBo.class, (Object)contextIdKey);
        if (existing == null) {
            throw new IllegalStateException("the context does not exist: " + String.valueOf(context));
        }
        if (!existing.getId().equals(context.getId())) {
            ContextDefinition.Builder builder = ContextDefinition.Builder.create((ContextDefinitionContract)context);
            builder.setId(existing.getId());
            toUpdate = builder.build();
        } else {
            toUpdate = context;
        }
        ContextBo boToUpdate = ContextBo.from(toUpdate);
        HashMap<String, String> fields = new HashMap<String, String>(1);
        fields.put("context.id", toUpdate.getId());
        BusinessObjectServiceMigrationUtils.deleteMatching(this.dataObjectService, ContextAttributeBo.class, fields);
        ContextBo updatedData = (ContextBo)this.dataObjectService.save((Object)boToUpdate, new PersistenceOption[0]);
        return ContextBo.to(updatedData);
    }

    @Override
    public ContextDefinition getContextByContextId(String contextId) {
        if (StringUtils.isBlank((String)contextId)) {
            return null;
        }
        ContextBo bo = (ContextBo)this.dataObjectService.find(ContextBo.class, (Object)contextId);
        return ContextBo.to(bo);
    }

    @Override
    public ContextDefinition getContextByNameAndNamespace(String name, String namespace) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name is null or blank");
        }
        if (StringUtils.isBlank((String)namespace)) {
            throw new IllegalArgumentException("namespace is null or blank");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("namespace", namespace);
        ContextBo bo = BusinessObjectServiceMigrationUtils.findSingleMatching(this.dataObjectService, ContextBo.class, map);
        return ContextBo.to(bo);
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

