/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository.rule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.krms.api.repository.action.ActionDefinition;
import org.kuali.rice.krms.api.repository.action.ActionDefinitionContract;
import org.kuali.rice.krms.api.repository.proposition.PropositionDefinition;
import org.kuali.rice.krms.api.repository.rule.RuleDefinitionContract;
import org.w3c.dom.Element;

@XmlRootElement(name="rule")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="RuleType", propOrder={"id", "name", "namespace", "description", "typeId", "active", "proposition", "actions", "attributes", "versionNumber", "_futureElements"})
public final class RuleDefinition
extends AbstractDataTransferObject
implements RuleDefinitionContract {
    private static final long serialVersionUID = 2783959459503209577L;
    @XmlElement(name="id", required=true)
    private final String id;
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="namespace", required=true)
    private final String namespace;
    @XmlElement(name="description", required=false)
    private final String description;
    @XmlElement(name="typeId", required=true)
    private final String typeId;
    @XmlElement(name="proposition", required=true)
    private final PropositionDefinition proposition;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlElementWrapper(name="actions")
    @XmlElement(name="action", required=false)
    private final List<ActionDefinition> actions;
    @XmlElement(name="attributes", required=false)
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    private final Map<String, String> attributes;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;
    @XmlTransient
    private String propId;

    private RuleDefinition() {
        this.id = null;
        this.name = null;
        this.namespace = null;
        this.description = null;
        this.typeId = null;
        this.propId = null;
        this.active = true;
        this.proposition = null;
        this.actions = null;
        this.attributes = null;
        this.versionNumber = null;
    }

    private RuleDefinition(Builder builder) {
        this.id = builder.getId();
        this.name = builder.getName();
        this.namespace = builder.getNamespace();
        this.typeId = builder.getTypeId();
        this.propId = builder.getPropId();
        this.description = builder.getDescription();
        this.active = builder.isActive();
        this.proposition = builder.getProposition() != null ? builder.getProposition().build() : null;
        ArrayList<ActionDefinition> actionList = new ArrayList<ActionDefinition>();
        if (builder.getActions() != null) {
            for (ActionDefinition.Builder b : builder.actions) {
                actionList.add(b.build());
            }
            this.actions = Collections.unmodifiableList(actionList);
        } else {
            this.actions = Collections.emptyList();
        }
        this.attributes = builder.attributes != null ? Collections.unmodifiableMap(builder.getAttributes()) : null;
        this.versionNumber = builder.getVersionNumber();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getTypeId() {
        return this.typeId;
    }

    @Override
    public String getPropId() {
        return this.propId;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public PropositionDefinition getProposition() {
        return this.proposition;
    }

    public List<ActionDefinition> getActions() {
        return this.actions;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public static class Builder
    implements RuleDefinitionContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = -7850514191699945347L;
        private String id;
        private String name;
        private String description;
        private String namespace;
        private String typeId;
        private String propId;
        private boolean active;
        private PropositionDefinition.Builder proposition;
        private List<ActionDefinition.Builder> actions;
        private Map<String, String> attributes;
        private Long versionNumber;

        private Builder(String ruleId, String name, String namespace, String typeId, String propId) {
            this.setId(ruleId);
            this.setName(name);
            this.setNamespace(namespace);
            this.setTypeId(typeId);
            this.setPropId(propId);
            this.setActive(true);
            this.setAttributes(new HashMap<String, String>());
        }

        public static Builder create(String ruleId, String name, String namespace, String typeId, String propId) {
            return new Builder(ruleId, name, namespace, typeId, propId);
        }

        public static Builder create(RuleDefinitionContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract is null");
            }
            ArrayList<ActionDefinition.Builder> actionList = new ArrayList<ActionDefinition.Builder>();
            if (contract.getActions() != null) {
                for (ActionDefinitionContract actionDefinitionContract : contract.getActions()) {
                    ActionDefinition.Builder actBuilder = ActionDefinition.Builder.create(actionDefinitionContract);
                    actionList.add(actBuilder);
                }
            }
            Builder builder = new Builder(contract.getId(), contract.getName(), contract.getNamespace(), contract.getTypeId(), contract.getPropId());
            if (contract.getProposition() != null) {
                builder.setProposition(PropositionDefinition.Builder.create(contract.getProposition()));
            }
            if (contract.getAttributes() != null) {
                builder.setAttributes(new HashMap<String, String>(contract.getAttributes()));
            }
            builder.setActions(actionList);
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setDescription(contract.getDescription());
            builder.setActive(contract.isActive());
            return builder;
        }

        public void setId(String ruleId) {
            if (ruleId != null && StringUtils.isBlank((String)ruleId)) {
                throw new IllegalArgumentException("rule ID must be null or else non-blank");
            }
            this.id = ruleId;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name is blank");
            }
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setNamespace(String namespace) {
            if (StringUtils.isBlank((String)namespace)) {
                throw new IllegalArgumentException("namespace is blank");
            }
            this.namespace = namespace;
        }

        public void setTypeId(String typeId) {
            this.typeId = typeId;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setPropId(String propId) {
            if (propId != null && StringUtils.isBlank((String)propId)) {
                throw new IllegalArgumentException("propId must be null or non-blank");
            }
            this.propId = propId;
        }

        public void setProposition(PropositionDefinition.Builder prop) {
            this.proposition = prop;
            this.setPropId(prop.getId());
        }

        public void setActions(List<ActionDefinition.Builder> actions) {
            if (actions == null) {
                this.actions = Collections.unmodifiableList(new ArrayList());
                return;
            }
            this.actions = Collections.unmodifiableList(actions);
        }

        public void setAttributes(Map<String, String> attributes) {
            if (attributes == null) {
                this.attributes = Collections.emptyMap();
            }
            this.attributes = Collections.unmodifiableMap(attributes);
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getTypeId() {
            return this.typeId;
        }

        @Override
        public String getPropId() {
            return this.propId;
        }

        public boolean isActive() {
            return this.active;
        }

        @Override
        public PropositionDefinition.Builder getProposition() {
            return this.proposition;
        }

        public List<ActionDefinition.Builder> getActions() {
            return this.actions;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public RuleDefinition build() {
            return new RuleDefinition(this);
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/krms/v2_0/RuleType";
    }

    public static class Elements {
        static final String ID = "id";
        static final String NAME = "name";
        static final String DESCRIPTION = "description";
        static final String NAMESPACE = "namespace";
        static final String TYPE_ID = "typeId";
        static final String PROPOSITION = "proposition";
        static final String ACTIONS = "actions";
        static final String ACTION = "action";
        static final String ACTIVE = "active";
        static final String ATTRIBUTES = "attributes";
    }

    public static class Constants {
        static final String ROOT_ELEMENT_NAME = "rule";
        static final String TYPE_NAME = "RuleType";
    }
}

