/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.personmasschange.service.impl;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.api.rolodex.RolodexService;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.kra.bo.AbstractPersonRoleAware;
import org.kuali.kra.personmasschange.bo.PersonMassChange;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class MassPersonChangeServiceBase {
    protected static final String PMC_LOCKED_FIELD = "personMassChangeDocumentLocked";
    protected final ErrorReporter errorReporter = KcServiceLocator.getService(ErrorReporter.class);
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;
    @Autowired
    @Qualifier(value="rolodexService")
    private RolodexService rolodexService;

    protected boolean isReplacerValidPersonChangeCandidate(PersonMassChange personMassChange, List<? extends AbstractPersonRoleAware> persons) {
        boolean isValid = true;
        for (AbstractPersonRoleAware abstractPersonRoleAware : persons) {
            if ((personMassChange.getReplacerPersonId() == null || !StringUtils.equals((CharSequence)personMassChange.getReplacerPersonId(), (CharSequence)abstractPersonRoleAware.getPersonId())) && (personMassChange.getReplacerRolodexId() == null || !Objects.equals(personMassChange.getReplacerRolodexId(), abstractPersonRoleAware.getRolodexId()))) continue;
            this.reportReplacerExists(abstractPersonRoleAware);
            isValid = false;
        }
        return isValid;
    }

    protected boolean isPersonChangeCandidate(PersonMassChange personMassChange, List<? extends AbstractPersonRoleAware> persons, String ... personRoles) {
        boolean isPersonChangeCandidate = false;
        for (AbstractPersonRoleAware abstractPersonRoleAware : persons) {
            if (!this.isPersonInRole(abstractPersonRoleAware, personRoles) || !this.isPersonIdMassChange(personMassChange, abstractPersonRoleAware.getPersonId()) && !this.isRolodexIdMassChange(personMassChange, abstractPersonRoleAware.getRolodexId())) continue;
            isPersonChangeCandidate = true;
            break;
        }
        return isPersonChangeCandidate;
    }

    protected boolean isPersonInRole(AbstractPersonRoleAware person, String ... personRoles) {
        boolean isPersonInRole = false;
        for (String personRole : personRoles) {
            if (!StringUtils.equals((CharSequence)person.getRoleCode(), (CharSequence)personRole)) continue;
            isPersonInRole = true;
            break;
        }
        return isPersonInRole;
    }

    protected boolean isPersonIdMassChange(PersonMassChange personMassChange, String personId) {
        String replaceePersonId = personMassChange.getReplaceePersonId();
        return replaceePersonId != null && replaceePersonId.equals(personId);
    }

    protected boolean isRolodexIdMassChange(PersonMassChange personMassChange, Integer rolodexId) {
        Integer replaceeRolodexId = personMassChange.getReplaceeRolodexId();
        return replaceeRolodexId != null && replaceeRolodexId.equals(rolodexId);
    }

    protected void reportReplacerExists(AbstractPersonRoleAware person) {
        this.errorReporter.reportWarning(this.getWarningKey(), "error.personMassChange.replacer.exists", this.getDocumentName(), this.getDocumentId(person.getParent()), person.getFullName());
    }

    protected abstract String getWarningKey();

    protected abstract String getDocumentName();

    protected abstract String getDocumentId(PersistableBusinessObject var1);

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    protected RolodexService getRolodexService() {
        return this.rolodexService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }

    protected DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

