/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kcb.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.springframework.beans.factory.BeanFactory;

public class BeanFactoryInvocationHandler
implements InvocationHandler {
    private static final String PREFIX = "get";
    private BeanFactory beanFactory;

    public BeanFactoryInvocationHandler(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (args != null && args.length > 0) {
            throw new RuntimeException("BeanFactoryInvocationHandler only serves getters");
        }
        String methodName = method.getName();
        if (!methodName.startsWith(PREFIX)) {
            throw new RuntimeException("BeanFactoryInvocationHandler only serves getters");
        }
        Object beanName = methodName.substring(PREFIX.length());
        if (((String)beanName).length() == 0) {
            throw new RuntimeException("Illegal accessor, no bean name specified: " + methodName);
        }
        char firstChar = ((String)beanName).charAt(0);
        if (!Character.isLowerCase(firstChar)) {
            beanName = Character.toLowerCase(firstChar) + ((String)beanName).substring(1);
        }
        return this.beanFactory.getBean((String)beanName);
    }
}

