/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.impl.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebParam;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.uif.RemotableAbstractControl;
import org.kuali.rice.core.api.uif.RemotableAttributeError;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableTextInput;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.krad.datadictionary.validation.AttributeValidatingTypeServiceBase;
import org.kuali.rice.krad.service.DataDictionaryRemoteFieldService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krms.api.repository.type.KrmsAttributeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeAttribute;
import org.kuali.rice.krms.api.repository.type.KrmsTypeDefinition;
import org.kuali.rice.krms.api.repository.type.KrmsTypeRepositoryService;
import org.kuali.rice.krms.framework.type.RemotableAttributeOwner;
import org.kuali.rice.krms.impl.repository.KrmsRepositoryServiceLocator;

public abstract class KrmsTypeServiceBase
extends AttributeValidatingTypeServiceBase
implements RemotableAttributeOwner {
    public List<RemotableAttributeField> getAttributeFields(@WebParam(name="krmsTypeId") String krmsTypeId) throws RiceIllegalArgumentException {
        List<AttributeValidatingTypeServiceBase.TypeAttributeDefinition> typeAttributeDefinitions = this.getTypeAttributeDefinitions(krmsTypeId);
        if (CollectionUtils.isEmpty(typeAttributeDefinitions)) {
            return Collections.emptyList();
        }
        ArrayList<RemotableAttributeField> fields = new ArrayList<RemotableAttributeField>(typeAttributeDefinitions.size());
        for (AttributeValidatingTypeServiceBase.TypeAttributeDefinition typeAttributeDefinition : typeAttributeDefinitions) {
            fields.add(typeAttributeDefinition.getField());
        }
        return fields;
    }

    protected List<AttributeValidatingTypeServiceBase.TypeAttributeDefinition> getTypeAttributeDefinitions(String krmsTypeId) {
        if (StringUtils.isBlank((String)krmsTypeId)) {
            throw new RiceIllegalArgumentException("krmsTypeId must be non-null and non-blank");
        }
        ArrayList<AttributeValidatingTypeServiceBase.TypeAttributeDefinition> results = new ArrayList<AttributeValidatingTypeServiceBase.TypeAttributeDefinition>();
        HashMap<String, Integer> sortCodeMap = new HashMap<String, Integer>();
        KrmsTypeDefinition krmsType = KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService().getTypeById(krmsTypeId);
        if (krmsType == null) {
            throw new RiceIllegalArgumentException("krmsTypeId must be a valid id of a KRMS type");
        }
        List typeAttributes = krmsType.getAttributes();
        ArrayList typeAttributeFields = new ArrayList(10);
        if (!CollectionUtils.isEmpty((Collection)typeAttributes)) {
            for (KrmsTypeAttribute typeAttribute : typeAttributes) {
                KrmsTypeRepositoryService typeRepositoryService = KrmsRepositoryServiceLocator.getKrmsTypeRepositoryService();
                KrmsAttributeDefinition attributeDefinition = typeRepositoryService.getAttributeDefinitionById(typeAttribute.getAttributeDefinitionId());
                RemotableAttributeField attributeField = this.translateTypeAttribute(typeAttribute, attributeDefinition);
                if (typeAttribute.getSequenceNumber() == null) {
                    throw new IllegalStateException(typeAttribute.toString() + " has a null sequenceNumber");
                }
                sortCodeMap.put(attributeField.getName(), typeAttribute.getSequenceNumber());
                AttributeValidatingTypeServiceBase.TypeAttributeDefinition typeAttributeDefinition = new AttributeValidatingTypeServiceBase.TypeAttributeDefinition(attributeField, attributeDefinition.getName(), attributeDefinition.getComponentName(), attributeDefinition.getLabel(), null);
                results.add(typeAttributeDefinition);
            }
        }
        this.sortFields(results, sortCodeMap);
        return results;
    }

    protected void sortFields(List<AttributeValidatingTypeServiceBase.TypeAttributeDefinition> results, final Map<String, Integer> sortCodeMap) {
        Collections.sort(results, new Comparator<AttributeValidatingTypeServiceBase.TypeAttributeDefinition>(){

            @Override
            public int compare(AttributeValidatingTypeServiceBase.TypeAttributeDefinition o1, AttributeValidatingTypeServiceBase.TypeAttributeDefinition o2) {
                Integer o2SortCode;
                if (o1 == o2 || o1.equals(o2)) {
                    return 0;
                }
                Integer o1SortCode = (Integer)sortCodeMap.get(o1.getName());
                if (o1SortCode.compareTo(o2SortCode = (Integer)sortCodeMap.get(o2.getName())) != 0) {
                    return o1SortCode.compareTo(o2SortCode);
                }
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    public List<RemotableAttributeError> validateAttributes(@WebParam(name="krmsTypeId") String krmsTypeId, @WebParam(name="attributes") @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) Map<String, String> attributes) throws RiceIllegalArgumentException {
        return super.validateAttributes(krmsTypeId, attributes);
    }

    public List<RemotableAttributeError> validateAttributesAgainstExisting(@WebParam(name="krmsTypeId") String krmsTypeId, @WebParam(name="newAttributes") @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) Map<String, String> newAttributes, @WebParam(name="oldAttributes") @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) Map<String, String> oldAttributes) throws RiceIllegalArgumentException {
        return this.validateAttributes(krmsTypeId, newAttributes);
    }

    public RemotableAttributeField translateTypeAttribute(KrmsTypeAttribute inputAttribute, KrmsAttributeDefinition attributeDefinition) {
        if (StringUtils.isEmpty((String)attributeDefinition.getComponentName())) {
            RemotableAttributeField.Builder builder = RemotableAttributeField.Builder.create((String)attributeDefinition.getName());
            RemotableTextInput.Builder controlBuilder = RemotableTextInput.Builder.create();
            controlBuilder.setSize(Integer.valueOf(80));
            controlBuilder.setWatermark(attributeDefinition.getDescription());
            builder.setShortLabel(attributeDefinition.getLabel());
            builder.setLongLabel(attributeDefinition.getLabel());
            builder.setName(attributeDefinition.getName());
            builder.setControl((RemotableAbstractControl.Builder)controlBuilder);
            builder.setMaxLength(Integer.valueOf(400));
            return builder.build();
        }
        return this.getDataDictionaryRemoteFieldService().buildRemotableFieldFromAttributeDefinition(attributeDefinition.getComponentName(), attributeDefinition.getName());
    }

    public DataDictionaryRemoteFieldService getDataDictionaryRemoteFieldService() {
        return KRADServiceLocatorWeb.getDataDictionaryRemoteFieldService();
    }

    protected List<RemotableAttributeError> validateNonDataDictionaryAttribute(RemotableAttributeField attr, String key, String value) {
        return Collections.emptyList();
    }
}

