/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.rule.bo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.rule.RuleTemplate;
import org.kuali.rice.kew.api.rule.RuleTemplateAttribute;
import org.kuali.rice.kew.rule.WorkflowRuleAttributeRows;
import org.kuali.rice.kew.rule.bo.RuleAttribute;
import org.kuali.rice.kew.rule.service.RuleTemplateService;
import org.kuali.rice.kew.service.KEWServiceLocator;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.kns.web.ui.Column;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.util.GlobalVariables;

public class AbstractRuleLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private List<Row> rows = new ArrayList<Row>();
    private List<Row> additionalFieldRows = new ArrayList<Row>();
    protected static final String GROUP_REVIEWER_PROPERTY_NAME = "groupReviewer";
    protected static final String GROUP_REVIEWER_NAME_PROPERTY_NAME = "groupReviewerName";
    protected static final String GROUP_REVIEWER_NAMESPACE_PROPERTY_NAME = "groupReviewerNamespace";
    protected static final String PERSON_REVIEWER_PROPERTY_NAME = "personReviewer";
    protected static final String PERSON_REVIEWER_TYPE_PROPERTY_NAME = "personReviewerType";
    protected static final String BACK_LOCATION = "backLocation";
    protected static final String DOC_FORM_KEY = "docFormKey";
    protected static final String INVALID_WORKGROUP_ERROR = "The Group Reviewer Namespace and Name combination is not valid";
    protected static final String INVALID_PERSON_ERROR = "The Person Reviewer is not valid";

    protected boolean checkForAdditionalFields(Map<String, String> fieldValues, String ruleTemplateNameParam) {
        if (StringUtils.isNotBlank((String)ruleTemplateNameParam)) {
            this.additionalFieldRows = new ArrayList<Row>();
            RuleTemplate ruleTemplate = KewApiServiceLocator.getRuleService().getRuleTemplateByName(ruleTemplateNameParam);
            for (RuleTemplateAttribute ruleTemplateAttribute : ruleTemplate.getActiveRuleTemplateAttributes()) {
                if (!RuleAttribute.isWorkflowAttribute(ruleTemplateAttribute.getRuleAttribute().getType())) continue;
                this.populateFieldsHelperMethod(fieldValues, ruleTemplateAttribute, false);
                this.populateFieldsHelperMethod(fieldValues, ruleTemplateAttribute, true);
            }
            return true;
        }
        this.additionalFieldRows.clear();
        return false;
    }

    private void populateFieldsHelperMethod(Map<String, String> fieldValues, RuleTemplateAttribute ruleTemplateAttribute, boolean setAndAddValuesToRow) {
        WorkflowRuleAttributeRows workflowRuleAttributeRows = KEWServiceLocator.getWorkflowRuleAttributeMediator().getSearchRows(fieldValues, ruleTemplateAttribute);
        for (Row row : workflowRuleAttributeRows.getRows()) {
            ArrayList<Field> fields = new ArrayList<Field>();
            for (Field field : row.getFields()) {
                if (fieldValues.get(field.getPropertyName()) != null) {
                    field.setPropertyValue(fieldValues.get(field.getPropertyName()));
                }
                fields.add(field);
                fieldValues.put(field.getPropertyName(), field.getPropertyValue());
            }
            if (!setAndAddValuesToRow) continue;
            row.setFields(fields);
            this.additionalFieldRows.add(row);
        }
    }

    public List<Row> getRows() {
        if (this.rows.size() == 0) {
            this.rows.addAll(super.getRows());
        }
        ArrayList<Row> returnRows = new ArrayList<Row>();
        returnRows.addAll(this.rows);
        returnRows.addAll(this.additionalFieldRows);
        return returnRows;
    }

    protected void clearRows() {
        this.rows.clear();
    }

    public void validateSearchParameters(Map<String, String> fieldValues) {
        Person person;
        Group group;
        String attributeLabel;
        super.validateSearchParameters(fieldValues);
        String groupName = fieldValues.get(GROUP_REVIEWER_NAME_PROPERTY_NAME);
        String groupNamespace = fieldValues.get(GROUP_REVIEWER_NAMESPACE_PROPERTY_NAME);
        String principalName = fieldValues.get(PERSON_REVIEWER_PROPERTY_NAME);
        if (StringUtils.isEmpty((String)groupName) && !StringUtils.isEmpty((String)groupNamespace)) {
            attributeLabel = this.getDataDictionaryService().getAttributeLabel(this.getBusinessObjectClass(), GROUP_REVIEWER_NAME_PROPERTY_NAME);
            GlobalVariables.getMessageMap().putError(GROUP_REVIEWER_NAME_PROPERTY_NAME, "error.required", new String[]{attributeLabel});
        }
        if (!StringUtils.isEmpty((String)groupName) && StringUtils.isEmpty((String)groupNamespace)) {
            attributeLabel = this.getDataDictionaryService().getAttributeLabel(this.getBusinessObjectClass(), GROUP_REVIEWER_NAMESPACE_PROPERTY_NAME);
            GlobalVariables.getMessageMap().putError(GROUP_REVIEWER_NAMESPACE_PROPERTY_NAME, "error.required", new String[]{attributeLabel});
        }
        if (!StringUtils.isEmpty((String)groupName) && !StringUtils.isEmpty((String)groupNamespace) && (group = KimApiServiceLocator.getGroupService().getGroupByNamespaceCodeAndName(groupNamespace, groupName)) == null) {
            GlobalVariables.getMessageMap().putError(GROUP_REVIEWER_NAME_PROPERTY_NAME, "error.custom", new String[]{INVALID_WORKGROUP_ERROR});
        }
        if (!StringUtils.isEmpty((String)principalName) && (person = KimApiServiceLocator.getPersonService().getPersonByPrincipalName(principalName)) == null) {
            GlobalVariables.getMessageMap().putError(PERSON_REVIEWER_PROPERTY_NAME, "error.custom", new String[]{INVALID_PERSON_ERROR});
        }
        if (!GlobalVariables.getMessageMap().hasNoErrors()) {
            throw new ValidationException("errors in search criteria");
        }
    }

    public List<Column> getColumns() {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (Row row : this.getRows()) {
            for (Field field : row.getFields()) {
                Column newColumn = new Column();
                newColumn.setColumnTitle(field.getFieldLabel());
                newColumn.setMaxLength(field.getMaxLength());
                newColumn.setPropertyName(field.getPropertyName());
                columns.add(newColumn);
            }
        }
        return columns;
    }

    protected GroupService getGroupService() {
        return KimApiServiceLocator.getGroupService();
    }

    protected RuleTemplateService getRuleTemplateService() {
        return (RuleTemplateService)KEWServiceLocator.getService("enRuleTemplateService");
    }
}

