/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.memory.jca;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.apache.commons.transaction.memory.TransactionalMapWrapper;
import org.apache.commons.transaction.memory.jca.MapConnection;
import org.apache.commons.transaction.memory.jca.MapConnectionSpec;
import org.apache.commons.transaction.memory.jca.MapLocalTransaction;
import org.apache.commons.transaction.memory.jca.MapXAResource;
import org.apache.commons.transaction.memory.jca.MemoryMapResourceManager;

public class MapManagedConnection
implements ManagedConnection {
    MapXAResource xares = null;
    MapLocalTransaction tx = null;
    String name = null;
    TransactionalMapWrapper map = null;
    protected MapConnection connection = null;
    protected List listeners = new ArrayList();
    protected PrintWriter out;

    public MapManagedConnection(ConnectionRequestInfo cxRequestInfo) {
        this.name = ((MapConnectionSpec)cxRequestInfo).getName();
        this.map = MemoryMapResourceManager.getInstance().lookup(this.name);
        this.xares = new MapXAResource(this.map);
        this.tx = new MapLocalTransaction(this.map);
    }

    Map getMap() {
        return this.map;
    }

    public void close() {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((ConnectionEventListener)it.next()).connectionClosed(event);
        }
        this.connection.invalidate();
        this.connection = null;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (this.connection == null) {
            this.connection = new MapConnection(this);
        }
        return this.connection;
    }

    public void destroy() throws ResourceException {
        if (this.connection != null) {
            this.connection.invalidate();
            this.connection = null;
        }
        this.listeners = null;
        this.name = null;
        this.map = null;
        this.xares = null;
        this.tx = null;
    }

    public void cleanup() throws ResourceException {
        if (this.connection != null) {
            this.connection.invalidate();
        }
    }

    public void associateConnection(Object connection) throws ResourceException {
        if (!(connection instanceof MapConnection)) {
            throw new ResourceException("Connection is not of type MapConnection");
        }
        this.connection = (MapConnection)connection;
        this.connection.mc = this;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }

    public XAResource getXAResource() throws ResourceException {
        return this.xares;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this.tx;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.out = out;
        this.xares.setLoggerFacade(out);
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.out;
    }
}

