/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.JdbcType;
import org.apache.ojb.broker.metadata.JdbcTypesHelper;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.AbstractSequenceManager;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public class SequenceManagerMSSQLGuidImpl
extends AbstractSequenceManager {
    private static final JdbcType JDBC_TYPE_VARCHAR = JdbcTypesHelper.getJdbcTypeByName("varchar");

    public SequenceManagerMSSQLGuidImpl(PersistenceBroker persistenceBroker) {
        super(persistenceBroker);
    }

    @Override
    public Object getUniqueValue(FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        if (!fieldDescriptor.getJdbcType().equals(JDBC_TYPE_VARCHAR)) {
            throw new SequenceManagerException("This implementation only works with fields defined as VARCHAR, but given field was " + (fieldDescriptor != null ? fieldDescriptor.getJdbcType() : null));
        }
        Object object = this.getUniqueString(fieldDescriptor);
        object = fieldDescriptor.getFieldConversion().sqlToJava(object);
        return object;
    }

    protected String getUniqueString(FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        String string = null;
        try (ResultSetAndStatement resultSetAndStatement = null;){
            resultSetAndStatement = this.getBrokerForClass().serviceJdbcAccess().executeSQL("select newid()", fieldDescriptor.getClassDescriptor(), false);
            if (resultSetAndStatement.m_rs.next()) {
                string = resultSetAndStatement.m_rs.getString(1);
            } else {
                LoggerFactory.getDefaultLogger().error(this.getClass() + ": Can't lookup new oid for field " + fieldDescriptor);
            }
        }
        return string;
    }

    protected int getUniqueId(FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        throw new SequenceManagerException(SystemUtils.LINE_SEPARATOR + "Failure attempting to retrieve a Guid for a field that is an int -- field should be returned as a VARCHAR");
    }

    @Override
    protected long getUniqueLong(FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        throw new SequenceManagerException(SystemUtils.LINE_SEPARATOR + "Failure attempting to retrieve a Guid for a field that is a long -- field should be returned as a VARCHAR");
    }
}

