/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.framework.resourceloader;

import java.util.Set;
import javax.xml.namespace.QName;
import org.kuali.rice.core.framework.resourceloader.BaseResourceLoader;
import org.springframework.beans.factory.BeanFactory;

public class BeanFactoryResourceLoader
extends BaseResourceLoader {
    private final BeanFactory beanFactory;
    private final Set<String> beanNames;

    public BeanFactoryResourceLoader(QName name, BeanFactory beanFactory) {
        this(name, beanFactory, null);
    }

    public BeanFactoryResourceLoader(QName name, BeanFactory beanFactory, Set<String> beanNames) {
        super(name);
        this.beanFactory = beanFactory;
        this.beanNames = beanNames;
    }

    @Override
    public Object getService(QName serviceName) {
        String beanName = this.translateBeanName(serviceName);
        if ((this.beanNames == null || this.beanNames.contains(beanName)) && this.beanFactory.containsBean(beanName)) {
            return this.beanFactory.getBean(beanName);
        }
        return super.getService(serviceName);
    }

    protected String translateBeanName(QName serviceName) {
        return serviceName.toString();
    }
}

