/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krms.api.repository.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinition;
import org.kuali.rice.krms.api.repository.agenda.AgendaDefinitionContract;
import org.kuali.rice.krms.api.repository.context.ContextDefinitionContract;
import org.w3c.dom.Element;

@XmlRootElement(name="context")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="ContextDefinitionType", propOrder={"id", "namespace", "name", "typeId", "description", "active", "agendas", "attributes", "versionNumber", "_futureElements"})
public final class ContextDefinition
extends AbstractDataTransferObject
implements ContextDefinitionContract {
    private static final long serialVersionUID = -6639428234851623868L;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="namespace", required=true)
    private final String namespace;
    @XmlElement(name="typeId", required=false)
    private final String typeId;
    @XmlElement(name="description", required=false)
    private final String description;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlElementWrapper(name="agendas")
    @XmlElement(name="agenda", required=false)
    private final List<AgendaDefinition> agendas;
    @XmlElement(name="attributes", required=false)
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    private final Map<String, String> attributes;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private ContextDefinition() {
        this.id = null;
        this.name = null;
        this.namespace = null;
        this.typeId = null;
        this.description = null;
        this.active = true;
        this.agendas = null;
        this.versionNumber = null;
        this.attributes = null;
    }

    private ContextDefinition(Builder builder) {
        this.id = builder.getId();
        this.name = builder.getName();
        this.namespace = builder.getNamespace();
        this.active = builder.isActive();
        this.description = builder.getDescription();
        this.typeId = builder.getTypeId();
        this.agendas = ContextDefinition.constructAgendas(builder.getAgendas());
        this.versionNumber = builder.getVersionNumber();
        this.attributes = builder.getAttributes() != null ? Collections.unmodifiableMap(new HashMap<String, String>(builder.getAttributes())) : null;
    }

    private static List<AgendaDefinition> constructAgendas(List<AgendaDefinition.Builder> agendaBuilders) {
        ArrayList<AgendaDefinition> agendas = new ArrayList<AgendaDefinition>();
        if (agendaBuilders != null) {
            for (AgendaDefinition.Builder agendaBuilder : agendaBuilders) {
                agendas.add(agendaBuilder.build());
            }
        }
        return agendas;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTypeId() {
        return this.typeId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public boolean isActive() {
        return this.active;
    }

    public List<AgendaDefinition> getAgendas() {
        return Collections.unmodifiableList(this.agendas);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public static final class Builder
    implements ContextDefinitionContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = -219369603932108436L;
        private String id;
        private String namespace;
        private String name;
        private String typeId;
        private String description;
        private boolean active;
        private List<AgendaDefinition.Builder> agendas;
        private Map<String, String> attributes;
        private Long versionNumber;

        private Builder(String namespace, String name) {
            this.setNamespace(namespace);
            this.setName(name);
            this.setActive(true);
            this.setAgendas(new ArrayList());
            this.setAttributes(new HashMap<String, String>());
        }

        public static Builder create(String namespace, String name) {
            return new Builder(namespace, name);
        }

        public static Builder create(ContextDefinitionContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getNamespace(), contract.getName());
            builder.setId(contract.getId());
            builder.setTypeId(contract.getTypeId());
            builder.setDescription(contract.getDescription());
            builder.setActive(contract.isActive());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setAgendas(contract.getAgendas());
            if (contract.getAttributes() != null) {
                builder.setAttributes(new HashMap<String, String>(contract.getAttributes()));
            }
            return builder;
        }

        public ContextDefinition build() {
            return new ContextDefinition(this);
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getTypeId() {
            return this.typeId;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public boolean isActive() {
            return this.active;
        }

        public List<AgendaDefinition.Builder> getAgendas() {
            return this.agendas;
        }

        @Override
        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setId(String id) {
            if (id != null && StringUtils.isBlank((String)id)) {
                throw new IllegalArgumentException("context id is blank");
            }
            this.id = id;
        }

        public void setNamespace(String namespace) {
            if (StringUtils.isBlank((String)namespace)) {
                throw new IllegalArgumentException("namespace is blank");
            }
            this.namespace = namespace;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name is blank");
            }
            this.name = name;
        }

        public void setTypeId(String typeId) {
            this.typeId = typeId;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setAgendas(List<? extends AgendaDefinitionContract> agendaContracts) {
            this.agendas = new ArrayList<AgendaDefinition.Builder>();
            if (agendaContracts != null) {
                for (AgendaDefinitionContract agendaDefinitionContract : agendaContracts) {
                    this.agendas.add(AgendaDefinition.Builder.create(agendaDefinitionContract));
                }
            }
        }

        public void setAttributes(Map<String, String> attributes) {
            if (attributes == null) {
                this.attributes = Collections.emptyMap();
            }
            this.attributes = Collections.unmodifiableMap(attributes);
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/krms/v2_0/ContextDefinitionType";
    }

    public static class Elements {
        static final String ID = "id";
        static final String NAMESPACE = "namespace";
        static final String NAME = "name";
        static final String TYPE_ID = "typeId";
        static final String DESCRIPTION = "description";
        static final String ACTIVE = "active";
        static final String AGENDA = "agenda";
        static final String AGENDAS = "agendas";
        static final String ATTRIBUTES = "attributes";
    }

    public static class Constants {
        static final String ROOT_ELEMENT_NAME = "context";
        static final String TYPE_NAME = "ContextDefinitionType";
    }
}

