/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.parse.BeanTag;
import org.kuali.rice.krad.datadictionary.parse.BeanTagAttribute;
import org.kuali.rice.krad.datadictionary.parse.BeanTags;
import org.kuali.rice.krad.uif.component.BindingInfo;
import org.kuali.rice.krad.uif.component.Component;
import org.kuali.rice.krad.uif.component.DataBinding;
import org.kuali.rice.krad.uif.container.Group;
import org.kuali.rice.krad.uif.container.GroupBase;
import org.kuali.rice.krad.uif.control.CheckboxControl;
import org.kuali.rice.krad.uif.control.Control;
import org.kuali.rice.krad.uif.control.SelectControl;
import org.kuali.rice.krad.uif.control.TextControl;
import org.kuali.rice.krad.uif.element.Action;
import org.kuali.rice.krad.uif.element.Image;
import org.kuali.rice.krad.uif.element.Label;
import org.kuali.rice.krad.uif.element.Link;
import org.kuali.rice.krad.uif.element.Message;
import org.kuali.rice.krad.uif.field.DataField;
import org.kuali.rice.krad.uif.field.Field;
import org.kuali.rice.krad.uif.field.FieldGroup;
import org.kuali.rice.krad.uif.field.InputField;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycle;
import org.kuali.rice.krad.uif.lifecycle.ViewLifecycleUtils;
import org.kuali.rice.krad.uif.util.ComponentUtils;
import org.kuali.rice.krad.uif.util.LifecycleElement;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.ExpressionEvaluator;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.uif.widget.Inquiry;
import org.kuali.rice.krad.uif.widget.RichTable;
import org.kuali.rice.krad.uif.widget.Tooltip;
import org.kuali.rice.krad.util.KRADUtils;
import org.kuali.rice.krad.web.form.UifFormBase;

@BeanTags(value={@BeanTag(name="lightTable", parent="Uif-LightTableGroup"), @BeanTag(name="lightTableSection", parent="Uif-LightTableSection"), @BeanTag(name="lightTableSubSection", parent="Uif-LightTableSubSection")})
public class LightTable
extends GroupBase
implements DataBinding {
    private static final long serialVersionUID = -8930885219866835711L;
    private static final String VALUE_TOKEN = "@v@";
    private static final String EXPRESSION_TOKEN = "@e@";
    private static final String RENDER = "render";
    private static final String ID_TOKEN = "@id@";
    private static final String A_TOKEN = "@";
    private static final String ROW_CLASS = "@rowClass@";
    private static final String SORT_VALUE = "@sortVal";
    private static final String SEPARATOR = "@@@";
    private String propertyName;
    private BindingInfo bindingInfo;
    private List<Label> headerLabels;
    private RichTable richTable;
    private Map<String, String> conditionalRowCssClasses;
    private Map<String, String> expressionConversionMap = new HashMap<String, String>();
    private List<String> initialComponentIds = new ArrayList<String>();
    private Map<String, String> renderIdExpressionMap = new HashMap<String, String>();
    private boolean emptyTable;
    private String currentColumnValue;

    @Override
    public void performInitialization(Object model) {
        super.performInitialization(model);
        this.richTable.setForceLocalJsonData(true);
        if (this.bindingInfo != null) {
            this.bindingInfo.setDefaults(ViewLifecycle.getView(), this.getPropertyName());
        }
        List<? extends Component> items = this.getItems();
        ComponentUtils.clearAndAssignIds(items);
        for (Component component : this.getItems()) {
            this.initialComponentIds.add(component.getId());
            if (component instanceof DataField) {
                ((DataField)component).setForcedValue(VALUE_TOKEN + component.getId() + VALUE_TOKEN);
            }
            this.expressionConversionMap = this.buildExpressionMap(component, this.expressionConversionMap);
        }
    }

    protected Map<String, String> buildExpressionMap(Component item, Map<String, String> expressionMap) {
        if (item == null) {
            return expressionMap;
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        if (item.getExpressionGraph() != null && !item.getExpressionGraph().isEmpty()) {
            for (String name : item.getExpressionGraph().keySet()) {
                this.processExpression(name, item, expressionMap, toRemove);
            }
        }
        item.setId(ID_TOKEN + item.getId() + ID_TOKEN);
        if (item instanceof Group) {
            ((Group)item).getLayoutManager().setId(ID_TOKEN + ((Group)item).getLayoutManager().getId() + ID_TOKEN);
        }
        expressionMap = this.addChildExpressions(ViewLifecycleUtils.getElementsForLifecycle(item).values(), expressionMap);
        for (String name : toRemove) {
            item.getExpressionGraph().remove(name);
        }
        return expressionMap;
    }

    public void processExpression(String name, Component item, Map<String, String> expressionMap, List<String> toRemove) {
        Class<Object> clazz = ObjectPropertyUtils.getPropertyType(item, name);
        if (clazz == null) {
            return;
        }
        if (clazz.isAssignableFrom(String.class)) {
            expressionMap.put(name + SEPARATOR + item.getId(), item.getExpressionGraph().get(name));
            toRemove.add(name);
            ObjectPropertyUtils.setPropertyValue(item, name, EXPRESSION_TOKEN + name + SEPARATOR + item.getId() + EXPRESSION_TOKEN);
        } else if (name.endsWith(RENDER) && clazz.isAssignableFrom(Boolean.TYPE)) {
            Component renderComponent = item;
            if (!name.equals(RENDER)) {
                renderComponent = (Component)ObjectPropertyUtils.getPropertyValue(item, StringUtils.removeEnd((String)name, (String)".render"));
            }
            this.renderIdExpressionMap.put(renderComponent.getId(), item.getExpressionGraph().get(name));
            toRemove.add(name);
            String renderMarker = "@render@" + renderComponent.getId() + A_TOKEN;
            String pre = renderComponent.getPreRenderContent() == null ? "" : renderComponent.getPreRenderContent();
            renderComponent.setPreRenderContent(renderMarker + pre);
            String post = renderComponent.getPostRenderContent() == null ? "" : renderComponent.getPostRenderContent();
            renderComponent.setPostRenderContent(post + renderMarker);
            ObjectPropertyUtils.setPropertyValue(item, name, true);
        }
    }

    protected Map<String, String> addChildExpressions(Collection<? extends LifecycleElement> components, Map<String, String> expressionMap) {
        for (LifecycleElement lifecycleElement : components) {
            if (lifecycleElement == null || !(lifecycleElement instanceof Action) && !(lifecycleElement instanceof Image) && !(lifecycleElement instanceof Message) && !(lifecycleElement instanceof Link) && !(lifecycleElement instanceof Inquiry) && !(lifecycleElement instanceof Group) && !(lifecycleElement instanceof Tooltip) && !(lifecycleElement instanceof InputField) && !(lifecycleElement instanceof CheckboxControl) && !(lifecycleElement instanceof TextControl) && !(lifecycleElement instanceof SelectControl)) continue;
            expressionMap = this.buildExpressionMap((Component)lifecycleElement, expressionMap);
        }
        return expressionMap;
    }

    @Override
    public void performFinalize(Object model, LifecycleElement parent) {
        super.performFinalize(model, parent);
        this.headerLabels = new ArrayList<Label>();
        for (Component component : this.getItems()) {
            if (component instanceof Field) {
                this.headerLabels.add(ComponentUtils.copy(((Field)component).getFieldLabel()));
                ((Field)component).getFieldLabel().setRender(false);
            } else {
                this.headerLabels.add(null);
            }
            if (component instanceof FieldGroup) {
                ((FieldGroup)component).getGroup().setValidationMessages(null);
            }
            if (component instanceof DataField) {
                ((DataField)component).getBindingInfo().setBindByNamePrefix(this.getBindingInfo().getBindingPath() + "[0]");
            }
            if (!(component instanceof InputField)) continue;
            ViewLifecycle.getViewPostMetadata().addAccessibleBindingPath(this.getBindingInfo().getBindingPath() + "[*]." + ((DataField)component).getPropertyName());
        }
        Object collectionValue = ObjectPropertyUtils.getPropertyValue(model, this.bindingInfo.getBindingPath());
        if (collectionValue == null || !(collectionValue instanceof Collection) || ((Collection)collectionValue).isEmpty()) {
            this.emptyTable = true;
        }
    }

    public void buildRows(View view, String rowTemplate, UifFormBase model) {
        if (StringUtils.isBlank((String)rowTemplate)) {
            return;
        }
        rowTemplate = StringUtils.removeEnd((String)rowTemplate, (String)",");
        rowTemplate = rowTemplate.replace("\n", "");
        rowTemplate = rowTemplate.replace("\r", "");
        StringBuffer rows = new StringBuffer();
        List collectionObjects = (List)ObjectPropertyUtils.getPropertyValue(model, this.bindingInfo.getBindingPath());
        rowTemplate = rowTemplate.replace("checked=\"checked\"", "");
        Pattern idPattern = Pattern.compile("@id@(.*?)@id@");
        Pattern expressionPattern = Pattern.compile("@e@(.*?)@e@");
        ExpressionEvaluator expressionEvaluator = ViewLifecycle.getExpressionEvaluator();
        expressionEvaluator.initializeEvaluationContext(model);
        int lineIndex = 0;
        for (Object obj : collectionObjects) {
            Object row = idPattern.matcher(rowTemplate).replaceAll("$1_line" + lineIndex);
            HashMap<String, Object> expandedContext = new HashMap<String, Object>();
            expandedContext.put("line", obj);
            expandedContext.put("index", lineIndex);
            expandedContext.put("view", view);
            this.currentColumnValue = "";
            int itemIndex = 0;
            for (Component component : this.getItems()) {
                String originalId = this.initialComponentIds.get(itemIndex);
                row = this.handleDataFieldInRow(component, obj, (String)row, lineIndex, originalId);
                row = this.handleInputFieldInRow(component, obj, (String)row, lineIndex, originalId);
                if (component.getContext() != null) {
                    expandedContext.putAll(component.getContext());
                }
                row = this.evaluateAndReplaceExpressionValues((String)row, lineIndex, model, expandedContext, expressionPattern, expressionEvaluator);
                if (this.currentColumnValue == null) {
                    this.currentColumnValue = "";
                }
                row = ((String)row).replace(SORT_VALUE + itemIndex + A_TOKEN, this.currentColumnValue);
                ++itemIndex;
            }
            boolean isOdd = lineIndex % 2 == 0;
            String string = KRADUtils.generateRowCssClassString(this.conditionalRowCssClasses, lineIndex, isOdd, expandedContext, expressionEvaluator);
            row = ((String)row).replace("\"", "\\\"");
            row = ((String)row).replace(ROW_CLASS, string);
            row = "{" + (String)row + "},";
            row = this.evaluateRenderExpressions((String)row, lineIndex, model, expandedContext, expressionEvaluator);
            rows.append((String)row);
            ++lineIndex;
        }
        StringBuffer tableToolsColumnOptions = new StringBuffer("[");
        for (int index = 0; index < this.getItems().size(); ++index) {
            String colOptions = this.richTable.constructTableColumnOptions(index, true, false, String.class, null);
            tableToolsColumnOptions.append(colOptions + " , ");
        }
        String aoColumnDefs = StringUtils.removeEnd((String)tableToolsColumnOptions.toString(), (String)" , ") + "]";
        Map<String, String> rtTemplateOptions = this.richTable.getTemplateOptions();
        if (rtTemplateOptions == null) {
            rtTemplateOptions = new HashMap<String, String>();
            this.richTable.setTemplateOptions(rtTemplateOptions);
        }
        rtTemplateOptions.put("aoColumnDefs", aoColumnDefs);
        Object aaData = StringUtils.removeEnd((String)rows.toString(), (String)",");
        aaData = "[" + (String)aaData + "]";
        aaData = ((String)aaData).replace("@quot@", "\"");
        rtTemplateOptions.put("aaData", (String)aaData);
        rtTemplateOptions.put("bDeferRender", "true");
    }

    protected String evaluateAndReplaceExpressionValues(String row, int index, Object model, Map<String, Object> expandedContext, Pattern expressionPattern, ExpressionEvaluator expressionEvaluator) {
        Matcher matcher = expressionPattern.matcher(row);
        while (matcher.find()) {
            String matchingGroup = matcher.group(1);
            String expression = this.expressionConversionMap.get(matchingGroup);
            String value = expressionEvaluator.evaluateExpressionTemplate(expandedContext, expression = expression.replace("#lp.", this.getBindingInfo().getBindingPath() + "[" + index + "]."));
            if (value != null) {
                row = row.replace(matcher.group(), value.toString());
                continue;
            }
            row = row.replace(matcher.group(), "");
        }
        return row;
    }

    protected String evaluateRenderExpressions(String row, int index, Object model, Map<String, Object> expandedContext, ExpressionEvaluator expressionEvaluator) {
        for (String id : this.renderIdExpressionMap.keySet()) {
            String expression = this.renderIdExpressionMap.get(id);
            expression = expression.replace("#lp.", this.getBindingInfo().getBindingPath() + "[" + index + "].");
            String value = expressionEvaluator.evaluateExpressionTemplate(expandedContext, expression);
            String wrap = "@render@" + id + A_TOKEN;
            if (value != null && value instanceof String && !Boolean.parseBoolean(value)) {
                row = row.replaceAll(wrap + "(.|\\s)*?" + wrap, "");
                continue;
            }
            row = row.replaceAll(wrap, "");
        }
        return row;
    }

    protected String handleDataFieldInRow(Component item, Object obj, String row, int index, String originalId) {
        if (!(item instanceof DataField)) {
            return row;
        }
        String currentValue = ObjectPropertyUtils.getPropertyValueAsText(obj, ((DataField)item).getPropertyName());
        if (currentValue == null) {
            currentValue = "";
        }
        row = row.replaceAll(VALUE_TOKEN + originalId + VALUE_TOKEN, currentValue);
        this.currentColumnValue = currentValue;
        Inquiry dataFieldInquiry = ((DataField)item).getInquiry();
        if (dataFieldInquiry != null && dataFieldInquiry.getInquiryParameters() != null && dataFieldInquiry.getInquiryLink() != null) {
            String inquiryLinkId = dataFieldInquiry.getInquiryLink().getId().replace(ID_TOKEN, "") + "_line" + index;
            for (String key : dataFieldInquiry.getInquiryParameters().keySet()) {
                String name = dataFieldInquiry.getInquiryParameters().get(key);
                if (!ObjectPropertyUtils.isReadableProperty(obj, key = key.replace(((DataField)item).getBindingInfo().getBindByNamePrefix() + ".", ""))) continue;
                String value = ObjectPropertyUtils.getPropertyValueAsText(obj, key);
                row = row.replaceFirst("(" + inquiryLinkId + "(.|\\s)*?" + name + ")=.*?([&|\"])", "$1=" + value + "$3");
            }
        }
        return row;
    }

    protected String handleInputFieldInRow(Component item, Object obj, String row, int index, String originalId) {
        if (!(item instanceof InputField) || ((InputField)item).getControl() == null) {
            return row;
        }
        Control control = ((InputField)item).getControl();
        row = row.replace("name=\"" + ((InputField)item).getBindingInfo().getBindingPath() + "\"", "name=\"" + this.getBindingInfo().getBindingPath() + "[" + index + "]." + ((InputField)item).getPropertyName() + "\"");
        Object value = ObjectPropertyUtils.getPropertyValue(obj, ((InputField)item).getPropertyName());
        Object stringValue = "";
        if (value == null) {
            stringValue = "";
        } else if (value.getClass().isAssignableFrom(Boolean.TYPE)) {
            stringValue = String.valueOf(value);
        } else if (!(value instanceof Collection)) {
            stringValue = ObjectPropertyUtils.getPropertyValueAsText(obj, ((InputField)item).getPropertyName());
        }
        String controlId = originalId + "_line" + index + "_control";
        if (control instanceof CheckboxControl && ((String)stringValue).equalsIgnoreCase("true")) {
            row = row.replaceAll("(id(\\s)*?=(\\s)*?\"" + controlId + "\")", "$1 checked=\"checked\" ");
        } else if (control instanceof TextControl) {
            row = row.replaceAll("(id(\\s)*?=(\\s)*?\"" + controlId + "\"(.|\\s)*?value=\")(.|\\s)*?\"", "$1" + (String)stringValue + "\"");
        } else if (control instanceof SelectControl && !((SelectControl)control).isMultiple()) {
            Pattern pattern = Pattern.compile("<select(\\s)*?id(\\s)*?=(\\s)*?\"" + controlId + "\"(.|\\s)*?</select>");
            Matcher matcher = pattern.matcher(row);
            String replacement = "";
            if (matcher.find()) {
                String selected = "selected=\"selected\"";
                replacement = matcher.group().replace(selected, "");
                String selectedValue = "value=\"" + (String)stringValue + "\"";
                replacement = replacement.replace(selectedValue, selectedValue + " " + selected);
            }
            if (StringUtils.isNotBlank((String)replacement)) {
                row = matcher.replaceAll(replacement);
            }
        }
        this.currentColumnValue = stringValue;
        return row;
    }

    @Override
    @BeanTagAttribute
    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    @BeanTagAttribute
    public BindingInfo getBindingInfo() {
        return this.bindingInfo;
    }

    @Override
    public void setBindingInfo(BindingInfo bindingInfo) {
        this.bindingInfo = bindingInfo;
    }

    public List<Label> getHeaderLabels() {
        return this.headerLabels;
    }

    @BeanTagAttribute
    public RichTable getRichTable() {
        return this.richTable;
    }

    public void setRichTable(RichTable richTable) {
        this.richTable = richTable;
    }

    @BeanTagAttribute
    public Map<String, String> getConditionalRowCssClasses() {
        return this.conditionalRowCssClasses;
    }

    public void setConditionalRowCssClasses(Map<String, String> conditionalRowCssClasses) {
        this.conditionalRowCssClasses = conditionalRowCssClasses;
    }

    public boolean isEmptyTable() {
        return this.emptyTable;
    }

    public void setHeaderLabels(List<Label> headerLabels) {
        this.headerLabels = headerLabels;
    }

    public void setExpressionConversionMap(Map<String, String> expressionConversionMap) {
        this.expressionConversionMap = expressionConversionMap;
    }

    public Map<String, String> getExpressionConversionMap() {
        return this.expressionConversionMap;
    }

    public List<String> getInitialComponentIds() {
        return this.initialComponentIds;
    }

    public Map<String, String> getRenderIdExpressionMap() {
        return this.renderIdExpressionMap;
    }

    public void setInitialComponentIds(List<String> initialComponentIds) {
        this.initialComponentIds = initialComponentIds;
    }

    public void setRenderIdExpressionMap(Map<String, String> renderIdExpressionMap) {
        this.renderIdExpressionMap = renderIdExpressionMap;
    }

    public void setEmptyTable(boolean emptyTable) {
        this.emptyTable = emptyTable;
    }

    @BeanTagAttribute(name="currentColumnValue")
    protected String getCurrentColumnValue() {
        return this.currentColumnValue;
    }

    protected void setCurrentColumnValue(String currentColumnValue) {
        this.currentColumnValue = currentColumnValue;
    }
}

