/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.nio.ReadbackStrategy;
import com.terracottatech.frs.io.nio.SegmentHeaders;
import java.io.IOException;
import java.nio.ByteBuffer;

abstract class AbstractReadbackStrategy
implements ReadbackStrategy {
    private volatile boolean closedDetected = false;

    protected boolean isCloseDetected() {
        return this.closedDetected;
    }

    protected ByteBuffer[] readChunk(Chunk buffer) throws IOException {
        if (!buffer.hasRemaining()) {
            return null;
        }
        if (buffer.remaining() < 4L) {
            return null;
        }
        int start = buffer.getInt();
        if (!SegmentHeaders.CHUNK_START.validate(start)) {
            if (SegmentHeaders.CLOSE_FILE.validate(start)) {
                this.closedDetected = true;
            }
            return null;
        }
        if (buffer.remaining() < 8L) {
            return null;
        }
        long length = buffer.getLong();
        if (buffer.remaining() < length + 8L + 8L + 4L) {
            return null;
        }
        ByteBuffer[] targets = buffer.getBuffers(length);
        if (length != buffer.getLong()) {
            return null;
        }
        buffer.getLong();
        if (!SegmentHeaders.FILE_CHUNK.validate(buffer.getInt())) {
            return null;
        }
        return targets;
    }

    protected long[] readJumpList(ByteBuffer buffer) throws IOException {
        int LAST_INT_WORD_IN_CHUNK = buffer.position() + buffer.remaining() - 4;
        int LAST_INT_WORD_BEFORE_JUMP_MARK = LAST_INT_WORD_IN_CHUNK - 4;
        if (!buffer.hasRemaining()) {
            return null;
        }
        int jump = buffer.getInt(LAST_INT_WORD_IN_CHUNK);
        if (SegmentHeaders.JUMP_LIST.validate(jump)) {
            int numberOfChunks = buffer.getInt(LAST_INT_WORD_BEFORE_JUMP_MARK);
            if (numberOfChunks < 0) {
                return null;
            }
            int reach = numberOfChunks * 4;
            int EXPECTED_CLOSE_POSITION = LAST_INT_WORD_BEFORE_JUMP_MARK - reach - 4;
            if (EXPECTED_CLOSE_POSITION < 0) {
                return null;
            }
            int cfm = buffer.getInt(EXPECTED_CLOSE_POSITION);
            if (SegmentHeaders.CLOSE_FILE.validate(cfm)) {
                long[] jumps = new long[numberOfChunks];
                long last = 0L;
                for (int x = 0; x < numberOfChunks; ++x) {
                    int value = buffer.getInt(EXPECTED_CLOSE_POSITION + 4 + x * 4);
                    if (value < 0) {
                        return null;
                    }
                    jumps[x] = last += (long)value;
                }
                this.closedDetected = true;
                return jumps;
            }
        }
        return null;
    }
}

