/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.core.api.util.type;

import com.google.common.collect.MapMaker;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentMap;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;

public class TypeUtils {
    protected static Collection<Class<?>> BOOLEAN_CLASSES = TypeUtils.add(Boolean.class, Boolean.TYPE);
    protected static Collection<Class<?>> INTEGRAL_CLASSES = TypeUtils.add(Byte.class, Byte.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, BigInteger.class, KualiInteger.class);
    protected static Collection<Class<?>> DECIMAL_CLASSES = TypeUtils.add(Float.class, Float.TYPE, Double.class, Double.TYPE, BigDecimal.class, AbstractKualiDecimal.class, KualiDecimal.class);
    protected static Collection<Class<?>> TEMPORAL_CLASSES = TypeUtils.add(java.util.Date.class, Date.class, Timestamp.class, LocalDate.class, DateTime.class);
    protected static Collection<Class<?>> STRING_CLASSES = Collections.singleton(CharSequence.class);
    protected static Collection<Class<?>> CLASS_CLASSES = Collections.singleton(Class.class);
    protected static Collection<Class<?>> SIMPLE_CLASSES = TypeUtils.add(BOOLEAN_CLASSES, INTEGRAL_CLASSES, DECIMAL_CLASSES, TEMPORAL_CLASSES, STRING_CLASSES);
    private static final ConcurrentMap<Class<?>, Boolean> IS_BOOLEAN_CACHE = new MapMaker().weakKeys().makeMap();
    private static final ConcurrentMap<Class<?>, Boolean> IS_INTEGRAL_CACHE = new MapMaker().weakKeys().makeMap();
    private static final ConcurrentMap<Class<?>, Boolean> IS_DECIMAL_CACHE = new MapMaker().weakKeys().makeMap();
    private static final ConcurrentMap<Class<?>, Boolean> IS_TEMPORAL_CACHE = new MapMaker().weakKeys().makeMap();
    private static final ConcurrentMap<Class<?>, Boolean> IS_STRING_CACHE = new MapMaker().weakKeys().makeMap();
    private static final ConcurrentMap<Class<?>, Boolean> IS_SIMPLE_CACHE = new MapMaker().weakKeys().makeMap();
    private static final ConcurrentMap<Class<?>, Boolean> IS_CACHE_CACHE = new MapMaker().weakKeys().makeMap();

    private TypeUtils() {
        throw new UnsupportedOperationException("do not call.");
    }

    public static boolean isBooleanClass(Class<?> clazz) {
        return TypeUtils.is(clazz, BOOLEAN_CLASSES, IS_BOOLEAN_CACHE);
    }

    public static boolean isIntegralClass(Class<?> clazz) {
        return TypeUtils.is(clazz, INTEGRAL_CLASSES, IS_INTEGRAL_CACHE);
    }

    public static boolean isDecimalClass(Class<?> clazz) {
        return TypeUtils.is(clazz, DECIMAL_CLASSES, IS_DECIMAL_CACHE);
    }

    public static boolean isTemporalClass(Class<?> clazz) {
        return TypeUtils.is(clazz, TEMPORAL_CLASSES, IS_TEMPORAL_CACHE);
    }

    public static boolean isStringClass(Class<?> clazz) {
        return TypeUtils.is(clazz, STRING_CLASSES, IS_STRING_CACHE);
    }

    public static boolean isClassClass(Class<?> clazz) {
        return TypeUtils.is(clazz, CLASS_CLASSES, IS_CACHE_CACHE);
    }

    public static boolean isSimpleType(Class<?> clazz) {
        return TypeUtils.is(clazz, SIMPLE_CLASSES, IS_SIMPLE_CACHE);
    }

    private static boolean is(Class<?> clazz, Collection<Class<?>> clazzes, ConcurrentMap<Class<?>, Boolean> cache) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        if (clazzes == null) {
            throw new IllegalArgumentException("clazzes is null");
        }
        if (cache == null) {
            throw new IllegalArgumentException("cache is null");
        }
        Boolean result = (Boolean)cache.get(clazz);
        if (result == null) {
            result = TypeUtils.isa(clazzes, clazz);
            cache.putIfAbsent(clazz, result);
        }
        return result;
    }

    private static boolean isa(Collection<Class<?>> types, Class<?> type) {
        for (Class<?> cur : types) {
            if (!cur.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    private static Collection<Class<?>> add(Class<?> ... classes) {
        ArrayList arrayClasses = new ArrayList();
        for (Class<?> clazz : classes) {
            arrayClasses.add(clazz);
        }
        return arrayClasses;
    }

    private static Collection<Class<?>> add(Collection<Class<?>> ... classes) {
        ArrayList temp = new ArrayList();
        for (Collection<Class<?>> clazz : classes) {
            temp.addAll(clazz);
        }
        return temp;
    }

    public static void addToDecimalType(Class<?> clazz) {
        DECIMAL_CLASSES.add(clazz);
    }

    public static void addToIntegralType(Class<?> clazz) {
        INTEGRAL_CLASSES.add(clazz);
    }

    public static void addToTemporalType(Class<?> clazz) {
        TEMPORAL_CLASSES.add(clazz);
    }

    public static void addToStringType(Class<?> clazz) {
        STRING_CLASSES.add(clazz);
    }

    public static void addToBooleanType(Class<?> clazz) {
        BOOLEAN_CLASSES.add(clazz);
    }
}

