/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.ksb.messaging.serviceconnectors;

import java.util.HashSet;
import java.util.Set;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.util.ClassLoaderUtils;

public enum HttpClientParams {
    USE_EXPECT_CONTINUE("http.protocol.expect-continue", Boolean.class),
    HTTP_CONTENT_CHARSET("http.protocol.content-charset"),
    COOKIE_POLICY("http.protocol.cookie-policy"),
    SO_TIMEOUT("http.socket.timeout", Integer.class),
    TCP_NODELAY("http.tcp.nodelay", Boolean.class),
    SO_SNDBUF("http.socket.sendbuffer", Integer.class),
    SO_RCVBUF("http.socket.receivebuffer", Integer.class),
    SO_LINGER("http.socket.linger", Integer.class),
    CONNECTION_TIMEOUT("http.connection.timeout", Integer.class),
    STALE_CONNECTION_CHECK("http.connection.stalecheck", Boolean.class),
    MAX_TOTAL_CONNECTIONS("http.connection-manager.max-total", Integer.class),
    CONNECTION_MANAGER_TIMEOUT("http.connection-manager.timeout", Integer.class),
    REJECT_RELATIVE_REDIRECT("http.protocol.reject-relative-redirect", Boolean.class),
    MAX_REDIRECTS("http.protocol.max-redirects", Integer.class),
    ALLOW_CIRCULAR_REDIRECTS("http.protocol.allow-circular-redirects", Boolean.class);

    private String paramName;
    private Class paramValueClass;
    private static final Set<String> supportedParamNames;

    private HttpClientParams(String paramName, Class paramValueClass) {
        this.paramName = paramName;
        this.paramValueClass = paramValueClass;
    }

    private HttpClientParams(String paramName) {
        this(paramName, String.class);
    }

    public <T> T getValue() {
        return this.getValueOrDefault(null);
    }

    public <T> T getValueOrDefault(T defaultValue) {
        Class<?> value = null;
        String strValue = ConfigContext.getCurrentContextConfig().getProperty(this.getParamName());
        if (strValue == null) {
            return defaultValue;
        }
        Class paramType = this.getParamValueClass();
        if (paramType.equals(Boolean.class)) {
            value = ConfigContext.getCurrentContextConfig().getBooleanProperty(this.getParamName());
        } else if (paramType.equals(Integer.class)) {
            value = Integer.valueOf(strValue);
        } else if (paramType.equals(Long.class)) {
            value = Long.valueOf(strValue);
        } else if (paramType.equals(Double.class)) {
            value = Double.valueOf(strValue);
        } else if (paramType.equals(String.class)) {
            value = strValue;
        } else if (paramType.equals(Class.class)) {
            try {
                value = Class.forName(ConfigContext.getCurrentContextConfig().getProperty(this.getParamName()), true, ClassLoaderUtils.getDefaultClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not locate the class needed to configure the HttpClient.", e);
            }
        } else {
            throw new RuntimeException("Attempted to configure an HttpClient parameter '" + this.getParamName() + "' of a type not supported through Workflow configuration: " + this.getParamValueClass().getName());
        }
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public String getParamName() {
        return this.paramName;
    }

    public Class getParamValueClass() {
        return this.paramValueClass;
    }

    static {
        supportedParamNames = new HashSet<String>();
    }
}

