/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.notifications;

import java.util.List;
import org.kuali.coeus.common.framework.mail.EmailAttachment;
import org.kuali.coeus.common.notification.impl.NotificationContextBase;
import org.kuali.coeus.common.notification.impl.NotificationRenderer;
import org.kuali.coeus.common.notification.impl.service.KcNotificationModuleRoleService;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.negotiations.document.NegotiationDocument;
import org.kuali.kra.negotiations.notifications.NegotiationNotificationRenderer;
import org.kuali.kra.negotiations.notifications.NegotiationNotificationRoleQualifierService;

public class NegotiationNotificationContext
extends NotificationContextBase {
    private static final long serialVersionUID = 8162094790526199178L;
    private NegotiationDocument negotiationDocument;
    private String documentNumber;
    private String actionTypeCode;
    private String contextName;
    private List<EmailAttachment> emailAttachments;

    public NegotiationNotificationContext(NegotiationDocument negotiationDocument, String actionTypeCode, String contextName, NotificationRenderer renderer) {
        super(renderer);
        this.negotiationDocument = negotiationDocument;
        this.documentNumber = negotiationDocument.getDocumentNumber();
        this.actionTypeCode = actionTypeCode;
        this.contextName = contextName;
        this.setNotificationService(KcServiceLocator.getService(KcNotificationService.class));
        this.setNotificationModuleRoleService(KcServiceLocator.getService(KcNotificationModuleRoleService.class));
        this.setNotificationRoleQualifierService(KcServiceLocator.getService(NegotiationNotificationRoleQualifierService.class));
        ((NegotiationNotificationRenderer)this.getRenderer()).setNegotiation(negotiationDocument.getNegotiation());
        ((NegotiationNotificationRoleQualifierService)this.getNotificationRoleQualifierService()).setNegotiation(negotiationDocument.getNegotiation());
    }

    public NegotiationNotificationContext(NegotiationDocument negotiationDocument, String actionTypeCode, String contextName) {
        this(negotiationDocument, actionTypeCode, contextName, KcServiceLocator.getService(NegotiationNotificationRenderer.class));
    }

    @Override
    public String getModuleCode() {
        return "5";
    }

    @Override
    public String getActionTypeCode() {
        return this.actionTypeCode;
    }

    @Override
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    @Override
    public String getContextName() {
        return this.contextName;
    }

    @Override
    public List<EmailAttachment> getEmailAttachments() {
        return this.emailAttachments;
    }

    public void setEmailAttachments(List<EmailAttachment> emailAttachments) {
        this.emailAttachments = emailAttachments;
    }

    public NegotiationDocument getNegotiationDocument() {
        return this.negotiationDocument;
    }

    public void setNegotiationDocument(NegotiationDocument negotiationDocument) {
        this.negotiationDocument = negotiationDocument;
    }
}

