<!--
  #%L
  %%
  Copyright (C) 2014 - 2025 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  -->

<xsl:stylesheet version="1.0"
				xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:fo="http://www.w3.org/1999/XSL/Format"
				xmlns:SupplementaryCoverSheetforNEHGrantPrograms_3_0="http://apply.grants.gov/forms/SupplementaryCoverSheetforNEHGrantPrograms_3_0-V3.0"
				xmlns:footer="http://apply.grants.gov/system/Footer-V1.0"
				xmlns:att="http://apply.grants.gov/system/Attachments-V1.0"
				xmlns:glob="http://apply.grants.gov/system/Global-V1.0"
				xmlns:globLib="http://apply.grants.gov/system/GlobalLibrary-V2.0"
				xmlns:xs="http://www.w3.org/2001/XMLSchema">
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.4in" margin-right="0.4in">
				<fo:region-body margin-top="0.9in" margin-bottom="0.6in"/>
				<fo:region-before extent=".5in"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="SupplementaryCoverSheetforNEHGrantPrograms_3_0:SupplementaryCoverSheetforNEHGrantPrograms_3_0">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
				<fo:static-content flow-name="xsl-region-before">
					<fo:table width="100%" space-before.optimum="0pt" space-after.optimum="0pt" table-layout="fixed">
						<fo:table-column column-width="proportional-column-width(100)"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell  hyphenate="true" language="en" line-height="9pt" padding-start="0pt" padding-end="0pt" padding-before="1pt" padding-after="1pt" display-align="before" text-align="right" border-style="solid" border-width="0pt" border-color="white">
									<fo:block>
										<fo:inline font-size="5px" font-weight="100">OMB Number: 3136-0134</fo:inline>
									</fo:block>
									<fo:block>
										<fo:inline font-size="5px" font-weight="100">Expiration Date: 6/30/2024</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="center">
										<fo:inline font-size="12pt">Supplementary Cover Sheet for NEH Grant Programs</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<fo:block font-weight="bold" font-size="8pt">
						<fo:table border-left-style="none" border-right-style="none" border-top-style="solid" border-bottom-style="none" border-color="black" space-before.optimum="10pt" space-after.optimum="2pt" border-width="1pt" width="100%" table-layout="fixed">
							<fo:table-column column-width="proportional-column-width(1)"/>
							<fo:table-body>
								<fo:table-row border-left-style="none" border-right-style="none" border-top-style="solid" border-bottom-style="solid">
									<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" border-before-width="0pt" border-color="black" border-width="1pt">
										<fo:block>
											<fo:table width="100%" table-layout="fixed">
												<fo:table-column column-width="proportional-column-width(20)"/>
												<fo:table-column column-width="proportional-column-width(20)"/>
												<fo:table-column column-width="proportional-column-width(60)"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>1. Project Director</fo:block>
														</fo:table-cell>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>Major Field of Study</fo:block>
														</fo:table-cell>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>
																<fo:inline font-weight="100">
																	<xsl:for-each select="SupplementaryCoverSheetforNEHGrantPrograms_3_0:PDMajorField">
																		<xsl:choose>
																			<xsl:when test=".='10'"><fo:inline>History: Near and Middle Eastern History</fo:inline></xsl:when>
																			<xsl:when test=".='101'"><fo:inline>Interdisciplinary: Ethnic Studies</fo:inline></xsl:when>
																			<xsl:when test=".='102'"><fo:inline>Interdisciplinary: Native American Studies</fo:inline></xsl:when>
																			<xsl:when test=".='103'"><fo:inline>Interdisciplinary: Hispanic American Studies</fo:inline></xsl:when>
																			<xsl:when test=".='104'"><fo:inline>Interdisciplinary: African American Studies</fo:inline></xsl:when>
																			<xsl:when test=".='105'"><fo:inline>Interdisciplinary: Asian American Studies</fo:inline></xsl:when>
																			<xsl:when test=".='106'"><fo:inline>Interdisciplinary: Jewish Studies</fo:inline></xsl:when>
																			<xsl:when test=".='108'"><fo:inline>Social Science: Anthropology</fo:inline></xsl:when>
																			<xsl:when test=".='11'"><fo:inline>History: Russian History</fo:inline></xsl:when>
																			<xsl:when test=".='110'"><fo:inline>Arts: Art History and Criticism</fo:inline></xsl:when>
																			<xsl:when test=".='111'"><fo:inline>Arts: Theater History and Criticism</fo:inline></xsl:when>
																			<xsl:when test=".='112'"><fo:inline>Arts: Dance History and Criticism</fo:inline></xsl:when>
																			<xsl:when test=".='113'"><fo:inline>Arts: Film History and Criticism</fo:inline></xsl:when>
																			<xsl:when test=".='114'"><fo:inline>Arts: Music History and Criticism</fo:inline></xsl:when>
																			<xsl:when test=".='117'"><fo:inline>Arts: General</fo:inline></xsl:when>
																			<xsl:when test=".='119'"><fo:inline>Social Science: Economics</fo:inline></xsl:when>
																			<xsl:when test=".='12'"><fo:inline>History: South Asian History</fo:inline></xsl:when>
																			<xsl:when test=".='120'"><fo:inline>Other: Business</fo:inline></xsl:when>
																			<xsl:when test=".='123'"><fo:inline>Communications: Composition and Rhetoric</fo:inline></xsl:when>
																			<xsl:when test=".='124'"><fo:inline>Communications: Communications</fo:inline></xsl:when>
																			<xsl:when test=".='1245'"><fo:inline>History: General</fo:inline></xsl:when>
																			<xsl:when test=".='1246'"><fo:inline>History: African History</fo:inline></xsl:when>
																			<xsl:when test=".='1247'"><fo:inline>History: British History</fo:inline></xsl:when>
																			<xsl:when test=".='1248'"><fo:inline>Philosophy: Epistemology</fo:inline></xsl:when>
																			<xsl:when test=".='1249'"><fo:inline>Philosophy: Ethics</fo:inline></xsl:when>
																			<xsl:when test=".='125'"><fo:inline>Interdisciplinary: Media Studies</fo:inline></xsl:when>
																			<xsl:when test=".='126'"><fo:inline>Communications: Journalism</fo:inline></xsl:when>
																			<xsl:when test=".='127'"><fo:inline>Law: Law and Jurisprudence</fo:inline></xsl:when>
																			<xsl:when test=".='129'"><fo:inline>Interdisciplinary: Folklore and Folklife</fo:inline></xsl:when>
																			<xsl:when test=".='13'"><fo:inline>History: Ancient History</fo:inline></xsl:when>
																			<xsl:when test=".='130'"><fo:inline>Social Science: Sociology</fo:inline></xsl:when>
																			<xsl:when test=".='132'"><fo:inline>Other: Natural Sciences</fo:inline></xsl:when>
																			<xsl:when test=".='140'"><fo:inline>Interdisciplinary: General</fo:inline></xsl:when>
																			<xsl:when test=".='141'"><fo:inline>Social Science: General</fo:inline></xsl:when>
																			<xsl:when test=".='142'"><fo:inline>Arts: Architecture</fo:inline></xsl:when>
																			<xsl:when test=".='144'"><fo:inline>Social Science: Psychology</fo:inline></xsl:when>
																			<xsl:when test=".='145'"><fo:inline>Social Science: Archaeology</fo:inline></xsl:when>
																			<xsl:when test=".='146'"><fo:inline>Social Science: Geography</fo:inline></xsl:when>
																			<xsl:when test=".='15'"><fo:inline>Philosophy: General</fo:inline></xsl:when>
																			<xsl:when test=".='16'"><fo:inline>Philosophy: Aesthetics</fo:inline></xsl:when>
																			<xsl:when test=".='19'"><fo:inline>Philosophy: History of Philosophy</fo:inline></xsl:when>
																			<xsl:when test=".='20'"><fo:inline>Philosophy: Logic</fo:inline></xsl:when>
																			<xsl:when test=".='21'"><fo:inline>Philosophy: Metaphysics</fo:inline></xsl:when>
																			<xsl:when test=".='22'"><fo:inline>Philosophy: Non-Western Philosophy</fo:inline></xsl:when>
																			<xsl:when test=".='23'"><fo:inline>Philosophy: Philosophy of Language</fo:inline></xsl:when>
																			<xsl:when test=".='24'"><fo:inline>Philosophy: Phenomenology - Existentialism</fo:inline></xsl:when>
																			<xsl:when test=".='25'"><fo:inline>Philosophy: Philosophy of Science</fo:inline></xsl:when>
																			<xsl:when test=".='27'"><fo:inline>Languages: General</fo:inline></xsl:when>
																			<xsl:when test=".='28'"><fo:inline>Languages: Classical Languages</fo:inline></xsl:when>
																			<xsl:when test=".='2832'"><fo:inline>Other: Computer Science</fo:inline></xsl:when>
																			<xsl:when test=".='2833'"><fo:inline>History: Medieval History</fo:inline></xsl:when>
																			<xsl:when test=".='2834'"><fo:inline>History: Renaissance History</fo:inline></xsl:when>
																			<xsl:when test=".='2835'"><fo:inline>History: History of Science</fo:inline></xsl:when>
																			<xsl:when test=".='2836'"><fo:inline>History: African American History</fo:inline></xsl:when>
																			<xsl:when test=".='2837'"><fo:inline>History: Cultural History</fo:inline></xsl:when>
																			<xsl:when test=".='2838'"><fo:inline>History: Diplomatic History</fo:inline></xsl:when>
																			<xsl:when test=".='2839'"><fo:inline>History: Economic History</fo:inline></xsl:when>
																			<xsl:when test=".='2840'"><fo:inline>History: Immigration History</fo:inline></xsl:when>
																			<xsl:when test=".='2841'"><fo:inline>History: Intellectual History</fo:inline></xsl:when>
																			<xsl:when test=".='2842'"><fo:inline>History: Labor History</fo:inline></xsl:when>
																			<xsl:when test=".='2843'"><fo:inline>History: Latino History</fo:inline></xsl:when>
																			<xsl:when test=".='2844'"><fo:inline>History: Military History</fo:inline></xsl:when>
																			<xsl:when test=".='2845'"><fo:inline>History: Political History</fo:inline></xsl:when>
																			<xsl:when test=".='2846'"><fo:inline>History: Public History</fo:inline></xsl:when>
																			<xsl:when test=".='2847'"><fo:inline>History: Urban History</fo:inline></xsl:when>
																			<xsl:when test=".='2848'"><fo:inline>History: Women's History</fo:inline></xsl:when>
																			<xsl:when test=".='2849'"><fo:inline>History: Other</fo:inline></xsl:when>
																			<xsl:when test=".='2850'"><fo:inline>Philosophy: Other</fo:inline></xsl:when>
																			<xsl:when test=".='2851'"><fo:inline>Languages: Arabic Language</fo:inline></xsl:when>
																			<xsl:when test=".='2852'"><fo:inline>Languages: Computational Linguistics</fo:inline></xsl:when>
																			<xsl:when test=".='2853'"><fo:inline>Languages: Other</fo:inline></xsl:when>
																			<xsl:when test=".='2854'"><fo:inline>Literature: East Asian Literature</fo:inline></xsl:when>
																			<xsl:when test=".='2855'"><fo:inline>Literature: South Asian Literature</fo:inline></xsl:when>
																			<xsl:when test=".='2856'"><fo:inline>Politics: Comparative Politics</fo:inline></xsl:when>
																			<xsl:when test=".='2857'"><fo:inline>Politics: Political Theory</fo:inline></xsl:when>
																			<xsl:when test=".='2858'"><fo:inline>Politics: Other</fo:inline></xsl:when>
																			<xsl:when test=".='2859'"><fo:inline>Interdisciplinary: East Asian Studies</fo:inline></xsl:when>
																			<xsl:when test=".='2860'"><fo:inline>Interdisciplinary: South Asian Studies</fo:inline></xsl:when>
																			<xsl:when test=".='2861'"><fo:inline>Interdisciplinary: Other</fo:inline></xsl:when>
																			<xsl:when test=".='2862'"><fo:inline>Social Science: Cultural Anthropology</fo:inline></xsl:when>
																			<xsl:when test=".='2863'"><fo:inline>Social Science: Biological Anthropology</fo:inline></xsl:when>
																			<xsl:when test=".='2864'"><fo:inline>Social Science: Linguistic Anthropology</fo:inline></xsl:when>
																			<xsl:when test=".='2865'"><fo:inline>Social Science: Ethnomusicology</fo:inline></xsl:when>
																			<xsl:when test=".='2866'"><fo:inline>Social Science: Other</fo:inline></xsl:when>
																			<xsl:when test=".='2868'"><fo:inline>Arts: History, Criticism, and Theory of the Arts</fo:inline></xsl:when>
																			<xsl:when test=".='2869'"><fo:inline>Arts: Other</fo:inline></xsl:when>
																			<xsl:when test=".='2870'"><fo:inline>Law: Legal History</fo:inline></xsl:when>
																			<xsl:when test=".='2871'"><fo:inline>Other: Conservation Science</fo:inline></xsl:when>
																			<xsl:when test=".='2872'"><fo:inline>Other: Digital Humanities</fo:inline></xsl:when>
																			<xsl:when test=".='2873'"><fo:inline>Other: Digital Preservation</fo:inline></xsl:when>
																			<xsl:when test=".='2874'"><fo:inline>Other: Engineering</fo:inline></xsl:when>
																			<xsl:when test=".='2875'"><fo:inline>Other: Filmmaking</fo:inline></xsl:when>
																			<xsl:when test=".='2876'"><fo:inline>Other: Health Science</fo:inline></xsl:when>
																			<xsl:when test=".='2877'"><fo:inline>Other: Information Science</fo:inline></xsl:when>
																			<xsl:when test=".='2878'"><fo:inline>Other: Mathematics</fo:inline></xsl:when>
																			<xsl:when test=".='2880'"><fo:inline>Other: Radio Production</fo:inline></xsl:when>
																			<xsl:when test=".='2881'"><fo:inline>Other: Statistics</fo:inline></xsl:when>
																			<xsl:when test=".='2882'"><fo:inline>Religion: Other</fo:inline></xsl:when>
																			<xsl:when test=".='29'"><fo:inline>Languages: French Language</fo:inline></xsl:when>
																			<xsl:when test=".='30'"><fo:inline>Languages: German Language</fo:inline></xsl:when>
																			<xsl:when test=".='31'"><fo:inline>Languages: Italian Language</fo:inline></xsl:when>
																			<xsl:when test=".='32'"><fo:inline>Languages: Latin American Languages</fo:inline></xsl:when>
																			<xsl:when test=".='33'"><fo:inline>Languages: Slavic Languages</fo:inline></xsl:when>
																			<xsl:when test=".='34'"><fo:inline>Languages: Spanish Language</fo:inline></xsl:when>
																			<xsl:when test=".='35'"><fo:inline>Languages: Comparative Languages</fo:inline></xsl:when>
																			<xsl:when test=".='36'"><fo:inline>Languages: Asian Languages</fo:inline></xsl:when>
																			<xsl:when test=".='37'"><fo:inline>Languages: Near and Middle Eastern Languages</fo:inline></xsl:when>
																			<xsl:when test=".='38'"><fo:inline>Languages: Ancient Languages</fo:inline></xsl:when>
																			<xsl:when test=".='39'"><fo:inline>Languages: Romance Languages</fo:inline></xsl:when>
																			<xsl:when test=".='4'"><fo:inline>History: U.S. History</fo:inline></xsl:when>
																			<xsl:when test=".='40'"><fo:inline>Languages: English</fo:inline></xsl:when>
																			<xsl:when test=".='42'"><fo:inline>Literature: General</fo:inline></xsl:when>
																			<xsl:when test=".='43'"><fo:inline>Literature: Classical Literature</fo:inline></xsl:when>
																			<xsl:when test=".='44'"><fo:inline>Literature: French Literature</fo:inline></xsl:when>
																			<xsl:when test=".='45'"><fo:inline>Literature: German Literature</fo:inline></xsl:when>
																			<xsl:when test=".='46'"><fo:inline>Literature: Italian Literature</fo:inline></xsl:when>
																			<xsl:when test=".='47'"><fo:inline>Literature: Latin American Literature</fo:inline></xsl:when>
																			<xsl:when test=".='48'"><fo:inline>Literature: Slavic Literature</fo:inline></xsl:when>
																			<xsl:when test=".='49'"><fo:inline>Literature: Spanish Literature</fo:inline></xsl:when>
																			<xsl:when test=".='50'"><fo:inline>Literature: Comparative Literature</fo:inline></xsl:when>
																			<xsl:when test=".='52'"><fo:inline>Literature: Near and Middle Eastern Literature</fo:inline></xsl:when>
																			<xsl:when test=".='53'"><fo:inline>Literature: Ancient Literature</fo:inline></xsl:when>
																			<xsl:when test=".='54'"><fo:inline>Literature: British Literature</fo:inline></xsl:when>
																			<xsl:when test=".='55'"><fo:inline>Literature: American Literature</fo:inline></xsl:when>
																			<xsl:when test=".='56'"><fo:inline>Literature: Russian Literature</fo:inline></xsl:when>
																			<xsl:when test=".='57'"><fo:inline>Literature: Arabic Literature</fo:inline></xsl:when>
																			<xsl:when test=".='59'"><fo:inline>Literature: Literary Criticism</fo:inline></xsl:when>
																			<xsl:when test=".='6'"><fo:inline>History: Classical History</fo:inline></xsl:when>
																			<xsl:when test=".='60'"><fo:inline>Literature: Other</fo:inline></xsl:when>
																			<xsl:when test=".='61'"><fo:inline>Literature: African Literature</fo:inline></xsl:when>
																			<xsl:when test=".='63'"><fo:inline>Religion: General</fo:inline></xsl:when>
																			<xsl:when test=".='64'"><fo:inline>Religion: History of Religion</fo:inline></xsl:when>
																			<xsl:when test=".='65'"><fo:inline>Philosophy: Philosophy of Religion</fo:inline></xsl:when>
																			<xsl:when test=".='66'"><fo:inline>Religion: Nonwestern Religion</fo:inline></xsl:when>
																			<xsl:when test=".='67'"><fo:inline>Religion: Comparative Religion</fo:inline></xsl:when>
																			<xsl:when test=".='69'"><fo:inline>Politics: General</fo:inline></xsl:when>
																			<xsl:when test=".='7'"><fo:inline>History: European History</fo:inline></xsl:when>
																			<xsl:when test=".='70'"><fo:inline>Politics: American Government</fo:inline></xsl:when>
																			<xsl:when test=".='71'"><fo:inline>Politics: International Relations</fo:inline></xsl:when>
																			<xsl:when test=".='72'"><fo:inline>Other: Public Administration</fo:inline></xsl:when>
																			<xsl:when test=".='74'"><fo:inline>Interdisciplinary: Gender Studies</fo:inline></xsl:when>
																			<xsl:when test=".='75'"><fo:inline>Interdisciplinary: Urban Studies</fo:inline></xsl:when>
																			<xsl:when test=".='76'"><fo:inline>Interdisciplinary: American Studies</fo:inline></xsl:when>
																			<xsl:when test=".='77'"><fo:inline>Interdisciplinary: Labor Relations</fo:inline></xsl:when>
																			<xsl:when test=".='79'"><fo:inline>Interdisciplinary: Turkish Studies</fo:inline></xsl:when>
																			<xsl:when test=".='8'"><fo:inline>History: East Asian History</fo:inline></xsl:when>
																			<xsl:when test=".='80'"><fo:inline>Interdisciplinary: Classics</fo:inline></xsl:when>
																			<xsl:when test=".='81'"><fo:inline>Interdisciplinary: Medieval Studies</fo:inline></xsl:when>
																			<xsl:when test=".='82'"><fo:inline>Interdisciplinary: Renaissance Studies</fo:inline></xsl:when>
																			<xsl:when test=".='83'"><fo:inline>Interdisciplinary: History and Philosophy of Science, Technology, and Medicine</fo:inline></xsl:when>
																			<xsl:when test=".='84'"><fo:inline>Interdisciplinary: Western Civilization</fo:inline></xsl:when>
																			<xsl:when test=".='85'"><fo:inline>Interdisciplinary: Rural Studies</fo:inline></xsl:when>
																			<xsl:when test=".='86'"><fo:inline>Interdisciplinary: U.S. Regional Studies</fo:inline></xsl:when>
																			<xsl:when test=".='87'"><fo:inline>Interdisciplinary: International Studies</fo:inline></xsl:when>
																			<xsl:when test=".='88'"><fo:inline>Interdisciplinary: Area Studies</fo:inline></xsl:when>
																			<xsl:when test=".='89'"><fo:inline>Interdisciplinary: African Studies</fo:inline></xsl:when>
																			<xsl:when test=".='9'"><fo:inline>History: Latin American History</fo:inline></xsl:when>
																			<xsl:when test=".='90'"><fo:inline>Interdisciplinary: Latin American Studies</fo:inline></xsl:when>
																			<xsl:when test=".='92'"><fo:inline>Other: Education</fo:inline></xsl:when>
																			<xsl:when test=".='94'"><fo:inline>Other: Library Science</fo:inline></xsl:when>
																			<xsl:when test=".='96'"><fo:inline>Other: Archival Management and Conservation</fo:inline></xsl:when>
																			<xsl:when test=".='97'"><fo:inline>Other: Museum Studies or Historical Preservation</fo:inline></xsl:when>
																			<xsl:when test=".='99'"><fo:inline>Languages: Linguistics</fo:inline></xsl:when>

																			<xsl:otherwise>
																				<fo:inline> </fo:inline>
																			</xsl:otherwise>
																		</xsl:choose>
																	</xsl:for-each>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row border-left-style="none" border-right-style="none" border-top-style="solid" border-bottom-style="solid">
									<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" border-before-width="0pt" border-color="black" border-width="1pt">
										<fo:block>
											<fo:table width="100%" table-layout="fixed">
												<fo:table-column column-width="proportional-column-width(20)"/>
												<fo:table-column column-width="proportional-column-width(20)"/>
												<fo:table-column column-width="proportional-column-width(60)"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>2. Institution Information</fo:block>
														</fo:table-cell>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>Type</fo:block>
														</fo:table-cell>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>
																<fo:inline font-weight="100">
																	<xsl:value-of select="SupplementaryCoverSheetforNEHGrantPrograms_3_0:OrganizationType"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row border-left-style="none" border-right-style="none" border-top-style="solid" border-bottom-style="none">
									<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" border-before-width="0pt" border-color="black" border-width="1pt">
										<fo:block>
											<fo:table width="100%" table-layout="fixed">
												<fo:table-column column-width="proportional-column-width(100)"/>
												<fo:table-column column-width="proportional-column-width(20)"/>
												<fo:table-column column-width="proportional-column-width(60)"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>3. Project Funding</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row border-left-style="none" border-right-style="none" border-top-style="none" border-bottom-style="solid">
									<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" border-before-width="0pt" border-color="black" border-width="1pt">
										<fo:block>
											<fo:table width="100%" table-layout="fixed">
												<fo:table-column column-width="proportional-column-width(10)"/>
												<fo:table-column column-width="proportional-column-width(15)"/>
												<fo:table-column column-width="proportional-column-width(75)"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block> </fo:block>
														</fo:table-cell>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>Outright Funds</fo:block>
														</fo:table-cell>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>
																<fo:inline font-weight="100">
																	<xsl:value-of select="SupplementaryCoverSheetforNEHGrantPrograms_3_0:ProjectFundingGroup/SupplementaryCoverSheetforNEHGrantPrograms_3_0:ReqOutrightAmount"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block> </fo:block>
														</fo:table-cell>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>Federal Match</fo:block>
														</fo:table-cell>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>
																<fo:inline font-weight="100">
																	<xsl:value-of select="SupplementaryCoverSheetforNEHGrantPrograms_3_0:ProjectFundingGroup/SupplementaryCoverSheetforNEHGrantPrograms_3_0:ReqMatchAmount"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block> </fo:block>
														</fo:table-cell>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>Total from NEH</fo:block>
														</fo:table-cell>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>
																<fo:inline font-weight="100">
																	<xsl:value-of select="SupplementaryCoverSheetforNEHGrantPrograms_3_0:ProjectFundingGroup/SupplementaryCoverSheetforNEHGrantPrograms_3_0:TotalFromNEH"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block> </fo:block>
														</fo:table-cell>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>Cost Sharing</fo:block>
														</fo:table-cell>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>
																<fo:inline font-weight="100">
																	<xsl:value-of select="SupplementaryCoverSheetforNEHGrantPrograms_3_0:ProjectFundingGroup/SupplementaryCoverSheetforNEHGrantPrograms_3_0:CostSharing"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block> </fo:block>
														</fo:table-cell>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>Total Project Costs</fo:block>
														</fo:table-cell>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>
																<fo:inline font-weight="100">
																	<xsl:value-of select="SupplementaryCoverSheetforNEHGrantPrograms_3_0:ProjectFundingGroup/SupplementaryCoverSheetforNEHGrantPrograms_3_0:TotalProjectCosts"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row border-left-style="none" border-right-style="none" border-top-style="solid" border-bottom-style="none">
									<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" border-before-width="0pt" border-color="black" border-width="1pt">
										<fo:block>
											<fo:table width="100%" table-layout="fixed">
												<fo:table-column column-width="proportional-column-width(100)"/>
												<fo:table-column column-width="proportional-column-width(20)"/>
												<fo:table-column column-width="proportional-column-width(60)"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>4. Application Information</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row border-left-style="none" border-right-style="none" border-top-style="none" border-bottom-style="none">
									<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" border-before-width="0pt" border-color="black" border-width="1pt">
										<fo:block>
											<fo:table width="100%" table-layout="fixed">
												<fo:table-column column-width="proportional-column-width(35)"/>
												<fo:table-column column-width="proportional-column-width(10)"/>
												<fo:table-column column-width="proportional-column-width(55)"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>Will this proposal be submitted to another NEH division, government agency, or private entity for funding?</fo:block>
														</fo:table-cell>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>
																<fo:inline font-weight="100">
																	<xsl:value-of select="SupplementaryCoverSheetforNEHGrantPrograms_3_0:ApplicationInfoGroup/SupplementaryCoverSheetforNEHGrantPrograms_3_0:AdditionalFunding"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-weight="normal" padding-before="10pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>
																<fo:inline font-weight="100"><fo:block>If yes, please explain where and when:</fo:block>
																	<xsl:value-of select="SupplementaryCoverSheetforNEHGrantPrograms_3_0:ApplicationInfoGroup/SupplementaryCoverSheetforNEHGrantPrograms_3_0:AddFundingExplanation"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row border-left-style="none" border-right-style="none" border-top-style="none" border-bottom-style="none">
									<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" border-before-width="0pt" border-color="black" border-width="1pt">
										<fo:block>
											<fo:table width="100%" table-layout="fixed">
												<fo:table-column column-width="proportional-column-width(20)"/>
												<fo:table-column column-width="proportional-column-width(10)"/>
												<fo:table-column column-width="proportional-column-width(70)"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>Type of Application</fo:block>
														</fo:table-cell>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>
																<fo:inline font-weight="100">
																	<xsl:value-of select="SupplementaryCoverSheetforNEHGrantPrograms_3_0:ApplicationInfoGroup/SupplementaryCoverSheetforNEHGrantPrograms_3_0:TypeofApplication"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell font-weight="normal" padding-before="10pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>
																<fo:inline font-weight="100"><fo:block>If supplement, list current grant number(s).</fo:block>
																	<xsl:value-of select="SupplementaryCoverSheetforNEHGrantPrograms_3_0:ApplicationInfoGroup/SupplementaryCoverSheetforNEHGrantPrograms_3_0:SupGrantNumber"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row border-left-style="none" border-right-style="none" border-top-style="none" border-bottom-style="none">
									<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" border-before-width="0pt" border-color="black" border-width="1pt">
										<fo:block>
											<fo:table width="100%" table-layout="fixed">
												<fo:table-column column-width="proportional-column-width(30)"/>
												<fo:table-column column-width="proportional-column-width(70)"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>Primary project discipline</fo:block>
														</fo:table-cell>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>
																<xsl:for-each select="SupplementaryCoverSheetforNEHGrantPrograms_3_0:ApplicationInfoGroup/SupplementaryCoverSheetforNEHGrantPrograms_3_0:ProjFieldCode">
																	<xsl:choose>
																		<xsl:when test=".='10'"><fo:inline>History: Near and Middle Eastern History</fo:inline></xsl:when>
																		<xsl:when test=".='101'"><fo:inline>Interdisciplinary: Ethnic Studies</fo:inline></xsl:when>
																		<xsl:when test=".='102'"><fo:inline>Interdisciplinary: Native American Studies</fo:inline></xsl:when>
																		<xsl:when test=".='103'"><fo:inline>Interdisciplinary: Hispanic American Studies</fo:inline></xsl:when>
																		<xsl:when test=".='104'"><fo:inline>Interdisciplinary: African American Studies</fo:inline></xsl:when>
																		<xsl:when test=".='105'"><fo:inline>Interdisciplinary: Asian American Studies</fo:inline></xsl:when>
																		<xsl:when test=".='106'"><fo:inline>Interdisciplinary: Jewish Studies</fo:inline></xsl:when>
																		<xsl:when test=".='108'"><fo:inline>Social Science: Anthropology</fo:inline></xsl:when>
																		<xsl:when test=".='11'"><fo:inline>History: Russian History</fo:inline></xsl:when>
																		<xsl:when test=".='110'"><fo:inline>Arts: Art History and Criticism</fo:inline></xsl:when>
																		<xsl:when test=".='111'"><fo:inline>Arts: Theater History and Criticism</fo:inline></xsl:when>
																		<xsl:when test=".='112'"><fo:inline>Arts: Dance History and Criticism</fo:inline></xsl:when>
																		<xsl:when test=".='113'"><fo:inline>Arts: Film History and Criticism</fo:inline></xsl:when>
																		<xsl:when test=".='114'"><fo:inline>Arts: Music History and Criticism</fo:inline></xsl:when>
																		<xsl:when test=".='117'"><fo:inline>Arts: General</fo:inline></xsl:when>
																		<xsl:when test=".='119'"><fo:inline>Social Science: Economics</fo:inline></xsl:when>
																		<xsl:when test=".='12'"><fo:inline>History: South Asian History</fo:inline></xsl:when>
																		<xsl:when test=".='123'"><fo:inline>Communications: Composition and Rhetoric</fo:inline></xsl:when>
																		<xsl:when test=".='124'"><fo:inline>Communications: Communications</fo:inline></xsl:when>
																		<xsl:when test=".='1245'"><fo:inline>History: General</fo:inline></xsl:when>
																		<xsl:when test=".='1246'"><fo:inline>History: African History</fo:inline></xsl:when>
																		<xsl:when test=".='1247'"><fo:inline>History: British History</fo:inline></xsl:when>
																		<xsl:when test=".='1248'"><fo:inline>Philosophy: Epistemology</fo:inline></xsl:when>
																		<xsl:when test=".='1249'"><fo:inline>Philosophy: Ethics</fo:inline></xsl:when>
																		<xsl:when test=".='125'"><fo:inline>Interdisciplinary: Media Studies</fo:inline></xsl:when>
																		<xsl:when test=".='126'"><fo:inline>Communications: Journalism</fo:inline></xsl:when>
																		<xsl:when test=".='127'"><fo:inline>Law: Law and Jurisprudence</fo:inline></xsl:when>
																		<xsl:when test=".='129'"><fo:inline>Interdisciplinary: Folklore and Folklife</fo:inline></xsl:when>
																		<xsl:when test=".='13'"><fo:inline>History: Ancient History</fo:inline></xsl:when>
																		<xsl:when test=".='130'"><fo:inline>Social Science: Sociology</fo:inline></xsl:when>
																		<xsl:when test=".='140'"><fo:inline>Interdisciplinary: General</fo:inline></xsl:when>
																		<xsl:when test=".='141'"><fo:inline>Social Science: General</fo:inline></xsl:when>
																		<xsl:when test=".='142'"><fo:inline>Arts: Architecture</fo:inline></xsl:when>
																		<xsl:when test=".='144'"><fo:inline>Social Science: Psychology</fo:inline></xsl:when>
																		<xsl:when test=".='145'"><fo:inline>Social Science: Archaeology</fo:inline></xsl:when>
																		<xsl:when test=".='146'"><fo:inline>Social Science: Geography</fo:inline></xsl:when>
																		<xsl:when test=".='15'"><fo:inline>Philosophy: General</fo:inline></xsl:when>
																		<xsl:when test=".='16'"><fo:inline>Philosophy: Aesthetics</fo:inline></xsl:when>
																		<xsl:when test=".='19'"><fo:inline>Philosophy: History of Philosophy</fo:inline></xsl:when>
																		<xsl:when test=".='20'"><fo:inline>Philosophy: Logic</fo:inline></xsl:when>
																		<xsl:when test=".='21'"><fo:inline>Philosophy: Metaphysics</fo:inline></xsl:when>
																		<xsl:when test=".='22'"><fo:inline>Philosophy: Non-Western Philosophy</fo:inline></xsl:when>
																		<xsl:when test=".='23'"><fo:inline>Philosophy: Philosophy of Language</fo:inline></xsl:when>
																		<xsl:when test=".='24'"><fo:inline>Philosophy: Phenomenology - Existentialism</fo:inline></xsl:when>
																		<xsl:when test=".='25'"><fo:inline>Philosophy: Philosophy of Science</fo:inline></xsl:when>
																		<xsl:when test=".='27'"><fo:inline>Languages: General</fo:inline></xsl:when>
																		<xsl:when test=".='28'"><fo:inline>Languages: Classical Languages</fo:inline></xsl:when>
																		<xsl:when test=".='2833'"><fo:inline>History: Medieval History</fo:inline></xsl:when>
																		<xsl:when test=".='2834'"><fo:inline>History: Renaissance History</fo:inline></xsl:when>
																		<xsl:when test=".='2835'"><fo:inline>History: History of Science</fo:inline></xsl:when>
																		<xsl:when test=".='2836'"><fo:inline>History: African American History</fo:inline></xsl:when>
																		<xsl:when test=".='2837'"><fo:inline>History: Cultural History</fo:inline></xsl:when>
																		<xsl:when test=".='2838'"><fo:inline>History: Diplomatic History</fo:inline></xsl:when>
																		<xsl:when test=".='2839'"><fo:inline>History: Economic History</fo:inline></xsl:when>
																		<xsl:when test=".='2840'"><fo:inline>History: Immigration History</fo:inline></xsl:when>
																		<xsl:when test=".='2841'"><fo:inline>History: Intellectual History</fo:inline></xsl:when>
																		<xsl:when test=".='2842'"><fo:inline>History: Labor History</fo:inline></xsl:when>
																		<xsl:when test=".='2843'"><fo:inline>History: Latino History</fo:inline></xsl:when>
																		<xsl:when test=".='2844'"><fo:inline>History: Military History</fo:inline></xsl:when>
																		<xsl:when test=".='2845'"><fo:inline>History: Political History</fo:inline></xsl:when>
																		<xsl:when test=".='2846'"><fo:inline>History: Public History</fo:inline></xsl:when>
																		<xsl:when test=".='2847'"><fo:inline>History: Urban History</fo:inline></xsl:when>
																		<xsl:when test=".='2848'"><fo:inline>History: Women's History</fo:inline></xsl:when>
																		<xsl:when test=".='2849'"><fo:inline>History: Other</fo:inline></xsl:when>
																		<xsl:when test=".='2850'"><fo:inline>Philosophy: Other</fo:inline></xsl:when>
																		<xsl:when test=".='2851'"><fo:inline>Languages: Arabic Language</fo:inline></xsl:when>
																		<xsl:when test=".='2852'"><fo:inline>Languages: Computational Linguistics</fo:inline></xsl:when>
																		<xsl:when test=".='2853'"><fo:inline>Languages: Other</fo:inline></xsl:when>
																		<xsl:when test=".='2854'"><fo:inline>Literature: East Asian Literature</fo:inline></xsl:when>
																		<xsl:when test=".='2855'"><fo:inline>Literature: South Asian Literature</fo:inline></xsl:when>
																		<xsl:when test=".='2856'"><fo:inline>Politics: Comparative Politics</fo:inline></xsl:when>
																		<xsl:when test=".='2857'"><fo:inline>Politics: Political Theory</fo:inline></xsl:when>
																		<xsl:when test=".='2858'"><fo:inline>Politics: Other</fo:inline></xsl:when>
																		<xsl:when test=".='2859'"><fo:inline>Interdisciplinary: East Asian Studies</fo:inline></xsl:when>
																		<xsl:when test=".='2860'"><fo:inline>Interdisciplinary: South Asian Studies</fo:inline></xsl:when>
																		<xsl:when test=".='2861'"><fo:inline>Interdisciplinary: Other</fo:inline></xsl:when>
																		<xsl:when test=".='2862'"><fo:inline>Social Science: Cultural Anthropology</fo:inline></xsl:when>
																		<xsl:when test=".='2863'"><fo:inline>Social Science: Biological Anthropology</fo:inline></xsl:when>
																		<xsl:when test=".='2864'"><fo:inline>Social Science: Linguistic Anthropology</fo:inline></xsl:when>
																		<xsl:when test=".='2865'"><fo:inline>Social Science: Ethnomusicology</fo:inline></xsl:when>
																		<xsl:when test=".='2866'"><fo:inline>Social Science: Other</fo:inline></xsl:when>
																		<xsl:when test=".='2868'"><fo:inline>Arts: History, Criticism, and Theory of the Arts</fo:inline></xsl:when>
																		<xsl:when test=".='2869'"><fo:inline>Arts: Other</fo:inline></xsl:when>
																		<xsl:when test=".='2870'"><fo:inline>Law: Legal History</fo:inline></xsl:when>
																		<xsl:when test=".='2882'"><fo:inline>Religion: Other</fo:inline></xsl:when>
																		<xsl:when test=".='29'"><fo:inline>Languages: French Language</fo:inline></xsl:when>
																		<xsl:when test=".='30'"><fo:inline>Languages: German Language</fo:inline></xsl:when>
																		<xsl:when test=".='31'"><fo:inline>Languages: Italian Language</fo:inline></xsl:when>
																		<xsl:when test=".='32'"><fo:inline>Languages: Latin American Languages</fo:inline></xsl:when>
																		<xsl:when test=".='33'"><fo:inline>Languages: Slavic Languages</fo:inline></xsl:when>
																		<xsl:when test=".='34'"><fo:inline>Languages: Spanish Language</fo:inline></xsl:when>
																		<xsl:when test=".='35'"><fo:inline>Languages: Comparative Languages</fo:inline></xsl:when>
																		<xsl:when test=".='36'"><fo:inline>Languages: Asian Languages</fo:inline></xsl:when>
																		<xsl:when test=".='37'"><fo:inline>Languages: Near and Middle Eastern Languages</fo:inline></xsl:when>
																		<xsl:when test=".='38'"><fo:inline>Languages: Ancient Languages</fo:inline></xsl:when>
																		<xsl:when test=".='39'"><fo:inline>Languages: Romance Languages</fo:inline></xsl:when>
																		<xsl:when test=".='4'"><fo:inline>History: U.S. History</fo:inline></xsl:when>
																		<xsl:when test=".='40'"><fo:inline>Languages: English</fo:inline></xsl:when>
																		<xsl:when test=".='42'"><fo:inline>Literature: General</fo:inline></xsl:when>
																		<xsl:when test=".='43'"><fo:inline>Literature: Classical Literature</fo:inline></xsl:when>
																		<xsl:when test=".='44'"><fo:inline>Literature: French Literature</fo:inline></xsl:when>
																		<xsl:when test=".='45'"><fo:inline>Literature: German Literature</fo:inline></xsl:when>
																		<xsl:when test=".='46'"><fo:inline>Literature: Italian Literature</fo:inline></xsl:when>
																		<xsl:when test=".='47'"><fo:inline>Literature: Latin American Literature</fo:inline></xsl:when>
																		<xsl:when test=".='48'"><fo:inline>Literature: Slavic Literature</fo:inline></xsl:when>
																		<xsl:when test=".='49'"><fo:inline>Literature: Spanish Literature</fo:inline></xsl:when>
																		<xsl:when test=".='50'"><fo:inline>Literature: Comparative Literature</fo:inline></xsl:when>
																		<xsl:when test=".='52'"><fo:inline>Literature: Near and Middle Eastern Literature</fo:inline></xsl:when>
																		<xsl:when test=".='53'"><fo:inline>Literature: Ancient Literature</fo:inline></xsl:when>
																		<xsl:when test=".='54'"><fo:inline>Literature: British Literature</fo:inline></xsl:when>
																		<xsl:when test=".='55'"><fo:inline>Literature: American Literature</fo:inline></xsl:when>
																		<xsl:when test=".='56'"><fo:inline>Literature: Russian Literature</fo:inline></xsl:when>
																		<xsl:when test=".='57'"><fo:inline>Literature: Arabic Literature</fo:inline></xsl:when>
																		<xsl:when test=".='59'"><fo:inline>Literature: Literary Criticism</fo:inline></xsl:when>
																		<xsl:when test=".='6'"><fo:inline>History: Classical History</fo:inline></xsl:when>
																		<xsl:when test=".='60'"><fo:inline>Literature: Other</fo:inline></xsl:when>
																		<xsl:when test=".='61'"><fo:inline>Literature: African Literature</fo:inline></xsl:when>
																		<xsl:when test=".='63'"><fo:inline>Religion: General</fo:inline></xsl:when>
																		<xsl:when test=".='64'"><fo:inline>Religion: History of Religion</fo:inline></xsl:when>
																		<xsl:when test=".='65'"><fo:inline>Philosophy: Philosophy of Religion</fo:inline></xsl:when>
																		<xsl:when test=".='66'"><fo:inline>Religion: Nonwestern Religion</fo:inline></xsl:when>
																		<xsl:when test=".='67'"><fo:inline>Religion: Comparative Religion</fo:inline></xsl:when>
																		<xsl:when test=".='69'"><fo:inline>Politics: General</fo:inline></xsl:when>
																		<xsl:when test=".='7'"><fo:inline>History: European History</fo:inline></xsl:when>
																		<xsl:when test=".='70'"><fo:inline>Politics: American Government</fo:inline></xsl:when>
																		<xsl:when test=".='71'"><fo:inline>Politics: International Relations</fo:inline></xsl:when>
																		<xsl:when test=".='74'"><fo:inline>Interdisciplinary: Gender Studies</fo:inline></xsl:when>
																		<xsl:when test=".='75'"><fo:inline>Interdisciplinary: Urban Studies</fo:inline></xsl:when>
																		<xsl:when test=".='76'"><fo:inline>Interdisciplinary: American Studies</fo:inline></xsl:when>
																		<xsl:when test=".='77'"><fo:inline>Interdisciplinary: Labor Relations</fo:inline></xsl:when>
																		<xsl:when test=".='79'"><fo:inline>Interdisciplinary: Turkish Studies</fo:inline></xsl:when>
																		<xsl:when test=".='8'"><fo:inline>History: East Asian History</fo:inline></xsl:when>
																		<xsl:when test=".='80'"><fo:inline>Interdisciplinary: Classics</fo:inline></xsl:when>
																		<xsl:when test=".='81'"><fo:inline>Interdisciplinary: Medieval Studies</fo:inline></xsl:when>
																		<xsl:when test=".='82'"><fo:inline>Interdisciplinary: Renaissance Studies</fo:inline></xsl:when>
																		<xsl:when test=".='83'"><fo:inline>Interdisciplinary: History and Philosophy of Science, Technology, and Medicine</fo:inline></xsl:when>
																		<xsl:when test=".='84'"><fo:inline>Interdisciplinary: Western Civilization</fo:inline></xsl:when>
																		<xsl:when test=".='85'"><fo:inline>Interdisciplinary: Rural Studies</fo:inline></xsl:when>
																		<xsl:when test=".='86'"><fo:inline>Interdisciplinary: U.S. Regional Studies</fo:inline></xsl:when>
																		<xsl:when test=".='87'"><fo:inline>Interdisciplinary: International Studies</fo:inline></xsl:when>
																		<xsl:when test=".='88'"><fo:inline>Interdisciplinary: Area Studies</fo:inline></xsl:when>
																		<xsl:when test=".='89'"><fo:inline>Interdisciplinary: African Studies</fo:inline></xsl:when>
																		<xsl:when test=".='9'"><fo:inline>History: Latin American History</fo:inline></xsl:when>
																		<xsl:when test=".='90'"><fo:inline>Interdisciplinary: Latin American Studies</fo:inline></xsl:when>
																		<xsl:when test=".='99'"><fo:inline>Languages: Linguistics</fo:inline></xsl:when>
																		<xsl:otherwise>
																			<fo:inline> </fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row border-left-style="none" border-right-style="none" border-top-style="none" border-bottom-style="none">
									<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" border-before-width="0pt" border-color="black" border-width="1pt">
										<fo:block>
											<fo:table width="100%" table-layout="fixed">
												<fo:table-column column-width="proportional-column-width(30)"/>
												<fo:table-column column-width="proportional-column-width(70)"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>Secondary project discipline (optional)</fo:block>
														</fo:table-cell>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>
																<xsl:for-each select="SupplementaryCoverSheetforNEHGrantPrograms_3_0:ApplicationInfoGroup/SupplementaryCoverSheetforNEHGrantPrograms_3_0:ProjFieldCode2">
																	<xsl:choose>
																		<xsl:when test=".='10'"><fo:inline>History: Near and Middle Eastern History</fo:inline></xsl:when>
																		<xsl:when test=".='101'"><fo:inline>Interdisciplinary: Ethnic Studies</fo:inline></xsl:when>
																		<xsl:when test=".='102'"><fo:inline>Interdisciplinary: Native American Studies</fo:inline></xsl:when>
																		<xsl:when test=".='103'"><fo:inline>Interdisciplinary: Hispanic American Studies</fo:inline></xsl:when>
																		<xsl:when test=".='104'"><fo:inline>Interdisciplinary: African American Studies</fo:inline></xsl:when>
																		<xsl:when test=".='105'"><fo:inline>Interdisciplinary: Asian American Studies</fo:inline></xsl:when>
																		<xsl:when test=".='106'"><fo:inline>Interdisciplinary: Jewish Studies</fo:inline></xsl:when>
																		<xsl:when test=".='108'"><fo:inline>Social Science: Anthropology</fo:inline></xsl:when>
																		<xsl:when test=".='11'"><fo:inline>History: Russian History</fo:inline></xsl:when>
																		<xsl:when test=".='110'"><fo:inline>Arts: Art History and Criticism</fo:inline></xsl:when>
																		<xsl:when test=".='111'"><fo:inline>Arts: Theater History and Criticism</fo:inline></xsl:when>
																		<xsl:when test=".='112'"><fo:inline>Arts: Dance History and Criticism</fo:inline></xsl:when>
																		<xsl:when test=".='113'"><fo:inline>Arts: Film History and Criticism</fo:inline></xsl:when>
																		<xsl:when test=".='114'"><fo:inline>Arts: Music History and Criticism</fo:inline></xsl:when>
																		<xsl:when test=".='117'"><fo:inline>Arts: General</fo:inline></xsl:when>
																		<xsl:when test=".='119'"><fo:inline>Social Science: Economics</fo:inline></xsl:when>
																		<xsl:when test=".='12'"><fo:inline>History: South Asian History</fo:inline></xsl:when>
																		<xsl:when test=".='123'"><fo:inline>Communications: Composition and Rhetoric</fo:inline></xsl:when>
																		<xsl:when test=".='124'"><fo:inline>Communications: Communications</fo:inline></xsl:when>
																		<xsl:when test=".='1245'"><fo:inline>History: General</fo:inline></xsl:when>
																		<xsl:when test=".='1246'"><fo:inline>History: African History</fo:inline></xsl:when>
																		<xsl:when test=".='1247'"><fo:inline>History: British History</fo:inline></xsl:when>
																		<xsl:when test=".='1248'"><fo:inline>Philosophy: Epistemology</fo:inline></xsl:when>
																		<xsl:when test=".='1249'"><fo:inline>Philosophy: Ethics</fo:inline></xsl:when>
																		<xsl:when test=".='125'"><fo:inline>Interdisciplinary: Media Studies</fo:inline></xsl:when>
																		<xsl:when test=".='126'"><fo:inline>Communications: Journalism</fo:inline></xsl:when>
																		<xsl:when test=".='127'"><fo:inline>Law: Law and Jurisprudence</fo:inline></xsl:when>
																		<xsl:when test=".='129'"><fo:inline>Interdisciplinary: Folklore and Folklife</fo:inline></xsl:when>
																		<xsl:when test=".='13'"><fo:inline>History: Ancient History</fo:inline></xsl:when>
																		<xsl:when test=".='130'"><fo:inline>Social Science: Sociology</fo:inline></xsl:when>
																		<xsl:when test=".='140'"><fo:inline>Interdisciplinary: General</fo:inline></xsl:when>
																		<xsl:when test=".='141'"><fo:inline>Social Science: General</fo:inline></xsl:when>
																		<xsl:when test=".='142'"><fo:inline>Arts: Architecture</fo:inline></xsl:when>
																		<xsl:when test=".='144'"><fo:inline>Social Science: Psychology</fo:inline></xsl:when>
																		<xsl:when test=".='145'"><fo:inline>Social Science: Archaeology</fo:inline></xsl:when>
																		<xsl:when test=".='146'"><fo:inline>Social Science: Geography</fo:inline></xsl:when>
																		<xsl:when test=".='15'"><fo:inline>Philosophy: General</fo:inline></xsl:when>
																		<xsl:when test=".='16'"><fo:inline>Philosophy: Aesthetics</fo:inline></xsl:when>
																		<xsl:when test=".='19'"><fo:inline>Philosophy: History of Philosophy</fo:inline></xsl:when>
																		<xsl:when test=".='20'"><fo:inline>Philosophy: Logic</fo:inline></xsl:when>
																		<xsl:when test=".='21'"><fo:inline>Philosophy: Metaphysics</fo:inline></xsl:when>
																		<xsl:when test=".='22'"><fo:inline>Philosophy: Non-Western Philosophy</fo:inline></xsl:when>
																		<xsl:when test=".='23'"><fo:inline>Philosophy: Philosophy of Language</fo:inline></xsl:when>
																		<xsl:when test=".='24'"><fo:inline>Philosophy: Phenomenology - Existentialism</fo:inline></xsl:when>
																		<xsl:when test=".='25'"><fo:inline>Philosophy: Philosophy of Science</fo:inline></xsl:when>
																		<xsl:when test=".='27'"><fo:inline>Languages: General</fo:inline></xsl:when>
																		<xsl:when test=".='28'"><fo:inline>Languages: Classical Languages</fo:inline></xsl:when>
																		<xsl:when test=".='2833'"><fo:inline>History: Medieval History</fo:inline></xsl:when>
																		<xsl:when test=".='2834'"><fo:inline>History: Renaissance History</fo:inline></xsl:when>
																		<xsl:when test=".='2835'"><fo:inline>History: History of Science</fo:inline></xsl:when>
																		<xsl:when test=".='2836'"><fo:inline>History: African American History</fo:inline></xsl:when>
																		<xsl:when test=".='2837'"><fo:inline>History: Cultural History</fo:inline></xsl:when>
																		<xsl:when test=".='2838'"><fo:inline>History: Diplomatic History</fo:inline></xsl:when>
																		<xsl:when test=".='2839'"><fo:inline>History: Economic History</fo:inline></xsl:when>
																		<xsl:when test=".='2840'"><fo:inline>History: Immigration History</fo:inline></xsl:when>
																		<xsl:when test=".='2841'"><fo:inline>History: Intellectual History</fo:inline></xsl:when>
																		<xsl:when test=".='2842'"><fo:inline>History: Labor History</fo:inline></xsl:when>
																		<xsl:when test=".='2843'"><fo:inline>History: Latino History</fo:inline></xsl:when>
																		<xsl:when test=".='2844'"><fo:inline>History: Military History</fo:inline></xsl:when>
																		<xsl:when test=".='2845'"><fo:inline>History: Political History</fo:inline></xsl:when>
																		<xsl:when test=".='2846'"><fo:inline>History: Public History</fo:inline></xsl:when>
																		<xsl:when test=".='2847'"><fo:inline>History: Urban History</fo:inline></xsl:when>
																		<xsl:when test=".='2848'"><fo:inline>History: Women's History</fo:inline></xsl:when>
																		<xsl:when test=".='2849'"><fo:inline>History: Other</fo:inline></xsl:when>
																		<xsl:when test=".='2850'"><fo:inline>Philosophy: Other</fo:inline></xsl:when>
																		<xsl:when test=".='2851'"><fo:inline>Languages: Arabic Language</fo:inline></xsl:when>
																		<xsl:when test=".='2852'"><fo:inline>Languages: Computational Linguistics</fo:inline></xsl:when>
																		<xsl:when test=".='2853'"><fo:inline>Languages: Other</fo:inline></xsl:when>
																		<xsl:when test=".='2854'"><fo:inline>Literature: East Asian Literature</fo:inline></xsl:when>
																		<xsl:when test=".='2855'"><fo:inline>Literature: South Asian Literature</fo:inline></xsl:when>
																		<xsl:when test=".='2856'"><fo:inline>Politics: Comparative Politics</fo:inline></xsl:when>
																		<xsl:when test=".='2857'"><fo:inline>Politics: Political Theory</fo:inline></xsl:when>
																		<xsl:when test=".='2858'"><fo:inline>Politics: Other</fo:inline></xsl:when>
																		<xsl:when test=".='2859'"><fo:inline>Interdisciplinary: East Asian Studies</fo:inline></xsl:when>
																		<xsl:when test=".='2860'"><fo:inline>Interdisciplinary: South Asian Studies</fo:inline></xsl:when>
																		<xsl:when test=".='2861'"><fo:inline>Interdisciplinary: Other</fo:inline></xsl:when>
																		<xsl:when test=".='2862'"><fo:inline>Social Science: Cultural Anthropology</fo:inline></xsl:when>
																		<xsl:when test=".='2863'"><fo:inline>Social Science: Biological Anthropology</fo:inline></xsl:when>
																		<xsl:when test=".='2864'"><fo:inline>Social Science: Linguistic Anthropology</fo:inline></xsl:when>
																		<xsl:when test=".='2865'"><fo:inline>Social Science: Ethnomusicology</fo:inline></xsl:when>
																		<xsl:when test=".='2866'"><fo:inline>Social Science: Other</fo:inline></xsl:when>
																		<xsl:when test=".='2868'"><fo:inline>Arts: History, Criticism, and Theory of the Arts</fo:inline></xsl:when>
																		<xsl:when test=".='2869'"><fo:inline>Arts: Other</fo:inline></xsl:when>
																		<xsl:when test=".='2870'"><fo:inline>Law: Legal History</fo:inline></xsl:when>
																		<xsl:when test=".='2882'"><fo:inline>Religion: Other</fo:inline></xsl:when>
																		<xsl:when test=".='29'"><fo:inline>Languages: French Language</fo:inline></xsl:when>
																		<xsl:when test=".='30'"><fo:inline>Languages: German Language</fo:inline></xsl:when>
																		<xsl:when test=".='31'"><fo:inline>Languages: Italian Language</fo:inline></xsl:when>
																		<xsl:when test=".='32'"><fo:inline>Languages: Latin American Languages</fo:inline></xsl:when>
																		<xsl:when test=".='33'"><fo:inline>Languages: Slavic Languages</fo:inline></xsl:when>
																		<xsl:when test=".='34'"><fo:inline>Languages: Spanish Language</fo:inline></xsl:when>
																		<xsl:when test=".='35'"><fo:inline>Languages: Comparative Languages</fo:inline></xsl:when>
																		<xsl:when test=".='36'"><fo:inline>Languages: Asian Languages</fo:inline></xsl:when>
																		<xsl:when test=".='37'"><fo:inline>Languages: Near and Middle Eastern Languages</fo:inline></xsl:when>
																		<xsl:when test=".='38'"><fo:inline>Languages: Ancient Languages</fo:inline></xsl:when>
																		<xsl:when test=".='39'"><fo:inline>Languages: Romance Languages</fo:inline></xsl:when>
																		<xsl:when test=".='4'"><fo:inline>History: U.S. History</fo:inline></xsl:when>
																		<xsl:when test=".='40'"><fo:inline>Languages: English</fo:inline></xsl:when>
																		<xsl:when test=".='42'"><fo:inline>Literature: General</fo:inline></xsl:when>
																		<xsl:when test=".='43'"><fo:inline>Literature: Classical Literature</fo:inline></xsl:when>
																		<xsl:when test=".='44'"><fo:inline>Literature: French Literature</fo:inline></xsl:when>
																		<xsl:when test=".='45'"><fo:inline>Literature: German Literature</fo:inline></xsl:when>
																		<xsl:when test=".='46'"><fo:inline>Literature: Italian Literature</fo:inline></xsl:when>
																		<xsl:when test=".='47'"><fo:inline>Literature: Latin American Literature</fo:inline></xsl:when>
																		<xsl:when test=".='48'"><fo:inline>Literature: Slavic Literature</fo:inline></xsl:when>
																		<xsl:when test=".='49'"><fo:inline>Literature: Spanish Literature</fo:inline></xsl:when>
																		<xsl:when test=".='50'"><fo:inline>Literature: Comparative Literature</fo:inline></xsl:when>
																		<xsl:when test=".='52'"><fo:inline>Literature: Near and Middle Eastern Literature</fo:inline></xsl:when>
																		<xsl:when test=".='53'"><fo:inline>Literature: Ancient Literature</fo:inline></xsl:when>
																		<xsl:when test=".='54'"><fo:inline>Literature: British Literature</fo:inline></xsl:when>
																		<xsl:when test=".='55'"><fo:inline>Literature: American Literature</fo:inline></xsl:when>
																		<xsl:when test=".='56'"><fo:inline>Literature: Russian Literature</fo:inline></xsl:when>
																		<xsl:when test=".='57'"><fo:inline>Literature: Arabic Literature</fo:inline></xsl:when>
																		<xsl:when test=".='59'"><fo:inline>Literature: Literary Criticism</fo:inline></xsl:when>
																		<xsl:when test=".='6'"><fo:inline>History: Classical History</fo:inline></xsl:when>
																		<xsl:when test=".='60'"><fo:inline>Literature: Other</fo:inline></xsl:when>
																		<xsl:when test=".='61'"><fo:inline>Literature: African Literature</fo:inline></xsl:when>
																		<xsl:when test=".='63'"><fo:inline>Religion: General</fo:inline></xsl:when>
																		<xsl:when test=".='64'"><fo:inline>Religion: History of Religion</fo:inline></xsl:when>
																		<xsl:when test=".='65'"><fo:inline>Philosophy: Philosophy of Religion</fo:inline></xsl:when>
																		<xsl:when test=".='66'"><fo:inline>Religion: Nonwestern Religion</fo:inline></xsl:when>
																		<xsl:when test=".='67'"><fo:inline>Religion: Comparative Religion</fo:inline></xsl:when>
																		<xsl:when test=".='69'"><fo:inline>Politics: General</fo:inline></xsl:when>
																		<xsl:when test=".='7'"><fo:inline>History: European History</fo:inline></xsl:when>
																		<xsl:when test=".='70'"><fo:inline>Politics: American Government</fo:inline></xsl:when>
																		<xsl:when test=".='71'"><fo:inline>Politics: International Relations</fo:inline></xsl:when>
																		<xsl:when test=".='74'"><fo:inline>Interdisciplinary: Gender Studies</fo:inline></xsl:when>
																		<xsl:when test=".='75'"><fo:inline>Interdisciplinary: Urban Studies</fo:inline></xsl:when>
																		<xsl:when test=".='76'"><fo:inline>Interdisciplinary: American Studies</fo:inline></xsl:when>
																		<xsl:when test=".='77'"><fo:inline>Interdisciplinary: Labor Relations</fo:inline></xsl:when>
																		<xsl:when test=".='79'"><fo:inline>Interdisciplinary: Turkish Studies</fo:inline></xsl:when>
																		<xsl:when test=".='8'"><fo:inline>History: East Asian History</fo:inline></xsl:when>
																		<xsl:when test=".='80'"><fo:inline>Interdisciplinary: Classics</fo:inline></xsl:when>
																		<xsl:when test=".='81'"><fo:inline>Interdisciplinary: Medieval Studies</fo:inline></xsl:when>
																		<xsl:when test=".='82'"><fo:inline>Interdisciplinary: Renaissance Studies</fo:inline></xsl:when>
																		<xsl:when test=".='83'"><fo:inline>Interdisciplinary: History and Philosophy of Science, Technology, and Medicine</fo:inline></xsl:when>
																		<xsl:when test=".='84'"><fo:inline>Interdisciplinary: Western Civilization</fo:inline></xsl:when>
																		<xsl:when test=".='85'"><fo:inline>Interdisciplinary: Rural Studies</fo:inline></xsl:when>
																		<xsl:when test=".='86'"><fo:inline>Interdisciplinary: U.S. Regional Studies</fo:inline></xsl:when>
																		<xsl:when test=".='87'"><fo:inline>Interdisciplinary: International Studies</fo:inline></xsl:when>
																		<xsl:when test=".='88'"><fo:inline>Interdisciplinary: Area Studies</fo:inline></xsl:when>
																		<xsl:when test=".='89'"><fo:inline>Interdisciplinary: African Studies</fo:inline></xsl:when>
																		<xsl:when test=".='9'"><fo:inline>History: Latin American History</fo:inline></xsl:when>
																		<xsl:when test=".='90'"><fo:inline>Interdisciplinary: Latin American Studies</fo:inline></xsl:when>
																		<xsl:when test=".='99'"><fo:inline>Languages: Linguistics</fo:inline></xsl:when>
																		<xsl:otherwise>
																			<fo:inline> </fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row border-left-style="none" border-right-style="none" border-top-style="none" border-bottom-style="none">
									<fo:table-cell padding-before="2pt" padding-after="2pt" padding-end="1pt" border-before-width="0pt" border-color="black" border-width="1pt">
										<fo:block>
											<fo:table width="100%" table-layout="fixed">
												<fo:table-column column-width="proportional-column-width(30)"/>
												<fo:table-column column-width="proportional-column-width(70)"/>
												<fo:table-body>
													<fo:table-row>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>Tertiary project discipline (optional)</fo:block>
														</fo:table-cell>
														<fo:table-cell font-weight="normal" padding-before="2pt" padding-after="2pt" padding-end="1pt" padding-start="5pt">
															<fo:block>
																<xsl:for-each select="SupplementaryCoverSheetforNEHGrantPrograms_3_0:ApplicationInfoGroup/SupplementaryCoverSheetforNEHGrantPrograms_3_0:ProjFieldCode3">
																	<xsl:choose>
																		<xsl:when test=".='10'"><fo:inline>History: Near and Middle Eastern History</fo:inline></xsl:when>
																		<xsl:when test=".='101'"><fo:inline>Interdisciplinary: Ethnic Studies</fo:inline></xsl:when>
																		<xsl:when test=".='102'"><fo:inline>Interdisciplinary: Native American Studies</fo:inline></xsl:when>
																		<xsl:when test=".='103'"><fo:inline>Interdisciplinary: Hispanic American Studies</fo:inline></xsl:when>
																		<xsl:when test=".='104'"><fo:inline>Interdisciplinary: African American Studies</fo:inline></xsl:when>
																		<xsl:when test=".='105'"><fo:inline>Interdisciplinary: Asian American Studies</fo:inline></xsl:when>
																		<xsl:when test=".='106'"><fo:inline>Interdisciplinary: Jewish Studies</fo:inline></xsl:when>
																		<xsl:when test=".='108'"><fo:inline>Social Science: Anthropology</fo:inline></xsl:when>
																		<xsl:when test=".='11'"><fo:inline>History: Russian History</fo:inline></xsl:when>
																		<xsl:when test=".='110'"><fo:inline>Arts: Art History and Criticism</fo:inline></xsl:when>
																		<xsl:when test=".='111'"><fo:inline>Arts: Theater History and Criticism</fo:inline></xsl:when>
																		<xsl:when test=".='112'"><fo:inline>Arts: Dance History and Criticism</fo:inline></xsl:when>
																		<xsl:when test=".='113'"><fo:inline>Arts: Film History and Criticism</fo:inline></xsl:when>
																		<xsl:when test=".='114'"><fo:inline>Arts: Music History and Criticism</fo:inline></xsl:when>
																		<xsl:when test=".='117'"><fo:inline>Arts: General</fo:inline></xsl:when>
																		<xsl:when test=".='119'"><fo:inline>Social Science: Economics</fo:inline></xsl:when>
																		<xsl:when test=".='12'"><fo:inline>History: South Asian History</fo:inline></xsl:when>
																		<xsl:when test=".='123'"><fo:inline>Communications: Composition and Rhetoric</fo:inline></xsl:when>
																		<xsl:when test=".='124'"><fo:inline>Communications: Communications</fo:inline></xsl:when>
																		<xsl:when test=".='1245'"><fo:inline>History: General</fo:inline></xsl:when>
																		<xsl:when test=".='1246'"><fo:inline>History: African History</fo:inline></xsl:when>
																		<xsl:when test=".='1247'"><fo:inline>History: British History</fo:inline></xsl:when>
																		<xsl:when test=".='1248'"><fo:inline>Philosophy: Epistemology</fo:inline></xsl:when>
																		<xsl:when test=".='1249'"><fo:inline>Philosophy: Ethics</fo:inline></xsl:when>
																		<xsl:when test=".='125'"><fo:inline>Interdisciplinary: Media Studies</fo:inline></xsl:when>
																		<xsl:when test=".='126'"><fo:inline>Communications: Journalism</fo:inline></xsl:when>
																		<xsl:when test=".='127'"><fo:inline>Law: Law and Jurisprudence</fo:inline></xsl:when>
																		<xsl:when test=".='129'"><fo:inline>Interdisciplinary: Folklore and Folklife</fo:inline></xsl:when>
																		<xsl:when test=".='13'"><fo:inline>History: Ancient History</fo:inline></xsl:when>
																		<xsl:when test=".='130'"><fo:inline>Social Science: Sociology</fo:inline></xsl:when>
																		<xsl:when test=".='140'"><fo:inline>Interdisciplinary: General</fo:inline></xsl:when>
																		<xsl:when test=".='141'"><fo:inline>Social Science: General</fo:inline></xsl:when>
																		<xsl:when test=".='142'"><fo:inline>Arts: Architecture</fo:inline></xsl:when>
																		<xsl:when test=".='144'"><fo:inline>Social Science: Psychology</fo:inline></xsl:when>
																		<xsl:when test=".='145'"><fo:inline>Social Science: Archaeology</fo:inline></xsl:when>
																		<xsl:when test=".='146'"><fo:inline>Social Science: Geography</fo:inline></xsl:when>
																		<xsl:when test=".='15'"><fo:inline>Philosophy: General</fo:inline></xsl:when>
																		<xsl:when test=".='16'"><fo:inline>Philosophy: Aesthetics</fo:inline></xsl:when>
																		<xsl:when test=".='19'"><fo:inline>Philosophy: History of Philosophy</fo:inline></xsl:when>
																		<xsl:when test=".='20'"><fo:inline>Philosophy: Logic</fo:inline></xsl:when>
																		<xsl:when test=".='21'"><fo:inline>Philosophy: Metaphysics</fo:inline></xsl:when>
																		<xsl:when test=".='22'"><fo:inline>Philosophy: Non-Western Philosophy</fo:inline></xsl:when>
																		<xsl:when test=".='23'"><fo:inline>Philosophy: Philosophy of Language</fo:inline></xsl:when>
																		<xsl:when test=".='24'"><fo:inline>Philosophy: Phenomenology - Existentialism</fo:inline></xsl:when>
																		<xsl:when test=".='25'"><fo:inline>Philosophy: Philosophy of Science</fo:inline></xsl:when>
																		<xsl:when test=".='27'"><fo:inline>Languages: General</fo:inline></xsl:when>
																		<xsl:when test=".='28'"><fo:inline>Languages: Classical Languages</fo:inline></xsl:when>
																		<xsl:when test=".='2833'"><fo:inline>History: Medieval History</fo:inline></xsl:when>
																		<xsl:when test=".='2834'"><fo:inline>History: Renaissance History</fo:inline></xsl:when>
																		<xsl:when test=".='2835'"><fo:inline>History: History of Science</fo:inline></xsl:when>
																		<xsl:when test=".='2836'"><fo:inline>History: African American History</fo:inline></xsl:when>
																		<xsl:when test=".='2837'"><fo:inline>History: Cultural History</fo:inline></xsl:when>
																		<xsl:when test=".='2838'"><fo:inline>History: Diplomatic History</fo:inline></xsl:when>
																		<xsl:when test=".='2839'"><fo:inline>History: Economic History</fo:inline></xsl:when>
																		<xsl:when test=".='2840'"><fo:inline>History: Immigration History</fo:inline></xsl:when>
																		<xsl:when test=".='2841'"><fo:inline>History: Intellectual History</fo:inline></xsl:when>
																		<xsl:when test=".='2842'"><fo:inline>History: Labor History</fo:inline></xsl:when>
																		<xsl:when test=".='2843'"><fo:inline>History: Latino History</fo:inline></xsl:when>
																		<xsl:when test=".='2844'"><fo:inline>History: Military History</fo:inline></xsl:when>
																		<xsl:when test=".='2845'"><fo:inline>History: Political History</fo:inline></xsl:when>
																		<xsl:when test=".='2846'"><fo:inline>History: Public History</fo:inline></xsl:when>
																		<xsl:when test=".='2847'"><fo:inline>History: Urban History</fo:inline></xsl:when>
																		<xsl:when test=".='2848'"><fo:inline>History: Women's History</fo:inline></xsl:when>
																		<xsl:when test=".='2849'"><fo:inline>History: Other</fo:inline></xsl:when>
																		<xsl:when test=".='2850'"><fo:inline>Philosophy: Other</fo:inline></xsl:when>
																		<xsl:when test=".='2851'"><fo:inline>Languages: Arabic Language</fo:inline></xsl:when>
																		<xsl:when test=".='2852'"><fo:inline>Languages: Computational Linguistics</fo:inline></xsl:when>
																		<xsl:when test=".='2853'"><fo:inline>Languages: Other</fo:inline></xsl:when>
																		<xsl:when test=".='2854'"><fo:inline>Literature: East Asian Literature</fo:inline></xsl:when>
																		<xsl:when test=".='2855'"><fo:inline>Literature: South Asian Literature</fo:inline></xsl:when>
																		<xsl:when test=".='2856'"><fo:inline>Politics: Comparative Politics</fo:inline></xsl:when>
																		<xsl:when test=".='2857'"><fo:inline>Politics: Political Theory</fo:inline></xsl:when>
																		<xsl:when test=".='2858'"><fo:inline>Politics: Other</fo:inline></xsl:when>
																		<xsl:when test=".='2859'"><fo:inline>Interdisciplinary: East Asian Studies</fo:inline></xsl:when>
																		<xsl:when test=".='2860'"><fo:inline>Interdisciplinary: South Asian Studies</fo:inline></xsl:when>
																		<xsl:when test=".='2861'"><fo:inline>Interdisciplinary: Other</fo:inline></xsl:when>
																		<xsl:when test=".='2862'"><fo:inline>Social Science: Cultural Anthropology</fo:inline></xsl:when>
																		<xsl:when test=".='2863'"><fo:inline>Social Science: Biological Anthropology</fo:inline></xsl:when>
																		<xsl:when test=".='2864'"><fo:inline>Social Science: Linguistic Anthropology</fo:inline></xsl:when>
																		<xsl:when test=".='2865'"><fo:inline>Social Science: Ethnomusicology</fo:inline></xsl:when>
																		<xsl:when test=".='2866'"><fo:inline>Social Science: Other</fo:inline></xsl:when>
																		<xsl:when test=".='2868'"><fo:inline>Arts: History, Criticism, and Theory of the Arts</fo:inline></xsl:when>
																		<xsl:when test=".='2869'"><fo:inline>Arts: Other</fo:inline></xsl:when>
																		<xsl:when test=".='2870'"><fo:inline>Law: Legal History</fo:inline></xsl:when>
																		<xsl:when test=".='2882'"><fo:inline>Religion: Other</fo:inline></xsl:when>
																		<xsl:when test=".='29'"><fo:inline>Languages: French Language</fo:inline></xsl:when>
																		<xsl:when test=".='30'"><fo:inline>Languages: German Language</fo:inline></xsl:when>
																		<xsl:when test=".='31'"><fo:inline>Languages: Italian Language</fo:inline></xsl:when>
																		<xsl:when test=".='32'"><fo:inline>Languages: Latin American Languages</fo:inline></xsl:when>
																		<xsl:when test=".='33'"><fo:inline>Languages: Slavic Languages</fo:inline></xsl:when>
																		<xsl:when test=".='34'"><fo:inline>Languages: Spanish Language</fo:inline></xsl:when>
																		<xsl:when test=".='35'"><fo:inline>Languages: Comparative Languages</fo:inline></xsl:when>
																		<xsl:when test=".='36'"><fo:inline>Languages: Asian Languages</fo:inline></xsl:when>
																		<xsl:when test=".='37'"><fo:inline>Languages: Near and Middle Eastern Languages</fo:inline></xsl:when>
																		<xsl:when test=".='38'"><fo:inline>Languages: Ancient Languages</fo:inline></xsl:when>
																		<xsl:when test=".='39'"><fo:inline>Languages: Romance Languages</fo:inline></xsl:when>
																		<xsl:when test=".='4'"><fo:inline>History: U.S. History</fo:inline></xsl:when>
																		<xsl:when test=".='40'"><fo:inline>Languages: English</fo:inline></xsl:when>
																		<xsl:when test=".='42'"><fo:inline>Literature: General</fo:inline></xsl:when>
																		<xsl:when test=".='43'"><fo:inline>Literature: Classical Literature</fo:inline></xsl:when>
																		<xsl:when test=".='44'"><fo:inline>Literature: French Literature</fo:inline></xsl:when>
																		<xsl:when test=".='45'"><fo:inline>Literature: German Literature</fo:inline></xsl:when>
																		<xsl:when test=".='46'"><fo:inline>Literature: Italian Literature</fo:inline></xsl:when>
																		<xsl:when test=".='47'"><fo:inline>Literature: Latin American Literature</fo:inline></xsl:when>
																		<xsl:when test=".='48'"><fo:inline>Literature: Slavic Literature</fo:inline></xsl:when>
																		<xsl:when test=".='49'"><fo:inline>Literature: Spanish Literature</fo:inline></xsl:when>
																		<xsl:when test=".='50'"><fo:inline>Literature: Comparative Literature</fo:inline></xsl:when>
																		<xsl:when test=".='52'"><fo:inline>Literature: Near and Middle Eastern Literature</fo:inline></xsl:when>
																		<xsl:when test=".='53'"><fo:inline>Literature: Ancient Literature</fo:inline></xsl:when>
																		<xsl:when test=".='54'"><fo:inline>Literature: British Literature</fo:inline></xsl:when>
																		<xsl:when test=".='55'"><fo:inline>Literature: American Literature</fo:inline></xsl:when>
																		<xsl:when test=".='56'"><fo:inline>Literature: Russian Literature</fo:inline></xsl:when>
																		<xsl:when test=".='57'"><fo:inline>Literature: Arabic Literature</fo:inline></xsl:when>
																		<xsl:when test=".='59'"><fo:inline>Literature: Literary Criticism</fo:inline></xsl:when>
																		<xsl:when test=".='6'"><fo:inline>History: Classical History</fo:inline></xsl:when>
																		<xsl:when test=".='60'"><fo:inline>Literature: Other</fo:inline></xsl:when>
																		<xsl:when test=".='61'"><fo:inline>Literature: African Literature</fo:inline></xsl:when>
																		<xsl:when test=".='63'"><fo:inline>Religion: General</fo:inline></xsl:when>
																		<xsl:when test=".='64'"><fo:inline>Religion: History of Religion</fo:inline></xsl:when>
																		<xsl:when test=".='65'"><fo:inline>Philosophy: Philosophy of Religion</fo:inline></xsl:when>
																		<xsl:when test=".='66'"><fo:inline>Religion: Nonwestern Religion</fo:inline></xsl:when>
																		<xsl:when test=".='67'"><fo:inline>Religion: Comparative Religion</fo:inline></xsl:when>
																		<xsl:when test=".='69'"><fo:inline>Politics: General</fo:inline></xsl:when>
																		<xsl:when test=".='7'"><fo:inline>History: European History</fo:inline></xsl:when>
																		<xsl:when test=".='70'"><fo:inline>Politics: American Government</fo:inline></xsl:when>
																		<xsl:when test=".='71'"><fo:inline>Politics: International Relations</fo:inline></xsl:when>
																		<xsl:when test=".='74'"><fo:inline>Interdisciplinary: Gender Studies</fo:inline></xsl:when>
																		<xsl:when test=".='75'"><fo:inline>Interdisciplinary: Urban Studies</fo:inline></xsl:when>
																		<xsl:when test=".='76'"><fo:inline>Interdisciplinary: American Studies</fo:inline></xsl:when>
																		<xsl:when test=".='77'"><fo:inline>Interdisciplinary: Labor Relations</fo:inline></xsl:when>
																		<xsl:when test=".='79'"><fo:inline>Interdisciplinary: Turkish Studies</fo:inline></xsl:when>
																		<xsl:when test=".='8'"><fo:inline>History: East Asian History</fo:inline></xsl:when>
																		<xsl:when test=".='80'"><fo:inline>Interdisciplinary: Classics</fo:inline></xsl:when>
																		<xsl:when test=".='81'"><fo:inline>Interdisciplinary: Medieval Studies</fo:inline></xsl:when>
																		<xsl:when test=".='82'"><fo:inline>Interdisciplinary: Renaissance Studies</fo:inline></xsl:when>
																		<xsl:when test=".='83'"><fo:inline>Interdisciplinary: History and Philosophy of Science, Technology, and Medicine</fo:inline></xsl:when>
																		<xsl:when test=".='84'"><fo:inline>Interdisciplinary: Western Civilization</fo:inline></xsl:when>
																		<xsl:when test=".='85'"><fo:inline>Interdisciplinary: Rural Studies</fo:inline></xsl:when>
																		<xsl:when test=".='86'"><fo:inline>Interdisciplinary: U.S. Regional Studies</fo:inline></xsl:when>
																		<xsl:when test=".='87'"><fo:inline>Interdisciplinary: International Studies</fo:inline></xsl:when>
																		<xsl:when test=".='88'"><fo:inline>Interdisciplinary: Area Studies</fo:inline></xsl:when>
																		<xsl:when test=".='89'"><fo:inline>Interdisciplinary: African Studies</fo:inline></xsl:when>
																		<xsl:when test=".='9'"><fo:inline>History: Latin American History</fo:inline></xsl:when>
																		<xsl:when test=".='90'"><fo:inline>Interdisciplinary: Latin American Studies</fo:inline></xsl:when>
																		<xsl:when test=".='99'"><fo:inline>Languages: Linguistics</fo:inline></xsl:when>
																		<xsl:otherwise>
																			<fo:inline> </fo:inline>
																		</xsl:otherwise>
																	</xsl:choose>
																</xsl:for-each>
															</fo:block>
														</fo:table-cell>
													</fo:table-row>
												</fo:table-body>
											</fo:table>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</fo:block>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
</xsl:stylesheet>
