/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.datadictionary;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.ListUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.krad.datadictionary.BeanOverride;
import org.kuali.rice.krad.datadictionary.BusinessObjectEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntry;
import org.kuali.rice.krad.datadictionary.DataDictionaryEntryBase;
import org.kuali.rice.krad.datadictionary.DataDictionaryException;
import org.kuali.rice.krad.datadictionary.DataDictionaryIndex;
import org.kuali.rice.krad.datadictionary.DataDictionaryIndexMapper;
import org.kuali.rice.krad.datadictionary.DataDictionaryMapper;
import org.kuali.rice.krad.datadictionary.DataDictionaryPostProcessorUtils;
import org.kuali.rice.krad.datadictionary.DataObjectEntry;
import org.kuali.rice.krad.datadictionary.DictionaryBeanFactoryPostProcessor;
import org.kuali.rice.krad.datadictionary.DocumentEntry;
import org.kuali.rice.krad.datadictionary.InactivationBlockingMetadata;
import org.kuali.rice.krad.datadictionary.MaintenanceDocumentEntry;
import org.kuali.rice.krad.datadictionary.uif.UifBeanFactoryPostProcessor;
import org.kuali.rice.krad.datadictionary.uif.UifDictionaryIndex;
import org.kuali.rice.krad.datadictionary.validator.ErrorReport;
import org.kuali.rice.krad.datadictionary.validator.ValidationTrace;
import org.kuali.rice.krad.datadictionary.validator.Validator;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.uif.util.ObjectPropertyUtils;
import org.kuali.rice.krad.uif.view.View;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.StopWatch;

public class DataDictionary {
    private static final Logger LOG = LogManager.getLogger(DataDictionary.class);
    protected DefaultListableBeanFactory ddBeans = new DefaultListableBeanFactory();
    protected DataDictionaryIndex ddIndex = new DataDictionaryIndex(this.ddBeans);
    protected UifDictionaryIndex uifIndex = new UifDictionaryIndex(this.ddBeans);
    protected DataDictionaryMapper ddMapper = new DataDictionaryIndexMapper();
    protected Map<String, List<Resource>> moduleDictionaryFiles = new HashMap<String, List<Resource>>();
    protected List<String> moduleLoadOrder = new ArrayList<String>();
    protected StopWatch timer;

    public void parseDataDictionaryConfigurationFiles() {
        this.timer = new StopWatch("DD Processing");
        DataDictionaryPostProcessorUtils.setupProcessor(this.ddBeans);
        this.loadDictionaryBeans(this.ddBeans, this.moduleDictionaryFiles, this.ddIndex);
        this.performDictionaryPostProcessing();
    }

    public void loadDictionaryBeans(DefaultListableBeanFactory beans, Map<String, List<Resource>> moduleDictionaryFiles, DataDictionaryIndex index) {
        this.timer.start("XML File Loading");
        LOG.info("Starting DD XML File Load");
        ArrayList allBeanNames = new ArrayList();
        for (String namespaceCode : this.moduleLoadOrder) {
            LOG.info("Processing Module: " + namespaceCode);
            List<Resource> moduleDictionaryLocations = moduleDictionaryFiles.get(namespaceCode);
            if (LOG.isDebugEnabled()) {
                LOG.debug("DD Locations in Module: " + String.valueOf(moduleDictionaryLocations));
            }
            if (moduleDictionaryLocations == null) continue;
            XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beans);
            Resource[] configFileLocationsArray = new Resource[moduleDictionaryLocations.size()];
            configFileLocationsArray = moduleDictionaryLocations.toArray(configFileLocationsArray);
            try {
                xmlReader.loadBeanDefinitions(configFileLocationsArray);
                List addedBeanNames = Arrays.asList(beans.getBeanDefinitionNames());
                addedBeanNames = ListUtils.removeAll(addedBeanNames, allBeanNames);
                index.addBeanNamesToNamespace(namespaceCode, addedBeanNames);
                allBeanNames.addAll(addedBeanNames);
            }
            catch (Exception e) {
                throw new DataDictionaryException("Error loading bean definitions: " + e.getLocalizedMessage(), e);
            }
        }
        LOG.info("Completed DD XML File Load");
        this.timer.stop();
    }

    protected void performDictionaryPostProcessing() {
        LOG.info("Starting Data Dictionary Post Processing");
        this.timer.start("Spring Post Processing");
        PropertyPlaceholderConfigurer propertyPlaceholderConfigurer = new PropertyPlaceholderConfigurer();
        propertyPlaceholderConfigurer.setProperties(ConfigContext.getCurrentContextConfig().getProperties());
        propertyPlaceholderConfigurer.postProcessBeanFactory((ConfigurableListableBeanFactory)this.ddBeans);
        DictionaryBeanFactoryPostProcessor dictionaryBeanPostProcessor = new DictionaryBeanFactoryPostProcessor(this, (ConfigurableListableBeanFactory)this.ddBeans);
        dictionaryBeanPostProcessor.postProcessBeanFactory();
        this.timer.stop();
        this.timer.start("UIF Post Processing");
        UifBeanFactoryPostProcessor factoryPostProcessor = new UifBeanFactoryPostProcessor();
        factoryPostProcessor.postProcessBeanFactory((ConfigurableListableBeanFactory)this.ddBeans);
        this.timer.stop();
        if (ConfigContext.getCurrentContextConfig().getBooleanProperty("rice.krad.preInstantiateBeans.enabled", false)) {
            this.timer.start("Instantiating DD Beans");
            this.ddBeans.preInstantiateSingletons();
            this.timer.stop();
        }
        this.timer.start("DD Post Processing");
        for (DataDictionaryEntryBase entry : this.ddBeans.getBeansOfType(DataObjectEntry.class).values()) {
            entry.dataDictionaryPostProcessing();
        }
        for (DataDictionaryEntryBase entry : this.ddBeans.getBeansOfType(DocumentEntry.class).values()) {
            ((DocumentEntry)entry).dataDictionaryPostProcessing();
        }
        this.timer.stop();
        this.timer.start("Data Dictionary Indexing");
        this.ddIndex.run();
        this.timer.stop();
        this.timer.start("UIF Indexing");
        this.uifIndex.run();
        this.timer.stop();
        LOG.info("Completed Data Dictionary Post Processing");
    }

    public void validateDD() {
        this.timer.start("Validation");
        Validator.resetErrorReport();
        Map doBeans = this.ddBeans.getBeansOfType(DataObjectEntry.class);
        for (Object entry : doBeans.values()) {
            ((DataObjectEntry)entry).completeValidation(new ValidationTrace());
        }
        Map docBeans = this.ddBeans.getBeansOfType(DocumentEntry.class);
        for (DocumentEntry entry : docBeans.values()) {
            entry.completeValidation(new ValidationTrace());
        }
        List<ErrorReport> errorReports = Validator.getErrorReports();
        if (!errorReports.isEmpty()) {
            boolean hasErrors = this.hasErrors(errorReports);
            String errorReport = this.produceErrorReport(errorReports, hasErrors);
            if (hasErrors) {
                String message = "Errors during DD validation, failing validation.\n" + errorReport;
                throw new DataDictionaryException(message);
            }
            String message = "Warnings during DD validation.\n" + errorReport;
            LOG.warn(message);
        }
        this.timer.stop();
    }

    private boolean hasErrors(List<ErrorReport> errorReports) {
        for (ErrorReport err : errorReports) {
            if (!err.isError()) continue;
            return true;
        }
        return false;
    }

    protected String produceErrorReport(List<ErrorReport> errorReports, boolean hasErrors) {
        StringBuilder builder = new StringBuilder();
        builder.append("***********************************************************\n");
        if (hasErrors) {
            builder.append("ERRORS REPORTED UPON DATA DICTIONARY VALIDATION\n");
        } else {
            builder.append("WARNINGS REPORTED UPON DATA DICTIONARY VALIDATION\n");
        }
        builder.append("***********************************************************\n");
        for (ErrorReport report : errorReports) {
            builder.append(report.errorMessage()).append("\n");
        }
        return builder.toString();
    }

    public void addConfigFileLocation(String namespaceCode, String location) throws IOException {
        if (!this.moduleLoadOrder.contains(namespaceCode)) {
            this.moduleLoadOrder.add(namespaceCode);
        }
        this.indexSource(namespaceCode, location);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void indexSource(String namespaceCode, String sourceName) throws IOException {
        Resource resource;
        if (sourceName == null) {
            throw new DataDictionaryException("Source Name given is null");
        }
        if (!sourceName.endsWith(".xml")) {
            Resource resource2 = this.getFileResource(sourceName);
            if (!resource2.exists()) {
                LOG.warn("Could not find " + sourceName);
                throw new DataDictionaryException("DD Resource " + sourceName + " not found");
            }
            try {
                this.indexSource(namespaceCode, resource2.getFile());
                return;
            }
            catch (IOException e) {
                LOG.debug("Skipped existing resource without absolute file path", (Throwable)e);
                return;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding sourceName " + sourceName + " ");
        }
        if (!(resource = this.getFileResource(sourceName)).exists()) {
            throw new DataDictionaryException("DD Resource " + sourceName + " not found");
        }
        this.addModuleDictionaryFile(namespaceCode, sourceName);
    }

    protected Resource getFileResource(String sourceName) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader(ClassLoaderUtils.getDefaultClassLoader());
        return resourceLoader.getResource(sourceName);
    }

    protected void indexSource(String namespaceCode, File dir) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                this.indexSource(namespaceCode, file);
                continue;
            }
            if (file.getName().endsWith(".xml")) {
                this.addModuleDictionaryFile(namespaceCode, "file:" + file.getAbsolutePath());
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Skipping non xml file " + file.getAbsolutePath() + " in DD load");
        }
    }

    public void addModuleDictionaryFile(String namespaceCode, String location) {
        this.addModuleDictionaryFile(namespaceCode, new DefaultResourceLoader().getResource(location));
    }

    public void addModuleDictionaryFile(String namespaceCode, Resource location) {
        List<Resource> moduleFileLocations = new ArrayList<Resource>();
        if (this.moduleDictionaryFiles.containsKey(namespaceCode)) {
            moduleFileLocations = this.moduleDictionaryFiles.get(namespaceCode);
        }
        moduleFileLocations.add(location);
        this.moduleDictionaryFiles.put(namespaceCode, moduleFileLocations);
    }

    public Map<String, List<Resource>> getModuleDictionaryFiles() {
        return this.moduleDictionaryFiles;
    }

    public void setModuleDictionaryFiles(Map<String, List<Resource>> moduleDictionaryFiles) {
        this.moduleDictionaryFiles = moduleDictionaryFiles;
    }

    public List<String> getModuleLoadOrder() {
        return this.moduleLoadOrder;
    }

    public void setModuleLoadOrder(List<String> moduleLoadOrder) {
        this.moduleLoadOrder = moduleLoadOrder;
    }

    public void setDataDictionaryMapper(DataDictionaryMapper mapper) {
        this.ddMapper = mapper;
    }

    @Deprecated
    public BusinessObjectEntry getBusinessObjectEntry(String className) {
        return this.ddMapper.getBusinessObjectEntry(this.ddIndex, className);
    }

    public DataObjectEntry getDataObjectEntry(String className) {
        return this.ddMapper.getDataObjectEntry(this.ddIndex, className);
    }

    public BusinessObjectEntry getBusinessObjectEntryForConcreteClass(String className) {
        return this.ddMapper.getBusinessObjectEntryForConcreteClass(this.ddIndex, className);
    }

    public List<String> getBusinessObjectClassNames() {
        return this.ddMapper.getBusinessObjectClassNames(this.ddIndex);
    }

    public Map<String, BusinessObjectEntry> getBusinessObjectEntries() {
        return this.ddMapper.getBusinessObjectEntries(this.ddIndex);
    }

    public Map<String, DataObjectEntry> getDataObjectEntries() {
        return this.ddMapper.getDataObjectEntries(this.ddIndex);
    }

    public DataDictionaryEntry getDictionaryObjectEntry(String className) {
        return this.ddMapper.getDictionaryObjectEntry(this.ddIndex, className);
    }

    public DocumentEntry getDocumentEntry(String documentTypeDDKey) {
        return this.ddMapper.getDocumentEntry(this.ddIndex, documentTypeDDKey);
    }

    public MaintenanceDocumentEntry getMaintenanceDocumentEntryForBusinessObjectClass(Class<?> businessObjectClass) {
        return this.ddMapper.getMaintenanceDocumentEntryForBusinessObjectClass(this.ddIndex, businessObjectClass);
    }

    public Map<String, DocumentEntry> getDocumentEntries() {
        return this.ddMapper.getDocumentEntries(this.ddIndex);
    }

    public View getViewById(String viewId) {
        return this.ddMapper.getViewById(this.uifIndex, viewId);
    }

    public View getImmutableViewById(String viewId) {
        return this.ddMapper.getImmutableViewById(this.uifIndex, viewId);
    }

    public View getViewByTypeIndex(UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        return this.ddMapper.getViewByTypeIndex(this.uifIndex, viewTypeName, indexKey);
    }

    public String getViewIdByTypeIndex(UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        return this.ddMapper.getViewIdByTypeIndex(this.uifIndex, viewTypeName, indexKey);
    }

    public boolean viewByTypeExist(UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        return this.ddMapper.viewByTypeExist(this.uifIndex, viewTypeName, indexKey);
    }

    public List<View> getViewsForType(UifConstants.ViewType viewTypeName) {
        return this.ddMapper.getViewsForType(this.uifIndex, viewTypeName);
    }

    public Object getDictionaryBean(String beanName) {
        return this.ddBeans.getBean(beanName);
    }

    public boolean containsDictionaryBean(String id) {
        return this.ddBeans.containsBean(id);
    }

    public Object getDictionaryPrototype(String beanName) {
        if (!this.ddBeans.isPrototype(beanName)) {
            throw new IllegalArgumentException("Bean name " + beanName + " doesn't refer to a prototype bean in the data dictionary");
        }
        return this.getDictionaryBean(beanName);
    }

    public Object getDictionaryBeanProperty(String beanName, String propertyName) {
        Object bean = this.ddBeans.getSingleton(beanName);
        if (bean != null) {
            return ObjectPropertyUtils.getPropertyValue(bean, propertyName);
        }
        BeanDefinition beanDefinition = this.ddBeans.getMergedBeanDefinition(beanName);
        if (beanDefinition == null) {
            throw new RuntimeException("Unable to get bean for bean name: " + beanName);
        }
        MutablePropertyValues pvs = beanDefinition.getPropertyValues();
        if (pvs.contains(propertyName)) {
            Object value;
            PropertyValue propertyValue = pvs.getPropertyValue(propertyName);
            if (propertyValue.isConverted()) {
                value = propertyValue.getConvertedValue();
            } else if (propertyValue.getValue() instanceof String) {
                String unconvertedValue = (String)propertyValue.getValue();
                Scope scope = this.ddBeans.getRegisteredScope(beanDefinition.getScope());
                BeanExpressionContext beanExpressionContext = new BeanExpressionContext((ConfigurableBeanFactory)this.ddBeans, scope);
                value = this.ddBeans.getBeanExpressionResolver().evaluate(unconvertedValue, beanExpressionContext);
            } else {
                value = propertyValue.getValue();
            }
            return value;
        }
        return null;
    }

    public PropertyValues getViewPropertiesById(String viewId) {
        return this.ddMapper.getViewPropertiesById(this.uifIndex, viewId);
    }

    public PropertyValues getViewPropertiesByType(UifConstants.ViewType viewTypeName, Map<String, String> indexKey) {
        return this.ddMapper.getViewPropertiesByType(this.uifIndex, viewTypeName, indexKey);
    }

    public List<String> getBeanNamesForNamespace(String namespaceCode) {
        List<String> namespaceBeans = new ArrayList<String>();
        Map<String, List<String>> dictionaryBeansByNamespace = this.ddIndex.getDictionaryBeansByNamespace();
        if (dictionaryBeansByNamespace.containsKey(namespaceCode)) {
            namespaceBeans = dictionaryBeansByNamespace.get(namespaceCode);
        }
        return namespaceBeans;
    }

    public String getNamespaceForBeanDefinition(String beanName) {
        String beanNamespace = null;
        Map<String, List<String>> dictionaryBeansByNamespace = this.ddIndex.getDictionaryBeansByNamespace();
        for (Map.Entry<String, List<String>> moduleDefinitions : dictionaryBeansByNamespace.entrySet()) {
            List<String> namespaceBeans = moduleDefinitions.getValue();
            if (!namespaceBeans.contains(beanName)) continue;
            beanNamespace = moduleDefinitions.getKey();
            break;
        }
        return beanNamespace;
    }

    public Set<InactivationBlockingMetadata> getAllInactivationBlockingMetadatas(Class blockedClass) {
        return this.ddMapper.getAllInactivationBlockingMetadatas(this.ddIndex, blockedClass);
    }

    public void performBeanOverrides() {
        this.timer.start("Processing BeanOverride beans");
        Collection beanOverrides = this.ddBeans.getBeansOfType(BeanOverride.class).values();
        if (beanOverrides.isEmpty()) {
            LOG.info("DataDictionary.performOverrides(): No beans to override");
        }
        for (BeanOverride beanOverride : beanOverrides) {
            Object bean = this.ddBeans.getBean(beanOverride.getBeanName());
            beanOverride.performOverride(bean);
            LOG.info("DataDictionary.performOverrides(): Performing override on bean: " + bean.toString());
        }
        this.timer.stop();
        LOG.info("\n" + this.timer.prettyPrint());
    }
}

