/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.krad.uif.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public final class RecycleUtils {
    private static final Map<Class<?>, Reference<Map<String, Queue<Object>>>> RECYCLE = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Class<?>, List<Field>> FIELD_CACHE = Collections.synchronizedMap(new WeakHashMap());

    private RecycleUtils() {
    }

    public static <T> T getRecycledInstance(Class<T> c) {
        return RecycleUtils.getRecycledInstance(null, c);
    }

    public static <T> T getRecycledInstance(String name, Class<T> c) {
        return c.cast(RecycleUtils.getRecycleQueue(name, c).poll());
    }

    public static <T> T getInstance(Class<T> c) {
        T rv = RecycleUtils.getRecycledInstance(c);
        if (rv == null) {
            try {
                rv = c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Unabled to instantiate " + String.valueOf(c), e);
            }
        }
        return rv;
    }

    public static void recycle(Object instance) {
        RecycleUtils.recycle(null, instance);
    }

    public static void recycle(String name, Object instance) {
        if (instance != null) {
            RecycleUtils.getRecycleQueue(name, instance.getClass()).offer(instance);
        }
    }

    public static void recycle(String name, Object instance, Class<?> recycleClass) {
        if (instance != null) {
            RecycleUtils.getRecycleQueue(name, recycleClass).offer(instance);
        }
    }

    public static <T> void clean(T instance) {
        RecycleUtils.clean(instance, Object.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void clean(T instance, Class<? super T> top) {
        for (Class<?> c = instance.getClass(); c != null && c != top && top.isAssignableFrom(c); c = c.getSuperclass()) {
            List<Field> fields;
            Map<Class<?>, List<Field>> map = FIELD_CACHE;
            synchronized (map) {
                fields = FIELD_CACHE.get(c);
                if (fields == null) {
                    Field[] declared = c.getDeclaredFields();
                    fields = new ArrayList<Field>(declared.length);
                    for (Field field : fields) {
                        if ((field.getModifiers() & 8) == 8) continue;
                        field.setAccessible(true);
                        fields.add(field);
                    }
                    fields = Collections.unmodifiableList(fields);
                    FIELD_CACHE.put(c, fields);
                }
            }
            for (Field field : fields) {
                try {
                    Class<?> type = field.getType();
                    if (type.isPrimitive()) {
                        if (type == Integer.TYPE) {
                            field.set(instance, 0);
                            continue;
                        }
                        if (type == Boolean.TYPE) {
                            field.set(instance, false);
                            continue;
                        }
                        if (type == Long.TYPE) {
                            field.set(instance, 0L);
                            continue;
                        }
                        if (type == Character.TYPE) {
                            field.set(instance, Character.valueOf('\u0000'));
                            continue;
                        }
                        if (type == Double.TYPE) {
                            field.set(instance, 0.0);
                            continue;
                        }
                        if (type == Float.TYPE) {
                            field.set(instance, Float.valueOf(0.0f));
                            continue;
                        }
                        if (type == Short.TYPE) {
                            field.set(instance, (short)0);
                            continue;
                        }
                        if (type != Byte.TYPE) continue;
                        field.set(instance, (byte)0);
                        continue;
                    }
                    field.set(instance, null);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Unexpected error setting " + String.valueOf(field), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Queue<Object> getRecycleQueue(String name, Class<?> c) {
        Queue<Object> recycleQueue;
        Reference<Map<String, Queue<Object>>> recycleMapRef = RECYCLE.get(c);
        Map<String, Queue<Object>> recycleMap = null;
        if (recycleMapRef != null) {
            recycleMap = recycleMapRef.get();
        }
        if (recycleMap == null) {
            recycleMap = new HashMap<String, Queue<Object>>();
            recycleMapRef = new WeakReference<Map<String, Queue<Object>>>(recycleMap);
            Map<Class<?>, Reference<Map<String, Queue<Object>>>> map = RECYCLE;
            synchronized (map) {
                RECYCLE.put(c, recycleMapRef);
            }
        }
        if ((recycleQueue = recycleMap.get(name)) == null) {
            recycleQueue = new ConcurrentLinkedQueue<Object>();
            Map<String, Queue<Object>> map = recycleMap;
            synchronized (map) {
                recycleMap.put(name, recycleQueue);
            }
        }
        return recycleQueue;
    }
}

