/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.core.category;

import java.util.HashMap;
import org.kuali.coeus.common.budget.framework.core.CostElement;
import org.kuali.coeus.common.budget.framework.core.category.BudgetCategory;
import org.kuali.coeus.common.budget.framework.core.category.BudgetCategoryMapping;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.rice.kns.document.MaintenanceDocument;

public class BudgetCategoryExistenceRule
extends KcMaintenanceDocumentRuleBase {
    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkExistence(document);
    }

    protected boolean processCustomApproveDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkExistence(document);
    }

    private boolean checkExistence(MaintenanceDocument maintenanceDocument) {
        String budgetCategoryCode;
        boolean valid = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("new maintainable is: " + String.valueOf(maintenanceDocument.getNewMaintainableObject().getClass()));
        }
        if (maintenanceDocument.getNewMaintainableObject().getDataObject() instanceof BudgetCategoryMapping) {
            BudgetCategoryMapping budgetCategoryMapping = (BudgetCategoryMapping)maintenanceDocument.getNewMaintainableObject().getDataObject();
            budgetCategoryCode = budgetCategoryMapping.getBudgetCategoryCode();
        } else {
            CostElement costElement = (CostElement)maintenanceDocument.getNewMaintainableObject().getDataObject();
            budgetCategoryCode = costElement.getBudgetCategoryCode();
        }
        HashMap<String, String> pkMap = new HashMap<String, String>();
        pkMap.put("code", budgetCategoryCode);
        valid = this.checkExistenceFromTable(BudgetCategory.class, pkMap, "code", "Budget Category");
        return valid;
    }
}

