/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.instprop.impl.api;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.kuali.coeus.sys.framework.controller.rest.RestController;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.dao.InstitutionalProposalDao;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/api"})
@Controller(value="institutionalProposalPersonOrderingReportController")
public class InstitutionalProposalPersonOrderingReportController
extends RestController {
    @Autowired
    @Qualifier(value="institutionalProposalDao")
    private InstitutionalProposalDao institutionalProposalDao;

    @RequestMapping(method={RequestMethod.GET}, value={"/v1/institutional-proposal-person-ordering-report/"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    List<String> generateOrderingMismatchReport(@RequestParam(required=false) Instant startDate, @RequestParam(required=false) Instant endDate) {
        return this.institutionalProposalDao.getProposalsModifiedBetween(Date.from(startDate), Date.from(endDate)).stream().filter(instProp -> {
            List<InstitutionalProposalPerson> sortedList;
            ArrayList<InstitutionalProposalPerson> unsortedList = new ArrayList<InstitutionalProposalPerson>(instProp.getUnsortedProjectPersons());
            return !unsortedList.equals(sortedList = instProp.getProjectPersons());
        }).map(InstitutionalProposal::getProposalNumber).distinct().collect(Collectors.toList());
    }

    public InstitutionalProposalDao getInstitutionalProposalDao() {
        return this.institutionalProposalDao;
    }

    public void setInstitutionalProposalDao(InstitutionalProposalDao institutionalProposalDao) {
        this.institutionalProposalDao = institutionalProposalDao;
    }
}

