/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.auth;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.security.Key;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.keys.HmacKey;
import org.jose4j.lang.JoseException;
import org.kuali.coeus.sys.framework.auth.JwtService;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="jwtService")
public class JwtServiceImpl
implements JwtService {
    private static final String AUTH_SYSTEM_TOKEN_PARAM = "auth.system.token";
    private static final String SUFFIX_ENABLED = ".enabled";
    private static final String SUFFIX_SECRET = ".secret";
    private static final String SERVICE_2_SERVICE = "auth.filter.service2service";
    private static final String KUALI_BUILD = "kuali.build.integration";
    private static final String SINGLE_USE = "auth.filter.service2service.singleUse";
    private static final String UUID_CLAIM = "uuid";
    private static final String AUTHORIZATION_PREFIX = "Bearer ";
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    private Cache<String, String> usedTokens;

    @Override
    public boolean verifyToken(String authToken) {
        if (!this.isEnabled(SERVICE_2_SERVICE)) {
            return false;
        }
        String jwtString = this.getJwtString(authToken);
        if (StringUtils.isEmpty((CharSequence)jwtString)) {
            return false;
        }
        return this.getSecrets(SERVICE_2_SERVICE).stream().anyMatch(secret -> this.verifyToken(jwtString, (String)secret));
    }

    private boolean verifyToken(String jwtString, String secret) {
        try {
            JwtClaims jwtClaims = this.getJwtConsumer(secret).processToClaims(jwtString);
            if (this.isSingleUse()) {
                return this.validateSingleUse(jwtClaims);
            }
            return true;
        }
        catch (InvalidJwtException e) {
            return false;
        }
    }

    @Override
    public String createToken() {
        return this.createToken(SERVICE_2_SERVICE).orElseGet(this::getSystemAuthToken);
    }

    @Override
    public String createKualiBuildApiToken() {
        return this.createToken(KUALI_BUILD).orElseThrow(() -> new ConfigurationException("Could not create token for Kuali Build"));
    }

    private Optional<String> createToken(String prefix) {
        if (this.isEnabled(prefix)) {
            try {
                return Optional.of(this.createJsonWebSignature(prefix).getCompactSerialization());
            }
            catch (JoseException e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.empty();
    }

    private boolean validateSingleUse(JwtClaims jwtClaims) {
        String uuid = jwtClaims.getClaimValue(UUID_CLAIM).toString();
        if (this.getUsedTokens().getIfPresent((Object)uuid) == null) {
            this.getUsedTokens().put((Object)uuid, (Object)uuid);
            return true;
        }
        return false;
    }

    private JsonWebSignature createJsonWebSignature(String prefix) {
        JsonWebSignature jws = new JsonWebSignature();
        jws.setKey((Key)new HmacKey(this.getSecrets(prefix).get(0).getBytes()));
        jws.setAlgorithmHeaderValue("HS256");
        jws.setDoKeyValidation(false);
        jws.setPayload(this.createClaims().toJson());
        return jws;
    }

    private JwtClaims createClaims() {
        JwtClaims jwtClaims = new JwtClaims();
        jwtClaims.setExpirationTimeMinutesInTheFuture(1.0f);
        jwtClaims.setIssuedAtToNow();
        jwtClaims.setClaim(UUID_CLAIM, (Object)UUID.randomUUID());
        return jwtClaims;
    }

    private String getJwtString(String authTokenValue) {
        if (!StringUtils.startsWith((CharSequence)authTokenValue, (CharSequence)AUTHORIZATION_PREFIX)) {
            return null;
        }
        String[] parts = authTokenValue.split(" ");
        if (parts.length < 2) {
            return null;
        }
        return parts[1];
    }

    protected boolean isEnabled(String prefix) {
        return this.getConfigurationService().getPropertyValueAsBoolean(prefix + SUFFIX_ENABLED);
    }

    protected String getConfiguredSecret(String prefix) {
        return this.getConfigurationService().getPropertyValueAsString(prefix + SUFFIX_SECRET);
    }

    private List<String> getSecrets(String prefix) {
        return Optional.ofNullable(this.getConfiguredSecret(prefix)).map(config -> config.split(",")).map(secrets -> Stream.of(secrets).map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toList())).orElseThrow(() -> new ConfigurationException("Missing configuration: " + prefix + SUFFIX_SECRET));
    }

    protected boolean isSingleUse() {
        return this.getConfigurationService().getPropertyValueAsBoolean(SINGLE_USE);
    }

    protected String getSystemAuthToken() {
        return this.getConfigurationService().getPropertyValueAsString(AUTH_SYSTEM_TOKEN_PARAM);
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    private JwtConsumer getJwtConsumer(String secret) {
        return new JwtConsumerBuilder().setVerificationKey((Key)new HmacKey(secret.getBytes())).setRelaxVerificationKeyValidation().build();
    }

    private Cache<String, String> getUsedTokens() {
        if (this.usedTokens == null) {
            this.usedTokens = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(60L, TimeUnit.SECONDS).build();
        }
        return this.usedTokens;
    }
}

