/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.xml.service;

import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.core.spi.service.ServiceUtils;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.xml.CoreServiceConfigurationParser;

class SimpleCoreServiceConfigurationParser<TEMPLATE, CACHE, IN, OUT, U extends ServiceConfiguration<?, ?>>
implements CoreServiceConfigurationParser<TEMPLATE, CACHE> {
    private final Function<TEMPLATE, IN> extractor;
    private final Parser<IN, U> parser;
    private final Class<U> configType;
    private final Function<CACHE, OUT> getter;
    private final BiConsumer<CACHE, OUT> setter;
    private final Function<U, OUT> unparser;
    private final BinaryOperator<OUT> merger;

    SimpleCoreServiceConfigurationParser(Class<U> configType, Function<TEMPLATE, IN> extractor, Function<IN, U> parser, Function<CACHE, OUT> getter, BiConsumer<CACHE, OUT> setter, Function<U, OUT> unparser) {
        this(configType, extractor, (IN config, ClassLoader loader) -> (ServiceConfiguration)parser.apply(config), getter, setter, unparser, (a, b) -> {
            throw new IllegalStateException();
        });
    }

    SimpleCoreServiceConfigurationParser(Class<U> configType, Function<TEMPLATE, IN> extractor, Function<IN, U> parser, Function<CACHE, OUT> getter, BiConsumer<CACHE, OUT> setter, Function<U, OUT> unparser, BinaryOperator<OUT> merger) {
        this(configType, extractor, (IN config, ClassLoader loader) -> (ServiceConfiguration)parser.apply(config), getter, setter, unparser, merger);
    }

    SimpleCoreServiceConfigurationParser(Class<U> configType, Function<TEMPLATE, IN> extractor, Parser<IN, U> parser, Function<CACHE, OUT> getter, BiConsumer<CACHE, OUT> setter, Function<U, OUT> unparser) {
        this(configType, extractor, parser, getter, setter, unparser, (a, b) -> {
            throw new IllegalStateException();
        });
    }

    SimpleCoreServiceConfigurationParser(Class<U> configType, Function<TEMPLATE, IN> extractor, Parser<IN, U> parser, Function<CACHE, OUT> getter, BiConsumer<CACHE, OUT> setter, Function<U, OUT> unparser, BinaryOperator<OUT> merger) {
        this.configType = configType;
        this.extractor = extractor;
        this.parser = parser;
        this.getter = getter;
        this.setter = setter;
        this.unparser = unparser;
        this.merger = merger;
    }

    @Override
    public final <K, V> CacheConfigurationBuilder<K, V> parseServiceConfiguration(TEMPLATE cacheDefinition, ClassLoader cacheClassLoader, CacheConfigurationBuilder<K, V> cacheBuilder) throws ClassNotFoundException {
        ServiceConfiguration configuration;
        IN config = this.extractor.apply(cacheDefinition);
        if (config != null && (configuration = (ServiceConfiguration)this.parser.parse(config, cacheClassLoader)) != null) {
            return cacheBuilder.withService(configuration);
        }
        return cacheBuilder;
    }

    @Override
    public CACHE unparseServiceConfiguration(CacheConfiguration<?, ?> cacheConfiguration, CACHE cacheType) {
        ServiceConfiguration serviceConfig = (ServiceConfiguration)ServiceUtils.findSingletonAmongst(this.configType, (Collection)cacheConfiguration.getServiceConfigurations());
        if (serviceConfig == null) {
            return cacheType;
        }
        OUT foo = this.getter.apply(cacheType);
        if (foo == null) {
            this.setter.accept(cacheType, this.unparser.apply(serviceConfig));
        } else {
            this.setter.accept(cacheType, this.merger.apply(foo, this.unparser.apply(serviceConfig)));
        }
        return cacheType;
    }

    @FunctionalInterface
    static interface Parser<T, U> {
        public U parse(T var1, ClassLoader var2) throws ClassNotFoundException;
    }
}

