/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.ehcache.core.util.ByteBufferInputStream;
import org.ehcache.spi.persistence.StateHolder;
import org.ehcache.spi.persistence.StateRepository;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.SerializerException;
import org.ehcache.spi.serialization.StatefulSerializer;

public class CompactJavaSerializer<T>
implements StatefulSerializer<T> {
    private volatile StateHolder<Integer, ObjectStreamClass> persistentState;
    private final ConcurrentMap<Integer, ObjectStreamClass> readLookupCache = new ConcurrentHashMap<Integer, ObjectStreamClass>();
    private final ConcurrentMap<SerializableDataKey, Integer> writeLookupCache = new ConcurrentHashMap<SerializableDataKey, Integer>();
    private final Lock lock = new ReentrantLock();
    private int nextStreamIndex = 0;
    private boolean potentiallyInconsistent;
    private final transient ClassLoader loader;

    public CompactJavaSerializer(ClassLoader loader) {
        this.loader = loader;
    }

    public static <T> Class<? extends Serializer<T>> asTypedSerializer() {
        return CompactJavaSerializer.class;
    }

    public void init(StateRepository stateRepository) {
        this.persistentState = stateRepository.getPersistentStateHolder("CompactJavaSerializer-ObjectStreamClassIndex", Integer.class, ObjectStreamClass.class, c -> true, null);
        this.refreshMappingsFromStateRepository();
    }

    public ByteBuffer serialize(T object) throws SerializerException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try (ObjectOutputStream oout = this.getObjectOutputStream(bout);){
                oout.writeObject(object);
            }
            return ByteBuffer.wrap(bout.toByteArray());
        }
        catch (IOException e) {
            throw new SerializerException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T read(ByteBuffer binary) throws ClassNotFoundException, SerializerException {
        try (ObjectInputStream oin = this.getObjectInputStream((InputStream)new ByteBufferInputStream(binary));){
            Object value;
            Object object = value = oin.readObject();
            return (T)object;
        }
        catch (IOException e) {
            throw new SerializerException((Throwable)e);
        }
    }

    private ObjectOutputStream getObjectOutputStream(OutputStream out) throws IOException {
        return new OOS(out);
    }

    private ObjectInputStream getObjectInputStream(InputStream input) throws IOException {
        return new OIS(input, this.loader);
    }

    public boolean equals(T object, ByteBuffer binary) throws ClassNotFoundException, SerializerException {
        return object.equals(this.read(binary));
    }

    private int getOrAddMapping(ObjectStreamClass desc) {
        SerializableDataKey probe = new SerializableDataKey(desc, false);
        Integer rep = (Integer)this.writeLookupCache.get(probe);
        if (rep == null) {
            return this.addMappingUnderLock(desc, probe);
        }
        return rep;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int addMappingUnderLock(ObjectStreamClass desc, SerializableDataKey probe) {
        this.lock.lock();
        try {
            if (this.potentiallyInconsistent) {
                this.refreshMappingsFromStateRepository();
                this.potentiallyInconsistent = false;
            }
            while (true) {
                ObjectStreamClass existingOsc;
                Integer rep;
                if ((rep = (Integer)this.writeLookupCache.get(probe)) != null) {
                    int n = rep;
                    return n;
                }
                rep = this.nextStreamIndex++;
                try {
                    ObjectStreamClass disconnected = CompactJavaSerializer.disconnect(desc);
                    existingOsc = (ObjectStreamClass)this.persistentState.putIfAbsent((Object)rep, (Object)disconnected);
                    if (existingOsc == null) {
                        this.cacheMapping(rep, disconnected);
                        int n = rep;
                        return n;
                    }
                }
                catch (Throwable t) {
                    this.potentiallyInconsistent = true;
                    throw t;
                }
                {
                    this.cacheMapping(rep, CompactJavaSerializer.disconnect(existingOsc));
                    continue;
                }
                break;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void refreshMappingsFromStateRepository() {
        int highestIndex = -1;
        for (Map.Entry entry : this.persistentState.entrySet()) {
            Integer index = (Integer)entry.getKey();
            this.cacheMapping((Integer)entry.getKey(), CompactJavaSerializer.disconnect((ObjectStreamClass)entry.getValue()));
            highestIndex = Math.max(highestIndex, index);
        }
        this.nextStreamIndex = highestIndex + 1;
    }

    private void cacheMapping(Integer index, ObjectStreamClass disconnectedOsc) {
        this.readLookupCache.merge(index, disconnectedOsc, (existing, update) -> {
            if (CompactJavaSerializer.equals(existing, update)) {
                return existing;
            }
            throw new AssertionError((Object)("Corrupted data:\nState Repository: " + this.persistentState + "\nLocal Write Lookup: " + this.writeLookupCache + "\nLocal Read Lookup: " + this.readLookupCache));
        });
        this.writeLookupCache.merge(new SerializableDataKey(disconnectedOsc, true), index, (existing, update) -> {
            if (existing.equals(update)) {
                return existing;
            }
            throw new AssertionError((Object)("Corrupted data:\nState Repository: " + this.persistentState + "\nLocal Write Lookup: " + this.writeLookupCache + "\nLocal Read Lookup: " + this.readLookupCache));
        });
    }

    private static boolean equals(SerializableDataKey k1, SerializableDataKey k2) {
        Class<?> k1Clazz = k1.forClass();
        Class<?> k2Clazz = k2.forClass();
        if (k1Clazz != null && k2Clazz != null) {
            return k1Clazz == k2Clazz;
        }
        if (CompactJavaSerializer.equals(k1.getObjectStreamClass(), k2.getObjectStreamClass())) {
            if (k1Clazz != null) {
                k2.setClass(k1Clazz);
            } else if (k2Clazz != null) {
                k1.setClass(k2Clazz);
            }
            return true;
        }
        return false;
    }

    private static boolean equals(ObjectStreamClass osc1, ObjectStreamClass osc2) {
        if (osc1 == osc2) {
            return true;
        }
        if (osc1.getName().equals(osc2.getName()) && osc1.getSerialVersionUID() == osc2.getSerialVersionUID() && osc1.getFields().length == osc2.getFields().length) {
            try {
                return Arrays.equals(CompactJavaSerializer.getSerializedForm(osc1), CompactJavaSerializer.getSerializedForm(osc2));
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        return false;
    }

    private static ObjectStreamClass disconnect(ObjectStreamClass desc) {
        try {
            ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(CompactJavaSerializer.getSerializedForm(desc))){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass osc) {
                    return null;
                }
            };
            return (ObjectStreamClass)oin.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getSerializedForm(ObjectStreamClass desc) throws IOException {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();
             ObjectOutputStream oout = new ObjectOutputStream(bout);){
            oout.writeObject(desc);
        }
        return bout.toByteArray();
    }

    private static class SerializableDataKey {
        private final ObjectStreamClass osc;
        private final int hashCode;
        private transient WeakReference<Class<?>> klazz;

        SerializableDataKey(ObjectStreamClass desc, boolean store) {
            Class<?> forClass = desc.forClass();
            if (forClass != null) {
                if (store) {
                    throw new AssertionError((Object)"Must not store ObjectStreamClass instances with strong references to classes");
                }
                if (ObjectStreamClass.lookup(forClass) == desc) {
                    this.klazz = new WeakReference(forClass);
                }
            }
            this.hashCode = 3 * desc.getName().hashCode() ^ 7 * (int)(desc.getSerialVersionUID() >>> 32) ^ 11 * (int)desc.getSerialVersionUID();
            this.osc = desc;
        }

        public boolean equals(Object o) {
            if (o instanceof SerializableDataKey) {
                return CompactJavaSerializer.equals(this, (SerializableDataKey)o);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        Class<?> forClass() {
            if (this.klazz == null) {
                return null;
            }
            return (Class)this.klazz.get();
        }

        public void setClass(Class<?> clazz) {
            this.klazz = new WeakReference(clazz);
        }

        ObjectStreamClass getObjectStreamClass() {
            return this.osc;
        }
    }

    class OIS
    extends ObjectInputStream {
        private final ClassLoader loader;

        OIS(InputStream in, ClassLoader loader) throws IOException {
            super(in);
            this.loader = loader;
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException {
            int key = this.readInt();
            ObjectStreamClass objectStreamClass = (ObjectStreamClass)CompactJavaSerializer.this.readLookupCache.get(key);
            if (objectStreamClass == null) {
                objectStreamClass = (ObjectStreamClass)CompactJavaSerializer.this.persistentState.get((Object)key);
                CompactJavaSerializer.this.cacheMapping(key, CompactJavaSerializer.disconnect(objectStreamClass));
            }
            return objectStreamClass;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                ClassLoader cl;
                ClassLoader classLoader = cl = this.loader == null ? Thread.currentThread().getContextClassLoader() : this.loader;
                if (cl == null) {
                    return super.resolveClass(desc);
                }
                try {
                    return Class.forName(desc.getName(), false, cl);
                }
                catch (ClassNotFoundException e) {
                    return super.resolveClass(desc);
                }
            }
            catch (SecurityException ex) {
                return super.resolveClass(desc);
            }
        }
    }

    class OOS
    extends ObjectOutputStream {
        OOS(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
            this.writeInt(CompactJavaSerializer.this.getOrAddMapping(desc));
        }
    }
}

