/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.peopleflow;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.delegation.DelegationType;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowDelegateContract;
import org.w3c.dom.Element;

@XmlRootElement(name="peopleFlowDelegate")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="PeopleFlowDelegateType", propOrder={"memberId", "memberType", "actionRequestPolicy", "delegationType", "responsibilityId", "_futureElements"})
public final class PeopleFlowDelegate
extends AbstractDataTransferObject
implements PeopleFlowDelegateContract {
    @XmlElement(name="memberId", required=true)
    private final String memberId;
    @XmlElement(name="memberType", required=true)
    private final MemberType memberType;
    @XmlElement(name="actionRequestPolicy", required=false)
    private final ActionRequestPolicy actionRequestPolicy;
    @XmlElement(name="delegationType", required=true)
    private final DelegationType delegationType;
    @XmlElement(name="responsibilityId", required=false)
    private final String responsibilityId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private PeopleFlowDelegate() {
        this.memberId = null;
        this.memberType = null;
        this.actionRequestPolicy = null;
        this.delegationType = null;
        this.responsibilityId = null;
    }

    private PeopleFlowDelegate(Builder builder) {
        this.memberId = builder.getMemberId();
        this.memberType = builder.getMemberType();
        this.actionRequestPolicy = builder.getActionRequestPolicy();
        this.delegationType = builder.getDelegationType();
        this.responsibilityId = builder.getResponsibilityId();
    }

    @Override
    public String getMemberId() {
        return this.memberId;
    }

    @Override
    public MemberType getMemberType() {
        return this.memberType;
    }

    @Override
    public ActionRequestPolicy getActionRequestPolicy() {
        return this.actionRequestPolicy;
    }

    @Override
    public DelegationType getDelegationType() {
        return this.delegationType;
    }

    @Override
    public String getResponsibilityId() {
        return this.responsibilityId;
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    PeopleFlowDelegateContract {
        private String memberId;
        private MemberType memberType;
        private ActionRequestPolicy actionRequestPolicy;
        private DelegationType delegationType;
        private String responsibilityId;

        private Builder(String memberId, MemberType memberType) {
            this.setMemberId(memberId);
            this.setMemberType(memberType);
            this.setDelegationType(DelegationType.SECONDARY);
        }

        public static Builder create(String memberId, MemberType memberType) {
            return new Builder(memberId, memberType);
        }

        public static Builder create(PeopleFlowDelegateContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getMemberId(), contract.getMemberType());
            builder.setActionRequestPolicy(contract.getActionRequestPolicy());
            builder.setDelegationType(contract.getDelegationType());
            builder.setResponsibilityId(contract.getResponsibilityId());
            return builder;
        }

        public PeopleFlowDelegate build() {
            return new PeopleFlowDelegate(this);
        }

        @Override
        public String getMemberId() {
            return this.memberId;
        }

        @Override
        public MemberType getMemberType() {
            return this.memberType;
        }

        @Override
        public ActionRequestPolicy getActionRequestPolicy() {
            return this.actionRequestPolicy;
        }

        @Override
        public DelegationType getDelegationType() {
            return this.delegationType;
        }

        @Override
        public String getResponsibilityId() {
            return this.responsibilityId;
        }

        public void setMemberId(String memberId) {
            if (StringUtils.isBlank((String)memberId)) {
                throw new IllegalArgumentException("memberId was a null or blank value");
            }
            this.memberId = memberId;
        }

        public void setMemberType(MemberType memberType) {
            if (memberType == null) {
                throw new IllegalArgumentException("memberType was null");
            }
            this.memberType = memberType;
        }

        public void setActionRequestPolicy(ActionRequestPolicy actionRequestPolicy) {
            if (this.memberType.equals((Object)MemberType.ROLE)) {
                if (actionRequestPolicy == null) {
                    throw new IllegalArgumentException("actionRequestPolicy was null");
                }
                this.actionRequestPolicy = actionRequestPolicy;
            }
        }

        public void setDelegationType(DelegationType delegationType) {
            if (delegationType == null) {
                throw new IllegalArgumentException("delegationType was null");
            }
            this.delegationType = delegationType;
        }

        public void setResponsibilityId(String responsibilityId) {
            this.responsibilityId = responsibilityId;
        }
    }

    static class Elements {
        static final String MEMBER_ID = "memberId";
        static final String MEMBER_TYPE = "memberType";
        static final String ACTION_REQUEST_POLICY = "actionRequestPolicy";
        static final String DELEGATION_TYPE = "delegationType";
        static final String RESPONSIBILITY_ID = "responsibilityId";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "peopleFlowDelegate";
        static final String TYPE_NAME = "PeopleFlowDelegateType";

        Constants() {
        }
    }
}

